/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.PrintWriter;
import java.util.Map;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.IFDSFieldRenderer;
import pyrosim.io.fds.SyntaxMap;
import thunderheadeng.io.StringPrintWriter;

public class FDSRenderRecord
extends FDSRecord {
    static final long serialVersionUID = 1L;
    private String d_customText = null;

    public FDSRenderRecord(FDSRecordSpec fDSRecordSpec, boolean bl) {
        super(fDSRecordSpec, bl);
    }

    public static FDSRenderRecord fromParseRecord(FDSParseRecord fDSParseRecord) {
        FDSRenderRecord fDSRenderRecord = new FDSRenderRecord(fDSParseRecord.getSpec(), false);
        fDSRenderRecord.setComment(fDSParseRecord.getComment());
        for (FDSRecord.UnknownProp object : fDSParseRecord.getUnknownProps()) {
            fDSRenderRecord.addUnknownProp(object.key, object.values);
        }
        for (Map.Entry entry : fDSParseRecord.getProperties().entrySet()) {
            fDSRenderRecord.setValue((String)entry.getKey(), entry.getValue());
        }
        return fDSRenderRecord;
    }

    @Override
    public boolean empty() {
        return super.empty() && this.d_customText == null;
    }

    public void setCustomText(String string) {
        this.d_customText = string;
    }

    public String getCustomText() {
        return this.d_customText;
    }

    public String renderRecord(FDSRenderProps fDSRenderProps, IFDSFieldRenderer iFDSFieldRenderer) {
        StringPrintWriter stringPrintWriter = new StringPrintWriter();
        this.renderRecord(stringPrintWriter, fDSRenderProps, iFDSFieldRenderer);
        return stringPrintWriter.toString();
    }

    public SyntaxMap renderRecord(PrintWriter printWriter, FDSRenderProps fDSRenderProps, IFDSFieldRenderer iFDSFieldRenderer) {
        SyntaxMap syntaxMap = new SyntaxMap();
        if (this.d_customText != null) {
            printWriter.println(this.d_customText);
            return null;
        }
        syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
        syntaxMap.putSmart(this.getType().length() + 1, "SYMBOL_KEYWORD");
        printWriter.append("&");
        printWriter.append(this.getType());
        printWriter.append(" ");
        String string = fDSRenderProps.getFieldSep();
        int n = 0;
        for (Map.Entry<String, Object> object : this.getProperties().entrySet()) {
            SyntaxMap syntaxMap2 = new SyntaxMap();
            String string2 = this.renderToString(fDSRenderProps, object.getKey(), object.getValue(), syntaxMap2);
            if (string2.length() <= 0) continue;
            if (n++ > 0) {
                syntaxMap.putSmart(string.length(), "SYMBOL_SPECIAL");
                printWriter.append(string);
            }
            syntaxMap.mergeSyntaxToRoot(syntaxMap2);
            iFDSFieldRenderer.render(printWriter, object.getKey(), string2);
        }
        for (FDSRecord.UnknownProp unknownProp : this.getUnknownProps()) {
            if (n++ > 0) {
                syntaxMap.putSmart(string.length(), "SYMBOL_SPECIAL");
                printWriter.append(string);
            }
            printWriter.append(unknownProp.render(syntaxMap));
        }
        syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
        printWriter.append("/");
        String string3 = this.getComment();
        if (string3 != null) {
            syntaxMap.putSmart(string3.length() + 1, "SYMBOL_COMMENT");
            printWriter.append(" " + (String)string3);
        }
        printWriter.append(fDSRenderProps.getNewline());
        return syntaxMap;
    }

    protected String renderToString(FDSRenderProps fDSRenderProps, String string, Object object, SyntaxMap syntaxMap) {
        FDSRecordSpec.Field field = this.getSpec().fields.get(string);
        assert (field != null);
        try {
            return field.render(fDSRenderProps, object, syntaxMap);
        }
        catch (Throwable throwable) {
            String string2 = String.format("Error rendering %s:%s", this.getType(), string);
            throw new RuntimeException(string2, throwable);
        }
    }
}

