/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.SyntaxMap;
import thunderheadeng.io.StringPrintWriter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.ValueRange;
import thunderheadeng.util.theUtil;

public class FDSRecordSpec {
    public final String rectype;
    public final Map<String, Field> fields;

    public FDSRecordSpec(String string) {
        this.rectype = string;
        this.fields = new HashMap<String, Field>();
    }

    public void addField(Field field) {
        this.fields.put(field.name, field);
    }

    public boolean isDefault(String string, Object object) {
        Field field = this.fields.get(string);
        return theUtil.equal(object, field.initialValue);
    }

    public Pair<String, String> renderField(FDSRenderProps fDSRenderProps, String string, Object object) {
        Field field = this.fields.get(string);
        String string2 = field.render(fDSRenderProps, object);
        String[] stringArray = string2.split("=");
        assert (stringArray.length == 2);
        String string3 = stringArray[0].trim();
        String string4 = stringArray[1].trim();
        return new Pair<String, String>(string3, string4);
    }

    private static <T> int[] getArrayValRange(List<? extends T> list) {
        int n = -1;
        int n2 = -2;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            if (n == -1) {
                n = i;
            }
            n2 = i;
        }
        if (n > n2) {
            return null;
        }
        return new int[]{n, n2};
    }

    private static <T> void printArrayVals(PrintWriter printWriter, FDSRenderProps fDSRenderProps, List<? extends T> list, int[] nArray, SingleField<T> singleField, SyntaxMap syntaxMap) {
        for (int i = nArray[0]; i <= nArray[1]; ++i) {
            T t;
            if (i != nArray[0]) {
                syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                printWriter.print(",");
            }
            if ((t = list.get(i)) == null) continue;
            printWriter.print(singleField.renderVal(fDSRenderProps, t, syntaxMap));
        }
    }

    public static class ArrayFld<T>
    extends Field<FDSArray<T>> {
        public final SingleField<T> elementChecker;
        public final int[] dimensions;
        private int[] d_ixOffsets;
        private boolean d_allowFrontPackedRendering = false;
        private boolean d_reverseMutliDimenionRendering = false;

        public ArrayFld(String string, FDSArray<T> fDSArray, SingleField<T> singleField) {
            super(string, fDSArray, FDSArray.class);
            this.elementChecker = singleField;
            assert (fDSArray != null);
            this.dimensions = fDSArray.getDimensions();
            this.d_ixOffsets = new int[this.dimensions.length];
            Arrays.fill(this.d_ixOffsets, 1);
        }

        public ArrayFld(String string, SingleField<T> singleField, int[] nArray) {
            super(string, null, FDSArray.class);
            this.elementChecker = singleField;
            this.dimensions = nArray;
            this.d_ixOffsets = new int[nArray.length];
            Arrays.fill(this.d_ixOffsets, 1);
        }

        public ArrayFld(String string, SingleField<T> singleField, int n, int ... nArray) {
            super(string, null, FDSArray.class);
            this.elementChecker = singleField;
            this.dimensions = new int[1 + nArray.length];
            this.dimensions[0] = n;
            for (int i = 0; i < nArray.length; ++i) {
                this.dimensions[i + 1] = nArray[i];
            }
            this.d_ixOffsets = new int[this.dimensions.length];
            Arrays.fill(this.d_ixOffsets, 1);
        }

        public ArrayFld<T> setRenderPacked(boolean bl) {
            this.d_allowFrontPackedRendering = bl;
            return this;
        }

        public ArrayFld<T> setReverseMultiDimension(boolean bl) {
            this.d_reverseMutliDimenionRendering = bl;
            return this;
        }

        public void setIndexOffsets(int ... nArray) {
            assert (nArray.length == this.d_ixOffsets.length);
            this.d_ixOffsets = nArray;
        }

        @Override
        public FDSArray<T> cloneValue(FDSArray<T> fDSArray) {
            FDSArray fDSArray2 = new FDSArray(fDSArray.getDimensions());
            Object object = fDSArray.getBaseArray();
            Object object2 = fDSArray2.getBaseArray();
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object object3 = Array.get(object, i);
                if (object3 == null) continue;
                Array.set(object2, i, this.elementChecker.cloneValue(object3));
            }
            return fDSArray2;
        }

        @Override
        public String render(FDSRenderProps fDSRenderProps, FDSArray<T> fDSArray, SyntaxMap syntaxMap) {
            if (fDSArray.isEmpty()) {
                return "";
            }
            if (this.d_allowFrontPackedRendering && fDSArray.isFrontPacked()) {
                List<T> list = fDSArray.getFrontPackedValsAsList();
                return this.renderFrontPacked(fDSRenderProps, list, syntaxMap);
            }
            StringPrintWriter stringPrintWriter = new StringPrintWriter();
            this.render(stringPrintWriter, fDSRenderProps, fDSArray, 0, new int[this.dimensions.length], 0, syntaxMap);
            return stringPrintWriter.toString();
        }

        public String renderFrontPacked(FDSRenderProps fDSRenderProps, List<T> list, SyntaxMap syntaxMap) {
            StringPrintWriter stringPrintWriter = new StringPrintWriter();
            syntaxMap.putSmart(this.name.length(), "SYMBOL_KEYWORD");
            syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
            stringPrintWriter.write(this.name);
            stringPrintWriter.write("=");
            int[] nArray = new int[]{0, list.size() - 1};
            FDSRecordSpec.printArrayVals(stringPrintWriter, fDSRenderProps, list, nArray, this.elementChecker, syntaxMap);
            return stringPrintWriter.toString();
        }

        public int render(PrintWriter printWriter, FDSRenderProps fDSRenderProps, FDSArray<T> fDSArray, int n, int[] nArray, int n2, SyntaxMap syntaxMap) {
            if (n < this.dimensions.length - 1) {
                int n3 = 0;
                while (n3 < this.dimensions[n]) {
                    nArray[n] = n3++;
                    n2 = this.render(printWriter, fDSRenderProps, fDSArray, n + 1, nArray, n2, syntaxMap);
                }
            } else {
                ArrayList<T> arrayList = new ArrayList<T>(this.dimensions[n]);
                int n4 = 0;
                while (n4 < this.dimensions[n]) {
                    nArray[n] = n4++;
                    arrayList.add(fDSArray.get(nArray));
                }
                int[] nArray2 = FDSRecordSpec.getArrayValRange(arrayList);
                if (nArray2 == null) {
                    return n2;
                }
                if (n2 > 0) {
                    syntaxMap.putSmart(fDSRenderProps.getFieldSep().length(), "SYMBOL_SPECIAL");
                    printWriter.print(fDSRenderProps.getFieldSep());
                }
                syntaxMap.putSmart(this.name.length(), "SYMBOL_KEYWORD");
                printWriter.print(this.name);
                this.renderArraySubscripts(printWriter, n, nArray, nArray2, syntaxMap);
                syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                printWriter.print('=');
                FDSRecordSpec.printArrayVals(printWriter, fDSRenderProps, arrayList, nArray2, this.elementChecker, syntaxMap);
                ++n2;
            }
            return n2;
        }

        private void renderArraySubscripts(PrintWriter printWriter, int n, int[] nArray, int[] nArray2, SyntaxMap syntaxMap) {
            if (this.dimensions.length != 1 || nArray2[0] != 0 || nArray2[1] != this.dimensions[n] - 1) {
                syntaxMap.putSmart(1, "SYMBOL_KEYWORD");
                printWriter.print('(');
                if (this.d_reverseMutliDimenionRendering && nArray2[0] != nArray2[1]) {
                    String string = Integer.toString(this.offsetIx(n, nArray2[0]));
                    syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                    printWriter.print(string);
                    string = Integer.toString(this.offsetIx(n, nArray2[1]));
                    syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                    syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                    printWriter.print(":" + string + ",");
                    syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                    for (int i = 0; i < n; ++i) {
                        string = Integer.toString(this.offsetIx(i, nArray[i]));
                        syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                        printWriter.print(string);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        String string = Integer.toString(this.offsetIx(i, nArray[i]));
                        syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                        syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                        printWriter.print(string + ",");
                    }
                    String string = Integer.toString(this.offsetIx(n, nArray2[0]));
                    syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                    printWriter.print(string);
                    if (nArray2[0] != nArray2[1]) {
                        string = Integer.toString(this.offsetIx(n, nArray2[1]));
                        syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                        syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                        printWriter.print(":" + string);
                    }
                }
                syntaxMap.putSmart(1, "SYMBOL_KEYWORD");
                printWriter.print(')');
            }
        }

        private int offsetIx(int n, int n2) {
            return n2 + this.d_ixOffsets[n];
        }

        private int unoffsetIx(int n, int n2) {
            return n2 - this.d_ixOffsets[n];
        }

        @Override
        public int[] getDimensions() {
            return this.dimensions;
        }

        @Override
        public int[] getIndexOffsets() {
            return this.d_ixOffsets;
        }

        @Override
        public FDSArray<T> set(FDSArray<T> fDSArray, int[] nArray, String string) throws ParseException {
            Object t;
            assert (nArray.length == this.dimensions.length);
            Object t2 = t = string != null ? (Object)this.elementChecker.parse(string) : null;
            if (fDSArray == null) {
                fDSArray = new FDSArray(this.dimensions);
            }
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.unoffsetIx(i, nArray[i]);
                if (nArray2[i] < this.dimensions[i] && nArray2[i] >= 0) continue;
                return fDSArray;
            }
            fDSArray.set(t, nArray2);
            return fDSArray;
        }
    }

    public static class ListFld<T>
    extends Field<List<T>> {
        public final SingleField<T> elementChecker;
        private int d_ixOffset = 1;
        private boolean d_renderAsArray;

        public ListFld(String string, List<T> list, SingleField<T> singleField) {
            super(string, list, List.class);
            this.elementChecker = singleField;
            this.d_renderAsArray = false;
        }

        public void setIndexOffset(int n) {
            this.d_ixOffset = n;
        }

        @Override
        public List<T> cloneValue(List<T> list) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (T t : list) {
                Object e = t != null ? (Object)this.elementChecker.cloneValue(t) : null;
                arrayList.add(e);
            }
            return arrayList;
        }

        public String renderStandard(FDSRenderProps fDSRenderProps, List<T> list, SyntaxMap syntaxMap) {
            int[] nArray = FDSRecordSpec.getArrayValRange(list);
            if (nArray == null) {
                return "";
            }
            StringPrintWriter stringPrintWriter = new StringPrintWriter();
            syntaxMap.putSmart(this.name.length(), "SYMBOL_KEYWORD");
            stringPrintWriter.write(this.name);
            if (nArray[0] != 0) {
                String string = Integer.toString(this.offsetIx(nArray[0]));
                syntaxMap.putSmart(1, "SYMBOL_KEYWORD");
                syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                stringPrintWriter.write("(" + string);
                if (nArray[1] != nArray[0]) {
                    string = Integer.toString(this.offsetIx(nArray[1]));
                    syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                    syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                    stringPrintWriter.write(":" + this.offsetIx(nArray[1]));
                }
                syntaxMap.putSmart(1, "SYMBOL_KEYWORD");
                stringPrintWriter.write(")");
            }
            syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
            stringPrintWriter.write("=");
            FDSRecordSpec.printArrayVals(stringPrintWriter, fDSRenderProps, list, nArray, this.elementChecker, syntaxMap);
            return stringPrintWriter.toString();
        }

        public String renderArray(FDSRenderProps fDSRenderProps, List<T> list, SyntaxMap syntaxMap) {
            try (StringPrintWriter stringPrintWriter = new StringPrintWriter();){
                for (int i = 0; i < list.size(); ++i) {
                    String string = Integer.toString(i + 1);
                    syntaxMap.putSmart(this.name.length() + 4, "SYMBOL_KEYWORD");
                    syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
                    syntaxMap.putSmart(1, "SYMBOL_KEYWORD");
                    syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                    stringPrintWriter.print("\n  " + this.name + '(' + string + ")=");
                    stringPrintWriter.print(this.elementChecker.renderVal(fDSRenderProps, list.get(i), syntaxMap));
                    if (i + 1 == list.size()) continue;
                    syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
                    stringPrintWriter.print(',');
                }
                String string = stringPrintWriter.toString();
                return string;
            }
        }

        @Override
        public String render(FDSRenderProps fDSRenderProps, List<T> list, SyntaxMap syntaxMap) {
            if (list.isEmpty()) {
                return "";
            }
            if (!this.d_renderAsArray) {
                return this.renderStandard(fDSRenderProps, list, syntaxMap);
            }
            return this.renderArray(fDSRenderProps, list, syntaxMap);
        }

        private int offsetIx(int n) {
            return n + this.d_ixOffset;
        }

        private int unoffsetIx(int n) {
            return n - this.d_ixOffset;
        }

        @Override
        public int[] getDimensions() {
            return new int[]{0x7FFFFFFE};
        }

        @Override
        public int[] getIndexOffsets() {
            return new int[]{this.d_ixOffset};
        }

        @Override
        public List<T> set(List<T> list, int[] nArray, String string) throws ParseException {
            int n;
            Object e;
            assert (nArray.length == 1);
            Object e2 = e = string != null ? (Object)this.elementChecker.parse(string) : null;
            if (list == null) {
                list = new ArrayList<T>();
            }
            if ((n = this.unoffsetIx(nArray[0])) < 0) {
                return list;
            }
            for (int i = list.size(); i <= n; ++i) {
                list.add(null);
            }
            list.set(n, e);
            return list;
        }

        public ListFld<T> setRenderAsArray(boolean bl) {
            this.d_renderAsArray = bl;
            return this;
        }

        public boolean isRenderedAsArray() {
            return this.d_renderAsArray;
        }
    }

    public static class UnitDoubleFld
    extends NumericField<UnitDouble> {
        public final Unit unit;

        public UnitDoubleFld(String string, Double d, Unit unit) {
            this(string, d, DoubleVR.UNBOUNDED, unit);
        }

        public UnitDoubleFld(String string, Double d, DoubleVR doubleVR, Unit unit) {
            super(string, d == null ? null : new UnitDouble(d, unit), UnitDoubleVR.from(doubleVR, unit), UnitDouble.class);
            this.unit = unit;
        }

        @Override
        public UnitDouble parseUnchecked(String string) throws ParseException {
            return new UnitDouble(Double.parseDouble(string), this.unit);
        }

        @Override
        public String renderVal(FDSRenderProps fDSRenderProps, UnitDouble unitDouble, SyntaxMap syntaxMap) {
            String string = fDSRenderProps.renderDouble(unitDouble.getValue(this.unit));
            syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
            return string;
        }
    }

    public static class DoubleFld
    extends NumericField<Double> {
        public DoubleFld(String string, Double d) {
            this(string, d, DoubleVR.UNBOUNDED);
        }

        public DoubleFld(String string, Double d, ValueRange<Double> valueRange) {
            super(string, d, valueRange, Double.class);
        }

        @Override
        public Double parseUnchecked(String string) {
            return Double.parseDouble(string);
        }

        @Override
        public String renderVal(FDSRenderProps fDSRenderProps, Double d, SyntaxMap syntaxMap) {
            String string = fDSRenderProps.renderDouble(d);
            syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
            return string;
        }
    }

    public static class RgbFld
    extends DoubleFld {
        public RgbFld() {
            super(null, 0.0, DoubleVR.between(0.0, 255.0, true, true));
        }

        @Override
        public String renderVal(FDSRenderProps fDSRenderProps, Double d, SyntaxMap syntaxMap) {
            String string = Integer.toString(d.intValue());
            syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
            return string;
        }
    }

    public static class IntFld
    extends NumericField<Integer> {
        public IntFld(String string, Integer n) {
            this(string, n, IntVR.UNBOUNDED);
        }

        public IntFld(String string, Integer n, ValueRange<Integer> valueRange) {
            super(string, n, valueRange, Integer.class);
        }

        @Override
        public Integer parseUnchecked(String string) {
            Integer n;
            Double d = Double.parseDouble(string);
            if (d.compareTo((n = Integer.valueOf(d.intValue())).doubleValue()) != 0) {
                String string2 = String.format(Intl.intl("Floating-point value (%s) converted to integer (%s).\n"), d, n);
                JOptionPane.showMessageDialog(null, string2, Intl.intl("Import Warning"), 2);
            }
            return n;
        }

        @Override
        public String renderVal(FDSRenderProps fDSRenderProps, Integer n, SyntaxMap syntaxMap) {
            String string = n.toString();
            syntaxMap.putSmart(string.length(), "SYMBOL_VALUE");
            return string;
        }
    }

    public static abstract class NumericField<T>
    extends SingleField<T> {
        public final ValueRange<T> range;

        public NumericField(String string, T t, ValueRange<T> valueRange, Class<T> clazz) {
            super(string, t, clazz);
            this.range = valueRange;
        }

        protected abstract T parseUnchecked(String var1) throws ParseException;

        @Override
        protected T parse(String string) throws ParseException {
            T t = this.parseUnchecked(string);
            if (!this.range.checkValue(t)) {
                throw new ParseException(String.format(Intl.intl("Invalid value for %1$s: %2$s"), this.name, this.range.describeRange()), 0);
            }
            return t;
        }

        @Override
        public T cloneValue(T t) {
            return t;
        }
    }

    public static class BooleanFld
    extends SingleField<Boolean> {
        public BooleanFld(String string, Boolean bl) {
            super(string, bl, Boolean.class);
        }

        @Override
        protected Boolean parse(String string) throws ParseException {
            String string2 = string.toUpperCase();
            if (string2.startsWith(".T") || string2.startsWith("T")) {
                return Boolean.TRUE;
            }
            if (string2.startsWith(".F") || string2.startsWith("F")) {
                return Boolean.FALSE;
            }
            throw new ParseException(Intl.intl("Unrecognized logical value specified."), 0);
        }

        @Override
        public Boolean cloneValue(Boolean bl) {
            return bl;
        }

        @Override
        public String renderVal(FDSRenderProps fDSRenderProps, Boolean bl, SyntaxMap syntaxMap) {
            String string = bl != false ? ".TRUE." : ".FALSE.";
            syntaxMap.putSmart(string.length(), "SYMBOL_REFERENCE");
            return string;
        }
    }

    public static class StringFld
    extends SingleField<String> {
        public StringFld(String string, String string2) {
            super(string, string2, String.class);
        }

        @Override
        protected String parse(String string) {
            String string2 = string;
            if (string.length() >= 2) {
                String string3 = null;
                int n = string.length() - 1;
                if (string.charAt(0) == '\"' && string.charAt(n) == '\"') {
                    string3 = "\"";
                } else if (string.charAt(0) == '\'' && string.charAt(n) == '\'') {
                    string3 = "'";
                }
                if (string3 != null) {
                    if (string.length() == 2) {
                        string2 = "";
                    } else {
                        string2 = string.substring(1, n);
                        string2 = string2.replace(string3 + "" + string3, string3);
                    }
                }
            }
            return string2;
        }

        @Override
        public String cloneValue(String string) {
            return string;
        }

        @Override
        public String renderVal(FDSRenderProps fDSRenderProps, String string, SyntaxMap syntaxMap) {
            String string2 = "'" + string.replace("'", "''") + "'";
            syntaxMap.putSmart(string2.length(), "SYMBOL_REFERENCE");
            return string2;
        }
    }

    public static abstract class SingleField<T>
    extends Field<T> {
        public SingleField(String string, T t, Class<T> clazz) {
            super(string, t, clazz);
        }

        protected abstract T parse(String var1) throws ParseException;

        protected abstract String renderVal(FDSRenderProps var1, T var2, SyntaxMap var3);

        @Override
        public T set(T t, int[] nArray, String string) throws ParseException {
            if (string == null) {
                return t;
            }
            return this.parse(string);
        }

        @Override
        public int[] getDimensions() {
            return new int[]{1};
        }

        @Override
        public int[] getIndexOffsets() {
            return new int[]{1};
        }

        @Override
        public String render(FDSRenderProps fDSRenderProps, T t, SyntaxMap syntaxMap) {
            syntaxMap.putSmart(this.name.length(), "SYMBOL_KEYWORD");
            syntaxMap.putSmart(1, "SYMBOL_SPECIAL");
            return this.name + "=" + this.renderVal(fDSRenderProps, t, syntaxMap);
        }
    }

    public static abstract class Field<T> {
        public final String name;
        public final T initialValue;
        public final Class<? super T> clazz;

        public Field(String string, T t, Class<? super T> clazz) {
            this.name = string;
            this.initialValue = t;
            this.clazz = clazz;
        }

        public T newInitialValue() {
            return this.initialValue != null ? (T)this.cloneValue(this.initialValue) : null;
        }

        public abstract T cloneValue(T var1);

        public String render(FDSRenderProps fDSRenderProps, T t) {
            return this.render(fDSRenderProps, t, new SyntaxMap());
        }

        public abstract String render(FDSRenderProps var1, T var2, SyntaxMap var3);

        public abstract int[] getDimensions();

        public abstract int[] getIndexOffsets();

        public abstract T set(T var1, int[] var2, String var3) throws ParseException;
    }
}

