/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParseWarning;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.NamesDB;
import thunderheadeng.util.Pair;

public class FDSParsingInfo {
    public static final int DBL_FAIL_ON_ERROR = 0;
    public static final int DBL_CONTINUE_ON_ERROR = 1;
    public static final int DEFAULT_DEBUG_LEVEL = 0;
    private final NamesDB d_names;
    private final String d_parsingFile;
    private final PyroMod d_wContainer;
    private final Collection<PyroMod> d_rContainers;
    private final Map<Pair<Class, String>, String> d_aliases;
    private int d_debugLevel;
    private final FDSParseResult d_parseResult = new FDSParseResult();

    public FDSParsingInfo(String string, PyroMod pyroMod, PyroMod pyroMod2) {
        this(string, pyroMod, pyroMod2, 0);
    }

    public FDSParsingInfo(String string, PyroMod pyroMod, PyroMod pyroMod2, int n) {
        this.d_names = pyroMod.getNames().clone(true);
        this.d_parsingFile = string;
        this.d_debugLevel = n;
        this.d_wContainer = pyroMod;
        this.d_rContainers = pyroMod2 == pyroMod ? Arrays.asList(pyroMod) : Arrays.asList(pyroMod, pyroMod2);
        this.d_aliases = new HashMap<Pair<Class, String>, String>();
    }

    public NameGenerator getNames(Class<?> clazz) {
        return this.d_names.getNames(clazz);
    }

    public String getParsingFile() {
        return this.d_parsingFile;
    }

    public int getDebugLevel() {
        return this.d_debugLevel;
    }

    public PyroMod getContainer() {
        return this.d_wContainer;
    }

    public Collection<PyroMod> getSourceContainers() {
        return this.d_rContainers;
    }

    public FDSParseResult getParseResult() {
        return this.d_parseResult;
    }

    public static <T extends IPyroObject> T findObject(Class<T> clazz, String string, PyroMod ... pyroModArray) {
        return FDSParsingInfo.findObject(clazz, string, Arrays.asList(pyroModArray));
    }

    public static <T extends IPyroObject> T findObject(Class<T> clazz, String string, Collection<PyroMod> collection) {
        for (PyroMod pyroMod : collection) {
            T t;
            Composite<? extends IPyroObject> composite = FDSParsingInfo.getCategoryRoot(pyroMod, clazz);
            assert (composite != null);
            if (composite == null || (t = composite.find(string, clazz, true)) == null) continue;
            return t;
        }
        return null;
    }

    private static Composite<? extends IPyroObject> getCategoryRoot(PyroMod pyroMod, Class clazz) {
        for (IPyroObject iPyroObject : pyroMod.getMembers()) {
            if (!(iPyroObject instanceof Composite) || !((Composite)iPyroObject).getType().isAssignableFrom(clazz)) continue;
            return (Composite)iPyroObject;
        }
        return null;
    }

    public <T extends IPyroObject> T findObject(Class<T> clazz, String string) {
        String string2 = this.d_aliases.get(new Pair<Class<T>, String>(clazz, string));
        if (string2 != null) {
            string = string2;
        }
        return FDSParsingInfo.findObject(clazz, string, this.d_rContainers);
    }

    public <T extends IPyroObject> T findReplacementObject(Class<T> clazz, String string) {
        return FDSParsingInfo.findObject(clazz, string, this.d_wContainer);
    }

    public void addWarning(FDSParseWarning fDSParseWarning) {
        this.d_parseResult.warningReport.addWarning(fDSParseWarning);
    }

    public void addWarning(FDSParseRecord fDSParseRecord, String string, String string2) {
        this.d_parseResult.warningReport.addWarning(new FDSParseWarning(fDSParseRecord, string, string2));
    }

    public void addAlias(Class clazz, String string, String string2) {
        this.d_aliases.put(new Pair<Class, String>(clazz, string), string2);
    }
}

