/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.ArrayList;
import java.util.List;
import org.jscience.physics.units.Unit;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordDebugInfo;
import pyrosim.io.fds.FDSRecordSpec;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Lists;

public class FDSParseRecord
extends FDSRecord {
    static final long serialVersionUID = 1L;
    private FDSRecordDebugInfo d_debugInfo = null;

    public FDSParseRecord(FDSRecordSpec fDSRecordSpec, boolean bl) {
        super(fDSRecordSpec, bl);
    }

    public FDSRecordDebugInfo getDebugInfo() {
        return this.d_debugInfo;
    }

    public void setDebugInfo(FDSRecordDebugInfo fDSRecordDebugInfo) {
        this.d_debugInfo = fDSRecordDebugInfo;
    }

    public <T> FDSArray<T> getArray(String string, boolean bl) {
        FDSRecordSpec.ArrayFld arrayFld = (FDSRecordSpec.ArrayFld)this.getSpec().fields.get(string);
        Object object = bl ? arrayFld.elementChecker.initialValue : null;
        FDSArray fDSArray = (FDSArray)this.get(string, bl);
        FDSArray<Object> fDSArray2 = new FDSArray<Object>(object, arrayFld.dimensions);
        if (fDSArray != null) {
            this.setArray(fDSArray2, fDSArray, 0, new int[arrayFld.dimensions.length]);
        }
        return fDSArray2;
    }

    private <T> void setArray(FDSArray<T> fDSArray, FDSArray<T> fDSArray2, int n, int[] nArray) {
        int n2 = fDSArray.getDimensions()[n];
        if (n == nArray.length - 1) {
            for (int i = 0; i < n2; ++i) {
                nArray[n] = i;
                T t = fDSArray2.get(nArray);
                if (t == null) continue;
                fDSArray.set(t, nArray);
            }
        } else {
            int n3 = 0;
            while (n3 < n2) {
                nArray[n] = n3++;
                this.setArray(fDSArray, fDSArray2, n + 1, nArray);
            }
        }
    }

    public <T> List<T> getList(String string, boolean bl) {
        return this.getList(string, 0, bl);
    }

    public <T> List<T> getList(String string, int n, boolean bl) {
        Object object;
        List list;
        List list2;
        FDSRecordSpec.ListFld listFld = (FDSRecordSpec.ListFld)this.getSpec().fields.get(string);
        if (listFld.isRenderedAsArray()) {
            list2 = (List)this.get(string, bl);
            list = new FDSArray(list2);
            object = new FDSArray<Object>(listFld.elementChecker.initialValue, ((FDSArray)((Object)list)).getDimensions());
            this.setArray((FDSArray<T>)object, (FDSArray<T>)((Object)list), 0, listFld.getDimensions());
        }
        list2 = bl ? ((FDSRecordSpec.ListFld)this.getSpec().fields.get((Object)string)).elementChecker.initialValue : null;
        object = (List)this.get(string, bl);
        if (object == null) {
            list = n == 0 ? null : Lists.filled(n, list2);
        } else {
            int n2 = Math.max(n, object.size());
            list = Lists.filled(n2, list2);
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                if (e == null) continue;
                list.set(i, (List)e);
            }
        }
        return list;
    }

    public String getString(String string, boolean bl) {
        return (String)this.get(string, bl);
    }

    @Override
    public String getString(String string) {
        return (String)this.get(string);
    }

    public Boolean getBoolean(String string, boolean bl) {
        return (Boolean)this.get(string, bl);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)this.get(string);
    }

    public Double getDouble(String string, boolean bl) {
        return (Double)this.get(string, bl);
    }

    public Double getDouble(String string) {
        return (Double)this.get(string);
    }

    public UnitDouble getUnitDouble(String string, boolean bl) {
        return (UnitDouble)this.get(string, bl);
    }

    public UnitDouble getUnitDouble(String string) {
        return (UnitDouble)this.get(string);
    }

    public UnitDouble getUnitDouble(String string, Unit unit, boolean bl) {
        Double d = (Double)this.get(string, bl);
        if (d == null) {
            return null;
        }
        return new UnitDouble(d, unit);
    }

    public UnitDouble getUnitDouble(String string, Unit unit) {
        Double d = (Double)this.get(string);
        if (d == null) {
            return null;
        }
        return new UnitDouble(d, unit);
    }

    public List<UnitDouble> getUnitDoubleList(String string, Unit unit, boolean bl) {
        return this.getUnitDoubleList(string, unit, bl, 0);
    }

    public List<UnitDouble> getUnitDoubleList(String string, Unit unit, boolean bl, int n) {
        List list = this.getList(string, n, bl);
        if (list == null) {
            return null;
        }
        ArrayList<UnitDouble> arrayList = new ArrayList<UnitDouble>(list.size());
        for (Double d : list) {
            arrayList.add(d == null ? null : new UnitDouble(d, unit));
        }
        return arrayList;
    }

    public Integer getInteger(String string, boolean bl) {
        return (Integer)this.get(string, bl);
    }

    public Integer getInteger(String string) {
        return (Integer)this.get(string);
    }
}

