/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.Intl;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecordDebugInfo;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSWarningReport;

public class FDSGrammar {
    private static final String REC_FIELD = "[a-zA-Z_]+[a-zA-Z_0-9]*";

    public static List<FDSParseRecord> parse(CharSequence charSequence, String string, FDSWarningReport fDSWarningReport, Map<String, FDSRecordSpec> map, String string2) throws FDSParseException {
        ArrayList<FDSParseRecord> arrayList = new ArrayList<FDSParseRecord>();
        FDSLexer fDSLexer = new FDSLexer(charSequence);
        FDSParseException fDSParseException = null;
        try {
            FDSParseRecord fDSParseRecord;
            while (fDSLexer.hasNext() && (fDSParseRecord = FDSGrammar.readNextRecord(string, fDSWarningReport, fDSLexer, map)) != null) {
                arrayList.add(fDSParseRecord);
                if (!fDSParseRecord.getType().equals(string2)) continue;
                break;
            }
        }
        catch (FDSParseException fDSParseException2) {
            fDSParseException = fDSParseException2;
        }
        catch (Exception exception) {
            fDSParseException = new FDSParseException(string, fDSLexer.getLineNumberLastMatch(), exception.getMessage(), exception.getStackTrace());
        }
        if (fDSParseException != null) {
            throw fDSParseException;
        }
        return arrayList;
    }

    private static FDSParseRecord readNextRecord(String string, FDSWarningReport fDSWarningReport, FDSLexer fDSLexer, Map<String, FDSRecordSpec> map) throws Exception {
        Object object;
        boolean bl = false;
        while (fDSLexer.hasNext()) {
            fDSLexer.swallowSpace();
            if (!fDSLexer.hasNext()) break;
            if (fDSLexer.match('&', true)) {
                bl = true;
                break;
            }
            fDSLexer.swallowLine();
        }
        if (!bl) {
            return null;
        }
        int n = fDSLexer.getLastMatchIx();
        int n2 = fDSLexer.getLineNumberLastMatch();
        String string2 = fDSLexer.match(REC_FIELD, true);
        if (string2 == null) {
            throw new Exception(Intl.intl("Record has no type."));
        }
        string2 = string2.toUpperCase();
        boolean bl2 = true;
        FDSRecordSpec fDSRecordSpec = map.get(string2);
        if (fDSRecordSpec == null) {
            fDSRecordSpec = new FDSRecordSpec(string2);
            bl2 = false;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (fDSLexer.hasNext() && fDSLexer.peek() != '/' && (object = FDSGrammar.extractFieldAssign(fDSLexer)) != null) {
            arrayList.add(object);
        }
        if (fDSLexer.match('/', false)) {
            object = fDSLexer.swallowLine();
            object = object == null ? "" : ((String)object).trim();
        } else {
            throw new Exception(String.format(Intl.intl("Record is missing its closing '/'."), new Object[0]));
        }
        int n3 = fDSLexer.getLastMatchIx();
        String string3 = fDSLexer.getText(n, n3);
        FDSRecordDebugInfo fDSRecordDebugInfo = new FDSRecordDebugInfo(string, string3, n2);
        FDSParseRecord fDSParseRecord = new FDSParseRecord(fDSRecordSpec, false);
        fDSParseRecord.setDebugInfo(fDSRecordDebugInfo);
        fDSParseRecord.setComment((String)object);
        for (FDSFieldAssign fDSFieldAssign : arrayList) {
            FDSRecordSpec.Field field = fDSRecordSpec.fields.get(fDSFieldAssign.field);
            if (field == null) {
                if (bl2) {
                    fDSWarningReport.addWarning(new FDSParseWarning(fDSParseRecord, String.format(Intl.intl("Unknown property, %1$s, for record %2$s."), fDSFieldAssign.field, string2), Intl.intl("Property ignored or added to additional fields for imported object.")));
                }
                fDSParseRecord.addUnknownProp(fDSFieldAssign.renderKey(), fDSFieldAssign.values);
                continue;
            }
            Object t = fDSParseRecord.get(fDSFieldAssign.field);
            if (t == null) {
                t = field.newInitialValue();
            }
            Object t2 = fDSFieldAssign.assign(field, t);
            fDSParseRecord.setValue(fDSFieldAssign.field, t2);
        }
        return fDSParseRecord;
    }

    private static FDSFieldAssign extractFieldAssign(FDSLexer fDSLexer) throws Exception {
        ArrayList<IArraySubscript> arrayList = new ArrayList<IArraySubscript>();
        String string = fDSLexer.matchField(arrayList, true);
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        List<String> list = FDSGrammar.extractAssignmentValues(fDSLexer);
        if (list.isEmpty()) {
            throw new Exception(String.format(Intl.intl("Invalid values specified for field, %s."), string));
        }
        return new FDSFieldAssign(string, arrayList, list);
    }

    private static void extractAssignmentRanges(FDSLexer fDSLexer, List<IArraySubscript> list) throws Exception {
        if (fDSLexer.match("\\(", true) == null) {
            return;
        }
        try {
            while (fDSLexer.hasNext()) {
                Integer n;
                Object object;
                String[] stringArray = fDSLexer.matchMultiple("([-]?[0-9]*)\\:([-]?[0-9]*)", true);
                if (stringArray != null) {
                    object = null;
                    n = null;
                    if (stringArray.length > 0 && stringArray[0] != null && stringArray[0].length() > 0) {
                        object = Integer.parseInt(stringArray[0]);
                    }
                    if (stringArray.length > 1 && stringArray[1] != null && stringArray[1].length() > 0) {
                        n = Integer.parseInt(stringArray[1]);
                    }
                    list.add(new RangeSubscript((Integer)object, n));
                } else {
                    object = fDSLexer.match("[-]?[0-9]+", true);
                    if (object == null) {
                        throw new Exception(Intl.intl("Array assignment is missing a subscript."));
                    }
                    n = Integer.parseInt((String)object);
                    list.add(new ElementSubscript(n));
                }
                if (fDSLexer.match(',', true)) continue;
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception(Intl.intl("Array subscript must be an integer."));
        }
        if (fDSLexer.match("\\)", true) == null) {
            throw new Exception(Intl.intl("Array subscript is missing its closing ')'."));
        }
    }

    private static List<String> extractAssignmentValues(FDSLexer fDSLexer) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (fDSLexer.hasNext()) {
            while (fDSLexer.match(',', true)) {
                arrayList.add(null);
            }
            if (fDSLexer.matchField(new ArrayList<IArraySubscript>(), false) != null || fDSLexer.match('/', false)) {
                fDSLexer.unmatchLast();
                break;
            }
            String string = fDSLexer.matchSingleVal();
            if (string == null) break;
            arrayList.add(string);
            fDSLexer.match(',', true);
        }
        return arrayList;
    }

    private static class FDSLexer {
        private final CharSequence d_seq;
        private final int d_length;
        private int d_numLines = 1;
        private int d_ixNumLines = 0;
        private int d_ixLastMatch = 0;
        private int d_ix = 0;

        public FDSLexer(CharSequence charSequence) {
            this.d_seq = charSequence;
            this.d_length = this.d_seq.length();
        }

        public char peek() {
            return this.d_seq.charAt(this.d_ix);
        }

        public boolean hasNext() {
            return this.d_ix < this.d_length;
        }

        public String swallowLine() {
            String string;
            this.d_ixLastMatch = this.d_ix;
            int[] nArray = this.findNext("(?m)$");
            if (nArray != null) {
                string = this.d_seq.subSequence(this.d_ix, nArray[0]).toString();
                this.d_ix = nArray[1];
            } else {
                string = this.d_seq.subSequence(this.d_ix, this.d_seq.length()).toString();
                this.d_ix = this.d_length;
            }
            return string;
        }

        public void swallowSpace() {
            while (this.d_ix < this.d_length) {
                char c = this.d_seq.charAt(this.d_ix);
                if (Character.isWhitespace(c)) {
                    ++this.d_ix;
                    continue;
                }
                if (c == '!') {
                    this.swallowLine();
                    continue;
                }
                return;
            }
        }

        public boolean match(char c, boolean bl) {
            if (this.d_seq.charAt(this.d_ix) == c) {
                this.d_ixLastMatch = this.d_ix++;
                if (bl) {
                    this.swallowSpace();
                }
                return true;
            }
            return false;
        }

        public String matchBool() {
            return this.match("([\\.]*[tT]{1}[a-zA-Z]*[\\.]*)|([\\.]*[fF]{1}[a-zA-Z]*[\\.]*)", true);
        }

        public String matchNumber() {
            return this.match("([-+]?(([0-9]+\\.[0-9]+)|([0-9]+\\.)|(\\.[0-9]+)|([0-9]+))([eE][-+]?[0-9]+)?)", true);
        }

        public String matchString() {
            String string = this.match("(\\\"([^\\\"]*(\\\"\\\"[^\\\"]*)*)\\\")", true);
            if (string != null) {
                return string;
            }
            String string2 = this.match("(\\'([^\\']*(\\'\\'[^\\']*)*)\\')", true);
            if (string2 != null) {
                return string2;
            }
            return null;
        }

        public String matchField(List<IArraySubscript> list, boolean bl) throws Exception {
            int n = this.d_ix;
            String string = this.match(FDSGrammar.REC_FIELD, true);
            if (string == null) {
                return null;
            }
            FDSGrammar.extractAssignmentRanges(this, list);
            if (!this.match('=', bl)) {
                this.d_ixLastMatch = n;
                this.d_ix = n;
                return null;
            }
            this.d_ixLastMatch = n;
            return string;
        }

        public int[] findNext(String string) {
            Matcher matcher = Pattern.compile(string).matcher(this.d_seq);
            if (!matcher.find(this.d_ix)) {
                return null;
            }
            return new int[]{matcher.start(), matcher.end()};
        }

        public String matchSingleVal() {
            String string = this.matchBool();
            if (string != null) {
                return string;
            }
            String string2 = this.matchNumber();
            if (string2 != null) {
                return string2.replaceFirst("^[+]", "");
            }
            return this.matchString();
        }

        public String match(String string, boolean bl) {
            Matcher matcher = Pattern.compile(string).matcher(this.d_seq).region(this.d_ix, this.d_length);
            if (!matcher.lookingAt()) {
                return null;
            }
            assert (matcher.start() == this.d_ix);
            String string2 = matcher.groupCount() > 0 && matcher.group(1) != null ? matcher.group(1) : matcher.group(0);
            this.d_ixLastMatch = this.d_ix;
            this.d_ix = matcher.end();
            if (bl) {
                this.swallowSpace();
            }
            return string2;
        }

        public String[] matchMultiple(String string, boolean bl) {
            Matcher matcher = Pattern.compile(string).matcher(this.d_seq).region(this.d_ix, this.d_length);
            if (!matcher.lookingAt()) {
                return null;
            }
            assert (matcher.start() == this.d_ix);
            String[] stringArray = new String[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                stringArray[i] = matcher.group(i + 1);
            }
            this.d_ixLastMatch = this.d_ix;
            this.d_ix = matcher.end();
            if (bl) {
                this.swallowSpace();
            }
            return stringArray;
        }

        public void unmatchLast() {
            this.d_ix = this.d_ixLastMatch;
        }

        public int getLastMatchIx() {
            return this.d_ixLastMatch;
        }

        public int getLineNumberLastMatch() {
            if (this.d_ixNumLines == this.d_ixLastMatch) {
                return this.d_numLines;
            }
            Matcher matcher = Pattern.compile("(?m)^").matcher(this.d_seq);
            if (matcher.find(this.d_ixNumLines)) {
                while (matcher.find() && matcher.end() <= this.d_ixLastMatch) {
                    ++this.d_numLines;
                }
                this.d_ixNumLines = this.d_ixLastMatch;
            }
            return this.d_numLines;
        }

        public String getText(int n, int n2) {
            return this.d_seq.subSequence(n, n2).toString();
        }
    }

    private static class FDSFieldAssign {
        public final String field;
        public final List<IArraySubscript> subscripts;
        public final List<String> values;

        public FDSFieldAssign(String string, List<IArraySubscript> list, List<String> list2) {
            this.field = string;
            this.subscripts = list;
            this.values = list2;
        }

        public String renderKey() {
            String string = this.field;
            if (this.subscripts.size() > 0) {
                string = string + "(";
                for (int i = 0; i < this.subscripts.size(); ++i) {
                    if (i != 0) {
                        string = string + ',';
                    }
                    string = string + this.subscripts.get(i).render();
                }
                string = string + ")";
            }
            return string;
        }

        public <T> T assign(FDSRecordSpec.Field<T> field, T t) throws Exception {
            int[] nArray = field.getDimensions();
            int[] nArray2 = field.getIndexOffsets();
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            if (this.subscripts.isEmpty()) {
                FDSFieldAssign.getIxes(arrayList, this.values.size(), new int[nArray.length], nArray.length - 1, nArray, nArray2, null);
            } else {
                if (this.subscripts.size() != nArray.length) {
                    throw new Exception(String.format(Intl.intl("Field %1$s must have 0 or %2$d subscripts."), field.name, nArray.length));
                }
                FDSFieldAssign.getIxes(arrayList, this.values.size(), new int[nArray.length], nArray.length - 1, nArray, nArray2, this.subscripts);
            }
            int n = Math.min(arrayList.size(), this.values.size());
            for (int i = 0; i < n; ++i) {
                int[] nArray3 = (int[])arrayList.get(i);
                t = field.set(t, nArray3, this.values.get(i));
            }
            return t;
        }

        private static void getIxes(List<int[]> list, int n, int[] nArray, int n2, int[] nArray2, int[] nArray3, List<IArraySubscript> list2) {
            int n3 = nArray3[n2];
            int n4 = nArray3[n2] + nArray2[n2];
            if (list2 != null) {
                IArraySubscript iArraySubscript = list2.get(n2);
                Integer[] integerArray = iArraySubscript.getRange();
                if (integerArray[0] != null) {
                    n3 = integerArray[0];
                }
                if (integerArray[1] != null) {
                    n4 = integerArray[1];
                }
            }
            if (n2 == 0) {
                int n5 = n3;
                while (n5 <= n4) {
                    nArray[n2] = n5++;
                    list.add((int[])nArray.clone());
                    if (list.size() < n) continue;
                    return;
                }
            } else {
                int n6 = n3;
                while (n6 <= n4) {
                    nArray[n2] = n6++;
                    FDSFieldAssign.getIxes(list, n, nArray, n2 - 1, nArray2, nArray3, list2);
                    if (list.size() < n) continue;
                    return;
                }
            }
        }
    }

    private static class ElementSubscript
    implements IArraySubscript {
        public final int ix;

        public ElementSubscript(int n) {
            this.ix = n;
        }

        @Override
        public String render() {
            return new Integer(this.ix).toString();
        }

        @Override
        public Integer[] getRange() {
            return new Integer[]{this.ix, this.ix};
        }
    }

    private static class RangeSubscript
    implements IArraySubscript {
        public final Integer ix1;
        public final Integer ix2;

        public RangeSubscript(Integer n, Integer n2) {
            this.ix1 = n;
            this.ix2 = n2;
        }

        @Override
        public String render() {
            if (this.ix1 != null && this.ix2 != null) {
                return this.ix1 + ":" + this.ix2;
            }
            if (this.ix1 != null) {
                return this.ix1 + ":";
            }
            if (this.ix2 != null) {
                return ":" + this.ix2;
            }
            return ":";
        }

        @Override
        public Integer[] getRange() {
            return new Integer[]{this.ix1, this.ix2};
        }
    }

    private static interface IArraySubscript {
        public String render();

        public Integer[] getRange();
    }
}

