/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import pyroloader.IPyroGeom;
import pyroloader.PyroPoint3d;
import pyrosim.io.extloader.DataStore;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.util.IPropertySet;

public class GeomWrapper
implements IPyroGeom {
    private final DataStore d_store;
    private final IGeomNode d_geom;
    private IPyroGeom d_baseGeom = null;

    public GeomWrapper(DataStore dataStore, IGeomNode iGeomNode) {
        this.d_store = dataStore;
        int[] nArray = dataStore.getLoadOptions().getSupportedGeomTypes();
        while (GeomWrapper.getType(iGeomNode, nArray) == 0 && GeomWrapper.canExplode(iGeomNode)) {
            ArrayList<IGeomNode> arrayList = new ArrayList<IGeomNode>();
            GeomWrapper.explode(iGeomNode, arrayList);
            if (arrayList.isEmpty()) break;
            if (arrayList.size() == 1) {
                iGeomNode = (IGeomNode)arrayList.iterator().next();
                continue;
            }
            iGeomNode = GeomNodeUtil.newNode(arrayList);
        }
        this.d_geom = iGeomNode;
    }

    private static boolean canExplode(IGeomNode iGeomNode) {
        return iGeomNode.getLocalGeom().canExplode() || !iGeomNode.getChildren().isEmpty();
    }

    private static boolean isGroup(IGeomNode iGeomNode) {
        return iGeomNode.getLocalGeom() instanceof GeomGroup || !iGeomNode.getChildren().isEmpty();
    }

    private static boolean isTransformed(IGeomNode iGeomNode) {
        return !iGeomNode.getLocalTransform().isIdentity();
    }

    private static void explode(IGeomNode iGeomNode, List<IGeomNode> list) {
        if (iGeomNode.getLocalGeom().canExplode()) {
            int n = 0;
            ArrayList arrayList = new ArrayList();
            iGeomNode.getLocalGeom().explode(arrayList);
            Iterator object = arrayList.iterator();
            while (object.hasNext()) {
                IGeom iGeom = (IGeom)object.next();
                int n2 = iGeom.getNumPrims(7);
                IPropertySet iPropertySet = Elements.subset(iGeomNode.getLocalElements(), n, n2);
                list.add(GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), iGeom, iPropertySet));
                n += n2;
            }
        }
        TransformInfo transformInfo = iGeomNode.getLocalTransform().getInfo();
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            list.add(iGeomNode2.transform(transformInfo));
        }
    }

    public int getType() {
        return GeomWrapper.getType(this.d_geom, this.d_store.getLoadOptions().getSupportedGeomTypes());
    }

    public static int getType(IGeomNode iGeomNode, int[] nArray) {
        int n = 0;
        if (GeomWrapper.isTransformed(iGeomNode)) {
            n = 2;
        } else if (GeomWrapper.isGroup(iGeomNode)) {
            n = 1;
        } else {
            IGeom iGeom = iGeomNode.getLocalGeom();
            if (iGeom instanceof Mesh) {
                n = 3;
            } else if (iGeom instanceof AABoxGeom) {
                n = 4;
            } else if (iGeom instanceof IPolygon) {
                n = 5;
            } else if (iGeom instanceof PolyLine) {
                n = 6;
            } else if (iGeom instanceof Point) {
                n = 7;
            }
        }
        if (n != 0 && !GeomWrapper.contains(nArray, n)) {
            n = 0;
        }
        return n;
    }

    private static boolean contains(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public PyroPoint3d[] getBoundingBox() {
        AABox aABox = this.d_geom.getBoundingBox(new AABox());
        return this.d_store.getPoints(aABox.getMin(), aABox.getMax());
    }

    public int getNumPrims() {
        return this.d_geom.getNumPrims(7);
    }

    public Collection<? extends IPyroGeom> getChildren() {
        if (GeomWrapper.isGroup(this.d_geom)) {
            ArrayList<IPyroGeom> arrayList = new ArrayList<IPyroGeom>();
            if (this.d_geom.getLocalGeom() instanceof GeomGroup) {
                GeomGroup geomGroup = (GeomGroup)this.d_geom.getLocalGeom();
                for (IGeom iGeom : geomGroup.children) {
                    arrayList.add(this.d_store.getGeom(iGeom));
                }
            } else if (this.d_geom.getLocalGeom() != EmptyGeom.INSTANCE) {
                arrayList.add(this.d_store.getGeom(this.d_geom.getLocalGeom()));
            }
            for (IGeomNode iGeomNode : this.d_geom.getChildren()) {
                arrayList.add(this.d_store.getNodeAsGeom(iGeomNode));
            }
            return arrayList;
        }
        return null;
    }

    public IPyroGeom getBaseGeom() {
        if (GeomWrapper.isTransformed(this.d_geom)) {
            if (this.d_baseGeom == null) {
                this.d_baseGeom = new GeomWrapper(this.d_store, this.d_geom.applyLocalTransform(TransformUtil.IDENTITY));
            }
            return this.d_baseGeom;
        }
        return null;
    }

    public double[] getTransform() {
        if (GeomWrapper.isTransformed(this.d_geom)) {
            Matrix4d matrix4d = this.d_geom.getLocalTransform().toMatrix(false);
            return new double[]{matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33};
        }
        return null;
    }

    public int getSubType() {
        if (this.d_geom.getLocalGeom() instanceof Mesh) {
            switch (((Mesh)this.d_geom.getLocalGeom()).primtype) {
                case 1: {
                    return 2;
                }
                case 0: {
                    return 1;
                }
                case 3: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return 0;
    }

    public PyroPoint3d[] getVerts() {
        if (this.d_geom.getLocalGeom() instanceof Mesh) {
            Mesh mesh = (Mesh)this.d_geom.getLocalGeom();
            return this.d_store.getPoints(mesh.vertices);
        }
        return null;
    }

    public int[] getIndices() {
        if (this.d_geom.getLocalGeom() instanceof Mesh) {
            Mesh mesh = (Mesh)this.d_geom.getLocalGeom();
            return mesh.indices;
        }
        return null;
    }

    public PyroPoint3d[] getCorners() {
        if (this.d_geom.getLocalGeom() instanceof AABoxGeom) {
            AABoxGeom aABoxGeom = (AABoxGeom)this.d_geom.getLocalGeom();
            return this.d_store.getPoints(aABoxGeom.min, aABoxGeom.max);
        }
        return null;
    }

    public short getFaceSwizzle() {
        return this.d_geom.getLocalGeom() instanceof AABoxGeom ? ((AABoxGeom)this.d_geom.getLocalGeom()).swizzle : (short)0;
    }

    public PyroPoint3d[][] getLoops() {
        if (this.d_geom.getLocalGeom() instanceof IPolygon) {
            IPolygon iPolygon = (IPolygon)this.d_geom.getLocalGeom();
            ArrayList<PyroPoint3d[]> arrayList = new ArrayList<PyroPoint3d[]>(iPolygon.getNumLoops());
            for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
                int n = iPolygon.getNumPoints(i);
                if (n == 0) continue;
                PyroPoint3d[] pyroPoint3dArray = new PyroPoint3d[n];
                for (int j = 0; j < n; ++j) {
                    pyroPoint3dArray[j] = this.d_store.getPoint(iPolygon.getPoint(i, j));
                }
                arrayList.add(pyroPoint3dArray);
            }
            return (PyroPoint3d[][])arrayList.toArray((T[])new PyroPoint3d[arrayList.size()][]);
        }
        return null;
    }

    public PyroPoint3d[] getPoints() {
        if (this.d_geom.getLocalGeom() instanceof PolyLine) {
            PolyLine polyLine = (PolyLine)this.d_geom.getLocalGeom();
            return this.d_store.getPoints(polyLine.verts);
        }
        return null;
    }

    public PyroPoint3d getLocation() {
        if (this.d_geom.getLocalGeom() instanceof Point) {
            return this.d_store.getPoint(((Point)this.d_geom.getLocalGeom()).loc);
        }
        return null;
    }
}

