/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import pyroloader.IPyroGeom;
import pyroloader.IPyroGeomNode;
import pyroloader.IPyroGeomSrc;
import pyroloader.IPyroPrimProps;
import pyroloader.IPyroSurface;
import pyroloader.PyroPoint2d;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.io.extloader.DataStore;
import pyrosim.io.extloader.GeomNodeWrapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.theUtil;

public class GeomSrcWrapper
implements IPyroGeomSrc {
    private final DataStore d_store;
    private final IPyroObject d_geom;
    private final DisplayGeom d_dispGeom;
    private final Surface[] d_surfs;

    public GeomSrcWrapper(DataStore dataStore, IPyroObject iPyroObject) {
        this.d_store = dataStore;
        this.d_geom = iPyroObject;
        if (iPyroObject instanceof Grid) {
            Surface[] surfaceArray;
            Grid grid = (Grid)iPyroObject;
            DisplayGeom displayGeom = grid.getDisplayGeom(this.d_store.getDisplayProps());
            AABox aABox = grid.getBounds();
            Surface surface = grid.getDomain() != null ? ((PyroMod)grid.getDomain()).getSimParams().getMisc().getSurfDefault() : null;
            IPrimProps.Face face = FDSUtil.newObstFaceProps(grid.getColor(), surface, 0);
            this.d_dispGeom = new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(new AABoxGeom(aABox), displayGeom.node.getLocalElements()), new UniformProps(face));
            if (surface != null) {
                Surface[] surfaceArray2 = new Surface[1];
                surfaceArray = surfaceArray2;
                surfaceArray2[0] = surface;
            } else {
                surfaceArray = new Surface[]{};
            }
            this.d_surfs = surfaceArray;
        } else {
            this.d_surfs = iPyroObject instanceof ISurfObj ? ((ISurfObj)iPyroObject).getSurfaces() : new Surface[0];
            this.d_dispGeom = iPyroObject instanceof pyrosim.domain.IPyroGeomSrc ? ((pyrosim.domain.IPyroGeomSrc)iPyroObject).getDisplayGeom(this.d_store.getDisplayProps()) : DisplayGeom.EMPTY;
        }
    }

    public int getType() {
        if (this.d_geom instanceof Vent) {
            return 2;
        }
        if (this.d_geom instanceof IObstruction) {
            return 3;
        }
        if (this.d_geom instanceof IHole) {
            return 4;
        }
        if (this.d_geom instanceof Grid) {
            return 5;
        }
        if (this.d_geom instanceof ModelComposite) {
            return 1;
        }
        return 0;
    }

    public String getName() {
        return this.d_geom instanceof INamed ? ((INamed)this.d_geom).getName() : "";
    }

    public Collection<IPyroGeomSrc> getChildren() {
        if (this.d_geom instanceof ModelComposite) {
            ModelComposite modelComposite = (ModelComposite)this.d_geom;
            ArrayList<IPyroGeomSrc> arrayList = new ArrayList<IPyroGeomSrc>(modelComposite.getMembers().size());
            for (IPyroObject iPyroObject : modelComposite.getMembers()) {
                if (!this.d_store.include(iPyroObject)) continue;
                arrayList.add(new GeomSrcWrapper(this.d_store, iPyroObject));
            }
            return arrayList;
        }
        return null;
    }

    public Color[] getColors() {
        int n = this.d_dispGeom.node.getNumPrims(7);
        if (this.d_dispGeom.props.getUniformCount(0, n) == n) {
            n = 1;
        }
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = this.d_dispGeom.props.get(i).getColor();
        }
        return colorArray;
    }

    public IPyroSurface[] getSurfaces() {
        Surface[] surfaceArray = this.d_surfs;
        IPyroSurface[] iPyroSurfaceArray = new IPyroSurface[surfaceArray.length];
        for (int i = 0; i < surfaceArray.length; ++i) {
            iPyroSurfaceArray[i] = this.d_store.getSurface(surfaceArray[i]);
        }
        return iPyroSurfaceArray;
    }

    public IPyroPrimProps[] getPrimProps() {
        int n = this.d_dispGeom.node.getNumPrims(7);
        if (n == 0) {
            return new IPyroPrimProps[0];
        }
        if (this.d_dispGeom.props.getUniformCount(0, n) == n) {
            n = 1;
        }
        IPyroPrimProps[] iPyroPrimPropsArray = new IPyroPrimProps[n];
        for (int i = 0; i < n; ++i) {
            IPrimProps iPrimProps = this.d_dispGeom.props.get(i);
            iPyroPrimPropsArray[i] = this.d_store.getProps(iPrimProps);
        }
        return iPyroPrimPropsArray;
    }

    public IPyroGeomNode getGeomRoot() {
        return this.d_store.getNode(this.d_dispGeom.node);
    }

    public IPyroGeomSrc.TexCoords getTexCoords() {
        IGeomNode iGeomNode = this.d_dispGeom.node.flatten();
        List<IPrimitive> list = GeomUtil.explode(iGeomNode.getLocalGeom(), IPrimitive.class);
        PyroPoint2d[][] pyroPoint2dArray = (PyroPoint2d[][])GeomNodeWrapper.getElements(this.d_store, iGeomNode, list, IPyroGeomNode.UV, this.d_dispGeom.props.iterator());
        int[][] nArrayArray = new int[pyroPoint2dArray.length][];
        LinkedHashMap<PyroPoint2d, Integer> linkedHashMap = new LinkedHashMap<PyroPoint2d, Integer>();
        for (int i = 0; i < pyroPoint2dArray.length; ++i) {
            PyroPoint2d[] pyroPoint2dArray2 = pyroPoint2dArray[i];
            if (pyroPoint2dArray2 == null) continue;
            int[] nArray = new int[pyroPoint2dArray2.length];
            nArrayArray[i] = nArray;
            for (int j = 0; j < pyroPoint2dArray2.length; ++j) {
                int n;
                nArray[j] = n = linkedHashMap.computeIfAbsent(pyroPoint2dArray2[j], pyroPoint2d -> linkedHashMap.size()).intValue();
            }
        }
        return new IPyroGeomSrc.TexCoords(theUtil.toArray(linkedHashMap.keySet(), PyroPoint2d.class), (int[][])nArrayArray);
    }

    public IPyroGeom getGeom() {
        return this.d_store.getNodeAsGeom(this.d_dispGeom.node);
    }
}

