/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Vector3d;
import pyroloader.IPyroGeom;
import pyroloader.IPyroGeomNode;
import pyroloader.IPyroPrimProps;
import pyroloader.PyroPoint2d;
import pyroloader.PyroPoint3d;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.io.extloader.DataStore;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.MappedIterator;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class GeomNodeWrapper
implements IPyroGeomNode {
    private final DataStore d_store;
    private final IGeomNode d_node;
    private List<IPrimitive> d_cachedPrims;

    public GeomNodeWrapper(DataStore dataStore, IGeomNode iGeomNode) {
        this.d_store = dataStore;
        this.d_node = iGeomNode;
    }

    public double[] getTransform() {
        if (this.d_node.getLocalTransform().isIdentity()) {
            return DataStore.IDENTITY_XFORM;
        }
        double[] dArray = new double[16];
        Matrix4d matrix4d = this.d_node.getLocalTransform().toMatrix(false);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray[i * 4 + j] = matrix4d.getElement(i, j);
            }
        }
        return dArray;
    }

    public IPyroGeom getGeom() {
        return this.d_store.getGeom(this.d_node.getLocalGeom());
    }

    public <T> T[][] getElements(double[] dArray, IPyroGeomNode.Elem<T> elem, List<IPyroPrimProps> list) {
        IGeomNode iGeomNode = this.d_node;
        List<IPrimitive> list2 = this.getCachedPrims(new MatrixXform(new Matrix4d(dArray)));
        return GeomNodeWrapper.getElements(this.d_store, iGeomNode, list2, elem, this.getPropIterator(list));
    }

    private Iterator<IPrimProps> getPropIterator(List<IPyroPrimProps> list) {
        return new MappedIterator<IPyroPrimProps, IPrimProps>(list.iterator(), iPyroPrimProps -> this.d_store.getNativeProps((IPyroPrimProps)iPyroPrimProps));
    }

    protected List<IPrimitive> getCachedPrims(ITransform iTransform) {
        if (this.d_cachedPrims == null) {
            TransformInfo transformInfo = iTransform.concatenate(this.d_node.getLocalTransform()).getInfo();
            this.d_cachedPrims = GeomUtil.explode(this.d_node.getLocalGeom(), IPrimitive.class);
            this.d_cachedPrims = new ArrayList<IPrimitive>(theUtil.map(this.d_cachedPrims, iPrimitive -> iPrimitive.transform(transformInfo, 0)));
        }
        return this.d_cachedPrims;
    }

    public Map<String, PyroPoint2d[][]> getUVElements(double[] dArray, List<IPyroPrimProps> list) {
        Map<String, IElemSource<Point2d>> map = this.d_node.getLocalElements().get(Elements.UV);
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, PyroPoint2d[][]> hashMap = new HashMap<String, PyroPoint2d[][]>();
        List<IPrimitive> list2 = this.getCachedPrims(new MatrixXform(new Matrix4d(dArray)));
        for (Map.Entry<String, IElemSource<Point2d>> entry : map.entrySet()) {
            IElemSource<Point2d> iElemSource = entry.getValue();
            HashMap hashMap2 = new HashMap();
            Function<Point2d, PyroPoint2d> function = point2d -> new PyroPoint2d(point2d.x, point2d.y);
            PyroPoint2d[][] pyroPoint2dArray = GeomNodeWrapper.getElements(this.d_store, this.d_node, list2, PyroPoint2d.class, this.getPropIterator(list), Point2d.class, (n, iPrimProps) -> iElemSource.getPrimSource((int)n), point2d -> (PyroPoint2d)hashMap2.computeIfAbsent(point2d, function), Mapping.FACE_VERT, iPrimProps -> {
                Surface surface = (Surface)iPrimProps.getMaterial();
                return surface != null && surface.getAppearance() != null;
            });
            hashMap.put(entry.getKey(), pyroPoint2dArray);
        }
        return hashMap;
    }

    public static <T, NT> T[][] getElements(DataStore dataStore, IGeomNode iGeomNode, List<IPrimitive> list, IPyroGeomNode.Elem<T> elem, Iterator<IPrimProps> iterator) {
        if (elem.equals((Object)UV)) {
            HashMap hashMap = new HashMap();
            Function<Point2d, PyroPoint2d> function = point2d -> new PyroPoint2d(point2d.x, point2d.y);
            Map<String, IElemSource<Point2d>> map = iGeomNode.getLocalElements().get(Elements.UV);
            return GeomNodeWrapper.getElements(dataStore, iGeomNode, list, PyroPoint2d.class, iterator, Point2d.class, (n, iPrimProps) -> {
                Texture texture;
                Texture texture2 = texture = iPrimProps.getMaterial() != null ? iPrimProps.getMaterial().getAttributes().getTexture(MatChannel.DIFFUSE) : null;
                if (texture != null) {
                    IElemSource iElemSource = (IElemSource)map.get(texture.uvSet);
                    if (iElemSource == null && (iElemSource = (IElemSource)map.get("teciuv0x193fa")) == null) {
                        return Elements.NO_UV;
                    }
                    return iElemSource.getPrimSource((int)n);
                }
                return Elements.NO_UV;
            }, point2d -> (PyroPoint2d)hashMap.computeIfAbsent(point2d, function), Mapping.FACE_VERT, iPrimProps -> {
                Surface surface = (Surface)iPrimProps.getMaterial();
                return surface != null && surface.getAppearance() != null;
            });
        }
        if (elem.equals((Object)CCW)) {
            return GeomNodeWrapper.getElements(dataStore, iGeomNode, list, elem, iterator, Elements.ORIENT, orient -> orient == Elements.Orient.CCW ? Boolean.TRUE : Boolean.FALSE, Mapping.PRIM, Predicates.alwaysTrue());
        }
        if (elem.equals((Object)NORMAL)) {
            HashMap hashMap = new HashMap();
            Function<Vector3d, PyroPoint3d> function = vector3d -> new PyroPoint3d(vector3d.x, vector3d.y, vector3d.z);
            return GeomNodeWrapper.getElements(dataStore, iGeomNode, list, elem, iterator, Elements.NORMAL, vector3d -> hashMap.computeIfAbsent(vector3d, function), Mapping.FACE_VERT, Predicates.alwaysTrue());
        }
        if (elem.equals((Object)CREASE)) {
            return GeomNodeWrapper.getElements(dataStore, iGeomNode, list, elem, iterator, Elements.CREASE, bl -> bl, Mapping.FACE_VERT, Predicates.alwaysTrue());
        }
        return (Object[][])Array.newInstance(elem.type, 0, 0);
    }

    public static <T, NT> T[][] getElements(DataStore dataStore, IGeomNode iGeomNode, List<IPrimitive> list, IPyroGeomNode.Elem<T> elem, Iterator<IPrimProps> iterator, Elements.ElemProp<NT> elemProp, Function<NT, T> function, Mapping mapping, Predicate<IPrimProps> predicate) {
        IElemSource iElemSource = iGeomNode.getElements(elemProp);
        return GeomNodeWrapper.getElements(dataStore, iGeomNode, list, elem.type, iterator, elemProp.type, (n, iPrimProps) -> iElemSource.getPrimSource((int)n), function, mapping, predicate);
    }

    private static <T, NT> T[][] getElements(DataStore dataStore, IGeomNode iGeomNode, List<IPrimitive> list, Class<T> clazz, Iterator<IPrimProps> iterator, Class<NT> clazz2, BiFunction<Integer, IPrimProps, IElemSource<NT>> biFunction, Function<NT, T> function, Mapping mapping, Predicate<IPrimProps> predicate) {
        Iterator iterator2 = ((IElemSource)((Object)iGeomNode.getLocalElements().get(Elements.ORIENT))).getPrimIterator();
        Iterator<IPrimProps> iterator3 = iterator;
        Object[][] objectArray = (Object[][])Array.newInstance(clazz, list.size(), 0);
        block4: for (int i = 0; i < list.size(); ++i) {
            IPrimitive iPrimitive = list.get(i);
            IPrimProps iPrimProps = iterator3.next();
            IElemSource<NT> iElemSource = biFunction.apply(i, iPrimProps);
            IElemSource<Elements.Orient> iElemSource2 = iterator2.next();
            if (!(iPrimitive instanceof IPolygon) || !predicate.test(iPrimProps)) {
                objectArray[i] = null;
                continue;
            }
            IPolygon iPolygon = (IPolygon)iPrimitive;
            int n = PolyUtil.getNumVerts(iPolygon);
            if (iElemSource == Elements.NO_UV) {
                objectArray[i] = null;
                continue;
            }
            ElementMesh<NT> elementMesh = iElemSource.generate(clazz2, Collections.singletonList(iPolygon), iElemSource2, new UniformProps(iPrimProps), n, false);
            switch (mapping) {
                case PRIM: {
                    Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
                    T t = function.apply(elementMesh.getPrimElement(0));
                    Arrays.fill(objectArray2, t);
                    objectArray[i] = objectArray2;
                    continue block4;
                }
                case FACE_VERT: {
                    Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
                    for (int j = 0; j < n; ++j) {
                        NT NT = elementMesh.getPrimVertElement(0, j);
                        objectArray2[j] = function.apply(NT);
                    }
                    objectArray[i] = objectArray2;
                    continue block4;
                }
            }
        }
        return objectArray;
    }

    public IPyroGeomNode[] getChildren() {
        Collection<? extends IGeomNode> collection = this.d_node.getChildren();
        IPyroGeomNode[] iPyroGeomNodeArray = new IPyroGeomNode[collection.size()];
        int n = 0;
        for (IGeomNode iGeomNode : collection) {
            iPyroGeomNodeArray[n++] = new GeomNodeWrapper(this.d_store, iGeomNode);
        }
        return iPyroGeomNodeArray;
    }

    public static enum Mapping {
        FACE_VERT,
        PRIM;

    }
}

