/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import pyroloader.IPyroDataStore;
import pyroloader.IPyroGeom;
import pyroloader.IPyroGeomNode;
import pyroloader.IPyroGeomSrc;
import pyroloader.IPyroPrimProps;
import pyroloader.IPyroSurface;
import pyroloader.PyroLoadOptions;
import pyroloader.PyroPoint3d;
import pyroloader.PyroTexture;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.ImportFDSFile;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.extloader.GeomNodeWrapper;
import pyrosim.io.extloader.GeomSrcWrapper;
import pyrosim.io.extloader.GeomWrapper;
import pyrosim.io.extloader.PrimPropWrapper;
import pyrosim.io.extloader.SurfWrapper;
import pyrosim.mv.displays.ClippingManager;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.image.IImage;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class DataStore
implements IPyroDataStore {
    public static final double[] IDENTITY_XFORM = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private final PyroMod d_model = new PyroMod(true);
    private final Map<IGeomNode, IPyroGeom> d_nodeToGeomMap = new IdentityHashMap<IGeomNode, IPyroGeom>();
    private final Map<IGeom, IPyroGeom> d_geomMap;
    private final Map<IGeomNode, IPyroGeomNode> d_nodeMap = new IdentityHashMap<IGeomNode, IPyroGeomNode>();
    private final Map<Surface, IPyroSurface> d_surfMap;
    private final Map<Point3d, PyroPoint3d> d_pMap;
    private final Map<IPrimProps, IPyroPrimProps> d_propsMap;
    private final Map<IPyroPrimProps, IPrimProps> d_revPropsMap;
    private final Map<IImage, byte[]> d_imgDataMap;
    private PyroLoadOptions d_loadOptions;
    private GridMergeUtil.MergeResult d_mergedGridsCache;

    public DataStore() {
        this.d_geomMap = new IdentityHashMap<IGeom, IPyroGeom>();
        this.d_surfMap = new IdentityHashMap<Surface, IPyroSurface>();
        this.d_propsMap = new IdentityHashMap<IPrimProps, IPyroPrimProps>();
        this.d_revPropsMap = new IdentityHashMap<IPyroPrimProps, IPrimProps>();
        this.d_imgDataMap = new IdentityHashMap<IImage, byte[]>();
        this.d_pMap = new HashMap<Point3d, PyroPoint3d>();
    }

    public String getPyroSimRevision() {
        return "2018.3.1210";
    }

    private void initApp() {
        new PyroSim(this.d_loadOptions.getAppName(), this.d_loadOptions.getInstallDir(), this.d_loadOptions.getActiveFrame());
    }

    public void readPyroSim(String string, PyroLoadOptions pyroLoadOptions) throws Exception {
        this.readPyroSim(null, string, pyroLoadOptions);
    }

    private static void printWarnings(WarningReport<Warning> warningReport) {
        if (!warningReport.isEmpty()) {
            System.out.println("Import warnings:");
            String string = warningReport.prepareReport();
            if (string.length() < 262144) {
                System.out.println(string);
            } else {
                System.out.println("Warning report too long to print.");
            }
        }
    }

    public void readPyroSim(Component component, String string, PyroLoadOptions pyroLoadOptions) throws Exception {
        this.d_model.updateGeomSearchesEnabled(pyroLoadOptions.cutHoles());
        this.d_loadOptions = pyroLoadOptions;
        this.initApp();
        int n = Integer.MAX_VALUE;
        String[] stringArray = new PyroSimObjectInputStream(new BufferedInputStream(new FileInputStream(string)));
        Object object = null;
        try {
            if (stringArray.isNewer()) {
                String string2 = String.format(Intl.intl("This file was created with %s, which is newer\nthan this importer supports."), "PyroSim " + stringArray.getRevision());
                throw new IOException(string2);
            }
            if (stringArray.canOpenVersion()) {
                this.d_model.openModel((PyroSimObjectInputStream)stringArray, true);
                DataStore.printWarnings(stringArray.getWarnings());
                return;
            }
            n = stringArray.getVersion();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stringArray != null) {
                if (object != null) {
                    try {
                        stringArray.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stringArray.close();
                }
            }
        }
        stringArray = new String[]{Intl.intl("Record"), Intl.intl("Action")};
        object = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), stringArray, 0);
        if (n >= 20) {
            try (pyrosim.legacy_2012_1.io.PyroSimObjectInputStream pyroSimObjectInputStream = new pyrosim.legacy_2012_1.io.PyroSimObjectInputStream(new BufferedInputStream(new FileInputStream(string)), Collections.EMPTY_SET);){
                pyrosim.legacy_2012_1.PyroMod pyroMod = new pyrosim.legacy_2012_1.PyroMod();
                pyroMod.openModel(pyroSimObjectInputStream, true);
                this.d_model.fromLegacy(null, pyroMod, (WarningReport<Warning>)object);
                DataStore.printWarnings((WarningReport<Warning>)object);
            }
            return;
        }
        try (pyrosim.legacy_2006_2.PyroSimObjectInputStream pyroSimObjectInputStream = new pyrosim.legacy_2006_2.PyroSimObjectInputStream(new BufferedInputStream(new FileInputStream(string)));){
            pyrosim.legacy_2006_2.PyroMod pyroMod = new pyrosim.legacy_2006_2.PyroMod();
            pyroMod.openModel(pyroSimObjectInputStream, true);
            this.d_model.fromLegacy(null, pyroMod, (WarningReport<Warning>)object);
            DataStore.printWarnings((WarningReport<Warning>)object);
        }
    }

    public void readFDS(String string, PyroLoadOptions pyroLoadOptions) throws Exception {
        this.readFDS(null, string, pyroLoadOptions);
    }

    public void readFDS(Component component, String string, PyroLoadOptions pyroLoadOptions) throws Exception {
        this.d_model.updateGeomSearchesEnabled(pyroLoadOptions.cutHoles());
        this.d_loadOptions = pyroLoadOptions;
        this.initApp();
        if (!ImportFDSFile.readFDSFile(component, null, string, this.d_model, false)) {
            throw new CancellationException();
        }
    }

    public PyroMod getModel() {
        return this.d_model;
    }

    public IPyroDisplayProps getDisplayProps() {
        return new IPyroDisplayProps(){

            @Override
            public Predicate<IHole> getHoleFilter() {
                return Filters.always(DataStore.this.d_loadOptions.cutHoles());
            }

            @Override
            public double getCurveError() {
                return 0.1;
            }

            @Override
            public double getFaceError() {
                return 0.1;
            }

            @Override
            public FDSRasterization getRasterizer() {
                return null;
            }

            @Override
            public ClippingManager getClippingManager() {
                return null;
            }

            @Override
            public GridMergeUtil.MergeResult getMergedMeshes() {
                if (DataStore.this.d_mergedGridsCache == null) {
                    DataStore.this.d_mergedGridsCache = GridMergeUtil.mergeGrids(DataStore.this.d_model.getGridManager().flatten(grid -> DataStore.this.include((IPyroObject)grid)), Collections.emptyList());
                }
                return DataStore.this.d_mergedGridsCache;
            }

            @Override
            public boolean getVentOrientVisible() {
                return false;
            }
        };
    }

    public Collection<IPyroSurface> getSurfaces() {
        ArrayList<IPyroSurface> arrayList = new ArrayList<IPyroSurface>();
        for (Surface surface : this.d_model.getSurfaceMgr().flatten()) {
            arrayList.add(this.getSurface(surface));
        }
        return arrayList;
    }

    public IPyroSurface getSurface(Surface surface) {
        IPyroSurface iPyroSurface = this.d_surfMap.get(surface);
        if (iPyroSurface == null) {
            iPyroSurface = new SurfWrapper(this, surface);
            this.d_surfMap.put(surface, iPyroSurface);
        }
        return iPyroSurface;
    }

    public IPyroGeom getNodeAsGeom(IGeomNode iGeomNode) {
        IPyroGeom iPyroGeom = this.d_nodeToGeomMap.get(iGeomNode);
        if (iPyroGeom == null) {
            iPyroGeom = new GeomWrapper(this, iGeomNode);
            this.d_nodeToGeomMap.put(iGeomNode, iPyroGeom);
        }
        return iPyroGeom;
    }

    public IPyroGeomNode getNode(IGeomNode iGeomNode2) {
        return this.d_nodeMap.computeIfAbsent(iGeomNode2, iGeomNode -> new GeomNodeWrapper(this, (IGeomNode)iGeomNode));
    }

    public IPyroPrimProps getProps(IPrimProps iPrimProps) {
        IPyroPrimProps iPyroPrimProps = this.d_propsMap.get(iPrimProps);
        if (iPyroPrimProps == null) {
            iPyroPrimProps = new PrimPropWrapper(this, iPrimProps);
            this.d_propsMap.put(iPrimProps, iPyroPrimProps);
            this.d_revPropsMap.put(iPyroPrimProps, iPrimProps);
        }
        return iPyroPrimProps;
    }

    public IPrimProps getNativeProps(IPyroPrimProps iPyroPrimProps) {
        return this.d_revPropsMap.get(iPyroPrimProps);
    }

    public IPyroGeom getGeom(IGeom iGeom) {
        return this.d_geomMap.computeIfAbsent(iGeom, iGeom2 -> new GeomWrapper(this, GeomNodeUtil.newNode(iGeom)));
    }

    private static PyroTexture.Mode convert(Texture.Mode mode) {
        switch (mode) {
            case BLEND: {
                return PyroTexture.Mode.BLEND;
            }
            case DECAL: {
                return PyroTexture.Mode.DECAL;
            }
            case MODULATE: {
                return PyroTexture.Mode.MODULATE;
            }
            case REPLACE: {
                return PyroTexture.Mode.REPLACE;
            }
        }
        assert (false);
        return PyroTexture.Mode.MODULATE;
    }

    private static PyroTexture.Wrap convert(Texture.Wrap wrap) {
        switch (wrap) {
            case CLAMP: {
                return PyroTexture.Wrap.CLAMP;
            }
            case CLAMP_TO_EDGE: {
                return PyroTexture.Wrap.CLAMP_TO_EDGE;
            }
            case REPEAT: {
                return PyroTexture.Wrap.REPEAT;
            }
        }
        assert (false);
        return PyroTexture.Wrap.REPEAT;
    }

    public PyroTexture getTexture(Texture texture) {
        byte[] byArray = this.getImageData(texture.image);
        return new PyroTexture(texture.image.getFilename(), texture.uvSet, DataStore.convert(texture.mode), DataStore.convert(texture.wrap), texture.borderColor, byArray);
    }

    private byte[] getImageData(IImage iImage2) {
        return this.d_imgDataMap.computeIfAbsent(iImage2, iImage -> {
            byte[] byArray = null;
            if (iImage.isCached()) {
                IStreamSrc iStreamSrc = iImage.getSource();
                try {
                    ByteBuffer byteBuffer = (ByteBuffer)IOUtil.loadData((IStreamSrc)iStreamSrc, (int)1, (boolean)false, (ByteOrder)ByteOrder.nativeOrder()).v1;
                    if (byteBuffer.hasArray()) {
                        byArray = byteBuffer.array();
                    } else {
                        byArray = new byte[byteBuffer.capacity()];
                        byteBuffer.get(byArray);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return byArray;
        });
    }

    public PyroPoint3d getPoint(Point3d point3d) {
        PyroPoint3d pyroPoint3d = this.d_pMap.get(point3d);
        if (pyroPoint3d == null) {
            pyroPoint3d = new PyroPoint3d(point3d.x, point3d.y, point3d.z);
            this.d_pMap.put(point3d, pyroPoint3d);
        }
        return pyroPoint3d;
    }

    public PyroPoint3d[] getPoints(Point3d ... point3dArray) {
        PyroPoint3d[] pyroPoint3dArray = new PyroPoint3d[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            pyroPoint3dArray[i] = this.getPoint(point3dArray[i]);
        }
        return pyroPoint3dArray;
    }

    public PyroLoadOptions getLoadOptions() {
        return this.d_loadOptions;
    }

    private int count(Class<? extends IModelObj> clazz) {
        return ((APyroObject)this.d_model.getObstructions()).flatten(clazz).size();
    }

    public void printSummary(PrintStream printStream) {
        printStream.println("Num Grids: " + this.d_model.getGridManager().flatten().size());
        printStream.println("Num Generic: " + this.count(GenericGeomSrc.class));
        printStream.println("Num Vents: " + this.count(Vent.class));
        printStream.println("Num Obstructions: " + this.count(IObstruction.class));
        printStream.println("Num Holes: " + this.count(IHole.class));
    }

    public boolean include(IPyroObject iPyroObject) {
        return iPyroObject.isEnabled() || this.d_loadOptions.includeDisabled();
    }

    public Collection<IPyroGeomSrc> getGeomObjs() {
        ArrayList<IPyroGeomSrc> arrayList = new ArrayList<IPyroGeomSrc>(this.d_model.getGridManager().flatten().size() + this.d_model.getObstructions().getMembers().size());
        for (Grid iPyroObject : this.d_model.getGridManager().flatten()) {
            if (!this.include(iPyroObject)) continue;
            arrayList.add(new GeomSrcWrapper(this, iPyroObject));
        }
        for (IPyroObject iPyroObject : this.d_model.getObstructions().getMembers()) {
            if (!this.include(iPyroObject)) continue;
            arrayList.add(new GeomSrcWrapper(this, iPyroObject));
        }
        return arrayList;
    }
}

