/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pyrosim.Intl;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.Lists;
import thunderheadeng.util.theUtil;

public class TimeHistoryData {
    private File d_tcFile;
    private List<String> d_labels;
    private List<String> d_quantities;
    private List<String> d_units;
    private List<Double>[] d_values;

    public TimeHistoryData(File file) throws IOException {
        this.d_tcFile = file;
        int[] nArray = new int[]{0};
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            this.d_quantities = this.parseQuantities(bufferedReader, nArray);
        }
        catch (Throwable throwable) {
            throw new IOException(Intl.intl("Error reading quantities."));
        }
        try {
            this.d_labels = this.parseLabels(bufferedReader, nArray);
        }
        catch (Throwable throwable) {
            throw new IOException(Intl.intl("Error reading labels."));
        }
        try {
            this.d_units = this.parseUnits(bufferedReader, nArray);
        }
        catch (Throwable throwable) {
            throw new IOException(Intl.intl("Error reading units."));
        }
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        int n = this.d_labels.size();
        List<Double> list = this.convertToDataRow(this.d_units);
        if (list != null) {
            this.d_units = this.d_quantities;
            this.d_quantities = Lists.filled(this.d_labels.size(), "");
            arrayList.add(list);
        }
        if (this.d_labels.size() != this.d_quantities.size()) {
            throw new IOException(String.format(Intl.intl("The number of labels (%d) does not match the number of quantities (%d)."), this.d_labels.size(), this.d_quantities.size()));
        }
        if (this.d_quantities.size() != this.d_units.size()) {
            throw new IOException(String.format(Intl.intl("The number of quantities (%d) does not match the number of units (%d)."), this.d_quantities.size(), this.d_units.size()));
        }
        try {
            if (list != null) {
                TimeHistoryData.validateDataRow(list, n, nArray);
            }
            while (bufferedReader.ready()) {
                List<Double> list2 = this.parseValues(bufferedReader, nArray);
                TimeHistoryData.validateDataRow(list2, n, nArray);
                arrayList.add(list2);
            }
        }
        catch (Throwable throwable) {
            throw new IOException(String.format(Intl.intl("[Line %d] %s"), nArray[0], throwable.getLocalizedMessage() != null ? throwable.getLocalizedMessage() : throwable.getMessage()));
        }
        this.close(bufferedReader);
        this.d_values = theUtil.toArray(arrayList, List.class);
    }

    private static void validateDataRow(List<Double> list, int n, int[] nArray) throws IOException {
        if (list.size() != n) {
            throw new IOException(String.format(Intl.intl("Invalid number of data values. Expected: %d, Found: %d"), n, list.size()));
        }
    }

    public TimeHistoryData refresh() throws IOException {
        return new TimeHistoryData(this.d_tcFile);
    }

    private List<Double> convertToDataRow(List<String> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
        try {
            for (String string : list) {
                arrayList.add(new Double(string));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return arrayList;
    }

    private void close(BufferedReader bufferedReader) {
        try {
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public List<String> getLabels() {
        return this.d_labels;
    }

    public List<String> getQuantities() {
        return this.d_quantities;
    }

    public List<String> getUnits() {
        return this.d_units;
    }

    public List<Double> getValues(int n) {
        return this.d_values[n];
    }

    public int getNumValues() {
        return this.d_values.length;
    }

    private int parseNTC(BufferedReader bufferedReader, int[] nArray) throws IOException {
        int n = Integer.parseInt(bufferedReader.readLine().replaceAll(" ", ""));
        nArray[0] = nArray[0] + 1;
        return n;
    }

    private boolean isUINT(String string) {
        return string.matches("\\d+");
    }

    private List<String> parseLabels(BufferedReader bufferedReader, int[] nArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        nArray[0] = nArray[0] + 1;
        List<String> list = CSVLineParser.parse(string, ",", "''\"\"");
        for (String string2 : list) {
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private List<String> parseQuantities(BufferedReader bufferedReader, int[] nArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        nArray[0] = nArray[0] + 1;
        if (this.isUINT(string.replaceAll(" ", ""))) {
            string = bufferedReader.readLine();
            nArray[0] = nArray[0] + 1;
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            if (string2 == null && string3.equals(",")) {
                arrayList.add("");
            } else if (string2 == null && !string3.equals(",")) {
                arrayList.add(string3);
            } else if (string2.equals(",") && string3.equals(",")) {
                arrayList.add("");
            } else if (string2.equals(",") && !string3.equals(",")) {
                arrayList.add(string3);
            } else if (string2.equals(",") || string3.equals(",")) {
                // empty if block
            }
            string2 = string3;
        }
        if (string2.equals(",")) {
            arrayList.add("");
        }
        return arrayList;
    }

    private List<String> parseUnits(BufferedReader bufferedReader, int[] nArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        nArray[0] = nArray[0] + 1;
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].trim());
        }
        return arrayList;
    }

    private List<Double> parseValues(BufferedReader bufferedReader, int[] nArray) throws IOException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string = bufferedReader.readLine().replaceAll(" ", "");
        nArray[0] = nArray[0] + 1;
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new Double(stringArray[i]));
        }
        return arrayList;
    }
}

