/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.io.IOUtil;
import thunderheadeng.util.LinkedIdentityHashSet;

public class STLReader {
    private static final int MAX_TRI_ALLOC = 2000000;
    private final Options d_options;
    private final ITriReader d_reader;
    private List<Triangle> d_tris = Collections.EMPTY_LIST;

    public STLReader(File file, Options options) throws IOException {
        this.d_options = options;
        this.d_reader = this.getReader(file);
    }

    private ITriReader getReader(File file) throws IOException {
        ATriReader aTriReader = null;
        try {
            aTriReader = new AsciiTriReader(file, this.d_options);
            return aTriReader;
        }
        catch (InvalidSTLReaderException invalidSTLReaderException) {
            try {
                aTriReader = new BinaryTriReader(file, this.d_options);
                return aTriReader;
            }
            catch (InvalidSTLReaderException invalidSTLReaderException2) {
                String string = String.format(Intl.intl("Could not determine if STL file was binary or ASCII format."), new Object[0]);
                throw new IOException(string);
            }
        }
    }

    public Type getType() {
        return this.d_reader instanceof AsciiTriReader ? Type.ASCII : Type.BINARY;
    }

    public void read() throws IOException {
        int n = this.d_reader.getSizeHint();
        if (n > 2000000) {
            n = 2000000;
        }
        List<Triangle> list = this.d_tris = n > 0 ? new ArrayList<Triangle>(n) : new ArrayList();
        while (this.readNextTri()) {
        }
        this.d_reader.close();
    }

    private boolean readNextTri() throws IOException {
        Triangle triangle = this.d_reader.readNext();
        if (triangle == null) {
            return false;
        }
        if (STLReader.isValid(triangle)) {
            this.d_tris.add(triangle);
        } else {
            System.err.printf("Found invalid triangle: [%s, %s, %s]%n", triangle.p1, triangle.p2, triangle.p3);
        }
        return true;
    }

    private static boolean isValid(Triangle triangle) {
        return !triangle.p1.equals(triangle.p2) && !triangle.p1.equals(triangle.p3);
    }

    public String getName() {
        return this.d_reader.getName();
    }

    public List<? extends IGeom> getGeometry() {
        List<List<Triangle>> list = STLReader.separateTris(this.d_tris);
        ArrayList<Mesh> arrayList = new ArrayList<Mesh>(list.size());
        for (List<Triangle> list2 : list) {
            arrayList.add(STLReader.toMesh(list2));
        }
        return arrayList;
    }

    private static List<List<Triangle>> separateTris(List<Triangle> list) {
        Object object;
        HashMap<Point3d, List<Triangle>> hashMap = new HashMap<Point3d, List<Triangle>>();
        for (Triangle serializable2 : list) {
            for (int i = 0; i < 3; ++i) {
                object = serializable2.getPoint(0, i);
                ArrayList<Triangle> arrayList = (ArrayList<Triangle>)hashMap.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<Triangle>(2);
                    hashMap.put((Point3d)object, arrayList);
                }
                arrayList.add(serializable2);
            }
        }
        ArrayList arrayList = new ArrayList();
        LinkedIdentityHashSet<Triangle> linkedIdentityHashSet = new LinkedIdentityHashSet<Triangle>((Collection<Triangle>)list);
        while (!linkedIdentityHashSet.isEmpty()) {
            Triangle triangle = (Triangle)linkedIdentityHashSet.iterator().next();
            object = STLReader.getConnectedTris(triangle, hashMap, linkedIdentityHashSet);
            assert (!object.isEmpty());
            arrayList.add(object);
        }
        return arrayList;
    }

    private static List<Triangle> getConnectedTris(Triangle triangle, Map<Point3d, List<Triangle>> map, Set<Triangle> set) {
        ArrayList<Triangle> arrayList = new ArrayList<Triangle>();
        ArrayDeque<Triangle> arrayDeque = new ArrayDeque<Triangle>();
        arrayDeque.push(triangle);
        set.remove(triangle);
        while (!arrayDeque.isEmpty()) {
            Triangle triangle2 = (Triangle)arrayDeque.pop();
            arrayList.add(triangle2);
            for (int i = 0; i < 3; ++i) {
                Point3d point3d = triangle2.getPoint(0, i);
                List<Triangle> list = map.get(point3d);
                for (Triangle triangle3 : list) {
                    if (triangle3 == triangle2 || !set.remove(triangle3)) continue;
                    arrayDeque.push(triangle3);
                }
            }
        }
        return arrayList;
    }

    private static Mesh toMesh(List<Triangle> list) {
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        int[] nArray = new int[list.size() * 3];
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Triangle triangle = list.get(i);
            nArray[n++] = STLReader.indexOf(triangle.p1, linkedHashMap);
            nArray[n++] = STLReader.indexOf(triangle.p2, linkedHashMap);
            nArray[n++] = STLReader.indexOf(triangle.p3, linkedHashMap);
        }
        Point3d[] point3dArray = linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]);
        return new Mesh(point3dArray, nArray, 2, 0);
    }

    private static int indexOf(Point3d point3d, Map<Point3d, Integer> map) {
        Integer n = map.get(point3d);
        if (n == null) {
            n = map.size();
            map.put(point3d, n);
        }
        return n;
    }

    public static class Options {
        public final Matrix4d lwXform;
        public final double weldTol;

        public Options(Matrix4d matrix4d, double d) {
            this.lwXform = matrix4d;
            this.weldTol = d;
        }
    }

    private static class BinaryTriReader
    extends ATriReader {
        private static final int HEADER_LEN = 80;
        private final byte[] d_header;
        private final DataInput d_is;
        private final int d_numTris;
        private int d_currTri;
        private float[] d_buffer;

        public BinaryTriReader(File file, Options options) throws IOException, InvalidSTLReaderException {
            super(options);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                this.d_header = new byte[80];
                int n = ((InputStream)bufferedInputStream).read(this.d_header);
                if (n < 80) {
                    ((InputStream)bufferedInputStream).close();
                    throw new InvalidSTLReaderException();
                }
                this.d_is = IOUtil.constructNativeDataInput(bufferedInputStream);
                this.d_numTris = this.d_is.readInt();
                this.d_currTri = 0;
                this.d_buffer = new float[3];
            }
            catch (IOException iOException) {
                ((InputStream)bufferedInputStream).close();
                throw iOException;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.d_is instanceof Closeable) {
                ((Closeable)((Object)this.d_is)).close();
            }
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int getSizeHint() {
            return this.d_numTris;
        }

        @Override
        public Triangle readNext() throws IOException {
            if (this.d_currTri >= this.d_numTris) {
                return null;
            }
            ++this.d_currTri;
            this.readREAL32(this.d_buffer);
            Point3d point3d = this.readPoint();
            Point3d point3d2 = this.readPoint();
            Point3d point3d3 = this.readPoint();
            this.d_is.readShort();
            return new Triangle(point3d, point3d2, point3d3);
        }

        private void readREAL32(float[] fArray) throws IOException {
            fArray[0] = this.d_is.readFloat();
            fArray[1] = this.d_is.readFloat();
            fArray[2] = this.d_is.readFloat();
        }

        private Point3d readPoint() throws IOException {
            this.readREAL32(this.d_buffer);
            return this.finalize(new Point3d(this.d_buffer[0], this.d_buffer[1], this.d_buffer[2]));
        }
    }

    private static class AsciiTriReader
    extends ATriReader {
        private static final String SOLID = "solid";
        private static final String FACET = "facet";
        private static final String NORMAL = "normal";
        private static final String OUTER = "outer";
        private static final String LOOP = "loop";
        private static final String VERTEX = "vertex";
        private static final String ENDLOOP = "endloop";
        private static final String ENDFACET = "endfacet";
        private static final String ENDSOLID = "endsolid";
        private final String d_name;
        private String d_nextKeyword;
        private final StringBuilder d_tempStringBuilder = new StringBuilder();
        private final BufferedReader d_reader;
        private int d_lineCount;

        public AsciiTriReader(File file, Options options) throws IOException, InvalidSTLReaderException {
            super(options);
            this.d_reader = new BufferedReader(new FileReader(file));
            this.d_lineCount = 0;
            try {
                String string = this.readNextToken();
                if (!string.equals(SOLID)) {
                    throw new InvalidSTLReaderException();
                }
                this.d_name = this.readTitle();
                if (!this.d_nextKeyword.equals(FACET) && !this.d_nextKeyword.equals(ENDSOLID)) {
                    throw new InvalidSTLReaderException();
                }
            }
            catch (IOException iOException) {
                this.d_reader.close();
                throw iOException;
            }
            catch (InvalidSTLReaderException invalidSTLReaderException) {
                this.d_reader.close();
                throw invalidSTLReaderException;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.d_reader != null) {
                this.d_reader.close();
            }
        }

        @Override
        public String getName() {
            return this.d_name;
        }

        @Override
        public int getSizeHint() {
            return -1;
        }

        @Override
        public Triangle readNext() throws IOException {
            if (this.d_nextKeyword.equals(ENDSOLID)) {
                return null;
            }
            this.checkKeyword(this.d_nextKeyword, FACET);
            this.readNextKeyword(NORMAL);
            this.readNormal();
            this.readNextKeywords(OUTER, LOOP);
            Point3d point3d = this.readPoint();
            Point3d point3d2 = this.readPoint();
            Point3d point3d3 = this.readPoint();
            this.readNextKeyword(ENDLOOP);
            this.readNextKeyword(ENDFACET);
            this.d_nextKeyword = this.readNextToken();
            return new Triangle(point3d, point3d2, point3d3);
        }

        private void readNormal() throws IOException {
            this.readDouble();
            this.readDouble();
            this.readDouble();
        }

        private Point3d readPoint() throws IOException {
            this.readNextKeyword(VERTEX);
            return this.finalize(new Point3d(this.readDouble(), this.readDouble(), this.readDouble()));
        }

        private double readDouble() throws IOException {
            String string = this.readNextToken();
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.exc(numberFormatException.getLocalizedMessage());
            }
        }

        private void readNextKeywords(String ... stringArray) throws IOException {
            for (String string : stringArray) {
                this.readNextKeyword(string);
            }
        }

        private void readNextKeyword(String string) throws IOException {
            String string2 = this.readNextToken();
            this.checkKeyword(string2, string);
        }

        private void checkKeyword(String string, String string2) throws IOException {
            if (!string.equals(string2)) {
                String string3 = String.format(Intl.intl("Unexpected keyword, \"%1$s\".  Expected \"%2$s\"."), string, string2);
                throw this.exc(string3);
            }
        }

        private IOException exc(String string) {
            return new IOException(String.format(Intl.intl("Error on line %d: %s"), this.d_lineCount + 1, string));
        }

        private String readNextToken() throws IOException {
            int n;
            this.d_tempStringBuilder.setLength(0);
            while ((n = this.d_reader.read()) != -1) {
                char c = (char)n;
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
                    if (c == '\n') {
                        ++this.d_lineCount;
                    }
                    if (this.d_tempStringBuilder.length() <= 0) continue;
                    break;
                }
                this.d_tempStringBuilder.append(c);
            }
            return this.d_tempStringBuilder.toString();
        }

        private String readTitle() throws IOException {
            String string = "";
            this.d_nextKeyword = this.readNextToken();
            while (!(this.d_nextKeyword.equals(FACET) || this.d_nextKeyword.equals(ENDSOLID) || this.d_nextKeyword.isEmpty())) {
                string = string + " " + this.d_nextKeyword;
                this.d_nextKeyword = this.readNextToken();
            }
            return string;
        }
    }

    private static class InvalidSTLReaderException
    extends Exception {
        private static final long serialVersionUID = 4242355089218497348L;

        private InvalidSTLReaderException() {
        }
    }

    private static abstract class ATriReader
    implements ITriReader {
        private final Options d_options;
        private final Map<Point3d, Point3d> d_pointMap;

        public ATriReader(Options options) {
            this.d_options = options;
            this.d_pointMap = this.d_options.weldTol > 0.0 ? new HashMap() : null;
        }

        protected Point3d finalize(Point3d point3d) {
            if (this.d_options.lwXform != null) {
                this.d_options.lwXform.transform(point3d);
            }
            if (this.d_pointMap != null) {
                Point3d point3d2 = Util3D.round(point3d, this.d_options.weldTol);
                Point3d point3d3 = this.d_pointMap.get(point3d2);
                if (point3d3 == null) {
                    point3d3 = point3d;
                    this.d_pointMap.put(point3d2, point3d);
                } else {
                    point3d = point3d3;
                }
            }
            return point3d;
        }
    }

    private static interface ITriReader {
        public String getName();

        public int getSizeHint();

        public Triangle readNext() throws IOException;

        public void close() throws IOException;
    }

    public static enum Type {
        ASCII,
        BINARY;

    }
}

