/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.Serialized;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.CableFailDetector;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.domain.variant.Variant;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.CorrRenderer;
import pyrosim.io.fds.v6.renderers.DoorRenderer;
import pyrosim.io.fds.v6.renderers.EntrRenderer;
import pyrosim.io.fds.v6.renderers.EvacRenderer;
import pyrosim.io.fds.v6.renderers.EvhoRenderer;
import pyrosim.io.fds.v6.renderers.EvssRenderer;
import pyrosim.io.fds.v6.renderers.ExitRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PersRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import pyrosim.io.fds.v6.renderers.SurfaceRenderer;
import pyrosim.legacy.v109.domain.devices.hvac.HvacDevice;
import pyrosim.legacy.v49.domain.Variant;
import pyrosim.legacy.v76.domain.geom.Vent;
import pyrosim.legacy.v78.domain.geom.FireSpread;
import pyrosim.legacy.v78.domain.geom.Vent;
import pyrosim.legacy.v86.geom.TexCoordGenerator;
import pyrosim.legacy.v96.domain.NamesDB;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.TeciIO;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class PyroSimObjectInputStream
extends ObjectInputStream {
    public static final int CURR_VERSION = 125;
    public static final int TECI_VERSION = 17;
    public static final byte[] FORMAT_CODE;
    private final int d_version;
    private final int d_teciVersion;
    private String d_revision;
    private final TeciIO d_teciio;
    private final WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
    private final Map<UnitPoint3D, UnitPoint3D> d_pointMap = new HashMap<UnitPoint3D, UnitPoint3D>();
    private final Map<Point3d, Point3d> d_point3dMap = new HashMap<Point3d, Point3d>();
    private final Map<Color, Color> d_colorMap = new HashMap<Color, Color>();
    private final Map<String, String> d_strMap = new HashMap<String, String>();
    private final NavigableMap<Integer, Map<String, Class>> d_classLookup;
    private Set<Unit> d_obscurationUnits;

    public PyroSimObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        byte[] byArray = new byte[FORMAT_CODE.length];
        this.read(byArray);
        String string = new String(byArray);
        this.d_version = Integer.parseInt(string.substring(3));
        if (this.d_version < 30) {
            this.d_teciVersion = 1;
            this.d_revision = "";
        } else {
            this.d_teciVersion = this.readInt();
            try {
                this.d_revision = (String)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false);
                this.d_revision = "";
            }
        }
        this.d_teciio = new TeciIO(this.d_teciVersion);
        this.enableResolveObject(true);
        this.d_classLookup = new TreeMap<Integer, Map<String, Class>>();
        this.initLegClasses();
    }

    public static int getVersion(ObjectInputStream objectInputStream) {
        return objectInputStream instanceof PyroSimObjectInputStream ? ((PyroSimObjectInputStream)objectInputStream).getVersion() : Integer.MAX_VALUE;
    }

    public boolean canOpenVersion() {
        return this.d_version >= 49;
    }

    public boolean isNewer() {
        return this.d_version > 125;
    }

    public boolean isSupported() {
        if (this.d_version <= 50) {
            return false;
        }
        if (this.d_version == 51) {
            return true;
        }
        return true;
    }

    public String getRevision() {
        return this.d_revision;
    }

    public int getVersion() {
        return this.d_version;
    }

    public Serialized readModel() throws IOException, ClassNotFoundException {
        System.out.printf("loading model (PyroSim Version: %d; Teci Version: %d)%n", this.d_version, this.d_teciVersion);
        Serialized serialized = (Serialized)this.readObject();
        this.initSerFields(serialized);
        this.updateData(serialized);
        this.fixSurfRefs(serialized);
        return serialized;
    }

    private void removeObjsFromInvalidGroups(Serialized serialized) {
        LinkedHashMap<IPyroObject, List<Composite>> linkedHashMap = new LinkedHashMap<IPyroObject, List<Composite>>();
        PyroSimObjectInputStream.mapParents(serialized.obstructions, linkedHashMap);
        HashSet<Composite> hashSet = new HashSet<Composite>();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (int i = 1; i < ((List)entry.getValue()).size(); ++i) {
                Composite composite = (Composite)((List)entry.getValue()).get(i);
                composite.remove((IPyroObject)entry.getKey());
                hashSet.add(composite);
            }
        }
        System.out.printf("Removed duplicate objects from %d groups.%n", hashSet.size());
    }

    private static void mapParents(Composite composite, Map<IPyroObject, List<Composite>> map) {
        for (IPyroObject iPyroObject : composite.getMembers(IPyroObject.class)) {
            List<Composite> list = map.get(iPyroObject);
            if (list == null) {
                list = new ArrayList<Composite>(2);
                map.put(iPyroObject, list);
            }
            if (!list.contains(composite)) {
                list.add(composite);
            }
            if (!(iPyroObject instanceof Composite)) continue;
            PyroSimObjectInputStream.mapParents((Composite)iPyroObject, map);
        }
    }

    private void initSerFields(Serialized serialized) {
        if (this.d_version < 78) {
            serialized.initNewFields(true, "views", "viewNames");
        }
        if (this.d_version < 100) {
            serialized.initNewFields(true, "slices3d");
        }
        if (this.d_version < 104) {
            serialized.initNewFields(true, "slice3dNames");
        }
        if (this.d_version < 109) {
            serialized.initNewFields(true, "hvacLeakNames");
        }
    }

    private void updateData(Serialized serialized) {
        if (this.d_version < 67) {
            this.addPeriodicSurface(serialized);
        }
        if (this.d_version < 52) {
            this.removePre52deprecatedQuants(serialized);
            this.fixPre52ThermocoupleQuants(serialized);
        }
        if (this.d_version < 54) {
            this.removePre54HRRPUA(serialized);
            this.fixPre54OperatingPressure(serialized);
            this.fixPre54DefaultSurfs(serialized);
        }
        if (this.d_version < 56) {
            this.migratePre56TempRegToAdvanced(serialized);
        }
        if (this.d_version < 57) {
            this.fixPre57Species(serialized);
        }
        if (this.d_version < 58) {
            // empty if block
        }
        if (this.d_version < 59) {
            this.fixPre59Species(serialized);
        }
        if (this.d_version < 60) {
            this.removePre60InitVaporFlux(serialized);
        }
        if (this.d_version < 62) {
            this.reorganizePre62HVAC(serialized);
        }
        if (this.d_version < 63) {
            this.updatePre63Surfs(serialized);
        }
        if (this.d_version < 65) {
            this.updatePre65Surfs(serialized);
        }
        if (this.d_version < 66) {
            this.removeSolidPartSizeDist(serialized);
        }
        if (this.d_version < 68) {
            this.fixPre68SprayModels(serialized);
        }
        if (this.d_version < 69) {
            this.updatePre69Adiabatic(serialized);
        }
        if (this.d_version < 72) {
            this.fixPre72ClonedPins(serialized);
        }
        if (this.d_version < 73) {
            this.fixPre73SprayModels(serialized);
        }
        if (this.d_version < 75) {
            this.fixPre75FireSpreadVents(serialized);
        }
        if (this.d_version < 76) {
            this.fixPre76SliceDuplicates(serialized);
        }
        if (this.d_version == 76) {
            this.fix76BurnerVents(serialized);
        }
        if (this.d_version < 80) {
            PyroSimObjectInputStream.fixMissingJets(serialized, this.d_warnings);
        }
        if (this.d_version < 82) {
            this.fixPre82FanCurves(serialized);
        }
        if (this.d_version < 83) {
            this.fixPre83CableFailDetector(serialized, this.d_warnings);
        }
        if (this.d_version < 84) {
            PyroSimObjectInputStream.fixPre84Evac(serialized, this.d_warnings);
        }
        if (this.d_version < 85) {
            PyroSimObjectInputStream.fds_6_3_update(serialized, this.d_warnings);
        }
        if (this.d_version < 86) {
            PyroSimObjectInputStream.manuallyConvertPre86AtmGradUnits(serialized, this.d_warnings);
        }
        if (this.d_version < 87) {
            PyroSimObjectInputStream.generatePre87Elements(serialized, this.d_warnings);
        }
        if (this.d_version < 88) {
            this.reorganizePre88UV(serialized);
        }
        if (this.d_version < 89) {
            this.fixPre89ImportedSurfs(serialized);
            this.fixPre89BadObstSurfs(serialized);
        }
        if (this.d_version < 91) {
            PyroSimObjectInputStream.warnPre91SingleSprkDryPipe(serialized, this.d_warnings);
        }
        if (this.d_version < 96) {
            PyroSimObjectInputStream.warnPre92HvacCtrls(serialized, this.d_warnings);
        }
        if (this.d_version < 94) {
            PyroSimObjectInputStream.warnPre94OutflowSurfs(serialized, this.d_warnings);
        }
        if (this.d_version < 95) {
            PyroSimObjectInputStream.fixPre95MultipleReacs(serialized, this.d_warnings);
        }
        if (this.d_version < 99) {
            PyroSimObjectInputStream.bakePre99Transforms(serialized, this.d_warnings);
        }
        if (this.d_version < 102) {
            PyroSimObjectInputStream.udpateDefaultDTs3d(serialized, this.d_warnings);
        }
        if (this.d_version < 103) {
            PyroSimObjectInputStream.fixDanglingGridRefs(serialized, this.d_warnings);
        }
        if (this.d_version < 105) {
            PyroSimObjectInputStream.purgeMutantDevices(serialized, this.d_warnings);
        }
        if (this.d_version < 106) {
            PyroSimObjectInputStream.fixPre106CyclicControls(serialized, this.d_warnings);
        }
        if (this.d_version < 107) {
            PyroSimObjectInputStream.fixPre107SurfDepDevcs(serialized, this.d_warnings);
        }
        if (this.d_version < 111) {
            PyroSimObjectInputStream.fixPre111HvacRefs(serialized, this.d_warnings);
        }
        if (this.d_version < 112) {
            PyroSimObjectInputStream.fixPre112HvacDevices(serialized, this.d_warnings);
        }
        if (this.d_version < 114) {
            PyroSimObjectInputStream.fixPre114SprayAndSprinklerLinkModels(serialized, this.d_warnings);
        }
        if (this.d_version >= 113 && this.d_version < 116) {
            PyroSimObjectInputStream.warnPre116WindRecords(serialized, this.d_warnings);
        }
        if (this.d_version < 117) {
            PyroSimObjectInputStream.fixPre117PredefLumped(serialized, this.d_warnings);
        }
        if (this.d_version < 119) {
            PyroSimObjectInputStream.updatePre119BackgroundSpecies(serialized, this.d_warnings);
        }
        if (this.d_version < 120) {
            PyroSimObjectInputStream.updatePre120PredefSoot(serialized, this.d_warnings);
        }
        if (this.d_version < 121) {
            PyroSimObjectInputStream.updatePre121ProductsSpec(serialized, this.d_warnings);
        }
        if (this.d_version < 122) {
            PyroSimObjectInputStream.removePre122deprecatedQuants(serialized, this.d_warnings);
        }
        if (this.d_version < 125) {
            PyroSimObjectInputStream.warnPre125deprecatedField(serialized, this.d_warnings);
        }
        this.fixBadSpecInj(serialized);
        PyroSimObjectInputStream.fixBadDeviceRefs(serialized);
    }

    private void removePre52deprecatedQuants(Serialized serialized) {
        PyroSimObjectInputStream.removePre52deprecatedQuants(serialized, this.d_warnings);
    }

    public static void removePre52deprecatedQuants(Serialized serialized, WarningReport warningReport) {
        PyroMod pyroMod = new PyroMod(serialized, false, false);
        LinkedHashSet<StaticQuantity> linkedHashSet = new LinkedHashSet<StaticQuantity>();
        linkedHashSet.add(Quantity.MASS_LOSS.create());
        ArrayList<INamed> arrayList = new ArrayList<INamed>();
        block0: for (IMeasurer cloneable2 : ((APyroObject)serialized.devices).flatten(IMeasurer.class)) {
            for (int i = 0; i < cloneable2.getNumMeasurements(); ++i) {
                if (!linkedHashSet.contains(cloneable2.getQuantity(i))) continue;
                arrayList.add(cloneable2);
                continue block0;
            }
        }
        for (IMeasurementStat iMeasurementStat : serialized.msrStats.flatten()) {
            if (!linkedHashSet.contains(iMeasurementStat.getQuantity())) continue;
            arrayList.add(iMeasurementStat);
        }
        boolean bl = !arrayList.isEmpty();
        LinkedHashSet<IQuantity> linkedHashSet2 = new LinkedHashSet<IQuantity>(serialized.boundaryOutput.getQuantities());
        if (linkedHashSet2.removeAll(linkedHashSet)) {
            bl = true;
            serialized.boundaryOutput.setQuantities(linkedHashSet2);
        }
        if (bl) {
            warningReport.addWarning(new Warning(Intl.intl("Quantity MASS_LOSS is no longer supported."), Intl.intl("All references to MASS_LOSS have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(pyroMod, pyroMod.getDependencies(new IPyroObject[0]), arrayList, warningReport);
        serialized.setDomain(null);
    }

    private void fixPre52ThermocoupleQuants(Serialized serialized) {
        PyroSimObjectInputStream.fixPre52ThermocoupleQuants(serialized, this.d_warnings);
    }

    public static void fixPre52ThermocoupleQuants(Serialized serialized, WarningReport warningReport) {
        Cloneable cloneable2;
        PyroMod pyroMod = new PyroMod(serialized, false, false);
        LinkedHashSet<StaticQuantity> linkedHashSet = new LinkedHashSet<StaticQuantity>();
        linkedHashSet.add(Quantity.THERMOCOUPLE.create());
        ArrayList<APyroObject> arrayList = new ArrayList<APyroObject>();
        for (Cloneable cloneable2 : serialized.slices.flatten()) {
            if (!linkedHashSet.contains(((Slice)cloneable2).getQuantity())) continue;
            arrayList.add((APyroObject)cloneable2);
        }
        for (Cloneable cloneable2 : serialized.isosurfaces.flatten()) {
            if (!linkedHashSet.contains(((Isosurface)cloneable2).getQuantity())) continue;
            arrayList.add((APyroObject)cloneable2);
        }
        boolean bl = !arrayList.isEmpty();
        cloneable2 = new LinkedHashSet<IQuantity>(serialized.plot3d.getQuantities());
        if (cloneable2.removeAll(linkedHashSet)) {
            bl = true;
            serialized.plot3d.setQuantities((Collection<IQuantity>)((Object)cloneable2));
        }
        if (bl) {
            warningReport.addWarning(new Warning(Intl.intl("Quantity THERMOCOUPLE is only supported as a device."), Intl.intl("All invalid references to THERMOCOUPLE have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(pyroMod, pyroMod.getDependencies(new IPyroObject[0]), arrayList, warningReport);
        serialized.setDomain(null);
    }

    private void removePre54HRRPUA(Serialized serialized) {
        PyroSimObjectInputStream.removePre54HRRPUA(serialized, this.d_warnings);
    }

    public static void removePre54HRRPUA(Serialized serialized, WarningReport warningReport) {
        LinkedHashSet<IQuantity> linkedHashSet;
        Cloneable cloneable2;
        PyroMod pyroMod = new PyroMod(serialized, false, false);
        LinkedHashSet<StaticQuantity> linkedHashSet2 = new LinkedHashSet<StaticQuantity>();
        linkedHashSet2.add(Quantity.HRRPUA.create());
        ArrayList<APyroObject> arrayList = new ArrayList<APyroObject>();
        for (Cloneable cloneable2 : serialized.slices.flatten()) {
            if (!linkedHashSet2.contains(((Slice)cloneable2).getQuantity())) continue;
            arrayList.add((APyroObject)cloneable2);
        }
        for (Cloneable cloneable2 : serialized.isosurfaces.flatten()) {
            if (!linkedHashSet2.contains(((Isosurface)cloneable2).getQuantity())) continue;
            arrayList.add((APyroObject)cloneable2);
        }
        boolean bl = !arrayList.isEmpty();
        cloneable2 = new LinkedHashSet<IQuantity>(serialized.boundaryOutput.getQuantities());
        if (cloneable2.removeAll(linkedHashSet2)) {
            bl = true;
            serialized.boundaryOutput.setQuantities((Collection<IQuantity>)((Object)cloneable2));
        }
        if ((linkedHashSet = new LinkedHashSet<IQuantity>(serialized.plot3d.getQuantities())).removeAll(linkedHashSet2)) {
            bl = true;
            serialized.plot3d.setQuantities(linkedHashSet);
        }
        if (bl) {
            warningReport.addWarning(new Warning(Intl.intl("Quantity HRRPUA is only supported as a device."), Intl.intl("All invalid references to HRRPUA have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(pyroMod, pyroMod.getDependencies(new IPyroObject[0]), arrayList, warningReport);
        serialized.setDomain(null);
    }

    private void fixPre54OperatingPressure(Serialized serialized) {
        for (SprayModel sprayModel : serialized.sprayModels.flatten()) {
            SprayModel.FlowRate flowRate;
            SprayModel.FlowRate flowRate2 = sprayModel.getFlowRate();
            if (flowRate2 instanceof SprayModel.PressurizedFlowRate) {
                flowRate = (SprayModel.PressurizedFlowRate)flowRate2;
                sprayModel.setFlowRate(new SprayModel.PressurizedFlowRate(SIUS.newud(flowRate.d_opPressure.getValueNoUnit(), 12), flowRate.d_kFactor, flowRate.d_ramp));
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Spray Model %s used an Operating Pressure of the wrong unit."), sprayModel.getName()), String.format(Intl.intl("Please verify values for %s are correct."), sprayModel.getName())));
                continue;
            }
            if (!(flowRate2 instanceof SprayModel.VaryingFlowRate)) continue;
            flowRate = (SprayModel.VaryingFlowRate)flowRate2;
            Ramp ramp = ((SprayModel.VaryingFlowRate)flowRate).d_pressureRamp;
            List<Ramp.Entry> list = ramp.getRecords();
            ArrayList<Ramp.Entry> arrayList = new ArrayList<Ramp.Entry>();
            boolean bl = false;
            for (Ramp.Entry entry : list) {
                UnitDouble unitDouble = entry.f;
                if (entry.f.getUnit().equals(SI.PASCAL)) {
                    unitDouble = new UnitDouble(entry.f.getValueNoUnit(), NonSI.ATMOSPHERE);
                    bl = true;
                } else if (entry.f.getUnit().equals(NonSI.BAR)) {
                    double d = entry.f.getValue(SI.PASCAL);
                    unitDouble = new UnitDouble(d, NonSI.ATMOSPHERE);
                    bl = true;
                }
                arrayList.add(new Ramp.Entry(entry.t, unitDouble));
            }
            if (bl) {
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Spray Model, %s, contained incorrectly stored units for Pipe Pressure Ramp."), sprayModel.getName()), String.format(Intl.intl("Attempted to auto-correct. Verify values for %s are correct."), sprayModel.getName())));
            }
            Ramp ramp2 = new Ramp(arrayList, ramp.getDefaultInput(), ramp.getInput(), 12);
            sprayModel.setFlowRate(new SprayModel.VaryingFlowRate(ramp2, ((SprayModel.VaryingFlowRate)flowRate).d_opPressure, ((SprayModel.VaryingFlowRate)flowRate).d_kFactor, ((SprayModel.VaryingFlowRate)flowRate).d_rate, ((SprayModel.VaryingFlowRate)flowRate).d_ramp));
        }
    }

    private void fixPre54DefaultSurfs(Serialized serialized) {
        PyroSimObjectInputStream.fixPre54DefaultSurfs(serialized, this.d_warnings);
    }

    public static void fixPre54DefaultSurfs(Serialized serialized, WarningReport warningReport) {
        SimParams.Misc misc = serialized.simParams.getMisc();
        Surface surface = misc.getSurfDefault();
        if (surface.isPredefined() && !surface.equals(serialized.surfmgr.get("INERT"))) {
            misc.setSurfDefault((Surface)serialized.surfmgr.get("INERT"));
            warningReport.addWarning(new Warning(Intl.intl("The following surfaces cannot be set as default: OPEN, MIRROR, HVAC."), Intl.intl("Default Surface set as INERT")));
        }
    }

    private void migratePre56TempRegToAdvanced(Serialized serialized) {
        String string = PyroSimObjectInputStream.migrateBurnerTempRegToAdvanced(serialized.surfmgr.flatten(), this.d_warnings);
        serialized.unprocessedRecords = serialized.unprocessedRecords + string;
    }

    private void fixPre57Species(Serialized serialized) {
        Object object;
        HashMap<String, Ramp> hashMap = new HashMap<String, Ramp>();
        FDSNameMap fDSNameMap = new FDSNameMap();
        for (Object object2 : serialized.exSpecs.flatten()) {
            if (ExSpecList.isPredefinedSpecies(((NamedPyroObject)object2).getName())) {
                if (!ExSpecList.equalsPredefinedSpecies((ExSpec)object2)) {
                    Object object3;
                    this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports modifying predefined species."), String.format(Intl.intl("Non-default fields for Species %s moved to Advanced Parameters."), ((NamedPyroObject)object2).getName())));
                    object = new HashMap();
                    ExSpec exSpec = ExSpecList.getPredefinedSpecies(((NamedPyroObject)object2).getName());
                    if (!((ExSpec)object2).getMolecularWeight().equals(exSpec.getMolecularWeight())) {
                        object.put("MW", Double.toString(((ExSpec)object2).getMolecularWeight().getValue(SI.GRAM.divide(SI.MOLE))));
                        ((ExSpec)object2).setMolecularWeight(exSpec.getMolecularWeight());
                    }
                    if (!((ExSpec)object2).getChemFormula().equals(exSpec.getChemFormula())) {
                        object.put("FORMULA", '\'' + ((ExSpec)object2).getChemFormula() + '\'');
                        ((ExSpec)object2).setChemFormula(exSpec.getChemFormula());
                    }
                    ExSpec.PrimitiveParams primitiveParams = ((ExSpec)object2).getPrimParams();
                    ExSpec.PrimitiveParams primitiveParams2 = exSpec.getPrimParams();
                    if (!primitiveParams.getDiffusivity().isDefault()) {
                        if (primitiveParams.getDiffusivity().isRamp()) {
                            object3 = RampRenderer.createID(fDSNameMap, ((NamedPyroObject)object2).getName(), "RAMP_D");
                            hashMap.put((String)object3, (Ramp)primitiveParams.getDiffusivity().val);
                            object.put("RAMP_D", '\'' + (String)object3 + '\'');
                        } else {
                            object.put("DIFFUSIVITY", Double.toString(((UnitDouble)primitiveParams.getDiffusivity().val).getValue(SI.METER.pow(2).divide(SI.SECOND))));
                        }
                        primitiveParams.setDiffusivity(Variant.def());
                    }
                    if (!primitiveParams.getViscosity().isDefault()) {
                        if (primitiveParams.getViscosity().isRamp()) {
                            object3 = RampRenderer.createID(fDSNameMap, ((NamedPyroObject)object2).getName(), "RAMP_MU");
                            hashMap.put((String)object3, (Ramp)primitiveParams.getViscosity().val);
                            object.put("RAMP_MU", '\'' + (String)object3 + '\'');
                        } else {
                            object.put("VISCOSITY", Double.toString(((UnitDouble)primitiveParams.getViscosity().val).getValue(SI.KILOGRAM.divide(SI.METER.multiply(SI.SECOND)))));
                        }
                        primitiveParams.setViscosity(Variant.def());
                    }
                    if (primitiveParams.isSigmaLJSet()) {
                        object.put("SIGMALJ", Double.toString(primitiveParams.getSigmaLJ()));
                        primitiveParams.setSigmaLJ(0.0, false);
                    }
                    if (primitiveParams.isEpsilonKLJSet()) {
                        object.put("EPSILONKLJ", Double.toString(primitiveParams.getEpsilonKLJ()));
                        primitiveParams.setEpsilonKLJ(0.0, false);
                    }
                    if (!primitiveParams.getRadCalSurrogate().equals(primitiveParams2.getRadCalSurrogate())) {
                        object.put("RADCAL_ID", '\'' + primitiveParams.getRadCalSurrogate() + '\'');
                        primitiveParams.setRadCalSurrogate(primitiveParams2.getRadCalSurrogate());
                    }
                    if (primitiveParams.isAerosol()) {
                        object.put("AEROSOL", ".TRUE.");
                        if (!primitiveParams.getDensitySolid().equals(primitiveParams2.getDensitySolid())) {
                            object.put("DENSITY_SOLID", Double.toString(primitiveParams.getDensitySolid().getValue(SI.KILOGRAM.divide(SI.METER.pow(3)))));
                            primitiveParams.setDensitySolid(primitiveParams2.getDensitySolid());
                        }
                        if (!primitiveParams.getConductivitySolid().equals(primitiveParams2.getConductivitySolid())) {
                            object.put("CONDUCTIVITY_SOLID", Double.toString(primitiveParams.getConductivitySolid().getValue(SI.WATT.divide(SI.KELVIN.multiply(SI.METER)))));
                            primitiveParams.setConductivitySolid(primitiveParams2.getConductivitySolid());
                        }
                        if (!primitiveParams.getMeanDiameter().equals(primitiveParams2.getMeanDiameter())) {
                            object.put("MEAN_DIAMETER", Double.toString(primitiveParams.getMeanDiameter().getValue(SI.METER)));
                            primitiveParams.setMeanDiameter(primitiveParams2.getMeanDiameter());
                        }
                    }
                    if (!primitiveParams.getSpecHeat().isDefault()) {
                        if (primitiveParams.getSpecHeat().isRamp()) {
                            object3 = RampRenderer.createID(fDSNameMap, ((NamedPyroObject)object2).getName(), "RAMP_CP");
                            hashMap.put((String)object3, (Ramp)primitiveParams.getSpecHeat().val);
                            object.put("RAMP_CP", '\'' + (String)object3 + '\'');
                        } else {
                            object.put("SPECIFIC_HEAT", Double.toString(((UnitDouble)primitiveParams.getSpecHeat().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM.multiply(SI.KELVIN)))));
                        }
                        primitiveParams.setSpecHeat(Variant.def());
                    }
                    if (primitiveParams.isRefTempSet()) {
                        object.put("REFERENCE_TEMPERATURE", Double.toString(primitiveParams.getRefTemp().getValue(SI.CELSIUS)));
                        primitiveParams.setRefTemp(primitiveParams2.getRefTemp(), false);
                    }
                    if (primitiveParams.isRefEnthalpySet() && primitiveParams.getRefEnthalpy().isConstant()) {
                        object.put("REFERENCE_ENTHALPY", Double.toString(((UnitDouble)primitiveParams.getRefEnthalpy().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM))));
                        primitiveParams.setRefEnthalpy(null);
                    }
                    if (!primitiveParams.getSpecHeatLiquid().isDefault()) {
                        if (primitiveParams.getSpecHeatLiquid().isRamp()) {
                            object3 = RampRenderer.createID(fDSNameMap, ((NamedPyroObject)object2).getName(), "RAMP_CP_L");
                            hashMap.put((String)object3, (Ramp)primitiveParams.getSpecHeatLiquid().val);
                            object.put("RAMP_CP_L", '\'' + (String)object3 + '\'');
                        } else {
                            object.put("SPECIFIC_HEAT_LIQUID", Double.toString(((UnitDouble)primitiveParams.getSpecHeat().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM.multiply(SI.KELVIN)))));
                        }
                        primitiveParams.setViscosity(Variant.def());
                    }
                    if (primitiveParams.isDensityLiquidSet()) {
                        object.put("DENSITY_LIQUID", Double.toString(((UnitDouble)primitiveParams.getDensityLiquid().val).getValue(SI.KILOGRAM.divide(SI.METER.pow(3)))));
                        primitiveParams.setDensityLiquid(null);
                    }
                    if (primitiveParams.isVapTempSet()) {
                        object.put("VAPORIZATION_TEMPERATURE", Double.toString(((UnitDouble)primitiveParams.getVapTemp().val).getValue(SI.CELSIUS)));
                        primitiveParams.setVapTemp(null);
                    }
                    if (primitiveParams.isMeltingTempSet()) {
                        object.put("MELTING_TEMPERATURE", Double.toString(((UnitDouble)primitiveParams.getMeltTemp().val).getValue(SI.CELSIUS)));
                        primitiveParams.setMeltingTemp(null);
                    }
                    if (primitiveParams.isHoVaporizationSet()) {
                        object.put("HEAT_OF_VAPORIZATION", Double.toString(((UnitDouble)primitiveParams.getHoVaporization().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM))));
                        primitiveParams.setHoVaporization(null);
                    }
                    if (primitiveParams.isEoFormationSet()) {
                        object.put("ENTHALPY_OF_FORMATION", Double.toString(((UnitDouble)primitiveParams.getEoFormation().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM))));
                        primitiveParams.setEoFormation(null);
                    }
                    if (primitiveParams.isHVRefTempSet()) {
                        object.put("H_V_REFERENCE_TEMPERATURE", Double.toString(((UnitDouble)primitiveParams.getHVRefTemp().val).getValue(SI.CELSIUS)));
                        primitiveParams.setHVRefTemp(null);
                    }
                    if (((ExSpec)object2).getComposition().size() > 0) {
                        this.fixAirReferences(serialized.exSpecs.get("AIR"), (ExSpec)object2, this.d_warnings);
                        int n = 1;
                        for (Map.Entry<ExSpec, Double> entry : ((ExSpec)object2).getComposition().entrySet()) {
                            object.put(String.format("%s(%d)", "SPEC_ID", n), '\'' + entry.getKey().getName() + '\'');
                            if (((ExSpec)object2).getType() == 2) {
                                object.put(String.format("%s(%d)", "MASS_FRACTION", n), entry.getValue().toString());
                            } else if (((ExSpec)object2).getType() == 3) {
                                object.put(String.format("%s(%d)", "VOLUME_FRACTION", n), entry.getValue().toString());
                            }
                            ++n;
                        }
                        ((ExSpec)object2).setComposition(0, new LinkedHashMap<ExSpec, Double>());
                    }
                    object3 = CustomFDSProps.get((Map<String, String>)object);
                    object2.setCustomFDSProps(CustomFDSProps.union((CustomFDSProps)object3, object2.getCustomFDSProps()));
                }
                ((ExSpec)object2).setType(0);
            }
            this.fixAirReferences(serialized.exSpecs.get("AIR"), (ExSpec)object2, this.d_warnings);
            this.fixEnthalpyOfFormation((ExSpec)object2);
        }
        if (!hashMap.isEmpty()) {
            Object object2;
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports modifying predefined species."), Intl.intl("Unsupported ramps moved to Additional Records.")));
            FDSRenderProps fDSRenderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            object2 = new PinConnectionRenderer(fDSNameMap);
            object = new FDSStringRenderer(fDSRenderProps);
            RampRenderer.render((IFDSRecordRenderer)object, hashMap, (PinConnectionRenderer)object2);
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)object).toString();
        }
        serialized.exSpecs.addDefaults();
    }

    private void fixAirReferences(ExSpec exSpec, ExSpec exSpec2, WarningReport warningReport) {
        if (exSpec2.getType() != 2 && exSpec2.getType() != 3) {
            return;
        }
        if (exSpec == null) {
            return;
        }
        Map<ExSpec, Double> map = exSpec2.getComposition();
        if (map.containsKey(exSpec)) {
            warningReport.addWarning(new Warning(Intl.intl("The lumped species AIR can not be used as a component of another lumped species."), String.format(Intl.intl("AIR removed from the composition of species %s."), exSpec2.getName())));
            map.remove(exSpec);
        }
    }

    private void fixEnthalpyOfFormation(ExSpec exSpec) {
        Variant variant;
        if (exSpec.getType() == 1 && (variant = exSpec.getPrimParams().getEoFormation()).isConstant()) {
            double d = ((UnitDouble)variant.val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
            exSpec.getPrimParams().setEoFormation(new UnitDouble(d, SI.KILO(SI.JOULE).divide(SI.MOLE)));
        }
    }

    private void fixPre59Species(Serialized serialized) {
        PyroSimObjectInputStream.fixPre59Species(serialized, this.d_warnings);
    }

    private static void fixPre59Species(Serialized serialized, WarningReport warningReport) {
        ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>();
        for (ExSpec exSpec : serialized.exSpecs.flatten()) {
            if (!ExSpecList.equalsPredefinedSpecies(exSpec)) continue;
            arrayList.add(exSpec);
        }
    }

    private void removePre60InitVaporFlux(Serialized serialized) {
        for (Material material : serialized.matmgr.flatten()) {
            if (!(material.getPyrolysis() instanceof LiquidPyrolysis)) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("INITIAL_VAPOR_FLUX", Double.toString(((LiquidPyrolysis)material.getPyrolysis()).d_iniVaporFlux.getValue(SIUS.unit(73))));
            CustomFDSProps customFDSProps = CustomFDSProps.get(hashMap);
            material.setCustomFDSProps(CustomFDSProps.union(customFDSProps, material.getCustomFDSProps()));
            this.d_warnings.addWarning(new Warning("The variable Initial Vapor Flux is no longer supported.", String.format(Intl.intl("INITIAL_VAPOR_FLUX for material %s moved to Advanced Parameters."), material.getName())));
        }
    }

    private void reorganizePre62HVAC(Serialized serialized) {
        Collection<IHvacGeomComp> collection = ((APyroObject)serialized.hvacSystem).flatten(IHvacGeomComp.class);
        if (collection.isEmpty()) {
            return;
        }
        collection = new ArrayList<IHvacGeomComp>(collection);
        Composite composite = serialized.obstructions.newGroup(Intl.intl("HVAC"));
        serialized.obstructions.add(composite);
        IdentityHashMap<Composite, Composite> identityHashMap = new IdentityHashMap<Composite, Composite>();
        identityHashMap.put(serialized.hvacSystem, composite);
        new PyroMod(serialized, false, false);
        for (IHvacGeomComp iHvacGeomComp : collection) {
            IPyroObject iPyroObject = iHvacGeomComp.getParent();
            if (!(iPyroObject instanceof Composite)) continue;
            Composite composite2 = PyroSimObjectInputStream.getCopyParent(serialized, identityHashMap, iHvacGeomComp);
            ((Composite)iPyroObject).remove(iHvacGeomComp);
            composite2.add(iHvacGeomComp);
        }
        serialized.hvacSystem.prune(Filters.accept(identityHashMap.keySet()));
        serialized.setDomain(null);
        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("HVAC ducts and nodes are now stored in the \"%s\" group."), serialized.obstructions.getName()), String.format(Intl.intl("Ducts and nodes have been moved to \"%s\"."), serialized.obstructions.getName() + "->" + composite.getName())));
    }

    private static Composite getCopyParent(Serialized serialized, Map<Composite, Composite> map, IPyroObject iPyroObject) {
        IPyroObject iPyroObject2 = iPyroObject.getParent();
        if (!(iPyroObject2 instanceof Composite)) {
            return serialized.obstructions;
        }
        Composite composite = (Composite)iPyroObject2;
        Composite composite2 = map.get(composite);
        if (composite2 != null) {
            return composite2;
        }
        Composite composite3 = PyroSimObjectInputStream.getCopyParent(serialized, map, composite);
        composite2 = composite3.newGroup(pyrosim.util.Util.getName(composite));
        composite3.add(composite2);
        map.put(composite, composite2);
        return composite2;
    }

    private void updatePre63Surfs(Serialized serialized) {
        PyroSimObjectInputStream.updatePre63Surfs(serialized, this.d_warnings);
    }

    public static void updatePre63Surfs(Serialized serialized, WarningReport warningReport) {
        for (Surface surface : serialized.surfmgr.flatten()) {
            if (!(surface.getSurfDesc() instanceof SurfDescStatic.Adiabatic)) continue;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(surface.getCustomFDSProps().getProps());
            SurfDescStatic.Adiabatic adiabatic = (SurfDescStatic.Adiabatic)surface.getSurfDesc();
            if (adiabatic.slip instanceof ISlip.FreeSlip) {
                linkedHashMap.put("FREE_SLIP", ".TRUE.");
            } else if (adiabatic.slip instanceof ISlip.NoSlip) {
                linkedHashMap.put("NO_SLIP", ".TRUE.");
            } else if (((ISlip.RoughSlip)adiabatic.slip).roughness.getValueNoUnit() > 0.0) {
                linkedHashMap.put("ROUGHNESS", Double.toString(((ISlip.RoughSlip)adiabatic.slip).roughness.getValue(SI.METER)));
            }
            if (surface.isPredefined()) {
                surface.setSurfDesc(new SurfDescStatic.Adiabatic());
                surface.setCustomFDSProps(CustomFDSProps.EMPTY);
            }
            if (linkedHashMap.size() <= 0) continue;
            if (surface.isPredefined()) {
                warningReport.addWarning(new Warning(Intl.intl("The default surface ADIABATIC can no longer be modified."), Intl.intl("Slip conditions and custom properties removed from surface, ADIABATIC.")));
                continue;
            }
            surface.setCustomFDSProps(CustomFDSProps.get(linkedHashMap));
            surface.setSurfDesc(new ConstantTempSurfDesc(TempRegulation.newAdiabaticTR(null, false), new ParticleInjection(), IGeometry.DEFAULT));
            warningReport.addWarning(new Warning(Intl.intl("Adiabatic surfaces are now specified using the Heater/Cooler type."), String.format(Intl.intl("Surface %s is being converted to a Heater/Cooler surface type."), surface.getName())));
        }
    }

    private void updatePre69Adiabatic(Serialized serialized) {
        PyroSimObjectInputStream.updatePre69Adiabatic(serialized, this.d_warnings);
    }

    public static void updatePre69Adiabatic(Serialized serialized, WarningReport warningReport) {
        for (Surface surface : serialized.surfmgr.flatten()) {
            if (!(surface.getSurfDesc() instanceof SurfDescStatic.Adiabatic) || surface.isPredefined()) continue;
            surface.setSurfDesc(new ConstantTempSurfDesc(TempRegulation.newAdiabaticTR(null, false), new ParticleInjection(), IGeometry.DEFAULT));
        }
    }

    private void updatePre65Surfs(Serialized serialized) {
        PyroSimObjectInputStream.updatePre65Surfs(serialized, this.d_warnings);
    }

    public static void updatePre65Surfs(Serialized serialized, WarningReport warningReport) {
        for (Surface surface : serialized.surfmgr.flatten()) {
            if (!(surface.getSurfDesc() instanceof LayeredSurfDesc)) continue;
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (layeredSurfDesc.d_slip instanceof ISlip.FreeSlip) {
                hashMap.put("FREE_SLIP", ".TRUE.");
            } else if (layeredSurfDesc.d_slip instanceof ISlip.NoSlip) {
                hashMap.put("NO_SLIP", ".TRUE.");
            } else if (((ISlip.RoughSlip)layeredSurfDesc.d_slip).roughness.getValueNoUnit() > 0.0) {
                hashMap.put("ROUGHNESS", Double.toString(((ISlip.RoughSlip)layeredSurfDesc.d_slip).roughness.getValue(SI.METER)));
            }
            if (hashMap.size() > 0) {
                surface.setCustomFDSProps(CustomFDSProps.union(surface.getCustomFDSProps(), CustomFDSProps.get(hashMap)));
                warningReport.addWarning(new Warning(Intl.intl("Tangential boundary conditions can no longer be specified on layered surface."), String.format(Intl.intl("Tangential boundary conditions for %s moved to Advanced."), surface.getName())));
            }
            UnitDouble unitDouble = new UnitDouble(0.0, SI.METER);
            UnitDouble unitDouble2 = new UnitDouble(0.0, SI.METER);
            UnitDouble unitDouble3 = new UnitDouble(0.0, SI.METER);
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(surface.getCustomFDSProps().getProps());
            if (linkedHashMap.containsKey("LENGTH")) {
                unitDouble = new UnitDouble(Double.parseDouble((String)linkedHashMap.get("LENGTH")), SI.METER);
            }
            if (linkedHashMap.containsKey("WIDTH")) {
                unitDouble2 = new UnitDouble(Double.parseDouble((String)linkedHashMap.get("WIDTH")), SI.METER);
            }
            if (linkedHashMap.containsKey("INNER_RADIUS")) {
                unitDouble3 = new UnitDouble(Double.parseDouble((String)linkedHashMap.get("INNER_RADIUS")), SI.METER);
            }
            IGeometry iGeometry = IGeometry.DEFAULT;
            if (layeredSurfDesc.d_geom.equals((Object)LayeredSurfDesc.Geometry.CYLINDRICAL)) {
                iGeometry = new IGeometry.Cylindrical(unitDouble3, null, Variant.constant(unitDouble));
                if (linkedHashMap.containsKey("INNER_RADIUS")) {
                    linkedHashMap.remove("INNER_RADIUS");
                }
                if (linkedHashMap.containsKey("LENGTH")) {
                    linkedHashMap.remove("LENGTH");
                }
            } else if (layeredSurfDesc.d_geom.equals((Object)LayeredSurfDesc.Geometry.SPHERICAL)) {
                iGeometry = new IGeometry.Spherical(unitDouble3, null);
                if (linkedHashMap.containsKey("INNER_RADIUS")) {
                    linkedHashMap.remove("INNER_RADIUS");
                }
            } else if (layeredSurfDesc.d_geom.equals((Object)LayeredSurfDesc.Geometry.FLAT)) {
                iGeometry = new IGeometry.Cartesian(unitDouble, unitDouble2);
                if (linkedHashMap.containsKey("LENGTH")) {
                    linkedHashMap.remove("LENGTH");
                }
                if (linkedHashMap.containsKey("WIDTH")) {
                    linkedHashMap.remove("WIDTH");
                }
            }
            surface.setSurfDesc(new LayeredSurfDesc(iGeometry, layeredSurfDesc.d_iReac, layeredSurfDesc.d_surfComp, layeredSurfDesc.d_specInj, layeredSurfDesc.d_partInj, layeredSurfDesc.d_burnAway, layeredSurfDesc.d_leakPath, TempRegulation.newDefault()));
            surface.setCustomFDSProps(CustomFDSProps.get(linkedHashMap));
        }
    }

    private void removeSolidPartSizeDist(Serialized serialized) {
        for (Particle particle : serialized.particles.flatten()) {
            if (particle.getType() != Particle.Type.SOLID || particle.getDistribution().equals((Object)Particle.Distribution.CONST)) continue;
            this.d_warnings.addWarning(new Warning(Intl.intl("Solid particles do not support size distribution."), Intl.intl("Size distribution data removed from solid particles.")));
            break;
        }
    }

    private void addPeriodicSurface(Serialized serialized) {
        PyroSimObjectInputStream.addPeriodicSurface(serialized, this.d_warnings);
    }

    public static void addPeriodicSurface(Serialized serialized, WarningReport warningReport) {
        if (serialized.surfmgr.get(PredefSurf.PERIODIC.toString()) == null) {
            serialized.surfmgr.addPredefined();
        } else {
            Surface surface2;
            NameGenerator nameGenerator = new NameGenerator("Surfaces");
            for (Surface surface2 : serialized.surfmgr.flatten()) {
                nameGenerator.registerName(surface2.getName());
            }
            String string = nameGenerator.generateValidName(PredefSurf.PERIODIC.toString());
            surface2 = (Surface)serialized.surfmgr.get(PredefSurf.PERIODIC.toString());
            surface2.setName(string);
            serialized.surfmgr.addPredefined();
            warningReport.addWarning(new Warning(String.format(Intl.intl("The surface name %s conflicts with a reserved FDS surface name."), PredefSurf.PERIODIC.toString()), String.format(Intl.intl("User defined surface %s renamed as %s."), PredefSurf.PERIODIC.toString(), string)));
        }
    }

    private void fixPre68SprayModels(Serialized serialized) {
        PyroSimObjectInputStream.fixPre68SprayModels(serialized, this.d_warnings);
    }

    public static void fixPre68SprayModels(Serialized serialized, WarningReport warningReport) {
        for (SprayModel sprayModel : serialized.sprayModels.flatten()) {
            double d;
            double d2;
            if (sprayModel.getJets().size() > 1) continue;
            SprayModel.Jet jet = sprayModel.getJets().get(0);
            if (jet.d_long1 == null || jet.d_long2 == null || !(Math.abs(Math.abs((d2 = jet.d_long1.getValue(NonSI.DEGREE_ANGLE)) - (d = jet.d_long2.getValue(NonSI.DEGREE_ANGLE))) - 360.0) < 1.0E-5)) continue;
            SprayModel.Jet jet2 = new SprayModel.Jet(jet.d_velocity, jet.d_orificeDiam, 1.0, jet.d_lat1, jet.d_lat2);
            sprayModel.setJets(Arrays.asList(jet2));
        }
    }

    private void fixPre72ClonedPins(Serialized serialized) {
        PyroSimObjectInputStream.fixPre72ClonedPins(serialized, this.d_warnings);
    }

    public static void fixPre72ClonedPins(Serialized serialized, WarningReport warningReport) {
        for (INamed iNamed : serialized.controls.flatten()) {
            for (IOutPin iOutPin : iNamed.getOutputPins()) {
                if (iOutPin.getAttachedSource() == iNamed) continue;
                iOutPin.setSource((ISignalSource)((Object)iNamed));
            }
        }
        for (INamed iNamed : serialized.devices.flatten()) {
            if (!(iNamed instanceof ISignalSource)) continue;
            for (IOutPin iOutPin : ((ISignalSource)((Object)iNamed)).getOutputPins()) {
                if (iOutPin.getAttachedSource() == iNamed) continue;
                iOutPin.setSource((ISignalSource)((Object)iNamed));
            }
        }
    }

    private void fixPre73SprayModels(Serialized serialized) {
        PyroSimObjectInputStream.fixPre73SprayModels(serialized, this.d_warnings);
    }

    public static void fixPre73SprayModels(Serialized serialized, WarningReport warningReport) {
        for (SprayModel sprayModel : serialized.sprayModels.flatten()) {
            if (sprayModel.getJets().size() != 1) continue;
            ArrayList<SprayModel.Jet> arrayList = new ArrayList<SprayModel.Jet>();
            for (SprayModel.Jet jet : sprayModel.getJets()) {
                if (jet.d_orificeDiam != null || jet.d_velocity != null) continue;
                arrayList.add(new SprayModel.Jet(new UnitDouble(5.0, SI.METER.divide(SI.SECOND)), null, jet.d_flowFrac, jet.d_long1, jet.d_long2, jet.d_lat1, jet.d_lat2));
            }
            if (arrayList.isEmpty()) continue;
            sprayModel.setJets(arrayList);
        }
    }

    private void fixPre75FireSpreadVents(Serialized serialized) {
        PyroSimObjectInputStream.fixPre75FireSpreadVents(serialized, this.d_warnings);
    }

    public static void fixPre75FireSpreadVents(Serialized serialized, WarningReport warningReport) {
    }

    private void fixPre76SliceDuplicates(Serialized serialized) {
        PyroSimObjectInputStream.fixPre76SliceDuplicates(serialized, this.d_warnings);
    }

    public static void fixPre76SliceDuplicates(Serialized serialized, WarningReport warningReport) {
        Object object;
        Object object2;
        new PyroMod(serialized, false, false);
        HashMap hashMap = new HashMap();
        for (Object object3 : serialized.slices.flatten()) {
            object2 = (PlanarSlice)object3;
            object = new PlanarSlice.PlanarSliceHash(((PlanarSlice)object2).getPlane(), ((PlanarSlice)object2).getLocation(), ((Slice)object2).getQuantity());
            if (hashMap.get(object) == null) {
                hashMap.put((PlanarSlice.PlanarSliceHash)object, new ArrayList());
            }
            ((List)hashMap.get(object)).add(object3);
        }
        for (Object object3 : hashMap.values()) {
            object3.sort(new Comparator<Slice>(){

                @Override
                public int compare(Slice slice, Slice slice2) {
                    if (slice.includeFlowVector() && !slice2.includeFlowVector()) {
                        return 1;
                    }
                    if (!slice.includeFlowVector() && slice2.includeFlowVector()) {
                        return -1;
                    }
                    return Integer.compare(slice.hashCode(), slice2.hashCode());
                }
            });
            object3.remove(0);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Slice)object2.next();
                ((SliceList)((APyroObject)object).getParent()).remove((IPyroObject)object);
            }
        }
        serialized.setDomain(null);
    }

    private void fix76BurnerVents(Serialized serialized) {
        PyroSimObjectInputStream.fix76BurnerVents(serialized, this.d_warnings);
    }

    private static void fix76BurnerVents(Serialized serialized, WarningReport warningReport) {
        for (IModelObj iModelObj : serialized.obstructions.flatten()) {
            if (!(iModelObj instanceof pyrosim.domain.geom.Vent)) continue;
            pyrosim.domain.geom.Vent vent = (pyrosim.domain.geom.Vent)iModelObj;
            boolean bl = false;
            for (Surface surface : vent.getSurfaces()) {
                if (!pyrosim.domain.geom.Vent.isValidFireSpreadSurf(surface)) continue;
                bl = true;
                break;
            }
            if (bl && vent.getFireSpreadRate() != null && vent.getFireSpreadRate().getValueNoUnit() == 0.0) {
                vent.setFireSpreadRate(null);
                warningReport.addWarning(new Warning(Intl.intl("The previous PyroSim version incorrectly assigned spread rate properties to burning vents."), Intl.intl(String.format("Spread rate set inactive for Vent %s.", vent.getName()))));
            }
            if (vent.getRadius() == null || vent.getRadius().getValueNoUnit() != 0.0) continue;
            vent.setRadius(null);
        }
    }

    private void fixBadSpecInj(Serialized serialized) {
        PyroSimObjectInputStream.fixBadSpecInj(serialized, this.d_warnings);
    }

    private static void fixBadSpecInj(Serialized serialized, WarningReport warningReport) {
        for (Surface surface : serialized.surfmgr.flatten()) {
            ISurfDesc iSurfDesc;
            ISurfDesc iSurfDesc2 = null;
            if (surface.getSurfDesc() instanceof InFlowSurfDesc) {
                iSurfDesc = (InFlowSurfDesc)surface.getSurfDesc();
                if (iSurfDesc.d_airFlow.d_rate.specInj == null) continue;
                iSurfDesc2 = new InFlowSurfDesc(PyroSimObjectInputStream.fixBadSpecInj(iSurfDesc.d_airFlow), iSurfDesc.d_temperature);
            } else if (surface.getSurfDesc() instanceof BlowerSurfDesc) {
                iSurfDesc = (BlowerSurfDesc)surface.getSurfDesc();
                if (((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate.specInj == null) continue;
                iSurfDesc2 = new BlowerSurfDesc(((BlowerSurfDesc)iSurfDesc).d_tempReg, PyroSimObjectInputStream.fixBadSpecInj(((BlowerSurfDesc)iSurfDesc).d_airFlow), ((BlowerSurfDesc)iSurfDesc).d_partInj, ((BlowerSurfDesc)iSurfDesc).d_geometry);
            } else if (surface.getSurfDesc() instanceof GeneralSurfDesc) {
                iSurfDesc = (GeneralSurfDesc)surface.getSurfDesc();
                if (((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate.specInj == null || ((GeneralSurfDesc)iSurfDesc).d_specInj == null) continue;
                iSurfDesc2 = new GeneralSurfDesc(((GeneralSurfDesc)iSurfDesc).d_tempReg, ((GeneralSurfDesc)iSurfDesc).d_partInj, PyroSimObjectInputStream.fixBadSpecInj(((GeneralSurfDesc)iSurfDesc).d_specInj), ((GeneralSurfDesc)iSurfDesc).d_heatRelease, PyroSimObjectInputStream.fixBadSpecInj(((GeneralSurfDesc)iSurfDesc).d_airflow), ((GeneralSurfDesc)iSurfDesc).d_geometry);
            } else if (surface.getSurfDesc() instanceof LayeredSurfDesc) {
                iSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
                if (((LayeredSurfDesc)iSurfDesc).d_specInj == null) continue;
                iSurfDesc2 = new LayeredSurfDesc(((LayeredSurfDesc)iSurfDesc).d_geometry, ((LayeredSurfDesc)iSurfDesc).d_iReac, ((LayeredSurfDesc)iSurfDesc).d_surfComp, PyroSimObjectInputStream.fixBadSpecInj(((LayeredSurfDesc)iSurfDesc).d_specInj), ((LayeredSurfDesc)iSurfDesc).d_partInj, ((LayeredSurfDesc)iSurfDesc).d_burnAway, ((LayeredSurfDesc)iSurfDesc).d_leakPath, ((LayeredSurfDesc)iSurfDesc).d_temperature);
            }
            if (iSurfDesc2 == null) continue;
            surface.setSurfDesc(iSurfDesc2);
        }
    }

    private static SpecInjList fixBadSpecInj(SpecInjList specInjList) {
        return new SpecInjList(specInjList.injType, new ArrayList<SpeciesInjection>(specInjList.getInjections()));
    }

    private static AirFlow fixBadSpecInj(AirFlow airFlow) {
        AirFlow airFlow2 = null;
        if (airFlow.d_rate instanceof AirFlow.NormalVel) {
            AirFlow.NormalVel normalVel = (AirFlow.NormalVel)airFlow.d_rate;
            airFlow2 = new AirFlow(new AirFlow.NormalVel(normalVel.val, normalVel.tanVelU, normalVel.tanVelV, normalVel.func, new SpecInjList(normalVel.specInj.injType, new ArrayList<SpeciesInjection>(normalVel.specInj.getInjections()))), airFlow.d_profile);
        } else if (airFlow.d_rate instanceof AirFlow.VolumeFlux) {
            AirFlow.VolumeFlux volumeFlux = (AirFlow.VolumeFlux)airFlow.d_rate;
            airFlow2 = new AirFlow(new AirFlow.VolumeFlux(volumeFlux.val, volumeFlux.tanVelU, volumeFlux.tanVelV, volumeFlux.func, new SpecInjList(volumeFlux.specInj.injType, new ArrayList<SpeciesInjection>(volumeFlux.specInj.getInjections()))), airFlow.d_profile);
        } else if (airFlow.d_rate instanceof AirFlow.TotalMassFlux) {
            AirFlow.TotalMassFlux totalMassFlux = (AirFlow.TotalMassFlux)airFlow.d_rate;
            airFlow2 = new AirFlow(new AirFlow.TotalMassFlux(totalMassFlux.val, totalMassFlux.tanVelU, totalMassFlux.tanVelV, totalMassFlux.func, new SpecInjList(totalMassFlux.specInj.injType, new ArrayList<SpeciesInjection>(totalMassFlux.specInj.getInjections()))), airFlow.d_profile);
        } else if (airFlow.d_rate instanceof AirFlow.ExSpecMassFlux) {
            AirFlow.ExSpecMassFlux exSpecMassFlux = (AirFlow.ExSpecMassFlux)airFlow.d_rate;
            airFlow2 = new AirFlow(new AirFlow.ExSpecMassFlux(exSpecMassFlux.tanVelU, exSpecMassFlux.tanVelV, exSpecMassFlux.func, new SpecInjList(exSpecMassFlux.specInj.injType, new ArrayList<SpeciesInjection>(exSpecMassFlux.specInj.getInjections()))), airFlow.d_profile);
        } else {
            assert (false);
            airFlow2 = airFlow;
        }
        return airFlow2;
    }

    public static void fixBadDeviceRefs(Serialized serialized) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (ControlBridge object : serialized.controls.flatten()) {
            PyroSimObjectInputStream.getOriginalControl(object, linkedHashMap);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (serialized.devices.containsDeep((IPyroObject)((Pair)entry.getKey()).v2) || !(((Pair)entry.getKey()).v2 instanceof IDevice) || ((Pair)entry.getKey()).v2 instanceof Timer || ((Pair)entry.getKey()).v2 instanceof Clock) continue;
            serialized.devices.remove((IPyroObject)((Pair)entry.getKey()).v2);
            for (IOutPin iOutPin : ((ISignalSource)((Pair)entry.getKey()).v2).getOutputPins()) {
                ((ISignalSink)((Pair)entry.getKey()).v1).getInputPin().disconnect(iOutPin);
            }
        }
    }

    private static void getOriginalControl(ControlBridge controlBridge, Map map) {
        for (ISignalSource iSignalSource : controlBridge.getInputPin().getConnectedSources()) {
            PyroSimObjectInputStream.getOriginalControl(new Pair<ControlBridge, ISignalSource>(controlBridge, iSignalSource), controlBridge, iSignalSource, map);
        }
    }

    private static void getOriginalControl(Pair pair, ISignalSink iSignalSink, ISignalSource iSignalSource, Map map) {
        if (iSignalSource instanceof ISignalSink) {
            if (((ISignalSink)((Object)iSignalSource)).getInputPin().getConnectedSources().isEmpty()) {
                map.put(new Pair<ISignalSink, ISignalSource>(iSignalSink, iSignalSource), pair);
                return;
            }
            for (ISignalSource iSignalSource2 : ((ISignalSink)((Object)iSignalSource)).getInputPin().getConnectedSources()) {
                PyroSimObjectInputStream.getOriginalControl(pair, (ISignalSink)((Object)iSignalSource), iSignalSource2, map);
            }
        } else {
            map.put(new Pair<ISignalSink, ISignalSource>(iSignalSink, iSignalSource), pair);
        }
    }

    public static String migrateBurnerTempRegToAdvanced(Collection<Surface> collection, WarningReport<Warning> warningReport) {
        FDSNameMap fDSNameMap = new FDSNameMap();
        PinConnectionRenderer pinConnectionRenderer = new PinConnectionRenderer(fDSNameMap);
        HashMap<String, Ramp> hashMap = new HashMap<String, Ramp>();
        FDSRenderProps fDSRenderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
        for (Surface object : collection) {
            TempRegulation tempRegulation;
            if (object.isPredefined() || !(object.getSurfDesc() instanceof BurnerSurfDesc)) continue;
            Object object2 = (BurnerSurfDesc)object.getSurfDesc();
            TempRegulation tempRegulation2 = TempRegulation.legacyDefaultTR();
            if (tempRegulation2.equals(tempRegulation = ((BurnerSurfDesc)object2).getVestigialTempRegData())) continue;
            FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("SURF");
            SurfaceRenderer.renderTempRegulation(fDSRenderRecord, fDSNameMap, hashMap, object, tempRegulation, false);
            if (!fDSRenderRecord.contains("CONVECTIVE_HEAT_FLUX") || !fDSRenderRecord.contains("TAU_Q") && !fDSRenderRecord.contains("RAMP_Q")) continue;
            fDSRenderRecord.setValue("TAU_Q", null);
            if (fDSRenderRecord.contains("RAMP_Q")) {
                String string = (String)fDSRenderRecord.get("RAMP_Q");
                hashMap.remove(string);
                fDSRenderRecord.setValue("RAMP_Q", null);
            }
            if (warningReport == null) continue;
            warningReport.addWarning(new Warning(String.format(Intl.intl("[%s] Ambiguous ramp-up."), object.getName()), Intl.intl("Using heat release ramp-up; temperature ramp-up removed.")));
        }
        if (!hashMap.isEmpty()) {
            FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(fDSRenderProps);
            RampRenderer.render(fDSStringRenderer, hashMap, pinConnectionRenderer);
            if (warningReport != null) {
                for (Object object2 : hashMap.keySet()) {
                    warningReport.addWarning(new Warning(Intl.intl("Surface boundary conditions are no longer supported on burner surfaces."), String.format(Intl.intl("Ramp %s moved to the Additional Records."), object2)));
                }
            }
            return fDSStringRenderer.toString();
        }
        return "";
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    private void sortManagers(Serialized serialized) {
        ArrayList<Composite> arrayList = new ArrayList<Composite>(Hierarchy.flatten(PyroMod.getMembers(serialized, true), Composite.class));
        for (Composite composite : arrayList) {
            Class clazz = composite.getType();
            if (clazz.isAssignableFrom(FDSObject.class) || clazz.isAssignableFrom(Grid.class) || !INamed.class.isAssignableFrom(clazz)) continue;
            List<IPyroObject> list = pyrosim.util.Util.sort(composite.getMembers());
            composite.reorder(list);
        }
    }

    private static void disconnectControls(Collection<? extends ISignalSink> collection, Map<IOutPin, List<IInPin>> map) {
        for (ISignalSink iSignalSink : collection) {
            for (IOutPin iOutPin : iSignalSink.getInputPin().getConnections()) {
                List<IInPin> list = map.get(iOutPin);
                if (list == null) {
                    list = new ArrayList<IInPin>(1);
                    map.put(iOutPin, list);
                }
                list.add(iSignalSink.getInputPin());
            }
            iSignalSink.getInputPin().disconnectAll();
        }
    }

    private void fixSurfRefs(Serialized serialized) {
        ArrayList<INamed> arrayList = new ArrayList<INamed>();
        int n = 0;
        for (FDSObject fDSObject : ((APyroObject)serialized.obstructions).flatten(FDSObject.class)) {
            Object object;
            INamed iNamed;
            if (fDSObject instanceof IObstruction) {
                int n2 = 0;
                iNamed = (IObstruction)fDSObject;
                object = iNamed.getSurfaces();
                for (int i = 0; i < ((Surface[])object).length; ++i) {
                    Surface surface = object[i];
                    Surface surface2 = (Surface)serialized.surfmgr.get(surface.getName());
                    if (surface2 == null) {
                        serialized.surfmgr.add(surface);
                        arrayList.add(surface);
                        continue;
                    }
                    if (surface == surface2) continue;
                    object[i] = surface2;
                    ++n2;
                }
                if (n2 > 0) {
                    iNamed.setSurfaces((Surface[])object);
                }
                n += n2;
                continue;
            }
            if (!(fDSObject instanceof pyrosim.domain.geom.Vent)) continue;
            pyrosim.domain.geom.Vent vent = (pyrosim.domain.geom.Vent)fDSObject;
            iNamed = vent.getSurface();
            object = (Surface)serialized.surfmgr.get(((NamedPyroObject)iNamed).getName());
            if (object == null) {
                serialized.surfmgr.add(iNamed);
                arrayList.add(iNamed);
                continue;
            }
            if (iNamed == object) continue;
            vent.setSurface((Surface)object);
            ++n;
        }
        if (n > 0) {
            System.err.println("Fixed " + n + " invalid surface references.");
        }
        if (!arrayList.isEmpty()) {
            Object object = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i > 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + ((Surface)arrayList.get(i)).getName();
            }
            String string = String.format(Intl.intl("Found %d surface(s) missing from the model: %s"), arrayList.size(), object);
            String string2 = Intl.intl("Added extra surfaces to the model.");
            this.d_warnings.addWarning(new Warning(string, string2));
        }
    }

    public static void fixMissingJets(Serialized serialized, WarningReport warningReport) {
        for (SprayModel sprayModel : serialized.sprayModels.flatten()) {
            if (!sprayModel.getJets().isEmpty()) continue;
            String string = String.format(Intl.intl("Invalid spray model \"%s\". Jet stream data missing."), sprayModel.getName());
            String string2 = Intl.intl("Default jet stream data added.");
            warningReport.addWarning(new Warning(string, string2));
            sprayModel.setJets(Arrays.asList(new SprayModel.Jet()));
        }
    }

    private void fixPre82FanCurves(Serialized serialized) {
        PyroSimObjectInputStream.fixPre82FanCurves(serialized, this.d_warnings);
    }

    public static void fixPre82FanCurves(Serialized serialized, WarningReport warningReport) {
        for (IHvacObject iHvacObject : serialized.hvacSystem.flatten()) {
            ArrayList<Ramp.Entry> arrayList;
            HvacFan hvacFan;
            if (!(iHvacObject instanceof HvacFan) || !(hvacFan = (HvacFan)iHvacObject).getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_PRESDROP)) continue;
            Variant variant = hvacFan.getPressureFlow();
            Ramp ramp = (Ramp)variant.val;
            if (ramp.getTUnitType() == 39) {
                arrayList = new ArrayList(ramp.getRecords().size());
                for (Ramp.Entry entry : ramp.getRecords()) {
                    arrayList.add(new Ramp.Entry(entry.f, entry.t));
                }
                hvacFan.setPressureFlow(Variant.ramp(new Ramp(arrayList, RampInputs.FLOW, RampInputs.FLOW, 39)));
                warningReport.addWarning(new Warning(Intl.intl("HVAC fans previously reversed values for fan curve tables."), Intl.intl(String.format("Fan curve entries for fan %s have been reversed.", hvacFan.getName()))));
                continue;
            }
            arrayList = Variant.constant(new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)));
            hvacFan.setPressureFlow((Variant)((Object)arrayList));
            warningReport.addWarning(new Warning(Intl.intl("HVAC fans cannot be controlled by signal inputs."), Intl.intl(String.format("Volume Flow Rate set to 0.0 for fan %s", hvacFan.getName()))));
        }
    }

    private void fixPre83CableFailDetector(Serialized serialized, WarningReport warningReport) {
        for (IDevice iDevice : serialized.devices.flatten()) {
            if (!(iDevice instanceof CableFailDetector)) continue;
            warningReport.addWarning(new Warning(Intl.intl("Cable failure detectors are no longer supported by FDS. "), Intl.intl(String.format("Device %s is removed. Please check section 15.3.8 of FDS version 6 user's guide.", ((CableFailDetector)iDevice).getName()))));
        }
        for (IDevice iDevice : serialized.devices.flatten()) {
            if (!(iDevice instanceof CableFailDetector)) continue;
            serialized.devices.remove(iDevice);
        }
    }

    public static void fixPre84Evac(Serialized serialized, WarningReport warningReport) {
        Cloneable cloneable;
        NamedPyroObject namedPyroObject;
        Pair<String, String> pair;
        Object object;
        Pair<String, String> pair2;
        Pair<String, String> pair3;
        Object object2;
        Object object3;
        Cloneable cloneable222;
        Object object4;
        boolean bl = serialized.enableFdsEvac;
        if (!bl) {
            if (!(serialized.perss.isEmpty() && serialized.exits.isEmpty() && serialized.evacs.isEmpty() && serialized.entrs.isEmpty() && serialized.evhos.isEmpty() && serialized.corrs.isEmpty() && serialized.evsss.isEmpty() && serialized.doors.isEmpty())) {
                warningReport.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), Intl.intl("Unreferenced evacuation data will be removed from the model.")));
            }
            return;
        }
        boolean bl2 = false;
        if (!serialized.perss.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new PersRenderer(serialized.perss);
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.perss.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        if (!serialized.exits.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new ExitRenderer();
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.exits.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        if (!serialized.evacs.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new EvacRenderer();
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.evacs.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        if (!serialized.entrs.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new EntrRenderer();
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.entrs.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        if (!serialized.evhos.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new EvhoRenderer();
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.evhos.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        if (!serialized.corrs.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new CorrRenderer();
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.corrs.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        if (!serialized.evsss.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new EvssRenderer();
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.evsss.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        if (!serialized.doors.isEmpty()) {
            object4 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
            cloneable222 = new FDSStringRenderer((FDSRenderProps)object4);
            object3 = new DoorRenderer();
            ((AFDS6Renderer)object3).render((IFDSRecordRenderer)((Object)cloneable222), serialized.doors.flatten());
            serialized.unprocessedRecords = serialized.unprocessedRecords + ((FDSStringRenderer)((Object)cloneable222)).toString();
            bl2 = true;
        }
        serialized.perss.clear();
        serialized.exits.clear();
        serialized.evacs.clear();
        serialized.entrs.clear();
        serialized.evhos.clear();
        serialized.corrs.clear();
        serialized.evsss.clear();
        serialized.doors.clear();
        if (bl2) {
            warningReport.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), Intl.intl("Evacuation namelists moved to the additional records section.")));
        }
        for (Cloneable cloneable222 : serialized.grids.flatten()) {
            boolean bl3 = false;
            object2 = new HashMap<String, String>();
            if (((Grid)cloneable222).getEvacuation()) {
                object2.put("EVACUATION", ".TRUE.");
                ((Grid)cloneable222).setEvacuation(false);
                bl3 = true;
            }
            if (((Grid)cloneable222).getEvacHumans()) {
                object2.put("EVAC_HUMANS", ".TRUE.");
                ((Grid)cloneable222).setEvacHumans(false);
                bl3 = true;
            }
            if (((Grid)cloneable222).getEvacHumans() || ((Grid)cloneable222).getEvacuation()) {
                FDSRenderProps fDSRenderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
                pair3 = FDS6Const.getRecordSpecs().get("MESH");
                pair2 = ((FDSRecordSpec)((Object)pair3)).renderField(fDSRenderProps, "EVAC_Z_OFFSET", ((Grid)cloneable222).getEvacZOffset());
                object2.put(pair2.v1, pair2.v2);
                ((Grid)cloneable222).setEvacZOffset(new UnitDouble(1.0, SI.METER));
            }
            if (!bl3) continue;
            cloneable222.setCustomFDSProps(CustomFDSProps.union(cloneable222.getCustomFDSProps(), CustomFDSProps.get((Map<String, String>)object2)));
            warningReport.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), String.format(Intl.intl("Evacuation parameters for mesh %s moved to Advanced Parameters."), ((NamedPyroObject)cloneable222).getName())));
        }
        for (Cloneable cloneable222 : serialized.obstructions.flatten()) {
            if (!(cloneable222 instanceof FDSObject)) continue;
            object3 = (FDSObject)cloneable222;
            object2 = object3.getEvac();
            boolean bl4 = false;
            pair3 = new HashMap();
            if (((EvacProps)object2).evacuation == 2) {
                pair3.put("EVACUATION", ".TRUE.");
                bl4 = true;
            }
            if (((EvacProps)object2).mesh != null) {
                bl4 = true;
                pair2 = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
                object = FDS6Const.getRecordSpecs().get("OBST");
                pair = ((FDSRecordSpec)object).renderField((FDSRenderProps)((Object)pair2), "MESH_ID", ((EvacProps)object2).mesh.getName());
                pair3.put(pair.v1, pair.v2);
            }
            if (bl4) {
                object3.setCustomFDSProps(CustomFDSProps.union(object3.getCustomFDSProps(), CustomFDSProps.get((Map<String, String>)((Object)pair3))));
                warningReport.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), String.format(Intl.intl("Evacuation parameters for mesh %s moved to Advanced Parameters."), cloneable222.getName())));
            }
            object3.setEvac(EvacProps.DEFAULT);
        }
        object4 = new HashMap();
        cloneable222 = new HashMap<String, String>();
        object3 = FDS6Const.getRecordSpecs().get("MISC");
        object2 = FDS6Const.getRecordSpecs().get("TIME");
        FDSRenderProps fDSRenderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
        pair3 = ((FDSRecordSpec)object3).renderField(fDSRenderProps, "EVACUATION_MC_MODE", serialized.simParams.getMisc().getEvacProp("EVACUATION_MC_MODE"));
        object4.put(pair3.v1, pair3.v2);
        pair2 = ((FDSRecordSpec)object3).renderField(fDSRenderProps, "EVAC_PRESSURE_ITERATIONS", serialized.simParams.getMisc().getEvacProp("PRESSURE_ITERATIONS"));
        object4.put(pair2.v1, pair2.v2);
        object = ((FDSRecordSpec)object3).renderField(fDSRenderProps, "EVAC_TIME_ITERATIONS", serialized.simParams.getMisc().getEvacProp("TIME_ITERATIONS"));
        object4.put(((Pair)object).v1, ((Pair)object).v2);
        pair = ((FDSRecordSpec)object2).renderField(fDSRenderProps, "EVAC_DT_STEADY_STATE", serialized.simParams.getTime().getEvacProp("EVAC_DT_STEADY_STATE"));
        cloneable222.put((String)pair.v1, (String)pair.v2);
        Pair<String, String> pair4 = ((FDSRecordSpec)object2).renderField(fDSRenderProps, "EVAC_DT_FLOWFIELD", serialized.simParams.getTime().getEvacProp("EVAC_DT_FLOWFIELD"));
        cloneable222.put((String)pair4.v1, (String)pair4.v2);
        serialized.simParams.setCustomFDSProps("MISC", CustomFDSProps.union(serialized.simParams.getCustomFDSProps("MISC"), CustomFDSProps.get((Map<String, String>)object4)));
        serialized.simParams.setCustomFDSProps("TIME", CustomFDSProps.union(serialized.simParams.getCustomFDSProps("TIME"), CustomFDSProps.get(cloneable222)));
        Object object5 = serialized.simParams.getMisc().getEvacProp("EVAC_SURF_DEFAULT");
        if (object5 != null) {
            namedPyroObject = (Surface)object5;
            cloneable = new HashMap<String, String>();
            cloneable.put("EVAC_SURF_DEFAULT", ".TRUE.");
            namedPyroObject.setCustomFDSProps(CustomFDSProps.union(namedPyroObject.getCustomFDSProps(), CustomFDSProps.get(cloneable)));
        }
        serialized.simParams.getMisc().initEvacProps(serialized.surfmgr);
        serialized.simParams.getTime().setEvacProps(SimParams.Time.initEvacProps());
        namedPyroObject = serialized.simParams.getPersGlobals();
        cloneable = new Pers(namedPyroObject.getName());
        if (!(!bl || Pers.diff(PersRenderer.GLOBAL_PROPS, (Pers)namedPyroObject, cloneable).isEmpty() && Pers.diff(PersRenderer.GLOBAL_PROPS_SPECIAL, (Pers)namedPyroObject, cloneable).isEmpty())) {
            SingletonRecords singletonRecords = new SingletonRecords();
            singletonRecords.persRec.setValue("ID", namedPyroObject.getName());
            for (String object62 : PersRenderer.GLOBAL_PROPS) {
                singletonRecords.persRec.setValue(object62, ((Pers)namedPyroObject).getProp(object62), false);
            }
            FDSRenderRecord fDSRenderRecord = singletonRecords.persRec;
            FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(fDSRenderProps);
            fDSStringRenderer.render(fDSRenderRecord, null);
            serialized.unprocessedRecords = serialized.unprocessedRecords + fDSStringRenderer.toString();
        }
        serialized.simParams.clearPers();
        warningReport.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), Intl.intl("Evacuation parameters for TIME and MISC namelists moved Simulation Parameters - Advanced.")));
    }

    public static void fds_6_3_update(Serialized serialized, WarningReport warningReport) {
        ArrayList<APyroObject> arrayList2;
        boolean bl = false;
        for (Grid grid : serialized.grids.flatten()) {
            if (grid.syncTimeStep()) continue;
            bl = true;
            break;
        }
        if (bl) {
            warningReport.addWarning(new Warning(Intl.intl("As of FDS 6.3, SYNCHRONIZATION is no longer defined."), Intl.intl("Removing variable Synchronize Meshes from affected Meshes.")));
        }
        Object object = null;
        double d = serialized.simParams.getRadiTransport().getRadiativeLossFraction();
        if (d != 0.35) {
            object = SIUS.newud(d, 28);
            String string = !serialized.reactions.isEmpty() ? Intl.intl("Radiative Loss Fraction applied to all Reactions.") : Intl.intl("Radiative Loss Fraction removed from Simulation Parameters.");
            warningReport.addWarning(new Warning(Intl.intl("FDS variable RADIATIVE_FRACTION moved from &RADI to &REAC namelist."), string));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (ArrayList<APyroObject> arrayList2 : serialized.reactions.flatten()) {
            ((Reaction)((Object)arrayList2)).setRadiativeFraction((UnitDouble)object);
            if (!((Reaction)((Object)arrayList2)).getHrrpuaSheet().equals(new UnitDouble(200.0, SI.KILO(SI.WATT).divide(SI.METER.pow(2))))) {
                bl2 = true;
            }
            if (((Reaction)((Object)arrayList2)).getHrrpuvAvg().equals(new UnitDouble(2500.0, SI.KILO(SI.WATT).divide(SI.METER.pow(3))))) continue;
            bl3 = true;
        }
        if (bl2) {
            warningReport.addWarning(new Warning(Intl.intl("FDS variable HRRPUA_SHEET dropped from &REAC namelist."), Intl.intl("Maximum heat release rate per unit area removed from Reactions.")));
        }
        if (bl3) {
            warningReport.addWarning(new Warning(Intl.intl("FDS variable HRRPUV_AVERAGE dropped from &REAC namelist."), Intl.intl("Maximum heat release rate per unit volume removed from Reactions.")));
        }
        ArrayList arrayList3 = new ArrayList(serialized.devices.flatten().size());
        for (Object object2 : serialized.devices.flatten()) {
            APyroObject aPyroObject;
            if (object2 instanceof GaugeHeatFluxMeasurer) {
                ((GaugeHeatFluxMeasurer)object2).setGaugeEmissivity(0.9);
                continue;
            }
            if (!(object2 instanceof GasPointMeasurer) || !((AMeasuringDevc)(aPyroObject = (GasPointMeasurer)object2)).getQuantity().get().equals((Object)Quantity.TURBULENCE_RESOLUTION)) continue;
            warningReport.addWarning(new Warning(Intl.intl("Quantity TURBULENCE RESOLUTION is no longer supported by FDS."), String.format(Intl.intl("Solid-phase device %s removed from model."), object2.getName())));
            arrayList3.add(object2);
        }
        serialized.devices.removeAll(arrayList3);
        arrayList2 = new ArrayList<APyroObject>(serialized.devices.flatten().size());
        for (APyroObject aPyroObject : serialized.slices.flatten()) {
            if (!((Slice)aPyroObject).getQuantity().get().equals((Object)Quantity.TURBULENCE_RESOLUTION)) continue;
            arrayList2.add(aPyroObject);
        }
        if (!arrayList2.isEmpty()) {
            warningReport.addWarning(new Warning(Intl.intl("Quantity TURBULENCE RESOLUTION is no longer supported by FDS."), Intl.intl("TURBULENCE RESOLUTION slices removed from model.")));
            serialized.slices.removeAll(arrayList2);
        }
    }

    public static void manuallyConvertPre86AtmGradUnits(Serialized serialized, WarningReport warningReport) {
        UnitDouble unitDouble = serialized.simParams.getWind().get(SimParams.Wind.LAPSE_RATE);
        UnitDouble unitDouble2 = unitDouble.convert(SIUS.unit(5));
        serialized.simParams.getWind().setNoCheck(SimParams.Wind.LAPSE_RATE, unitDouble2);
    }

    public static boolean generatePre87Elements(Serialized serialized, WarningReport warningReport) {
        ArrayList<IModelObj> arrayList = new ArrayList<IModelObj>();
        arrayList.addAll(((APyroObject)serialized.obstructions).flatten(IObstruction.class));
        arrayList.addAll(((APyroObject)serialized.obstructions).flatten(IHole.class));
        arrayList.addAll(((APyroObject)serialized.obstructions).flatten(GenericGeomSrc.class));
        if (arrayList.isEmpty()) {
            return false;
        }
        System.out.println("Generating creases for legacy objects...");
        theTimer theTimer2 = new theTimer();
        boolean bl = false;
        LinkedHashMap<IGeom, IElemSource> linkedHashMap = new LinkedHashMap<IGeom, IElemSource>();
        for (IPyroGeomSrc iPyroGeomSrc : arrayList) {
            IGeomNode iGeomNode;
            Object object;
            IGeomNode iGeomNode2 = iPyroGeomSrc.getGeom();
            IPropsSrc iPropsSrc = iPyroGeomSrc instanceof GenericGeomSrc ? ((GenericGeomSrc)iPyroGeomSrc).getDisplayProps() : (iPyroGeomSrc instanceof IObstruction ? (((Surface[])(object = ((IObstruction)iPyroGeomSrc).getSurfaces())).length == 1 ? new UniformProps(new IPrimProps.Face(Color.WHITE, object[0], 0)) : new FlattenedProps(theUtil.toArray(theUtil.map(Arrays.asList(object), surface -> new IPrimProps.Face(Color.WHITE, (IMaterial)surface, 0)), IPrimProps.class))) : new UniformProps(new IPrimProps.Face(Color.WHITE, null, 0)));
            if (iGeomNode2.getLocalGeom() != EmptyGeom.INSTANCE && iGeomNode2.isLeaf()) {
                object = linkedHashMap.computeIfAbsent(iGeomNode2.getLocalGeom(), iGeom -> Elements.generateCreasesFromFacets(iGeom, iPropsSrc, (IElemSource)((Object)iGeomNode2.getLocalElements().get(Elements.ORIENT))));
            } else {
                iGeomNode = iGeomNode2.flatten(2);
                object = Elements.generateCreasesFromFacets(iGeomNode.getLocalGeom(), iPropsSrc, (IElemSource)((Object)iGeomNode.getLocalElements().get(Elements.ORIENT)));
            }
            if (object == Elements.ALL_CREASE) continue;
            iGeomNode = iGeomNode2.applyElements(Elements.CREASE, (arg_0, arg_1) -> PyroSimObjectInputStream.lambda$generatePre87Elements$37((IElemSource)object, arg_0, arg_1));
            bl |= iGeomNode != iGeomNode2;
            iPyroGeomSrc.setGeom(iGeomNode);
        }
        System.out.printf("Creases complete (%g s)%n", theTimer2.curr());
        return bl;
    }

    private boolean reorganizePre88UV(Serialized serialized) {
        boolean bl = true;
        Collection<ISurfObj> collection = ((APyroObject)serialized.obstructions).flatten(ISurfObj.class);
        if (collection.isEmpty()) {
            return false;
        }
        IdentityHashMap<IPropertySet, IPropertySet> identityHashMap = new IdentityHashMap<IPropertySet, IPropertySet>();
        for (ISurfObj iSurfObj : collection) {
            IGeomNode iGeomNode = iSurfObj.getGeom();
            IGeomNode iGeomNode2 = PyroSimObjectInputStream.reorganizePre88NodeUV(iGeomNode, identityHashMap);
            bl |= iGeomNode2 != iGeomNode;
            iSurfObj.setGeom(iGeomNode2);
        }
        return bl;
    }

    private static IGeomNode reorganizePre88NodeUV(IGeomNode iGeomNode, Map<IPropertySet, IPropertySet> map) {
        IPropertySet iPropertySet2;
        IPropertySet iPropertySet3 = iGeomNode.getLocalElements();
        if (iPropertySet3 == (iPropertySet2 = map.computeIfAbsent(iPropertySet3, iPropertySet -> Elements.fixLegacy(iPropertySet))) && iGeomNode.getChildren().isEmpty()) {
            return iGeomNode;
        }
        iPropertySet3 = iPropertySet2;
        Collection<? extends IGeomNode> collection = iGeomNode.getChildren();
        ArrayList<? extends IGeomNode> arrayList = null;
        int n = 0;
        for (IGeomNode iGeomNode2 : collection) {
            IGeomNode iGeomNode3 = PyroSimObjectInputStream.reorganizePre88NodeUV(iGeomNode2, map);
            if (iGeomNode3 != iGeomNode2) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IGeomNode>(iGeomNode.getChildren());
                }
                arrayList.set(n, iGeomNode3);
            }
            ++n;
        }
        if (arrayList != null) {
            collection = arrayList;
        }
        return GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), iGeomNode.getLocalGeom(), iPropertySet3, collection);
    }

    private void fixPre89ImportedSurfs(Serialized serialized) {
        for (Surface surface : serialized.surfmgr.flatten()) {
            if (!PyroSimObjectInputStream.isBadSurfCombo(surface, SurfDescStatic.Adiabatic.class) && !PyroSimObjectInputStream.isBadSurfCombo(surface, SurfDescStatic.Hvac.class) && !PyroSimObjectInputStream.isBadSurfCombo(surface, SurfDescStatic.Mirror.class) && !PyroSimObjectInputStream.isBadSurfCombo(surface, SurfDescStatic.Open.class) && !PyroSimObjectInputStream.isBadSurfCombo(surface, SurfDescStatic.Periodic.class)) continue;
            String string = String.format(Intl.intl("Surface was created with an invalid surface type"), new Object[0]);
            String string2 = String.format(Intl.intl("Changed surface type on \"%1$s\" from \"%2$s\" to \"Basic\""), surface.getName(), ((SurfDescStatic)surface.getSurfDesc()).getPredefType().name());
            this.d_warnings.addWarning(new Warning(string, string2));
            surface.setSurfDesc(Surface.newBasicDesc());
        }
    }

    private static boolean isBadSurfCombo(Surface surface, Class<? extends SurfDescStatic> clazz) {
        ISurfDesc iSurfDesc = surface.getSurfDesc();
        return clazz.isInstance(iSurfDesc) && !surface.isPredefined(clazz.cast(iSurfDesc).getPredefType());
    }

    private void fixPre89BadObstSurfs(Serialized serialized) {
        Surface surface = serialized.surfmgr.get(PredefSurf.INERT);
        assert (surface != null);
        for (IObstruction iObstruction : ((APyroObject)serialized.obstructions).flatten(IObstruction.class)) {
            Object object;
            Surface[] surfaceArray;
            Predicate<Surface> predicate = iObstruction.getSurfFilter();
            Surface[] surfaceArray2 = surfaceArray = iObstruction.getSurfaces();
            for (int i = 0; i < surfaceArray.length; ++i) {
                object = surfaceArray[i];
                if (predicate.test((Surface)object)) continue;
                if (surfaceArray2 == surfaceArray) {
                    surfaceArray2 = Arrays.copyOf(surfaceArray, surfaceArray.length);
                }
                surfaceArray2[i] = surface;
            }
            if (surfaceArray2 == surfaceArray) continue;
            iObstruction.setSurfaces(surfaceArray2);
            String string = Intl.intl("Invalid surface assigned to obstruction.");
            object = String.format(Intl.intl("Obstruction \"%s\": Faces assigned to MIRROR, OPEN, PERIODIC, or HVAC switched to INERT"), iObstruction.getName());
            this.d_warnings.addWarning(new Warning(string, (String)object));
        }
    }

    public static void warnPre91SingleSprkDryPipe(Serialized serialized, WarningReport<Warning> warningReport) {
        LinkedIdentityHashMap<DryPipe, List> linkedIdentityHashMap = new LinkedIdentityHashMap<DryPipe, List>();
        for (Sprinkler sprinkler : ((APyroObject)serialized.devices).flatten(Sprinkler.class)) {
            DryPipe dryPipe2 = sprinkler.getDryPipe();
            if (dryPipe2 == null) continue;
            linkedIdentityHashMap.computeIfAbsent(dryPipe2, dryPipe -> new ArrayList()).add(sprinkler);
        }
        linkedIdentityHashMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() == 1).forEach(entry -> {
            String string = Intl.intl("Behavior has changed for a single sprinkler attached to a dry pipe.");
            String string2 = String.format(Intl.intl("%s: Nozzle will now activate after the dry pipe delay rather than immediately."), ((Sprinkler)((List)entry.getValue()).get(0)).getName());
            warningReport.addWarning(new Warning(string, string2));
        });
    }

    public static void warnPre92HvacCtrls(Serialized serialized, WarningReport<Warning> warningReport) {
        Collection<IModelObj> collection = serialized.obstructions.flatten(iModelObj -> iModelObj instanceof HvacDuct);
        for (IHvacObject iHvacObject : serialized.hvacSystem.flatten()) {
            HvacDuct hvacDuct;
            boolean bl;
            Set<ISignalSource> set;
            IInPin iInPin;
            HvacComponent hvacComponent;
            if (iHvacObject instanceof HvacAircoil) {
                hvacComponent = (HvacAircoil)iHvacObject;
                iInPin = ((HvacAircoil)hvacComponent).getInputPin();
                set = iInPin.getConnectedSources();
                if (set.isEmpty()) continue;
                bl = false;
                for (IModelObj iModelObj2 : collection) {
                    hvacDuct = (HvacDuct)iModelObj2;
                    if (!theUtil.equal(hvacDuct.getProp("AIRCOIL_ID"), hvacComponent) || !hvacDuct.getInputPin().getConnectedSources().isEmpty()) continue;
                    for (IOutPin iOutPin : iInPin.getConnections()) {
                        hvacDuct.getInputPin().connect(iOutPin);
                    }
                    warningReport.addWarning(new Warning(Intl.intl("Aircoils can no longer be automated by a Control."), String.format(Intl.intl("Controls for Aircoil %s have been moved to HVAC Duct %s"), hvacComponent.getName(), hvacDuct.getName())));
                    iInPin.disconnectAll();
                    bl = true;
                }
                if (bl) continue;
                warningReport.addWarning(new Warning("Aircoils can no longer be automated by a Control.", String.format("Aircoil %s is no longer managed by a control.", hvacComponent.getName())));
                iInPin.disconnectAll();
                continue;
            }
            if (!(iHvacObject instanceof HvacFan) || (set = (iInPin = ((HvacFan)(hvacComponent = (HvacFan)iHvacObject)).getInputPin()).getConnectedSources()).isEmpty()) continue;
            bl = false;
            for (IModelObj iModelObj2 : collection) {
                hvacDuct = (HvacDuct)iModelObj2;
                if (!theUtil.equal(hvacDuct.getProp("FAN_ID"), hvacComponent) || !hvacDuct.getInputPin().getConnections().isEmpty()) continue;
                for (IOutPin iOutPin : iInPin.getConnections()) {
                    hvacDuct.getInputPin().connect(iOutPin);
                }
                warningReport.addWarning(new Warning(Intl.intl("Fans can no longer be automated by a Control."), String.format(Intl.intl("Controls for Fan %s have been moved to HVAC Duct %s"), hvacComponent.getName(), hvacDuct.getName())));
                iInPin.disconnectAll();
                bl = true;
            }
            if (bl) continue;
            warningReport.addWarning(new Warning(Intl.intl("Fans can  no longer be automated by a Control."), String.format(Intl.intl("Fan %s is no longer managed by a control."), hvacComponent.getName())));
            iInPin.disconnectAll();
        }
    }

    public static void warnPre94OutflowSurfs(Serialized serialized, WarningReport warningReport) {
        for (Surface surface : serialized.surfmgr.flatten()) {
            AirFlow airFlow;
            Serializable serializable;
            AirFlow.Rate rate;
            ISurfDesc iSurfDesc;
            if (surface.getSurfDesc() instanceof InFlowSurfDesc) {
                iSurfDesc = (InFlowSurfDesc)surface.getSurfDesc();
                if (iSurfDesc.d_airFlow.d_rate instanceof AirFlow.TotalMassFlux) {
                    rate = (AirFlow.TotalMassFlux)iSurfDesc.d_airFlow.d_rate;
                    if (rate.val.getValueNoUnit() < 0.0) {
                        warningReport.addWarning(new Warning(Intl.intl("Exhaust surfaces cannot specify a negative Total Mass Flux."), String.format(Intl.intl("Set Total Mass Flux for Surface %s to 0."), surface.getName())));
                        serializable = PyroSimObjectInputStream.fixPre94NegativeMassFlux(rate);
                        airFlow = new AirFlow((AirFlow.Rate)serializable, iSurfDesc.d_airFlow.d_profile);
                        surface.setSurfDesc(new InFlowSurfDesc(airFlow, iSurfDesc.d_temperature));
                    }
                }
                if (!(iSurfDesc.d_airFlow.d_rate instanceof AirFlow.ExSpecMassFlux) || iSurfDesc.d_airFlow.d_rate.func.equals(TimeFunction.newDefault())) continue;
                warningReport.addWarning(new Warning(Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), String.format(Intl.intl("Ramp Up Time dropped from surface %s."), surface.getName())));
                rate = new AirFlow.ExSpecMassFlux(iSurfDesc.d_airFlow.d_rate.tanVelU, iSurfDesc.d_airFlow.d_rate.tanVelV, TimeFunction.newDefault(), iSurfDesc.d_airFlow.d_rate.specInj);
                serializable = new AirFlow(rate, iSurfDesc.d_airFlow.d_profile);
                surface.setSurfDesc(new InFlowSurfDesc((AirFlow)serializable, iSurfDesc.d_temperature));
                continue;
            }
            if (surface.getSurfDesc() instanceof BlowerSurfDesc) {
                iSurfDesc = (BlowerSurfDesc)surface.getSurfDesc();
                if (((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate instanceof AirFlow.TotalMassFlux) {
                    warningReport.addWarning(new Warning(Intl.intl("Supply surfaces cannot specify Total Mass Flux."), String.format(Intl.intl("Converted airflow profile for Surface %s to Volume Flux."), surface.getName())));
                    rate = (AirFlow.TotalMassFlux)((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate;
                    serializable = new AirFlow.VolumeFlux(SIUS.newud(0.0, 24), rate.tanVelU, rate.tanVelV, rate.func, rate.specInj);
                    airFlow = new AirFlow((AirFlow.Rate)serializable, ((BlowerSurfDesc)iSurfDesc).d_airFlow.d_profile);
                    surface.setSurfDesc(new BlowerSurfDesc(((BlowerSurfDesc)iSurfDesc).d_tempReg, airFlow, ((BlowerSurfDesc)iSurfDesc).d_partInj, ((BlowerSurfDesc)iSurfDesc).d_geometry));
                }
                if (!(((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate instanceof AirFlow.ExSpecMassFlux) || ((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate.func.equals(TimeFunction.newDefault())) continue;
                warningReport.addWarning(new Warning(Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), String.format(Intl.intl("Ramp Up Time dropped from surface %s."), surface.getName())));
                rate = new AirFlow.ExSpecMassFlux(((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate.tanVelU, ((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate.tanVelV, TimeFunction.newDefault(), ((BlowerSurfDesc)iSurfDesc).d_airFlow.d_rate.specInj);
                serializable = new AirFlow(rate, ((BlowerSurfDesc)iSurfDesc).d_airFlow.d_profile);
                surface.setSurfDesc(new BlowerSurfDesc(((BlowerSurfDesc)iSurfDesc).d_tempReg, (AirFlow)serializable, ((BlowerSurfDesc)iSurfDesc).d_partInj, ((BlowerSurfDesc)iSurfDesc).d_geometry));
                continue;
            }
            if (!(surface.getSurfDesc() instanceof GeneralSurfDesc)) continue;
            iSurfDesc = (GeneralSurfDesc)surface.getSurfDesc();
            if (((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate instanceof AirFlow.TotalMassFlux) {
                rate = (AirFlow.TotalMassFlux)((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate;
                if (rate.val.getValueNoUnit() < 0.0) {
                    warningReport.addWarning(new Warning(Intl.intl("General surfaces cannot specify a negative Total Mass Flux."), String.format(Intl.intl("Set Total Mass Flux for Surface %s to 0."), surface.getName())));
                    serializable = PyroSimObjectInputStream.fixPre94NegativeMassFlux(rate);
                    airFlow = new AirFlow((AirFlow.Rate)serializable, ((GeneralSurfDesc)iSurfDesc).d_airflow.d_profile);
                    GeneralSurfDesc generalSurfDesc = new GeneralSurfDesc(((GeneralSurfDesc)iSurfDesc).d_tempReg, ((GeneralSurfDesc)iSurfDesc).d_partInj, ((GeneralSurfDesc)iSurfDesc).d_specInj, ((GeneralSurfDesc)iSurfDesc).d_heatRelease, airFlow, ((GeneralSurfDesc)iSurfDesc).d_geometry);
                    surface.setSurfDesc(generalSurfDesc);
                }
            }
            if (!(((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate instanceof AirFlow.ExSpecMassFlux) || ((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate.func.equals(TimeFunction.newDefault())) continue;
            warningReport.addWarning(new Warning(Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), String.format(Intl.intl("Ramp Up Time dropped from surface %s."), surface.getName())));
            rate = new AirFlow.ExSpecMassFlux(((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate.tanVelU, ((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate.tanVelV, TimeFunction.newDefault(), ((GeneralSurfDesc)iSurfDesc).d_airflow.d_rate.specInj);
            serializable = new AirFlow(rate, ((GeneralSurfDesc)iSurfDesc).d_airflow.d_profile);
            surface.setSurfDesc(new GeneralSurfDesc(((GeneralSurfDesc)iSurfDesc).d_tempReg, ((GeneralSurfDesc)iSurfDesc).d_partInj, ((GeneralSurfDesc)iSurfDesc).d_specInj, ((GeneralSurfDesc)iSurfDesc).d_heatRelease, (AirFlow)serializable, ((GeneralSurfDesc)iSurfDesc).d_geometry));
        }
    }

    private static AirFlow.TotalMassFlux fixPre94NegativeMassFlux(AirFlow.TotalMassFlux totalMassFlux) {
        return new AirFlow.TotalMassFlux(SIUS.newud(0.0, 45), totalMassFlux.tanVelU, totalMassFlux.tanVelV, totalMassFlux.func, totalMassFlux.specInj);
    }

    public static void fixPre95MultipleReacs(Serialized serialized, WarningReport warningReport) {
        ArrayList<Reaction> arrayList = new ArrayList<Reaction>();
        for (Object object : serialized.reactions.flatten()) {
            if (!((Reaction)object).isActive()) continue;
            arrayList.add((Reaction)object);
        }
        if (arrayList.size() > 1) {
            Reaction reaction = (Reaction)arrayList.iterator().next();
            warningReport.addWarning(new Warning(Intl.intl("Multiple active reactions detected."), String.format(Intl.intl("Reaction %s set as the only active reaction."), reaction.getName())));
            for (Reaction reaction2 : arrayList) {
                reaction2.setActive(false);
            }
            reaction.setActive(true);
        }
    }

    public static void bakePre99Transforms(Serialized serialized, WarningReport warningReport) {
        for (IPyroGeomSrc iPyroGeomSrc : serialized.obstructions.flatten()) {
            IGeomNode iGeomNode = iPyroGeomSrc.getGeom().bakeIfRecommended();
            iPyroGeomSrc.setGeom(iGeomNode);
        }
    }

    public static void udpateDefaultDTs3d(Serialized serialized, WarningReport warningReport) {
        SimParams.FileOutput fileOutput = serialized.simParams.getFileOutput();
        if (fileOutput.getDtSlice3dFiles() == null) {
            CustomFDSProps customFDSProps = serialized.simParams.getCustomFDSProps("DUMP");
            Map<String, String> map = customFDSProps.getProps();
            Double d = null;
            if (map.containsKey("DT_SL3D")) {
                try {
                    d = Double.valueOf(map.get("DT_SL3D"));
                    warningReport.addWarning(new Warning(Intl.intl("3D Slice output interval detected in Additional Fields."), Intl.intl("3D Slice output interval set moved to Simulation Parameters-Output.")));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    warningReport.addWarning(new Warning(Intl.intl("Unparseable value for 3D Slice output interval detected in Additional Fields."), Intl.intl("Default 3D Slice output interval of .25s set in Simulation Parameters-Output")));
                }
                HashMap<String, String> hashMap = new HashMap<String, String>(map);
                hashMap.remove("DT_SL3D");
                serialized.simParams.setCustomFDSProps("DUMP", CustomFDSProps.get(hashMap));
            }
            if (d == null) {
                d = 0.25;
            }
            fileOutput.setDtSlice3dFiles(new UnitDouble(d, SI.SECOND));
        }
    }

    public static void fixDanglingGridRefs(Serialized serialized, WarningReport warningReport) {
        for (IMeasurementStat iMeasurementStat : serialized.msrStats.flatten()) {
            Grid grid;
            if (!(iMeasurementStat.getMsrGeom() instanceof StatGeom.GridGeom) || serialized.grids.containsDeep(grid = ((StatGeom.GridGeom)iMeasurementStat.getMsrGeom()).grid)) continue;
            warningReport.addWarning(new Warning(Intl.intl(String.format("Invalid grid %s referenced by Statistics %s.", grid.getName(), iMeasurementStat.getName())), Intl.intl(String.format("Statistics %s converted to record a volume.", iMeasurementStat.getName()))));
            iMeasurementStat.setGeom(GeomNodeUtil.newNode(new AABoxGeom(grid.getBounds())));
        }
    }

    public static void purgeMutantDevices(Serialized serialized, WarningReport warningReport) {
        HashSet<IDevice> hashSet = new HashSet<IDevice>();
        for (IDevice iDevice : serialized.devices.flatten()) {
            IGeom iGeom = iDevice.getGeom().getLocalGeom();
            if (!(iGeom instanceof FreePointGeom)) continue;
            FreePointLoc freePointLoc = ((FreePointGeom)iGeom).loc;
            if (!(freePointLoc.d_geom instanceof LineSeg)) continue;
            hashSet.add(iDevice);
        }
        serialized.devices.removeAll(hashSet);
    }

    public static void fixPre106CyclicControls(Serialized serialized, WarningReport warningReport) {
        for (IDevice iDevice : serialized.devices.flatten()) {
            if (!(iDevice instanceof ISignalSink) || !Util.isCycle((ISignalSink)((Object)iDevice))) continue;
            warningReport.addWarning(new Warning(String.format(Intl.intl("Device %s has a cyclic definition."), iDevice.getName()), String.format(Intl.intl("Device %s has been disconnected from input controls."), iDevice.getName())));
            ((ISignalSink)((Object)iDevice)).getInputPin().disconnectAll();
        }
    }

    public static void fixPre107SurfDepDevcs(Serialized serialized, WarningReport warningReport) {
        HashMap<GasPointMeasurer, Point> hashMap = new HashMap<GasPointMeasurer, Point>();
        for (Object object : serialized.devices.flatten()) {
            Serializable serializable;
            Object object2;
            if (!(object instanceof AMeasuringDevc) || !((AMeasuringDevc)(object2 = (AMeasuringDevc)object)).getQuantity().get().equals((Object)Quantity.SPEC_SURFACE_DEPOSITION) || !(object2 instanceof GasPointMeasurer)) continue;
            GasPointMeasurer object3 = (GasPointMeasurer)object2;
            FreePointLoc freePointLoc = object3.getLocation();
            UnitPoint3D unitPoint3D = new UnitPoint3D(0.0, 0.0, 0.0, Geometry.LU);
            if (freePointLoc.d_geom instanceof Point) {
                serializable = (Point)freePointLoc.d_geom;
                unitPoint3D = new UnitPoint3D(serializable.loc, Geometry.LU);
            }
            serializable = new SolidPointMeasurer(object3.getName(), object3.getQuantity(), new AttachedPointLoc(unitPoint3D, freePointLoc.d_orientation, freePointLoc.d_rotation));
            hashMap.put(object3, (Point)serializable);
        }
        if (!hashMap.isEmpty()) {
            Object object;
            PyroMod pyroMod = new PyroMod(serialized, false, false);
            object = pyroMod.getDependencies(new IPyroObject[0]);
            serialized.devices.addAll(hashMap.values());
            for (Map.Entry entry : hashMap.entrySet()) {
                PyroSimObjectInputStream.replaceRefs((DepSnapshot)object, (IPyroObject)entry.getKey(), (IPyroObject)entry.getValue());
            }
            serialized.devices.removeAll(hashMap.keySet());
        }
    }

    private static int checkHvac(AHvacGeomComponent aHvacGeomComponent, String string, Serialized serialized, List<IHvacObject> list, List<IHvacObject> list2, Set<String> set, int n) {
        Object object = aHvacGeomComponent.getProp(string);
        if (object != null && object instanceof IHvacObject) {
            IHvacObject iHvacObject = (IHvacObject)object;
            IHvacObject iHvacObject2 = (IHvacObject)serialized.hvacSystem.get(iHvacObject.getName());
            if (iHvacObject2 == null) {
                serialized.hvacSystem.add(iHvacObject);
                list.add(iHvacObject);
            } else if (iHvacObject != iHvacObject2 && iHvacObject2.equals(iHvacObject)) {
                aHvacGeomComponent.setProp(string, iHvacObject2);
                ++n;
            } else if (iHvacObject != iHvacObject2) {
                NameGenerator nameGenerator = null;
                switch (string) {
                    case "AIRCOIL_ID": {
                        nameGenerator = serialized.hvacAircoilNames;
                        break;
                    }
                    case "FAN_ID": {
                        nameGenerator = serialized.hvacFanNames;
                        break;
                    }
                    case "FILTER_ID": {
                        nameGenerator = serialized.hvacFilterNames;
                    }
                }
                assert (nameGenerator != null);
                Object object2 = nameGenerator.generateValidNames(1, iHvacObject.getName(), Predicates.alwaysFalse(), Filters.reject(set));
                String string2 = (String)object2.get(0);
                iHvacObject.setName(string2);
                set.add(string2);
                serialized.hvacSystem.add(iHvacObject);
                list2.add(iHvacObject);
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static void fixPre111HvacRefs(Serialized serialized, WarningReport warningReport) {
        String string;
        Object object;
        new PyroMod(serialized, false, false);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<IHvacObject> arrayList = new ArrayList<IHvacObject>();
        ArrayList<IHvacObject> arrayList2 = new ArrayList<IHvacObject>();
        Integer n = 0;
        for (HvacNode object2 : ((APyroObject)serialized.obstructions).flatten(HvacNode.class)) {
            n = PyroSimObjectInputStream.checkHvac(object2, "FILTER_ID", serialized, arrayList, arrayList2, hashSet, n);
        }
        for (HvacDuct i : ((APyroObject)serialized.obstructions).flatten(HvacDuct.class)) {
            n = PyroSimObjectInputStream.checkHvac(i, "AIRCOIL_ID", serialized, arrayList, arrayList2, hashSet, n);
            n = PyroSimObjectInputStream.checkHvac(i, "FAN_ID", serialized, arrayList, arrayList2, hashSet, n);
        }
        if (n > 0) {
            System.err.println("Fixed " + n + " invalid HVAC component(s) references.");
        }
        if (!arrayList.isEmpty()) {
            void var7_11;
            object = "";
            boolean string2 = false;
            while (var7_11 < arrayList.size()) {
                if (var7_11 > 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + ((IHvacObject)arrayList.get((int)var7_11)).getName();
                ++var7_11;
            }
            String string3 = String.format(Intl.intl("Found %d HVAC component(s) missing from the model: %s"), arrayList.size(), object);
            string = Intl.intl("Added extra HVAC component(s) to the model.");
            warningReport.addWarning(new Warning(string3, string));
        }
        if (!arrayList2.isEmpty()) {
            void var7_15;
            object = "";
            boolean bl = false;
            while (var7_15 < arrayList2.size()) {
                if (var7_15 > 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + ((IHvacObject)arrayList2.get((int)var7_15)).getName();
                ++var7_15;
            }
            String string4 = String.format(Intl.intl("Renamed %d HVAC component(s) that contains duplicated names in the model: %s"), arrayList2.size(), object);
            string = Intl.intl("Renamed HVAC component(s) in the model");
            warningReport.addWarning(new Warning(string4, string));
        }
        serialized.setDomain(null);
    }

    private static void fixPre112HvacDevices(Serialized serialized, WarningReport warningReport) {
        ArrayList<pyrosim.domain.devices.hvac.HvacDevice> arrayList = new ArrayList<pyrosim.domain.devices.hvac.HvacDevice>();
        for (pyrosim.domain.devices.hvac.HvacDevice hvacDevice : ((APyroObject)serialized.devices).flatten(pyrosim.domain.devices.hvac.HvacDevice.class)) {
            ObjectQuantity objectQuantity = (ObjectQuantity)hvacDevice.getQuantity();
            ArrayList<IHvacGeomComp> arrayList2 = new ArrayList<IHvacGeomComp>();
            ArrayList<IHvacGeomComp> arrayList3 = new ArrayList<IHvacGeomComp>();
            for (Object t : objectQuantity.objects) {
                if (!(t instanceof IHvacGeomComp)) continue;
                if (serialized.obstructions.containsDeep((IPyroObject)t)) {
                    arrayList2.add((IHvacGeomComp)t);
                    continue;
                }
                arrayList3.add((IHvacGeomComp)t);
            }
            if (arrayList2.isEmpty() && !arrayList3.isEmpty()) {
                warningReport.addWarning(new Warning(String.format(Intl.intl("The device %s contains references to HVAC components no longer defined in the model."), hvacDevice.getName()), Intl.intl("Deleting device.")));
                arrayList.add(hvacDevice);
                continue;
            }
            if (arrayList2.isEmpty() || arrayList3.isEmpty()) continue;
            warningReport.addWarning(new Warning(String.format(Intl.intl("The device %s contains references to HVAC components no longer defined in the model."), hvacDevice.getName()), Intl.intl("Removing references to missing components.")));
            ObjectQuantity objectQuantity2 = (ObjectQuantity)hvacDevice.getQuantity();
            ObjectQuantity objectQuantity3 = objectQuantity2.quantity.create((IPyroObject[])arrayList2.stream().toArray(IPyroObject[]::new));
            hvacDevice.setQuantity(objectQuantity3);
        }
        for (pyrosim.domain.devices.hvac.HvacDevice hvacDevice : arrayList) {
            serialized.devices.remove(hvacDevice);
        }
    }

    private static void fixPre114SprayAndSprinklerLinkModels(Serialized serialized, WarningReport warningReport) {
        serialized.sprayModels.addDefaults(serialized.particles);
        serialized.sprkLinkModels.addDefaults();
    }

    private static void warnPre116WindRecords(Serialized serialized, WarningReport warningReport) {
        warningReport.addWarning(new Warning("Intermediate WIND record invalid.", "WIND record replaced with new default."));
    }

    private static void fixPre117PredefLumped(Serialized serialized, WarningReport warningReport) {
        for (ExSpec exSpec : serialized.exSpecs.flatten()) {
            if (exSpec.getType() != 0 || !exSpec.getName().equals("AIR") && !exSpec.getName().equals("PRODUCTS")) continue;
            exSpec.setType(5);
        }
    }

    private static void updatePre119BackgroundSpecies(Serialized serialized, WarningReport warningReport) {
        for (ExSpec exSpec : serialized.exSpecs.flatten()) {
            exSpec.setIsBackgroundSpec(false);
        }
    }

    private static void updatePre120PredefSoot(Serialized serialized, WarningReport warningReport) {
        for (ExSpec exSpec : serialized.exSpecs.flatten()) {
            if (!exSpec.getName().equals(ExSpecList.Predefined.SOOT.getName()) || !exSpec.isPredefined()) continue;
            ExSpec exSpec2 = ExSpecList.Predefined.SOOT.spec;
            exSpec.setChemFormula(exSpec2.getChemFormula());
            exSpec.setMolecularWeight(exSpec2.getMolecularWeight());
        }
    }

    private static void updatePre121ProductsSpec(Serialized serialized, WarningReport warningReport) {
        for (ExSpec exSpec : serialized.exSpecs.flatten()) {
            if (!exSpec.getName().equals(ExSpecList.Predefined.PRODUCTS.getName()) || !exSpec.isPredefined()) continue;
            ExSpec exSpec2 = ExSpecList.Predefined.PRODUCTS.spec;
            exSpec.setChemFormula(exSpec2.getChemFormula());
            exSpec.setMolecularWeight(exSpec2.getMolecularWeight());
        }
    }

    public static void removePre122deprecatedQuants(Serialized serialized, WarningReport warningReport) {
        boolean bl;
        PyroMod pyroMod = new PyroMod(serialized, false, false);
        LinkedHashSet<StaticQuantity> linkedHashSet = new LinkedHashSet<StaticQuantity>();
        linkedHashSet.add(Quantity.AVERAGE_SPECIFIC_HEAT.create());
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        block0: for (IMeasurer iPyroObject : ((APyroObject)serialized.devices).flatten(IMeasurer.class)) {
            for (int i = 0; i < iPyroObject.getNumMeasurements(); ++i) {
                if (!linkedHashSet.contains(iPyroObject.getQuantity(i))) continue;
                arrayList.add(iPyroObject);
                continue block0;
            }
        }
        for (IMeasurementStat iMeasurementStat : serialized.msrStats.flatten()) {
            if (!linkedHashSet.contains(iMeasurementStat.getQuantity())) continue;
            arrayList.add(iMeasurementStat);
        }
        for (Slice slice : serialized.slices.flatten()) {
            if (!linkedHashSet.contains(slice.getQuantity())) continue;
            arrayList.add(slice);
        }
        for (Isosurface isosurface : serialized.isosurfaces.flatten()) {
            if (!linkedHashSet.contains(isosurface.getQuantity())) continue;
            arrayList.add(isosurface);
        }
        LinkedHashSet<IQuantity> linkedHashSet2 = new LinkedHashSet<IQuantity>(serialized.plot3d.getQuantities());
        if (linkedHashSet2.removeAll(linkedHashSet)) {
            serialized.plot3d.setQuantities((Collection<IQuantity>)linkedHashSet2);
        }
        boolean bl2 = bl = !arrayList.isEmpty();
        if (bl) {
            warningReport.addWarning(new Warning(Intl.intl("Quantity AVERAGE_SPECIFIC_HEAT is no longer supported."), Intl.intl("All references to AVERAGE_SPECIFIC_HEAT have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(pyroMod, pyroMod.getDependencies(new IPyroObject[0]), arrayList, warningReport);
        serialized.setDomain(null);
    }

    public static void warnPre125deprecatedField(Serialized serialized, WarningReport warningReport) {
        SimParams.Time time = serialized.simParams.getTime();
        UnitDouble unitDouble = time.getHvacTimeStep();
        if (unitDouble != null) {
            time.setHvacTimeStep(null);
            warningReport.addWarning(new Warning(Intl.intl("FDS field HVAC_DT has been deprecated by FDS."), Intl.intl("Field for HVAC Initial Time Step has been dropped.")));
        }
    }

    private static void replaceRefs(Serialized serialized, IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        PyroMod pyroMod = new PyroMod(serialized, false, false);
        DepSnapshot depSnapshot = pyroMod.getDependencies(iPyroObject);
        PyroSimObjectInputStream.replaceRefs(depSnapshot, iPyroObject, iPyroObject2);
    }

    private static void replaceRefs(DepSnapshot depSnapshot, IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        Set<Dependency> set = depSnapshot.getDependents(iPyroObject);
        for (Dependency dependency : set) {
            dependency.source.taskReplaceDep(iPyroObject, iPyroObject2).run();
        }
    }

    private static void removeObjs(PyroMod pyroMod, DepSnapshot depSnapshot, Collection<? extends IPyroObject> collection, WarningReport warningReport) {
        Object object;
        Object object2;
        Object object3;
        IPyroObject iPyroObject;
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        Object object4 = new LinkedIdentityHashSet<IPyroObject>(collection);
        while (!object4.isEmpty()) {
            linkedIdentityHashSet.addAll(object4);
            LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
            Object object5 = object4.iterator();
            while (object5.hasNext()) {
                iPyroObject = (IPyroObject)object5.next();
                object3 = depSnapshot.getDependents(iPyroObject);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Dependency)object2.next();
                    assert (((Dependency)object).link != DLink.REQUIRED);
                    if (((Dependency)object).link == DLink.STRONG && ((Dependency)object).source instanceof IPyroObject && !linkedIdentityHashSet.contains((IPyroObject)((Object)((Dependency)object).source)) && pyrosim.util.Util.canDelete(pyroMod, ((Dependency)object).source)) {
                        linkedIdentityHashSet2.add((IPyroObject)((Object)((Dependency)object).source));
                        continue;
                    }
                    ((Dependency)object).source.taskReplaceDep(iPyroObject, null).run();
                }
            }
            object4 = linkedIdentityHashSet2;
        }
        for (Object object5 : linkedIdentityHashSet) {
            iPyroObject = object5.getParent();
            if (!(iPyroObject instanceof Composite)) continue;
            object3 = pyrosim.util.Util.getCatName((IPyroObject)object5);
            object2 = String.format(Intl.intl("The %s, %s, is no longer valid."), object3, pyrosim.util.Util.getName((IPyroObject)object5));
            object = String.format(Intl.intl("Removed %s from the model."), object3);
            warningReport.addWarning(new Warning((String)object2, (String)object));
            ((Composite)iPyroObject).remove((IPyroObject)object5);
        }
    }

    private void initLegClasses() {
        this.addLegClass(50, "pyrosim.domain.Variant", pyrosim.legacy.v49.domain.Variant.class);
        this.addLegClass(50, "pyrosim.domain.Variant$UnitDoubleVar", Variant.UnitDoubleVar.class);
        this.addLegClass(50, "pyrosim.domain.Variant$RampVar", Variant.RampVar.class);
        this.addLegClass(77, "pyrosim.domain.geom.Vent", pyrosim.legacy.v76.domain.geom.Vent.class);
        this.addLegClass(77, "pyrosim.domain.geom.Vent$VentGeom", Vent.VentGeom.class);
        this.addLegClass(77, "pyrosim.domain.geom.FireSpread", pyrosim.legacy.v76.domain.geom.FireSpread.class);
        this.addLegClass(79, "pyrosim.domain.geom.Vent", Vent.class);
        this.addLegClass(79, "pyrosim.domain.geom.Vent$VentGeom", Vent.VentGeom.class);
        this.addLegClass(79, "pyrosim.domain.geom.FireSpread", FireSpread.class);
        this.addLegClass(87, "pyrosim.geom.TexCoordGenerator", TexCoordGenerator.class);
        this.addLegClass(87, "pyrosim.geom.TexCoordGenerator$1", TexCoordGenerator.DEFAULT_PRIM.getClass());
        this.addLegClass(87, "pyrosim.geom.TexCoordGenerator$2", TexCoordGenerator.DEFAULT_OBJ.getClass());
        this.addLegClass(97, "pyrosim.domain.NameGenerator", pyrosim.legacy.v96.domain.NameGenerator.class);
        this.addLegClass(97, "pyrosim.domain.NamesDB", NamesDB.class);
        this.addLegClass(100, "pyrosim.domain.geom.FreePointLoc", pyrosim.legacy.v100.domain.geom.FreePointLoc.class);
        this.addLegClass(110, "pyrosim.domain.devices.hvac.HvacDevice", HvacDevice.class);
        this.addLegClass(110, "pyrosim.domain.devices.hvac.HvacDevice$DuctDevice", HvacDevice.DuctDevice.class);
        this.addLegClass(110, "pyrosim.domain.devices.hvac.HvacDevice$NodeDevice", HvacDevice.NodeDevice.class);
    }

    private void addLegClass(int n, String string, Class clazz) {
        HashMap<String, Class> hashMap = (HashMap<String, Class>)this.d_classLookup.get(n);
        if (hashMap == null) {
            hashMap = new HashMap<String, Class>();
            this.d_classLookup.put(n, hashMap);
        }
        hashMap.put(string, clazz);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        Collection collection = this.d_classLookup.tailMap(this.d_version, false).values();
        for (Map map : collection) {
            Class clazz = (Class)map.get(string);
            if (clazz == null) continue;
            System.out.printf("Resolving %s -> %s%n", string, clazz.getName());
            return clazz;
        }
        Class clazz = this.d_teciio.resolveClass(objectStreamClass);
        if (clazz == null) {
            clazz = super.resolveClass(objectStreamClass);
        }
        return clazz;
    }

    @Override
    protected Object resolveObject(Object object) throws IOException {
        if (this.d_version < 90 && object instanceof DoubleOutPin && ((DoubleOutPin)object).getAttachedSource() instanceof Sprinkler) {
            return new Sprinkler.LinkQuantOutPin((Sprinkler)((DoubleOutPin)object).getAttachedSource());
        }
        if (this.d_version < 90 && object instanceof IMeasurer && ((IMeasurer)object).getQuantity(0).get() == Quantity.TIME) {
            return Clock.INSTANCE;
        }
        return this.d_teciio.resolveObject(object);
    }

    private boolean isObscurationUnit(Unit unit) {
        if (this.d_obscurationUnits == null) {
            this.d_obscurationUnits = new HashSet<Unit>();
            for (Object e : Unit.getInstances()) {
                Unit unit2 = (Unit)e;
                if (!unit2.isCompatible(SI.METER)) continue;
                this.d_obscurationUnits.add(NonSI.PERCENT.divide(unit2));
            }
        }
        return this.d_obscurationUnits.contains(unit);
    }

    private <T> T getExisting(T t, Map<T, T> map) {
        if (!map.containsKey(t)) {
            map.put(t, t);
            return t;
        }
        return map.get(t);
    }

    private static /* synthetic */ IElemSource lambda$generatePre87Elements$37(IElemSource iElemSource, Integer n, IElemSource iElemSource2) {
        return iElemSource.getPrimSource(n);
    }

    static {
        String string = String.format("PSM%04d", 125);
        assert (string.length() <= 7);
        FORMAT_CODE = string.getBytes();
    }

    private static class PinReplacement
    extends Pair<IOutPin, IInPin> {
        private static final long serialVersionUID = -5478775037381610444L;

        public PinReplacement(IOutPin iOutPin, IInPin iInPin) {
            super(iOutPin, iInPin);
        }
    }
}

