/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.GridDisplay;
import thunderheadeng.cad.out.TeciGeomWriter;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.Filters;

public class PyroGeomFile {
    public static boolean write(File file, String string, PyroMod pyroMod, Collection<? extends IPyroObject> collection, boolean bl, Map<IObstruction, List<Integer>> map, Map<Vent, Integer> map2, boolean bl2, final Predicate<IHole> predicate) throws IOException {
        Set<Integer> set;
        Object object;
        GridMergeUtil.MergeResult[] mergeResultArray;
        Object object3;
        Collection<ISurfObj> collection2;
        File file2 = new File(file, string);
        ArrayList<TeciGeomWriter.DefaultObj> arrayList = new ArrayList<TeciGeomWriter.DefaultObj>();
        Predicate<Surface> predicate2 = Filters.reject(pyroMod.getSurfaceMgr().get(PredefSurf.MIRROR), pyroMod.getSurfaceMgr().get(PredefSurf.OPEN), pyroMod.getSurfaceMgr().get(PredefSurf.PERIODIC));
        Surface surface = pyroMod.getSimParams().getMisc().getSurfDefault();
        final Collection<Grid> collection3 = Hierarchy.flatten(collection, Grid.class, new EnabledFilter());
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS) && predicate2.test(surface)) {
            collection2 = Hierarchy.flatten(collection, Vent.class);
            object3 = GridMergeUtil.mergeGrids(collection3, collection2);
            mergeResultArray = ((GridMergeUtil.MergeResult)object3).faces;
            for (Map.Entry object4 : mergeResultArray.entrySet()) {
                Grid grid = (Grid)object4.getKey();
                if (!grid.isVisible()) continue;
                object = grid.getBounds().getCenter();
                for (Face face : ((GridMergeUtil.BoundaryInfo)object4.getValue()).faces) {
                    if (!(face.plane.dot((Point3d)object) < 0.0)) continue;
                    face.flipOrient();
                }
                set = GridDisplay.generateDisplayData(((GridMergeUtil.BoundaryInfo)object4.getValue()).faces, ((GridMergeUtil.BoundaryInfo)object4.getValue()).boundaryEdges, surface);
                IGeomNode iGeomNode = ((GridDisplay.DisplayData)((Object)set)).getGeom(true);
                int n = 2;
                IPrimProps.Face face = new IPrimProps.Face(surface.getColor(), surface.getAppearance() == null ? null : surface, n);
                arrayList.add(new TeciGeomWriter.DefaultObj(bl ? TeciGeomWriter.Type.FDS_MESH : TeciGeomWriter.Type.GENERIC, grid.getName(), new DisplayGeom(iGeomNode, (IPrimProps)face), Collections.emptyList()));
            }
        }
        collection2 = Hierarchy.flatten(collection, ISurfObj.class);
        object3 = new ArrayList();
        mergeResultArray = new GridMergeUtil.MergeResult[]{null};
        IPyroDisplayProps iPyroDisplayProps = new IPyroDisplayProps(){

            @Override
            public double getFaceError() {
                return 0.1;
            }

            @Override
            public double getCurveError() {
                return 0.1;
            }

            @Override
            public Predicate<IHole> getHoleFilter() {
                return predicate;
            }

            @Override
            public GridMergeUtil.MergeResult getMergedMeshes() {
                if (mergeResultArray[0] == null) {
                    mergeResultArray[0] = GridMergeUtil.mergeGrids(collection3, Collections.emptyList());
                }
                return mergeResultArray[0];
            }

            @Override
            public boolean getVentOrientVisible() {
                return false;
            }

            @Override
            public FDSRasterization getRasterizer() {
                return null;
            }

            @Override
            public ClippingManager getClippingManager() {
                return null;
            }
        };
        for (ISurfObj iSurfObj : collection2) {
            if (!iSurfObj.isEnabled() || !iSurfObj.isVisible() || iSurfObj instanceof Vent && !predicate2.test(((Vent)iSurfObj).getSurface())) continue;
            object = TeciGeomWriter.Type.GENERIC;
            set = Collections.emptyList();
            if (bl) {
                if (iSurfObj instanceof Vent) {
                    object = TeciGeomWriter.Type.FDS_VENT;
                    Integer n = map2.get((Vent)iSurfObj);
                    if (n != null) {
                        set = Collections.singleton(n);
                    }
                } else if (iSurfObj instanceof IObstruction) {
                    object = TeciGeomWriter.Type.FDS_OBST;
                    set = map.getOrDefault((IObstruction)iSurfObj, Collections.emptyList());
                }
            }
            DisplayGeom displayGeom = iSurfObj.getDisplayGeom(pyroMod, iPyroDisplayProps);
            arrayList.add(new TeciGeomWriter.DefaultObj((TeciGeomWriter.Type)((Object)object), iSurfObj.getName(), displayGeom, (Collection<Integer>)set));
        }
        if (!bl2 && arrayList.isEmpty() && object3.isEmpty()) {
            file2.delete();
            return false;
        }
        TeciGeomWriter.writeVis(file2, new TeciGeomWriter.Options(PyroPrefs.getDouble(PyroPrefs.DISPLAY_EDGE_ERROR), PyroPrefs.getDouble(PyroPrefs.DISPLAY_FACE_ERROR)), arrayList, (Collection<? extends TeciGeomWriter.BGImage>)object3);
        return true;
    }
}

