/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import thunderheadeng.gui.Application;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;

public class POVRayWriter {
    private static final String nl = System.getProperty("line.separator");

    public static void writePOVRayFile(PyroSim pyroSim, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
    }

    private static Vector3d[] getPOVRayCamVecs(Camera camera, double d, double d2) {
        if (camera instanceof PerspectiveCamera) {
            PerspectiveCamera perspectiveCamera = (PerspectiveCamera)camera;
            double d3 = perspectiveCamera.getFOV();
            double d4 = perspectiveCamera.getZoom();
            Point2d point2d = perspectiveCamera.getZoomLoc();
            double d5 = perspectiveCamera.getNearClip();
            double d6 = 2.0 * Math.tan(d3 * 0.5) * d5 / d4;
            double d7 = d6 * d / d2;
            Vector3d vector3d = perspectiveCamera.getRightVector();
            vector3d.normalize();
            vector3d.scale(d7);
            Vector3d vector3d2 = perspectiveCamera.getUpVector();
            vector3d2.normalize();
            vector3d2.scale(d6);
            Vector3d vector3d3 = perspectiveCamera.getViewVector();
            vector3d3.normalize();
            vector3d3.scale(d5);
            Point3d point3d = new Point3d();
            point3d.add(perspectiveCamera.getPosition(), vector3d3);
            perspectiveCamera.translateEye(point3d, new Vector3d(point2d.x, point2d.y, 0.0));
            vector3d3.sub(point3d, perspectiveCamera.getPosition());
            double d8 = 1.0 / vector3d2.length();
            vector3d.scale(d8);
            vector3d2.scale(d8);
            vector3d3.scale(d8);
            return new Vector3d[]{vector3d, vector3d2, vector3d3};
        }
        if (camera instanceof OrthoCamera) {
            OrthoCamera orthoCamera = (OrthoCamera)camera;
            Vector3d vector3d = orthoCamera.getViewVector(orthoCamera.getReference());
            Vector3d vector3d4 = orthoCamera.getUpVector();
            Vector3d vector3d5 = orthoCamera.getRightVector();
            double d9 = orthoCamera.getSubjectSize();
            double d10 = orthoCamera.getZoom();
            Point2d point2d = orthoCamera.getZoomLoc();
            double d11 = orthoCamera.getNearClip();
            double d12 = d9 / d10;
            double d13 = d12 * d / d2;
            vector3d5.normalize();
            vector3d5.scale(d13);
            vector3d4.normalize();
            vector3d4.scale(d12);
            vector3d.normalize();
            vector3d.scale(d11);
            Point3d point3d = new Point3d();
            point3d.add(orthoCamera.getPosition(), vector3d);
            orthoCamera.translateEye(point3d, new Vector3d(point2d.x, point2d.y, 0.0));
            vector3d.cross(vector3d4, vector3d5);
            Vector3d vector3d6 = new Vector3d();
            vector3d6.set(point3d);
            vector3d6.sub(vector3d);
            vector3d.scale(0.5);
            return new Vector3d[]{vector3d5, vector3d4, vector3d, vector3d6};
        }
        return null;
    }

    private static void writeTriangle(Point3d[] point3dArray, double d, double d2, double d3, PrintWriter printWriter) {
        if (point3dArray.length == 4) {
            printWriter.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", point3dArray[0].x, point3dArray[0].y, point3dArray[0].z, point3dArray[2].x, point3dArray[2].y, point3dArray[2].z, point3dArray[3].x, point3dArray[3].y, point3dArray[3].z);
            printWriter.printf("\t\ttexture{pigment{color rgb < %.4f, %.4f, %.4f>} ", d / 256.0, d2 / 256.0, d3 / 256.0);
            printWriter.write("\t\t\tnormal {bumps .05 scale .05}}}\n");
        }
        printWriter.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", point3dArray[0].x, point3dArray[0].y, point3dArray[0].z, point3dArray[1].x, point3dArray[1].y, point3dArray[1].z, point3dArray[2].x, point3dArray[2].y, point3dArray[2].z);
        printWriter.printf("\t\ttexture{pigment{color rgb < %.4f, %.4f, %.4f>} ", d / 256.0, d2 / 256.0, d3 / 256.0);
        printWriter.write("\t\t\tnormal {bumps .05 scale .05}}}\n");
    }

    private static void writeTriangle(Point3d[] point3dArray, double d, double d2, PrintWriter printWriter) {
        double d3 = point3dArray[0].distance(point3dArray[1]);
        double d4 = point3dArray[1].distance(point3dArray[2]);
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(0.0, d4 / d);
        Point2d point2d3 = new Point2d(d3 / d2, 0.0);
        Point2d point2d4 = new Point2d(d3 / d2, d4 / d);
        if (point3dArray.length == 4) {
            printWriter.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", point3dArray[3].x, point3dArray[3].y, point3dArray[3].z, point3dArray[2].x, point3dArray[2].y, point3dArray[2].z, point3dArray[1].x, point3dArray[1].y, point3dArray[1].z);
            printWriter.printf("\t\t uv_vectors < %.4f, %.4f>, < %.4f, %.4f>, ", point2d.x, point2d.y, point2d3.x, point2d3.y);
            printWriter.printf("<%.4f, %.4f>}\n", point2d4.x, point2d4.y);
        }
        printWriter.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", point3dArray[3].x, point3dArray[3].y, point3dArray[3].z, point3dArray[0].x, point3dArray[0].y, point3dArray[0].z, point3dArray[1].x, point3dArray[1].y, point3dArray[1].z);
        printWriter.printf("\t\t uv_vectors < %.4f, %.4f>, < %.4f, %.4f>, ", point2d.x, point2d.y, point2d2.x, point2d2.y);
        printWriter.printf("<%.4f, %.4f>}\n", point2d4.x, point2d4.y);
    }

    private static int runPOVRay(String string, String string2, boolean bl, int n, int n2) {
        String string3 = PyroPrefs.getString(PyroPrefs.PREF_MPOVLOCATION);
        String string4 = "";
        string4 = bl ? "+A" : "-A";
        String string5 = "";
        if (string.equals(".png")) {
            string5 = "+FN";
        } else if (string.equals(".ppm")) {
            string5 = "+FP";
        } else if (string.equals(".tga") || string.equals(".targa")) {
            string5 = "+FT";
        } else {
            string5 = "+FT";
            string2 = string2.replace(string, ".tga");
            string = ".tga";
        }
        File file = new File(string2);
        String string6 = file.getName();
        String string7 = string6.replace(string, ".pov");
        try {
            String[] stringArray = new String[]{"\"" + string3 + "\"", "+I" + string7, "+O" + string6, string5, "-UV", "+w" + n, "+h" + n2, string4};
            String[] stringArray2 = null;
            File file2 = new File(string2).getParentFile();
            Process process = Runtime.getRuntime().exec(stringArray, stringArray2, file2);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string8 = bufferedReader.readLine();
            while (string8 != null) {
                string8 = bufferedReader.readLine();
            }
            inputStreamReader = new InputStreamReader(process.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            string8 = bufferedReader.readLine();
            while (string8 != null) {
                string8 = bufferedReader.readLine();
            }
            int n3 = process.waitFor();
            return n3;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("An unknown error ocurred while attempting to run MegaPOV."), Intl.intl("Error While Executing MegaPOV"), 0);
            return -1;
        }
    }
}

