/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroTaskManager;
import pyrosim.gui.PyroGuiUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiExceptionError;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.Task;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class ImportFDSFile
implements Task,
PyroTaskManager.BypassWriteProtection {
    private final PyroSim d_pySim;
    private final PyroMod d_pyMod;
    private final String d_fn;
    private boolean d_success;

    public ImportFDSFile(PyroSim pyroSim, PyroMod pyroMod, String string) {
        this.d_pySim = pyroSim;
        this.d_pyMod = pyroMod;
        this.d_fn = string;
        this.d_success = false;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
        assert (this.canUndo());
    }

    @Override
    public int getEst() {
        return 1;
    }

    public boolean getSuccess() {
        return this.d_success;
    }

    @Override
    public void run() {
        this.d_pyMod.pauseUpdates(false);
        this.d_success = this.readFDSFile(this.d_fn);
        if (this.d_success) {
            this.d_pySim.getFDSMRUMenu().usedFile(this.d_fn);
            this.d_pySim.setFilename(this.d_fn, true);
            this.d_pyMod.resumeUpdates();
            this.d_pyMod.getEvents().changed(this.d_pyMod, PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_MODEL_CHANGED);
        } else {
            this.d_pyMod.resumeUpdates();
        }
    }

    private boolean readFDSFile(String string) {
        try {
            return ImportFDSFile.readFDSFile(PyroSim.getApp().getActiveFrame(), new File(Application.getApp().getInstallDir(), "fds"), string, this.d_pyMod, true);
        }
        catch (Exception exception) {
            Application.getApp().error(new guiExceptionError(exception));
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean readFDSFile(Component component, File file, String string, PyroMod pyroMod, boolean bl) throws IOException {
        int n;
        Window window = component != null ? PyroGuiUtil.getWindow(component) : null;
        String string2 = FilenameManager.getExtension(string).equalsIgnoreCase("data") ? "FDS4" : "FDS6";
        Object[] objectArray = new String[]{"FDS4", "FDS5", "FDS6"};
        String[] stringArray = (String[])JOptionPane.showInputDialog(window, Intl.intl("Select the FDS version used to create the input file."), Intl.intl("FDS Version Selection Dialog"), -1, null, objectArray, string2);
        if (stringArray == null) {
            return false;
        }
        switch (stringArray) {
            case "FDS4": {
                n = 4;
                break;
            }
            case "FDS5": {
                n = 5;
                break;
            }
            case "FDS6": {
                n = 6;
                break;
            }
            default: {
                assert (false) : "Invalid state";
                return false;
            }
        }
        try {
            String[] stringArray2 = new String[]{Intl.intl("Record"), Intl.intl("Action")};
            WarningReport<Warning> warningReport = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), stringArray2, 0);
            boolean bl2 = false;
            if (n == 6 && !bl2) {
                bl2 = pyroMod.readFDS6File(string, false);
            }
            if (n == 5 && !bl2) {
                bl2 = ImportFDSFile.readFDS5File(file, string, warningReport, pyroMod);
            }
            if (n == 4 && !bl2) {
                bl2 = ImportFDSFile.readFDS4File(file, string, warningReport, pyroMod);
            }
            if (bl2) {
                if (bl) {
                    if (!warningReport.isEmpty()) {
                        String string3 = Intl.intl("File Conversion Warnings");
                        String string4 = Intl.intl("Please review the following items in your updated model to verify proper conversion.");
                        WarningDlg<Warning> warningDlg = window instanceof JDialog ? new WarningDlg<Warning>((Window)((JDialog)window), string3, string4, warningReport) : (window instanceof JFrame ? new WarningDlg<Warning>((Window)((JFrame)window), string3, string4, warningReport) : new WarningDlg<Warning>((Window)null, string3, string4, warningReport));
                        warningDlg.doModal();
                    } else {
                        System.out.println("Warnings:\n" + warningReport.prepareReport());
                    }
                }
                return true;
            }
            throw new IOException(Intl.intl("Unable to determine FDS file type."));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    private static boolean readFDS4File(File file, String string, WarningReport warningReport, PyroMod pyroMod) throws Exception {
        pyrosim.legacy_2006_2.PyroMod pyroMod2 = new pyrosim.legacy_2006_2.PyroMod();
        return pyroMod2.readFDS4File(string) && pyroMod.fromLegacy(file, pyroMod2, (WarningReport<Warning>)warningReport);
    }

    private static boolean readFDS5File(File file, String string, WarningReport warningReport, PyroMod pyroMod) throws Exception {
        pyrosim.legacy_2012_1.PyroMod pyroMod2 = new pyrosim.legacy_2012_1.PyroMod();
        return pyroMod2.readFDS5File(string, false) && pyroMod.fromLegacy(file, pyroMod2, (WarningReport<Warning>)warningReport);
    }
}

