/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import pyrosim.Intl;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;

public class IOUtil {
    public static void zip(File file, File file2) throws IOException {
        IOUtil.zip(file, file2, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, File file2, boolean bl, int n) throws IOException {
        File file3 = file2.getParentFile();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        zipOutputStream.setMethod(bl ? 8 : 0);
        if (bl) {
            zipOutputStream.setLevel(n);
        }
        try {
            byte[] byArray = new byte[16384];
            File file4 = file.isDirectory() ? file : file.getParentFile();
            IOUtil.zip(file3, file4, zipOutputStream, bl, byArray, file);
        }
        finally {
            zipOutputStream.close();
        }
    }

    private static void zip(File file, File file2, ZipOutputStream zipOutputStream, boolean bl, byte[] byArray, File file3) throws IOException {
        if (file3.isDirectory()) {
            for (File file4 : IOUtil.listFiles(file3)) {
                IOUtil.zip(file, file2, zipOutputStream, bl, byArray, file4);
            }
        } else {
            String string = FilenameManager.getRelativeFilename(file2, file3, false, true);
            ZipEntry zipEntry = IOUtil.newZipEntry(file3, string, bl);
            zipOutputStream.putNextEntry(zipEntry);
            IOUtil.copyFile(file3, zipOutputStream, byArray);
            zipOutputStream.closeEntry();
        }
    }

    private static ZipEntry newZipEntry(File file, String string, boolean bl) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(file.lastModified());
        if (!bl) {
            zipEntry.setSize(file.length());
            zipEntry.setCrc(IOUtil.calcChecksumCRC32(file));
        }
        return zipEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, OutputStream outputStream, byte[] byArray) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream inputStream, File file, byte[] byArray) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, File file2) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            byte[] byArray = new byte[16384];
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object;
                ZipEntry zipEntry = enumeration.nextElement();
                File file3 = new File(file2, zipEntry.getName());
                File file4 = file3.getParentFile();
                if (!file4.exists() && !file4.mkdirs()) {
                    object = String.format(Intl.intl("Could not make parent directories for %s."), file3.getAbsolutePath());
                    throw new IOException((String)object);
                }
                object = zipFile.getInputStream(zipEntry);
                try {
                    IOUtil.copyFile((InputStream)object, file3, byArray);
                }
                finally {
                    ((InputStream)object).close();
                }
            }
        }
    }

    public static File[] split(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayDeque<File> arrayDeque = new ArrayDeque<File>();
        while (file != null) {
            arrayDeque.addFirst(file);
            file = file.getParentFile();
        }
        return arrayDeque.toArray(new File[arrayDeque.size()]);
    }

    public static long calcChecksumCRC32(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        IOUtil.calcChecksum(file, cRC32);
        return cRC32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calcChecksum(File file, Checksum checksum) throws IOException {
        try (FilterInputStream filterInputStream = null;){
            filterInputStream = new CheckedInputStream(new FileInputStream(file), checksum);
            byte[] byArray = new byte[16384];
            while (filterInputStream.read(byArray) >= 0) {
            }
        }
    }

    public static void copyDir(File file, File file2) throws IOException {
        assert (file.isDirectory());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(String.format(Intl.intl("Could not create directory, %s."), file2.getAbsolutePath()));
        }
        for (File file3 : IOUtil.listFiles(file)) {
            File file4 = new File(file2, file3.getName());
            if (file3.isFile()) {
                CopyFile.copyFileStream(file3, file4);
                continue;
            }
            IOUtil.copyDir(file3, file4);
        }
    }

    public static List<File> listFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(fileArray);
    }

    public static List<File> listFiles(File file, FilenameFilter filenameFilter) {
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(fileArray);
    }

    public static List<String> listFilenames(File file, FilenameFilter filenameFilter) {
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkZippedFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            throw new IOException(String.format(Intl.intl("%s does not exist."), file2.getAbsolutePath()));
        }
        try (ZipFile zipFile = new ZipFile(file2);){
            Object object;
            Object object2;
            List<File> list = IOUtil.listAllFiles(file, false);
            List<? extends ZipEntry> list2 = IOUtil.toList(zipFile.entries());
            if (list.size() != list2.size()) {
                String string = String.format(Intl.intl("Zip file does not contain the correct number of entries: expected %1$d, found %2$d."), list.size(), list2.size());
                throw new IOException(string);
            }
            File file3 = file.isDirectory() ? file : file.getParentFile();
            HashMap<String, ZipEntry> hashMap = new HashMap<String, ZipEntry>(list2.size());
            for (ZipEntry object3 : list2) {
                object2 = new File(file3, object3.getName());
                object = IOUtil.getCanonicalPath((File)object2);
                hashMap.put((String)object, object3);
            }
            for (File file4 : list) {
                object2 = IOUtil.getCanonicalPath(file4);
                object = (ZipEntry)hashMap.get(object2);
                if (object == null) {
                    String string = String.format(Intl.intl("Zip file is missing entry for %s."), file4.getAbsolutePath());
                    throw new IOException(string);
                }
                long l = ((ZipEntry)object).getSize();
                if (l == -1L || l == file4.length()) continue;
                String string = String.format(Intl.intl("Entry, %1$s, in zip file is the wrong size: expected %2$d, found %3$d."), ((ZipEntry)object).getName(), file4.length(), l);
                throw new IOException(string);
            }
        }
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkUnzippedFile(File file, File file2) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file3 = new File(file2, zipEntry.getName());
                if (!file3.exists()) {
                    throw new IOException(String.format(Intl.intl("%s could not be extracted from zip file."), zipEntry.getName()));
                }
                long l = zipEntry.getSize();
                if (l == -1L || l == file3.length()) continue;
                throw new IOException(String.format(Intl.intl("Extracted file, %1$s, is the wrong size: expected %2$d, found %3$d."), zipEntry.getName(), l, file3.length()));
            }
        }
    }

    private static <T> List<T> toList(Enumeration<? extends T> enumeration) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static List<File> listAllFiles(File file, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        IOUtil.getAllFiles(file, arrayList, bl);
        return arrayList;
    }

    private static void getAllFiles(File file, List<File> list, boolean bl) {
        if (file.isDirectory()) {
            for (File file2 : IOUtil.listFiles(file)) {
                IOUtil.getAllFiles(file2, list, bl);
            }
            if (bl) {
                list.add(file);
            }
        } else {
            list.add(file);
        }
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File file2 : IOUtil.listFiles(file)) {
                IOUtil.delete(file2);
            }
        }
        if (!file.delete()) {
            throw new IOException(String.format(Intl.intl("Could not delete %s."), file.getAbsolutePath()));
        }
    }

    public static PrintWriter newPrintWriterUTF8(String string) throws IOException {
        return IOUtil.newPrintWriter(string, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriterUTF8(File file) throws IOException {
        return IOUtil.newPrintWriter(file, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriter(String string, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), charset));
    }

    public static PrintWriter newPrintWriter(File file, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }
}

