/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.FDSVersion;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.Version;
import pyrosim.domain.APyroObject;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.GridDisplay;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class GE1File {
    public static boolean writeFile(String string, PyroMod pyroMod, Map<IImage, String> map) throws IOException {
        return GE1File.writeFile(string, pyroMod, Version.FDS_DESIGN, map);
    }

    public static boolean writeFile(String string, PyroMod pyroMod, FDSVersion fDSVersion, Map<IImage, String> map) throws IOException {
        System.out.println("Writing GE1 File...");
        theTimer theTimer2 = new theTimer();
        ArrayList<PolyInfo> arrayList = new ArrayList<PolyInfo>();
        ArrayList<Appearance> arrayList2 = new ArrayList<Appearance>();
        GE1File.getPolys(pyroMod, arrayList2, arrayList);
        System.out.println(String.format("   %d polys", arrayList.size()));
        System.out.println(String.format("   %d appearances", arrayList2.size()));
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        printWriter.println("[APPEARANCE]");
        printWriter.println(arrayList2.size());
        GE1File.writeAppearances(printWriter, arrayList2, fDSVersion, map);
        printWriter.println("[FACES]");
        printWriter.println(arrayList.size());
        GE1File.writePrims(printWriter, arrayList);
        printWriter.close();
        System.out.println("GE1 Written in " + GE1File.formatDbl(theTimer2.curr() * 1000.0) + " ms");
        return true;
    }

    private static void getPolys(PyroMod pyroMod, List<Appearance> list, List<PolyInfo> list2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        GridMergeUtil.MergeResult[] mergeResultArray;
        Predicate<IModelObj> predicate;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Predicate<Surface> predicate2 = Filters.reject(pyroMod.getSurfaceMgr().get(PredefSurf.MIRROR), pyroMod.getSurfaceMgr().get(PredefSurf.OPEN), pyroMod.getSurfaceMgr().get(PredefSurf.PERIODIC));
        Predicate<IModelObj> predicate3 = predicate = iModelObj -> iModelObj instanceof ISurfObj || iModelObj instanceof GenericGeomSrc;
        BiConsumer<DisplayGeom, IntPredicate> biConsumer = (displayGeom, intPredicate) -> {
            IPropsSrc iPropsSrc = displayGeom.props;
            IGeomNode iGeomNode = displayGeom.node.flatten();
            IElemSource<Elements.Orient> iElemSource = iGeomNode.getElements(Elements.ORIENT);
            List list2 = thunderheadeng.geometry.objs.GeomUtil.explode(iGeomNode.getLocalGeom(), IPrimitive.class);
            int n = 0;
            for (int i = 0; i < list2.size(); ++i) {
                IPrimitive iPrimitive = (IPrimitive)list2.get(i);
                if (!(iPrimitive instanceof IFace)) continue;
                boolean bl = !intPredicate.test(n);
                ++n;
                if (bl) continue;
                IFace iFace = (IFace)iPrimitive;
                IPrimProps iPrimProps = iPropsSrc.get(i);
                int n2 = GE1File.getAppearance(iPrimProps, linkedHashMap);
                Elements.Orient orient = iElemSource.getPrimElement(i);
                Consumer<IPolygon> consumer = orient == Elements.Orient.CCW ? iPolygon -> list2.add(new PolyInfo((IPolygon)iPolygon, n2)) : iPolygon -> list2.add(new PolyInfo(iPolygon.flipOrient(), n2));
                List<IPolygon> list3 = GeomUtil.toPolys(iFace, 0.1, false);
                for (IPolygon iPolygon2 : list3) {
                    if (iPolygon2.getNumLoops() > 1 || iPolygon2.getNumPoints(0) > 4) {
                        Mesh mesh = iPolygon2.triangulate(0.1);
                        int n3 = 0;
                        while (n3 < mesh.indices.length) {
                            Point3d point3d = mesh.vertices[mesh.indices[n3++]];
                            Point3d point3d2 = mesh.vertices[mesh.indices[n3++]];
                            Point3d point3d3 = mesh.vertices[mesh.indices[n3++]];
                            consumer.accept(new Triangle(point3d, point3d2, point3d3));
                        }
                        continue;
                    }
                    consumer.accept(iPolygon2);
                }
            }
        };
        final Collection collection = pyroMod.getGridManager().flatten(new EnabledFilter());
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS) && predicate2.test((Surface)(mergeResultArray = pyroMod.getSimParams().getMisc().getSurfDefault()))) {
            object4 = ((APyroObject)pyroMod.getObstructions()).flatten(Vent.class);
            object3 = GridMergeUtil.mergeGrids(collection, (Collection<? extends IPyroGeomSrc>)object4).faces;
            for (Map.Entry object5 : object3.entrySet()) {
                object2 = (Grid)object5.getKey();
                if (!((Grid)object2).isVisible()) continue;
                Point3d point3d = object2.getBounds().getCenter();
                for (Face face : ((GridMergeUtil.BoundaryInfo)object5.getValue()).faces) {
                    if (!(face.plane.dot(point3d) < 0.0)) continue;
                    face.flipOrient();
                }
                object = GridDisplay.generateDisplayData(((GridMergeUtil.BoundaryInfo)object5.getValue()).faces, Collections.EMPTY_LIST, (Surface)mergeResultArray);
                IGeomNode i = ((GridDisplay.DisplayData)object).getGeom(false);
                int n2 = 2;
                IPrimProps.Face face = new IPrimProps.Face(mergeResultArray.getColor(), (IMaterial)(mergeResultArray.getAppearance() == null ? null : mergeResultArray), n2);
                biConsumer.accept(new DisplayGeom(i, (IPrimProps)face), n -> true);
            }
        }
        mergeResultArray = new GridMergeUtil.MergeResult[]{null};
        object4 = new IPyroDisplayProps(){

            @Override
            public double getFaceError() {
                return 0.1;
            }

            @Override
            public double getCurveError() {
                return 0.1;
            }

            @Override
            public Predicate<IHole> getHoleFilter() {
                return Predicates.alwaysTrue();
            }

            @Override
            public GridMergeUtil.MergeResult getMergedMeshes() {
                if (mergeResultArray[0] == null) {
                    mergeResultArray[0] = GridMergeUtil.mergeGrids(collection, Collections.emptyList());
                }
                return mergeResultArray[0];
            }

            @Override
            public boolean getVentOrientVisible() {
                return false;
            }

            @Override
            public FDSRasterization getRasterizer() {
                return null;
            }

            @Override
            public ClippingManager getClippingManager() {
                return null;
            }
        };
        object3 = new BitSet();
        for (IModelObj iModelObj2 : pyroMod.getObstructions().flatten(predicate3)) {
            ((BitSet)object3).clear();
            if (!iModelObj2.isEnabled() || !iModelObj2.isVisible()) continue;
            if (iModelObj2 instanceof ISurfObj) {
                object2 = (ISurfObj)iModelObj2;
                int n3 = object2.getNumFaces();
                object = object2.getSurfaces();
                for (int i = 0; i < n3; ++i) {
                    Object object5;
                    Object object6 = object5 = ((Surface[])object).length == 1 ? object[0] : object[i];
                    if (predicate2.test((Surface)object5)) continue;
                    ((BitSet)object3).set(i);
                }
                if (((BitSet)object3).cardinality() == n3) continue;
            }
            object2 = iModelObj2.getDisplayGeom((IDisplayProps)object4);
            biConsumer.accept((DisplayGeom)object2, arg_0 -> GE1File.lambda$getPolys$545((BitSet)object3, arg_0));
        }
        list.addAll(linkedHashMap.keySet());
    }

    private static void writeAppearances(PrintWriter printWriter, Collection<Appearance> collection, FDSVersion fDSVersion, Map<IImage, String> map) {
        float[] fArray = new float[3];
        Iterator<Appearance> iterator = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            Appearance appearance = iterator.next();
            Color color = appearance.d_color;
            IImage iImage = appearance.d_surf;
            printWriter.println(appearance.toString());
            String string = "";
            if (iImage != null && (string = map.get(iImage)) == null) {
                string = new File(iImage.getFilename()).getName();
            }
            printWriter.print(i);
            printWriter.print(' ');
            if (fDSVersion.major < 6) {
                color.getColorComponents(fArray);
                printWriter.printf(GE1File.formatFloat(fArray[0]) + " " + GE1File.formatFloat(fArray[1]) + " " + GE1File.formatFloat(fArray[2]), new Object[0]);
            } else {
                printWriter.printf("%d %d %d", color.getRed(), color.getGreen(), color.getBlue());
            }
            printWriter.printf(" " + GE1File.formatDbl(appearance.d_width) + ", " + GE1File.formatDbl(appearance.d_height), new Object[0]);
            printWriter.print(" ");
            printWriter.print(GE1File.formatFloat((float)color.getAlpha() / 255.0f));
            printWriter.print(" ");
            printWriter.print(GE1File.formatFloat(0.0f));
            printWriter.print(" 0 0 0");
            printWriter.print(" ");
            printWriter.print(appearance.d_oneSided ? 1 : 0);
            printWriter.println();
            printWriter.println(string);
        }
    }

    private static void writePrims(PrintWriter printWriter, List<PolyInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            PolyInfo polyInfo = list.get(i);
            int n = polyInfo.poly.getNumPoints(0);
            if (n == 3) {
                GE1File.writeQuad(printWriter, polyInfo.appearanceIx, polyInfo.poly.getPoint(0, 0), polyInfo.poly.getPoint(0, 1), polyInfo.poly.getPoint(0, 2), polyInfo.poly.getPoint(0, 2));
                continue;
            }
            if (n != 4) continue;
            GE1File.writeQuad(printWriter, polyInfo.appearanceIx, polyInfo.poly.getPoint(0, 0), polyInfo.poly.getPoint(0, 1), polyInfo.poly.getPoint(0, 2), polyInfo.poly.getPoint(0, 3));
        }
    }

    private static void writeQuad(PrintWriter printWriter, int n, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        GE1File.writePoint(printWriter, point3d);
        GE1File.writePoint(printWriter, point3d2);
        GE1File.writePoint(printWriter, point3d3);
        GE1File.writePoint(printWriter, point3d4);
        printWriter.println(n);
    }

    private static void writePoint(PrintWriter printWriter, Point3d point3d) {
        printWriter.print(GE1File.formatFloat((float)point3d.x));
        printWriter.print(" ");
        printWriter.print(GE1File.formatFloat((float)point3d.y));
        printWriter.print(" ");
        printWriter.print(GE1File.formatFloat((float)point3d.z));
        printWriter.print(" ");
    }

    private static int getAppearance(IPrimProps iPrimProps, Map<Appearance, Integer> map) {
        Object object;
        Object object2;
        Texture texture;
        Surface surface = (Surface)iPrimProps.getMaterial();
        IImage iImage = null;
        double d = 0.0;
        double d2 = 0.0;
        if (surface != null && surface.getAppearance() != null && (texture = (object2 = ((Material)(object = surface.getAppearance())).getAttributes()).getTexture(MatChannel.DIFFUSE)) != null) {
            Unit unit = SIUS.getInstance().getLengthUnit();
            iImage = texture.image;
            d = ((Material)object).getWidth().getValue(unit);
            d2 = ((Material)object).getHeight().getValue(unit);
        }
        if ((object2 = map.get(object = new Appearance(GE1File.getColor(iPrimProps), iImage, d, d2, iPrimProps.testOptions(2)))) == null) {
            object2 = map.size();
            map.put((Appearance)object, (Integer)object2);
        }
        return (Integer)object2;
    }

    private static Color getColor(IPrimProps iPrimProps) {
        if (iPrimProps.getMaterial() != null && iPrimProps.getMaterial().getAttributes().getTexture(MatChannel.DIFFUSE) == null) {
            Color color = iPrimProps.getMaterial().getAttributes().getDiffuseColorWithOpacity();
            assert (color != null);
            return color;
        }
        assert (iPrimProps.getColor() != null);
        return iPrimProps.getColor();
    }

    private static String formatFloat(float f) {
        return String.format(Locale.US, "%f", Float.valueOf(f));
    }

    private static String formatDbl(double d) {
        return String.format(Locale.US, "%f", d);
    }

    private static /* synthetic */ boolean lambda$getPolys$545(BitSet bitSet, int n) {
        return !bitSet.get(n);
    }

    private static class Appearance {
        public final Color d_color;
        public final IImage d_surf;
        public final double d_width;
        public final double d_height;
        public final boolean d_oneSided;

        public Appearance(Color color, IImage iImage, double d, double d2, boolean bl) {
            this.d_surf = iImage;
            this.d_width = d;
            this.d_height = d2;
            this.d_color = color;
            this.d_oneSided = bl;
        }

        public int hashCode() {
            return 0x223FA3B ^ (this.d_surf != null ? this.d_surf.makeHashable().hashCode() : 0) + theUtil.hashCode(this.d_width) + theUtil.hashCode(this.d_height) + theUtil.hashCode(this.d_color) + theUtil.hashCode(this.d_oneSided);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Appearance)) {
                return false;
            }
            Appearance appearance = (Appearance)object;
            return this.d_width == appearance.d_width && this.d_height == appearance.d_height && theUtil.equal(appearance.d_color, this.d_color) && Appearance.pseudoEquals(appearance.d_surf, this.d_surf) && this.d_oneSided == appearance.d_oneSided;
        }

        private static boolean pseudoEquals(IImage iImage, IImage iImage2) {
            if (iImage == null) {
                return iImage2 == null;
            }
            if (iImage2 != null) {
                return iImage.makeHashable().equals(iImage2);
            }
            return false;
        }

        public String toString() {
            String string = this.d_surf != null ? this.d_surf.getFilename() : "";
            String string2 = this.d_color != null ? String.format("r=%d,g=%d,b=%d,a=%d", this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), this.d_color.getAlpha()) : "";
            return String.format("Appearance[%s,%s,%b]", string, string2, this.d_oneSided);
        }
    }

    private static class PolyInfo {
        public final IPolygon poly;
        public final int appearanceIx;

        public PolyInfo(IPolygon iPolygon, int n) {
            this.poly = iPolygon;
            this.appearanceIx = n;
        }
    }
}

