/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.zones;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.LeakUtil;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.SortCache;

public class ZonePnl
extends guiPanel
implements IEditor<Zone> {
    private static final long serialVersionUID = -1186846390114269095L;
    private final guiTextField d_nameFld;
    private final ColorButton d_colorBtn;
    private final AABoxGeomEditor d_boxPnl;
    private final LeakTblMdl d_leakTblMdl;
    private final guiTable d_leakTable;
    private final PyroMod d_mediator;

    public ZonePnl(PyroMod pyroMod) {
        super(new GridBagLayout());
        this.d_mediator = pyroMod;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Name:"));
        this.d_nameFld = new guiTextField();
        this.d_nameFld.setEditable(false);
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Color:"));
        this.d_colorBtn = new ColorButton();
        this.d_colorBtn.setMinimumSize(this.d_colorBtn.getPreferredSize());
        this.d_boxPnl = new AABoxGeomEditor(false, true);
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Bounding Box"));
        TitleSeparator titleSeparator2 = new TitleSeparator(Intl.intl("Leakage Areas"));
        this.d_leakTblMdl = new LeakTblMdl();
        this.d_leakTable = new guiTable((TableModel)this.d_leakTblMdl, 0);
        guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_leakTable, 0);
        this.d_leakTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        int n = 0;
        GridBagUtil.add(this, guiLabel2, 0, ++n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_nameFld, 1, n, 1, 1, 0, 6, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 0, ++n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_colorBtn, 1, n, 1, 1, 0, 6, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, titleSeparator2, 0, ++n, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiTableEditor2, 0, ++n, 2, 1, 0, 12, 6, 0, 1, 1.0, 1.0, 17);
        GridBagUtil.add(this, titleSeparator, 0, ++n, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_boxPnl, 0, ++n, 2, 1, 0, 12, 0, 0, 2, 1.0, 0.0, 17);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public Zone preview(Zone zone) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.save(zone);
        return zone;
    }

    @Override
    public void init(Zone zone) {
        this.setEnabled(zone != null && !zone.isOuter());
        if (zone != null) {
            this.d_nameFld.setText(zone.getName());
            this.d_colorBtn.setColor(zone.getColor());
            this.d_boxPnl.load(new AABoxGeom(GeomUtil.getBounds(zone)));
            this.d_leakTblMdl.load(zone, this.d_mediator);
        }
        this.setModified(false);
    }

    @Override
    public Zone commit(final Zone zone) {
        if (zone.isOuter()) {
            return zone;
        }
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                ZonePnl.this.save(zone);
                ZonePnl.this.d_leakTblMdl.save(zone, PyroSim.getApp().getMediator().getBridges());
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Zone"));
        this.setModified(false);
        return zone;
    }

    protected void save(Zone zone) {
        if (zone.isOuter()) {
            return;
        }
        zone.setColor(this.d_colorBtn.getColor());
        AABoxGeom aABoxGeom = this.d_boxPnl.save();
        zone.setBox(new UnitAABox(aABoxGeom.getBoundingBox(new AABox()), Geometry.LU));
    }

    public void previewLeakTblMdl(Zone zone, BridgeList bridgeList) {
        this.d_leakTblMdl.save(zone, bridgeList);
    }

    private static class LeakTblMdl
    extends AbstractTableModel {
        private static final long serialVersionUID = 7104561013331363347L;
        private static final int COL_ZONE = 0;
        private static final int COL_LEAK_AREA = 1;
        private final Unit d_areaUnit = PyroSim.getApp().getUnitSystem().getUnit(68);
        private SortCache<Zone> d_sortedZones;
        private Map<Zone, UnitDouble> d_leaks = new LinkedIdentityHashMap<Zone, UnitDouble>();

        public LeakTblMdl() {
            this.d_sortedZones = new SortCache(Collections.EMPTY_LIST);
        }

        public void load(final Zone zone, PyroMod pyroMod) {
            Collection<Zone> collection = pyroMod.getZoneMgr().flatten(new Predicate<Zone>(){

                @Override
                public boolean test(Zone zone2) {
                    return zone2 != zone;
                }
            });
            this.d_sortedZones = new SortCache<Zone>(Util.sort(collection));
            this.d_leaks.clear();
            for (Leak leak : LeakUtil.getLeaks(pyroMod, zone)) {
                Zone zone2 = leak.otherZone(zone);
                this.d_leaks.put(zone2, leak.area);
            }
            this.fireTableDataChanged();
        }

        public void save(Zone zone, BridgeList bridgeList) {
            ArrayList<Leak> arrayList = new ArrayList<Leak>(LeakUtil.getLeaks(bridgeList, zone));
            bridgeList.removeAll(arrayList);
            ArrayList<Leak> arrayList2 = new ArrayList<Leak>(this.d_leaks.size());
            for (Map.Entry<Zone, UnitDouble> entry : this.d_leaks.entrySet()) {
                Leak leak = new Leak(zone, entry.getKey(), entry.getValue());
                arrayList2.add(leak);
            }
            bridgeList.addAll(arrayList2);
        }

        @Override
        public int getRowCount() {
            return this.d_sortedZones.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Double.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Intl.intl("Zone");
                }
                case 1: {
                    return Intl.intl("Leak Area") + " (" + this.d_areaUnit + ")";
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Zone zone = this.d_sortedZones.get(n);
            switch (n2) {
                case 0: {
                    return zone.getName();
                }
                case 1: {
                    UnitDouble unitDouble = this.d_leaks.get(zone);
                    return unitDouble == null ? 0.0 : unitDouble.getValue(this.d_areaUnit);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            Double d = (Double)object;
            if (d != null && d < 0.0) {
                return;
            }
            Zone zone = this.d_sortedZones.get(n);
            if (d == null || d == 0.0) {
                this.d_leaks.remove(zone);
            } else {
                this.d_leaks.put(zone, new UnitDouble(d, this.d_areaUnit));
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

