/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.zones;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.NewDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.zones.ZonePnl;
import thunderheadeng.gui.guiAction;
import thunderheadeng.units.UnitAABox;

public class ZoneDlg
extends ManagerDlg<Zone, ZoneMgr> {
    private static final long serialVersionUID = 3512251011518955295L;
    private final ZonePnl d_pnl;
    private ZoneMgr d_mgr;
    private final Action[] d_actions;
    private final Action d_new = new NewAction();
    private final Action d_rename = new RenameAction<Zone, ZoneMgr>(this, Intl.intl("zone"));
    private final Action d_delete = new ManagerDlg.DeleteAction();

    public ZoneDlg(JFrame jFrame, PyroMod pyroMod) {
        super(jFrame, Intl.intl("Edit Zones"), true);
        this.d_actions = new Action[]{this.d_new, this.d_rename, this.d_delete};
        this.d_pnl = new ZonePnl(pyroMod);
        this.setResizable(true);
    }

    private void updateActions() {
        int n = this.getList().getSelectedIx();
        this.d_new.setEnabled(this.d_mgr != null);
        this.d_rename.setEnabled(this.d_mgr != null && n > -1);
        this.d_delete.setEnabled(this.d_mgr != null && n > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(ZoneMgr zoneMgr, Zone zone) {
        this.d_mgr = zoneMgr;
        ((RenameAction)this.d_rename).init(zoneMgr);
        super.init(this.d_mgr, this.d_pnl, this.d_actions, zone);
        this.updateActions();
    }

    @Override
    public void setPreview(Zone zone, boolean bl) {
        BridgeList bridgeList = new BridgeList();
        this.d_pnl.previewLeakTblMdl(zone, bridgeList);
        List list = bridgeList.flatten().stream().collect(Collectors.toList());
        list.add(zone);
        this.getPreviewPnl().setRecord(list, bl);
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 183129389776201158L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewDlg<Zone> newDlg;
            if (!ZoneDlg.this.preSave()) {
                return;
            }
            int n = ZoneDlg.this.getList().getSelectedIx();
            Zone zone = null;
            if (n >= 0) {
                zone = (Zone)ZoneDlg.this.getList().getItem(n);
            }
            if ((newDlg = new NewDlg<Zone>(ZoneDlg.this.d_mgr, Zone.class, Intl.intl("zone"))).doModal() == 1) {
                zone = new Zone(newDlg.getName(), new UnitAABox(0.0, 0.0, 0.0, 10.0, 10.0, 10.0, SI.METER));
                PyroMod pyroMod = (PyroMod)ZoneDlg.this.d_mgr.getDomain();
                AddTask addTask = new AddTask((IPyroObject)ZoneDlg.this.d_mgr, new IPyroObject[]{zone});
                SelectTask selectTask = new SelectTask(pyroMod, zone);
                selectTask.addTask(addTask);
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Zone"));
                ZoneDlg.this.getList().updateModelView(ZoneDlg.this.d_mgr);
                ZoneDlg.this.getList().select(zone);
                ZoneDlg.this.d_pnl.getEditorPanel().setModified(false);
                ZoneDlg.this.updateActions();
            }
        }
    }
}

