/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.view;

import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.view.SectionBox;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Task;

public class SectionBoxDlg
extends guiDialog {
    private static final long serialVersionUID = 7868312739617375409L;
    private final ColorButton d_colorEditor;
    private final IGeomEditor<IGeom> d_geomEditor;
    public static final Composite.IObjectProp<SectionBox, Color> colorProp = new Composite.AObjectProp<SectionBox, Color>(SectionBox.class){

        @Override
        public void set(SectionBox sectionBox, Color color) {
            sectionBox.setColor(color);
        }

        @Override
        public Object get(SectionBox sectionBox) {
            return sectionBox.getColor();
        }
    };

    public SectionBoxDlg(Window window, Collection<? extends IPyroGeomSrc> collection) {
        super(window, Intl.intl("Section Box Properties"), 9);
        Collection<SectionBox> collection2 = Hierarchy.flatten(collection, SectionBox.class);
        this.d_geomEditor = GeomGuiUtil.newEditor(collection2);
        this.d_colorEditor = new ColorButton();
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addRow(Intl.intl("Color:"), this.d_colorEditor);
        if (this.d_geomEditor != null) {
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Geometry")));
            gridBagHelper.indent();
            gridBagHelper.addFilledRow(this.d_geomEditor);
        }
        gridBagHelper.finalizeRows();
        this.load(collection);
    }

    private void load(Collection<? extends IPyroGeomSrc> collection) {
        Collection<SectionBox> collection2 = Hierarchy.flatten(collection, SectionBox.class);
        if (this.d_geomEditor != null) {
            this.d_geomEditor.load(collection2);
        }
        this.loadColor(this.d_colorEditor, collection2);
    }

    public Task taskSave(Collection<? extends IPyroGeomSrc> collection) {
        final ArrayList<SectionBox> arrayList = new ArrayList<SectionBox>(Hierarchy.flatten(collection, SectionBox.class));
        return new AOneTimeTask(){

            @Override
            public void run() {
                if (SectionBoxDlg.this.d_geomEditor != null) {
                    SectionBoxDlg.this.d_geomEditor.save(arrayList);
                }
                SectionBoxDlg.this.saveColor(SectionBoxDlg.this.d_colorEditor, arrayList);
            }
        };
    }

    private void loadColor(ColorButton colorButton, Collection<? extends SectionBox> collection) {
        Object object = Composite.getProperty(colorProp, collection);
        if (object instanceof Color) {
            colorButton.setColor((Color)object);
        } else {
            colorButton.setColor(null);
        }
    }

    private void saveColor(ColorButton colorButton, Collection<? extends SectionBox> collection) {
        Color color = colorButton.getColor();
        if (color != null) {
            Composite.setProperty(colorProp, color, collection);
        }
    }
}

