/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.domain.reaction.Reaction;
import pyrosim.util.RefWrapper;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class SetNewActiveSimpleReacDlg
extends guiDialog {
    private static final long serialVersionUID = 2139970846970882168L;
    private final guiComboBox<RefWrapper<Reaction>> d_combo;
    private final List<Reaction> d_defaultActive;

    public SetNewActiveSimpleReacDlg(List<Reaction> list, Function<Reaction, String> function, List<Reaction> list2) {
        super((Window)Application.getApp().getMainFrame(), Intl.intl("Update Active Reaction"), 9);
        this.d_defaultActive = list2;
        this.d_combo = this.buildCombo(list, function, list2);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Please select an active reaction:"));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Reaction:"));
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel2, guiLabel2, 0, 0, 2, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_combo, 1, 1, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.addGlue(guiPanel2);
    }

    private guiComboBox<RefWrapper<Reaction>> buildCombo(List<Reaction> list, Function<Reaction, String> function, List<Reaction> list2) {
        list = new ArrayList<Reaction>(list);
        list.add(0, null);
        guiComboBox<RefWrapper<Reaction>> guiComboBox2 = new guiComboBox<RefWrapper<Reaction>>(list.stream().map(reaction -> new RefWrapper<Reaction>((Reaction)reaction)).collect(Collectors.toList()));
        guiComboBox2.setRenderer(new ReactionListCellRenderer(list2, function));
        guiComboBox2.setSelectedIndex(0);
        return guiComboBox2;
    }

    public List<Reaction> getSelectedReacs() {
        Reaction reaction = (Reaction)this.d_combo.getSelectedItem().obj;
        if (reaction == null) {
            return this.d_defaultActive;
        }
        return Arrays.asList(reaction);
    }

    private static class ReactionListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6041394035117475920L;
        private final List<Reaction> d_actives;
        private final Function<Reaction, String> d_nameMapper;
        private final String d_defaultStr;

        public ReactionListCellRenderer(List<Reaction> list, Function<Reaction, String> function) {
            this.d_actives = list;
            this.d_nameMapper = function;
            String string = Intl.intl("Active");
            if (this.d_actives.size() == 0) {
                String string2 = Intl.intl("None");
                this.d_defaultStr = String.format("%s (%s)", string2, string);
            } else if (this.d_actives.size() == 1) {
                String string3 = this.d_nameMapper.apply(this.d_actives.iterator().next());
                this.d_defaultStr = String.format("%s (%s)", string3, string);
            } else {
                String string4 = Intl.intl("Complex (Multiple)");
                this.d_defaultStr = String.format("%s (%s)", string4, string);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Reaction reaction = (Reaction)((RefWrapper)object).obj;
            if (reaction == null) {
                this.setText(String.format("<html><b>%s</b>", this.d_defaultStr));
            } else {
                this.setText(String.format("<html>%s", this.d_nameMapper.apply(reaction)));
            }
            return this;
        }
    }
}

