/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.domain.reaction.Reaction;
import pyrosim.util.RefWrapper;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class SetActiveReacDlg
extends guiDialog {
    private static final long serialVersionUID = 2139970846970882168L;
    private final guiComboBox<RefWrapper<Reaction>> d_combo;

    public SetActiveReacDlg(List<Reaction> list, Function<Reaction, String> function, Reaction reaction) {
        super((Window)Application.getApp().getMainFrame(), Intl.intl("Set Active Reaction"), 9);
        this.d_combo = this.buildCombo(list, function, reaction);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Please set an active reaction:"));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Reaction:"));
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel2, guiLabel2, 0, 0, 2, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_combo, 1, 1, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.addGlue(guiPanel2);
    }

    private guiComboBox<RefWrapper<Reaction>> buildCombo(List<Reaction> list, Function<Reaction, String> function, Reaction reaction2) {
        list = new ArrayList<Reaction>(list);
        list.add(0, null);
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != reaction2) continue;
            n = i;
            break;
        }
        guiComboBox<RefWrapper<Reaction>> guiComboBox2 = new guiComboBox<RefWrapper<Reaction>>(list.stream().map(reaction -> new RefWrapper<Reaction>((Reaction)reaction)).collect(Collectors.toList()));
        guiComboBox2.setRenderer(new ReactionListCellRenderer(reaction2, function));
        guiComboBox2.setSelectedIndex(n);
        return guiComboBox2;
    }

    public Reaction getSelectedReac() {
        return (Reaction)this.d_combo.getSelectedItem().obj;
    }

    private static class ReactionListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -6041394035117475920L;
        private final Reaction d_active;
        private final Function<Reaction, String> d_nameMapper;

        public ReactionListCellRenderer(Reaction reaction, Function<Reaction, String> function) {
            this.d_active = reaction;
            this.d_nameMapper = function;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = Intl.intl("None");
            String string2 = Intl.intl("Active");
            Reaction reaction = (Reaction)((RefWrapper)object).obj;
            if (reaction == null && reaction == this.d_active) {
                this.setText(String.format("<html><i><b>%s</b></i>", string));
            } else if (reaction == null && reaction != this.d_active) {
                this.setText(String.format("<html><i>%s</i>", string));
            } else if (reaction != null && reaction == this.d_active) {
                this.setText(String.format("<html><b>%s (%s)</b>", this.d_nameMapper.apply(reaction), string2));
            } else if (reaction != null && reaction != this.d_active) {
                this.setText(String.format("<html>%s", this.d_nameMapper.apply(reaction)));
            }
            return this;
        }
    }
}

