/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.reaction.NewReactionDlg;
import pyrosim.gui.reaction.ReactionConfigPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class ReactionManagerDlg
extends ManagerDlg<Reaction, ReactionList> {
    private static final long serialVersionUID = -1037669556045030814L;
    private final Action[] d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(Reaction.class), new RenameAction<Reaction, ReactionList>(this, Intl.intl("reaction")), new ManagerDlg.DeleteAction()};
    private final IEditor<Reaction> d_editor = new ReactionConfigPanel();
    private ReactionList d_mgr;
    private ExSpecList d_specs;

    public ReactionManagerDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Edit Reactions"), true);
    }

    private void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(ReactionList reactionList, Reaction reaction, ExSpecList exSpecList) {
        this.d_mgr = reactionList;
        this.d_specs = exSpecList;
        ((RenameAction)this.d_actions[2]).init(reactionList);
        super.init(this.d_mgr, this.d_editor, this.d_actions, reaction);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 4782684556427102237L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ReactionManagerDlg.this.preSave()) {
                return;
            }
            int n = ReactionManagerDlg.this.getList().getSelectedIx();
            Reaction reaction = n > -1 ? (Reaction)ReactionManagerDlg.this.getList().getItem(n) : null;
            NewReactionDlg newReactionDlg = new NewReactionDlg(ReactionManagerDlg.this.d_mgr, reaction, ReactionManagerDlg.this.d_specs);
            if (newReactionDlg.doModal() == 1) {
                String string = newReactionDlg.getName();
                Reaction reaction2 = newReactionDlg.getBaseReac();
                Reaction.ReacType reacType = newReactionDlg.getReacType();
                Reaction reaction3 = new Reaction(string, false, reacType);
                if (newReactionDlg.getFuel() != null) {
                    reaction3.setFuel(newReactionDlg.getFuel());
                }
                if (reaction3.getFuel() == null) {
                    reaction3.setFuel(ExSpecList.getDefaultFuel(true));
                }
                if (reaction2 != null) {
                    reaction3.imprint(reaction2);
                }
                AddTask addTask = new AddTask((IPyroObject)ReactionManagerDlg.this.d_mgr, new IPyroObject[]{reaction3});
                PyroMod pyroMod = (PyroMod)ReactionManagerDlg.this.d_mgr.getDomain();
                SelectTask selectTask = new SelectTask(pyroMod, reaction3);
                selectTask.addTask(addTask);
                if (pyroMod.getReactions().flatten().size() == 0) {
                    selectTask.addTask(pyroMod.getReactions().taskSetActiveReaction(reaction3));
                }
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Reaction"));
                ReactionManagerDlg.this.getList().updateModelView(ReactionManagerDlg.this.d_mgr);
                ReactionManagerDlg.this.getList().select(reaction3);
                ReactionManagerDlg.this.updateActions();
            }
        }
    }
}

