/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.SimParams;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;

public class ReactionConfigPanel
extends guiPanel
implements IEditor<Reaction> {
    private static final long serialVersionUID = 8520540044821832889L;
    private static final String FUEL_LABEL = Intl.intl("Fuel");
    private static final String SUPP_LABEL = Intl.intl("Fire Suppression");
    private static final String PROD_LABEL = Intl.intl("Byproducts");
    private static final String COMPLEX_LABEL = Intl.intl("Complex Chemistry");
    private static final String ADVANCED_LABEL = Intl.intl("Advanced");
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private ReactionList d_reacList;
    private final guiTextField d_fyiFld;
    private final guiComboBox<Reaction.ReacType> d_typeCB;
    private final JTabbedPane d_tabs;
    private final FuelPanel d_fuelPanel;
    private final FireSupPanel d_fireSupPanel;
    private final ByproductsPanel d_byproductsPanel;
    private final ComplexReacEditor d_complexReacPanel;
    private final CustomFDSPanel d_advancedPnl;

    public ReactionConfigPanel() {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_reacList = pyroMod.getReactions();
        this.d_fuelPanel = new FuelPanel();
        this.d_fireSupPanel = new FireSupPanel();
        this.d_byproductsPanel = new ByproductsPanel();
        this.d_complexReacPanel = new ComplexReacEditor(pyroMod.getExSpecList());
        this.d_advancedPnl = new CustomFDSPanel(7);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(FUEL_LABEL, this.d_fuelPanel);
        this.d_tabs.addTab(SUPP_LABEL, this.d_fireSupPanel);
        this.d_tabs.addTab(PROD_LABEL, this.d_byproductsPanel);
        this.d_tabs.addTab(COMPLEX_LABEL, this.d_complexReacPanel);
        this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_fuelPanel, this.d_fireSupPanel, this.d_byproductsPanel, this.d_complexReacPanel, this.d_advancedPnl));
        this.getEditorPanel().setLayout(new GridBagLayout());
        this.d_fyiFld = new guiTextField();
        this.d_typeCB = new guiComboBox();
        this.d_typeCB.setRenderer(ReactionConfigPanel.getReacTypeRenderer());
        this.d_typeCB.addActionListener(actionEvent -> this.updateActivePanels());
        this.d_typeCB.add(Reaction.ReacType.SIMPLE);
        this.d_typeCB.add(Reaction.ReacType.COMPLEX);
        this.d_typeCB.setSelectedItem((Object)Reaction.ReacType.SIMPLE);
        GridBagHelper gridBagHelper = new GridBagHelper(this.getEditorPanel());
        gridBagHelper.addRow(Intl.intl("Description:"), this.d_fyiFld, 1.0);
        gridBagHelper.addRow(Intl.intl("Reaction Type:"), this.d_typeCB, 1.0);
        gridBagHelper.addRow(this.d_tabs, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        gridBagHelper.finalizeRows();
        this.setEnabled(false);
        this.setModified(false);
    }

    private static ListCellRenderer getReacTypeRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof Reaction.ReacType) {
                    this.setText(((Reaction.ReacType)((Object)object)).id);
                }
                return this;
            }
        };
    }

    private void updateActivePanels() {
        this.d_tabs.removeAll();
        if (this.d_typeCB.getSelectedItem().equals((Object)Reaction.ReacType.SIMPLE)) {
            this.d_tabs.addTab(FUEL_LABEL, this.d_fuelPanel);
            this.d_tabs.addTab(SUPP_LABEL, this.d_fireSupPanel);
            this.d_tabs.addTab(PROD_LABEL, this.d_byproductsPanel);
            this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        } else {
            this.d_tabs.addTab(COMPLEX_LABEL, this.d_complexReacPanel);
            this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.d_fyiFld.setEnabled(bl);
        this.d_byproductsPanel.setEnabled(bl);
        this.d_fireSupPanel.setEnabled(bl);
        this.d_fuelPanel.setEnabled(bl);
        this.d_complexReacPanel.setEnabled(bl);
        this.d_advancedPnl.setEnabled(bl);
    }

    @Override
    public Reaction commit(final Reaction reaction) {
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                ReactionConfigPanel.this.saveReaction(reaction, false);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Reaction"));
        this.setModified(false);
        return reaction;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(Reaction reaction) {
        this.setEnabled(reaction != null);
        if (reaction != null) {
            this.loadReactions(reaction);
            this.updateActivePanels();
        }
        this.setModified(false);
    }

    @Override
    public Reaction preview(Reaction reaction) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveReaction(reaction, true);
        return reaction;
    }

    public void loadReactions(Reaction reaction) {
        this.d_fyiFld.setText(reaction.getFYI());
        this.d_typeCB.setSelectedItem((Object)reaction.getReacType());
        this.d_fuelPanel.loadData(reaction);
        this.d_fireSupPanel.loadData(reaction);
        this.d_byproductsPanel.loadData(reaction);
        this.d_complexReacPanel.loadData(reaction);
        this.d_advancedPnl.clear();
        this.d_advancedPnl.load(Collections.singleton(reaction), new CustomFDSPanel.AdvPropWrapper<Boolean>(reaction.isForceWrite(), 1));
    }

    public void saveReaction(Reaction reaction, boolean bl) {
        reaction.setFYI(this.d_fyiFld.getText());
        reaction.setReacType(this.d_typeCB.getSelectedItem());
        if (this.checkShouldSave(this.d_fuelPanel)) {
            this.d_fuelPanel.saveData(reaction, bl);
        }
        if (this.checkShouldSave(this.d_fireSupPanel)) {
            this.d_fireSupPanel.saveData(reaction);
        }
        if (this.checkShouldSave(this.d_byproductsPanel)) {
            this.d_byproductsPanel.saveData(reaction);
        }
        if (this.checkShouldSave(this.d_complexReacPanel)) {
            this.d_complexReacPanel.saveData(reaction);
        }
        this.d_advancedPnl.save(Collections.singleton(reaction));
    }

    private boolean checkShouldSave(guiPanel guiPanel2) {
        return this.d_tabs.indexOfComponent(guiPanel2) != -1;
    }

    private static class ComplexReacEditor
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final ExSpecList d_specList;
        private final guiComboBox<ExSpec> d_fuelCombo;
        private final guiTable d_chemTable;
        private final guiCheckBox d_heatOfCombustionCB;
        private final ValueField<UnitDouble> d_heatOfCombustionVF;
        private static final String OPT_REACTANT = Intl.intl("Reactant");
        private static final String OPT_PRODUCT = Intl.intl("Product");

        public ComplexReacEditor(ExSpecList exSpecList) {
            this.d_specList = exSpecList;
            this.d_fuelCombo = new ExSpecComboBox(exSpecList);
            this.d_heatOfCombustionCB = new guiCheckBox(Intl.intl("Heat of Combustion:"));
            this.d_heatOfCombustionVF = ValueFields.udFld(UnitSystem.getSource(48));
            LinkStatus.link((AbstractButton)this.d_heatOfCombustionCB, this.d_heatOfCombustionVF);
            this.d_chemTable = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Species"), Intl.intl("Type"), Intl.intl("NU")}, new Class[]{ExSpec.class, String.class, Double.class}, 16);
            this.d_chemTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setValue(Object object) {
                    this.setText(object == null ? "" : ((ExSpec)object).getName());
                }
            });
            this.d_chemTable.setColumnEditable(0, false);
            this.d_chemTable.setColumnOptions(1, OPT_REACTANT, OPT_PRODUCT);
            this.d_chemTable.setPreferredScrollableViewportSize(new Dimension(150, 200));
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_heatOfCombustionCB, this.d_heatOfCombustionVF, 1.0);
            gridBagHelper.addRow(Intl.intl("Fuel Species:"), this.d_fuelCombo, 1.0);
            gridBagHelper.addRow(Intl.intl("Stoichiometric Coefficients:"));
            gridBagHelper.addRow(new JScrollPane(this.d_chemTable), new double[]{1.0, 1.0}, new int[]{0, 0});
            gridBagHelper.finalizeRows();
        }

        public void loadData(Reaction reaction) {
            Object object;
            Variant variant = reaction.getHeatOfCombustion();
            if (variant.getType().equals((Object)Variant.Type.DEFAULT)) {
                object = ((PyroSim)Application.getApp()).getUnitSystem().getHeatOfCombustion();
                this.d_heatOfCombustionCB.setSelected(false);
                this.d_heatOfCombustionVF.setValue(new UnitDouble(0.0, (Unit)object));
            } else if (variant.getType().equals((Object)Variant.Type.CONSTANT)) {
                this.d_heatOfCombustionCB.setSelected(true);
                this.d_heatOfCombustionVF.setValue(variant.val);
            }
            this.d_fuelCombo.setSelectedItem(reaction.getFuel());
            object = this.d_specList.flatten().stream().sorted((exSpec, exSpec2) -> exSpec.getName().compareTo(exSpec2.getName())).collect(Collectors.toList());
            this.d_chemTable.clearRows();
            Map<ExSpec, Double> map = reaction.getComplexStoichiometry();
            int n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ExSpec exSpec3 = (ExSpec)iterator.next();
                this.d_chemTable.getModel().setValueAt(exSpec3, n, 0);
                if (map.containsKey(exSpec3)) {
                    Double d = map.get(exSpec3);
                    if (d != null) {
                        String string = d < 0.0 ? OPT_REACTANT : OPT_PRODUCT;
                        double d2 = Math.abs(d);
                        this.d_chemTable.getModel().setValueAt(string, n, 1);
                        this.d_chemTable.getModel().setValueAt(d2, n, 2);
                    } else {
                        this.d_chemTable.getModel().setValueAt(OPT_REACTANT, n, 1);
                        this.d_chemTable.getModel().setValueAt(0.0, n, 2);
                    }
                } else {
                    this.d_chemTable.getModel().setValueAt(OPT_REACTANT, n, 1);
                    this.d_chemTable.getModel().setValueAt(0.0, n, 2);
                }
                ++n;
            }
            if (n > 0) {
                this.d_chemTable.setRowLimit(n);
            } else {
                this.d_chemTable.setRowLimit(1);
            }
            this.setModified(false);
        }

        public void saveData(Reaction reaction) {
            if (this.d_heatOfCombustionCB.isSelected()) {
                reaction.setHeatOfCombustion((UnitDouble)this.d_heatOfCombustionVF.getValue());
            } else {
                reaction.setHeatOfCombustion(null);
            }
            reaction.setFuel(this.d_fuelCombo.getSelectedItem());
            LinkedHashMap<ExSpec, Double> linkedHashMap = new LinkedHashMap<ExSpec, Double>();
            int n = this.d_chemTable.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Double d = (Double)this.d_chemTable.getValueAt(i, 2);
                    if (d == null || d == 0.0) continue;
                    double d2 = d;
                    String string = (String)this.d_chemTable.getValueAt(i, 1);
                    if (string == null) continue;
                    if (string.equals(OPT_REACTANT)) {
                        d2 *= -1.0;
                    }
                    linkedHashMap.put((ExSpec)this.d_chemTable.getValueAt(i, 0), d2);
                }
            }
            reaction.setComplexStoichiometry(linkedHashMap);
        }
    }

    private class ByproductsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1217278318223851207L;
        private guiRadioButton d_epumRB;
        private guiRadioButton d_hocRB;
        private guiCheckBox d_ideal;
        private ValueField<UnitDouble> d_epum;
        private ValueField<UnitDouble> d_hoc;
        private guiCheckBox d_radFracCB;
        private ValueField<Double> d_radFraction;
        private ValueField<Double> d_co;
        private ValueField<Double> d_soot;
        private ValueField<Double> d_hFraction;

        public ByproductsPanel() {
            this.setLayout(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Energy Released") + ":");
            this.d_epumRB = new guiRadioButton(Intl.intl("Specify release per unit mass oxygen") + ":");
            this.d_hocRB = new guiRadioButton(Intl.intl("Specify heat of combustion") + ":");
            this.d_epum = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_hoc = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_radFracCB = new guiCheckBox(Intl.intl("Radiative Fraction:"));
            this.d_radFraction = ValueFields.doubleFld(SimParams.RadiationTransport.RADIATIVE_FRACTION_RANGE);
            this.d_ideal = new guiCheckBox(Intl.intl("<html>Energy is Ideal (does not account for yields of CO, H<sub>2</sub>, or Soot)</html>"));
            this.d_co = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            this.d_soot = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            this.d_hFraction = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("<html>CO Yield (Y<sub>co</sub>):</html>"));
            guiLabel guiLabel4 = new guiLabel(Intl.intl("<html>Soot Yield (Y<sub>s</sub>):</html>"));
            guiLabel guiLabel5 = new guiLabel(Intl.intl("Hydrogen Fraction:"));
            int n = 0;
            GridBagUtil.add(this, guiLabel2, 0, n++, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_epumRB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_epum, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hocRB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hoc, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_radFracCB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_radFraction, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_ideal, 0, n++, 4, 1, 0, 30, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_co, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel4, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_soot, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel5, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hFraction, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_epumRB);
            buttonGroup.add(this.d_hocRB);
            LinkStatus.link((AbstractButton)this.d_epumRB, this.d_epum);
            LinkStatus.link((AbstractButton)this.d_hocRB, this.d_hoc);
            LinkStatus.link((AbstractButton)this.d_radFracCB, this.d_radFraction);
        }

        private void loadData(Reaction reaction) {
            this.d_epum.setValue(reaction.getEpumo2());
            if (reaction.getHeatOfCombustion().getType() == Variant.Type.CONSTANT) {
                this.d_hoc.setValue((UnitDouble)reaction.getHeatOfCombustion().val);
            }
            if (reaction.getEnergyType() == Reaction.EnergyRelease.EPUMO2) {
                this.d_epumRB.setSelected(true);
            } else {
                this.d_hocRB.setSelected(true);
            }
            this.d_ideal.setSelected(reaction.isIdeal());
            Variant variant = reaction.getRadiativeFraction();
            if (variant.getType() == Variant.Type.DEFAULT) {
                this.d_radFracCB.setSelected(false);
                this.d_radFraction.setValue(0.35);
            } else {
                this.d_radFracCB.setSelected(true);
                this.d_radFraction.setValue(((UnitDouble)variant.val).getRawValue());
            }
            this.d_co.setValue(reaction.getCOYield());
            this.d_soot.setValue(reaction.getSootYield());
            this.d_hFraction.setValue(reaction.getSootHFraction());
        }

        public void saveData(Reaction reaction) {
            reaction.setEpumo2((UnitDouble)this.d_epum.getValue());
            reaction.setHeatOfCombustion((UnitDouble)this.d_hoc.getValue());
            if (this.d_epumRB.isSelected()) {
                reaction.setEnergyType(Reaction.EnergyRelease.EPUMO2);
            } else {
                reaction.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
            }
            if (this.d_radFracCB.isSelected()) {
                reaction.setRadiativeFraction(SIUS.newud((Double)this.d_radFraction.getValue(), 28));
            } else {
                reaction.setRadiativeFraction(null);
            }
            reaction.setCOYield((Double)this.d_co.getValue());
            reaction.setSootYield((Double)this.d_soot.getValue());
            reaction.setSootHFraction((Double)this.d_hFraction.getValue());
            reaction.setIdeal(this.d_ideal.isSelected());
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if ((Double)this.d_co.getValue() + (Double)this.d_soot.getValue() > 1.0) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Yield values must add up to one or less."));
                }
                if (bl2) {
                    ReactionConfigPanel.this.d_tabs.setSelectedComponent(ReactionConfigPanel.this.d_byproductsPanel);
                }
                return false;
            }
            return true;
        }
    }

    private class FireSupPanel
    extends guiPanel {
        private static final long serialVersionUID = 7271780612622304827L;
        private guiCheckBox d_fireSupCB;
        private ValueField<UnitDouble> d_critFlameTemp;
        private ValueField<UnitDouble> d_autoIgnitionTemp;

        public FireSupPanel() {
            this.setLayout(new GridBagLayout());
            this.d_fireSupCB = new guiCheckBox(Intl.intl("Enable Fire Suppression"));
            this.d_critFlameTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_critFlameTemp.setNullAllowed(true);
            this.d_autoIgnitionTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_autoIgnitionTemp.setNullAllowed(true);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Critical Flame Temperature:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Autoignition Temperature:"));
            int n = 0;
            GridBagUtil.add(this, this.d_fireSupCB, 0, n, 1, 1, 12, 12, 6, 6, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, new JSeparator(0), 1, n++, 3, 1, 12, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_critFlameTemp, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_autoIgnitionTemp, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, guiLabel2);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, this.d_critFlameTemp);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, guiLabel3);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, this.d_autoIgnitionTemp);
        }

        public void loadData(Reaction reaction) {
            this.d_fireSupCB.setSelected(reaction.allowSuppression());
            this.d_critFlameTemp.setValue(reaction.getCritFlameTemp());
            if (reaction.getAutoIgnitionTemp().getType() == Variant.Type.CONSTANT) {
                this.d_autoIgnitionTemp.setValue((UnitDouble)reaction.getAutoIgnitionTemp().val);
            }
        }

        public void saveData(Reaction reaction) {
            reaction.setSuppression(this.d_fireSupCB.isSelected());
            reaction.setCritFlameTemp((UnitDouble)this.d_critFlameTemp.getValue());
            reaction.setAutoIgnitionTemp((UnitDouble)this.d_autoIgnitionTemp.getValue());
        }
    }

    private class FuelPanel
    extends guiPanel {
        private static final long serialVersionUID = 177924900571047191L;
        private final CardLayout d_specCL;
        private final CardLayout d_compCL;
        private final guiPanel d_specCardPanel;
        private final guiPanel d_compCardPanel;
        private final String DEFAULT = Intl.intl("Simple Chemistry Model");
        private final String PREDEF = Intl.intl("Predefined");
        private final String USERDEF = Intl.intl("User Defined");
        private final String SHOWCOMP = "COMPOSITION";
        private final String SHOWSPEC = "SPECIES";
        private final String SHOWNULL = "BLANK";
        private final guiLabel d_specLab;
        private final guiLabel d_carbonLab;
        private final guiLabel d_hydrogenLab;
        private final guiLabel d_oxygenLab;
        private final guiLabel d_nitrogenLab;
        private final guiComboBox d_fuelTypeCombo;
        private guiComboBox d_specCombo;
        private final JButton d_editSpecs;
        private final ValueField<Double> d_carbon;
        private final ValueField<Double> d_hydrogen;
        private final ValueField<Double> d_oxygen;
        private final ValueField<Double> d_nitrogen;

        public FuelPanel() {
            this.setLayout(new GridBagLayout());
            this.d_specCL = new CardLayout();
            this.d_compCL = new CardLayout();
            guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
            guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
            this.d_specCardPanel = new guiPanel(this.d_specCL);
            this.d_compCardPanel = new guiPanel(this.d_compCL);
            guiPanel guiPanel4 = new guiPanel(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Fuel assumed to contain only C, O, H, and N."));
            guiLabel2.setFont(guiLabel2.getFont().deriveFont(2));
            GridBagUtil.add(guiPanel4, guiLabel2, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(guiPanel4);
            this.d_specCardPanel.add((Component)guiPanel2, "SPECIES");
            this.d_compCardPanel.add((Component)guiPanel3, "COMPOSITION");
            this.d_specCardPanel.add((Component)guiPanel4, "BLANK");
            this.d_compCardPanel.add((Component)new guiPanel(), "BLANK");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Fuel Type:"));
            this.d_specLab = new guiLabel(Intl.intl("Fuel Species:"));
            this.d_fuelTypeCombo = new guiComboBox<Object>((T[])new Object[]{this.DEFAULT, this.PREDEF, this.USERDEF});
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.d_specCombo = new ExSpecComboBox(pyroMod.getExSpecList());
            this.d_specCombo.setPreferredSize(new Dimension(100, this.d_specCombo.getPreferredSize().height));
            this.d_editSpecs = new JButton(Intl.intl("Edit Species") + "...");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof JButton) {
                        Actions.editSpecies((ExSpec)FuelPanel.this.d_specCombo.getSelectedItem());
                    }
                }
            };
            this.d_editSpecs.addActionListener(actionListener);
            this.d_carbon = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_hydrogen = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_oxygen = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_nitrogen = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Composition"));
            this.d_carbonLab = new guiLabel(Intl.intl("Carbon atoms") + ":");
            this.d_hydrogenLab = new guiLabel(Intl.intl("Hydrogen atoms") + ":");
            this.d_oxygenLab = new guiLabel(Intl.intl("Oxygen atoms") + ":");
            this.d_nitrogenLab = new guiLabel(Intl.intl("Nitrogen atoms") + ":");
            this.d_fuelTypeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (FuelPanel.this.d_fuelTypeCombo.getSelectedItem().equals(FuelPanel.this.DEFAULT)) {
                        FuelPanel.this.defaultSelected();
                    } else if (FuelPanel.this.d_fuelTypeCombo.getSelectedItem().equals(FuelPanel.this.PREDEF)) {
                        FuelPanel.this.predefSelected();
                    } else {
                        FuelPanel.this.userDefSelected();
                    }
                }
            });
            int n = 0;
            GridBagUtil.add(guiPanel2, this.d_specLab, 0, n, 1, 1, 0, 0, 0, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_specCombo, 1, n, 1, 1, 0, 0, 0, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_editSpecs, 2, n, 1, 1, 0, 0, 0, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(guiPanel2);
            n = 0;
            GridBagUtil.add(guiPanel3, titleSeparator, 0, n++, 5, 1, 12, 0, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_carbonLab, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_carbon, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_hydrogenLab, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_hydrogen, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_oxygenLab, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_oxygen, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_nitrogenLab, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel3, this.d_nitrogen, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addVerticalGlue(guiPanel3);
            n = 0;
            GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 12, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_fuelTypeCombo, 1, n++, 1, 1, 12, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specCardPanel, 0, n++, 2, 1, 0, 12, 0, 0, 2, 0.0, 0.0, 18);
            GridBagUtil.add(this, this.d_compCardPanel, 0, n, 5, 1, 0, 12, 0, 0, 2, 1.0, 0.0, 18);
            GridBagUtil.addVerticalGlue(this);
        }

        private void defaultSelected() {
            ((PyroComboBox)this.d_specCombo).setFilter(new Predicate<ExSpec>(){

                @Override
                public boolean test(ExSpec exSpec) {
                    return true;
                }
            });
            this.d_compCL.show(this.d_compCardPanel, "COMPOSITION");
            this.d_specCL.show(this.d_specCardPanel, "BLANK");
            this.d_specCombo.setSelectedItem(ExSpecList.getDefaultFuel(false));
        }

        private void predefSelected() {
            ((PyroComboBox)this.d_specCombo).setFilter(new Predicate<ExSpec>(){

                @Override
                public boolean test(ExSpec exSpec) {
                    return ExSpecList.isPredefinedSpecies(exSpec.getName());
                }
            });
            this.d_specCL.show(this.d_specCardPanel, "SPECIES");
            this.d_compCL.show(this.d_compCardPanel, "BLANK");
        }

        private void userDefSelected() {
            ((PyroComboBox)this.d_specCombo).setFilter(new Predicate<ExSpec>(){

                @Override
                public boolean test(ExSpec exSpec) {
                    return !ExSpecList.isPredefinedSpecies(exSpec.getName()) && exSpec.getType() != 4;
                }
            });
            this.d_compCL.show(this.d_compCardPanel, "COMPOSITION");
            this.d_specCL.show(this.d_specCardPanel, "SPECIES");
        }

        public void loadData(Reaction reaction) {
            if (reaction.getFuel() == null || reaction.getFuel().getType() == 4) {
                this.d_fuelTypeCombo.setSelectedItem(this.DEFAULT);
                this.defaultSelected();
            } else if (ExSpecList.isPredefinedSpecies(reaction.getFuel().getName())) {
                this.d_fuelTypeCombo.setSelectedItem(this.PREDEF);
                this.predefSelected();
            } else {
                this.d_fuelTypeCombo.setSelectedItem(this.USERDEF);
                this.userDefSelected();
            }
            this.d_specCombo.setSelectedItem(reaction.getFuel());
            this.d_carbon.setValue(reaction.getC());
            this.d_hydrogen.setValue(reaction.getH());
            this.d_oxygen.setValue(reaction.getO());
            this.d_nitrogen.setValue(reaction.getN());
        }

        public void saveData(Reaction reaction, boolean bl) {
            if (this.d_fuelTypeCombo.getSelectedItem().equals(this.DEFAULT)) {
                reaction.setFuel(ExSpecList.getDefaultFuel(!bl));
            } else {
                ExSpec exSpec = (ExSpec)this.d_specCombo.getSelectedItem();
                reaction.setFuel(exSpec);
            }
            if (!this.d_fuelTypeCombo.getSelectedItem().equals(this.PREDEF)) {
                reaction.setC((Double)this.d_carbon.getValue());
                reaction.setH((Double)this.d_hydrogen.getValue());
                reaction.setO((Double)this.d_oxygen.getValue());
                reaction.setN((Double)this.d_nitrogen.getValue());
            } else {
                reaction.setFuelComp(0.0, 0.0, 0.0, 0.0);
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            boolean bl3 = true;
            if (bl && !(bl3 = Actions.isValidSpecies((ExSpec)this.d_specCombo.getSelectedItem()))) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Must select a valid Species."));
                return false;
            }
            return bl3 && super.validateData(bl, bl2);
        }
    }
}

