/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.comboboxes.ReactionComboBox;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class NewReactionDlg
extends guiDialog {
    private static final long serialVersionUID = -2361461368515213155L;
    private ReactionList d_reacList = null;
    private guiTextField d_name = null;
    private guiComboBox<Reaction> d_baseReac = null;
    private guiComboBox<Reaction.ReacType> d_reacType = null;
    private guiLabel d_fuelLbl = null;
    private guiComboBox<ExSpec> d_fuelSpec = null;

    public NewReactionDlg(ReactionList reactionList, Reaction reaction, ExSpecList exSpecList) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Reaction"), 9);
        this.d_reacList = reactionList;
        this.d_baseReac = this.getReacCombo(this.d_reacList, reaction);
        this.d_reacType = new guiComboBox();
        this.d_reacType.addItem((Reaction.ReacType)Reaction.ReacType.SIMPLE);
        this.d_reacType.addItem((Reaction.ReacType)Reaction.ReacType.COMPLEX);
        this.d_reacType.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof Reaction.ReacType) {
                    this.setText(((Reaction.ReacType)((Object)object)).id);
                }
                return this;
            }
        });
        this.d_fuelLbl = new guiLabel(Intl.intl("Fuel Species:"));
        this.d_fuelSpec = new ExSpecComboBox(exSpecList);
        this.d_fuelLbl.setVisible(false);
        this.d_fuelSpec.setVisible(false);
        this.d_reacType.addItemListener(itemEvent -> {
            boolean bl = this.d_reacType.getSelectedItem().equals((Object)Reaction.ReacType.COMPLEX);
            this.d_fuelLbl.setVisible(bl);
            this.d_fuelSpec.setVisible(bl);
        });
        this.d_name = new guiTextField(this.generateUniqueName());
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Reaction Name") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_name, 1, n++, 1, 1, 0, 0, 6, 0);
        if (!this.d_reacList.flatten().isEmpty()) {
            guiRadioButton guiRadioButton2 = new guiRadioButton(Intl.intl("Reaction Type:"));
            GridBagUtil.add(guiPanel2, guiRadioButton2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_reacType, 1, n++, 1, 1, 0, 0, 6, 0);
            GridBagUtil.add(guiPanel2, this.d_fuelLbl, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_fuelSpec, 1, n++, 1, 1, 0, 0, 6, 0);
            guiRadioButton guiRadioButton3 = new guiRadioButton(Intl.intl("Template Reaction:"));
            GridBagUtil.add(guiPanel2, guiRadioButton3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_baseReac, 1, n++, 1, 1, 0, 0, 6, 0);
            LinkStatus.link((AbstractButton)guiRadioButton3, this.d_baseReac);
            LinkStatus.link((AbstractButton)guiRadioButton2, this.d_reacType, this.d_fuelSpec);
            new guiButtonGroup(guiRadioButton3, guiRadioButton2);
            guiRadioButton2.setSelected(true);
        } else {
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Reaction Type:"));
            GridBagUtil.add(guiPanel2, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_reacType, 1, n++, 1, 1, 0, 0, 6, 0);
            GridBagUtil.add(guiPanel2, this.d_fuelLbl, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_fuelSpec, 1, n++, 1, 1, 0, 0, 6, 0);
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        String string = this.d_name.getText();
        if (this.nameInUse(string)) {
            String string2 = Intl.intl("Reaction name already in use.\nEach reaction must have a unique name.");
            this.showMessageBox(string2);
            this.requestFocusHack();
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            String string3 = Intl.intl("You must name the reaction.");
            this.showMessageBox(string3);
            this.requestFocusHack();
            return false;
        }
        if (this.d_fuelSpec.isEnabled() && this.d_fuelSpec.isVisible() && this.d_fuelSpec.getSelectedItem() == null) {
            String string4 = Intl.intl("Cannot create a complex reaction without a fuel species. Add a fuel species to proceed.");
            this.showMessageBox(string4);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private guiComboBox<Reaction> getReacCombo(ReactionList reactionList, Reaction reaction) {
        ReactionComboBox reactionComboBox = new ReactionComboBox(reactionList, reaction);
        return reactionComboBox;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    public Reaction getBaseReac() {
        if (this.d_reacList.flatten().isEmpty()) {
            return null;
        }
        if (this.d_baseReac.isEnabled()) {
            return this.d_baseReac.getSelectedItem();
        }
        return null;
    }

    public Reaction.ReacType getReacType() {
        if (!this.d_reacType.isEnabled()) {
            return null;
        }
        return this.d_reacType.getSelectedItem();
    }

    public ExSpec getFuel() {
        if (!this.d_fuelSpec.isVisible() || !this.d_fuelSpec.isEnabled()) {
            return null;
        }
        return this.d_fuelSpec.getSelectedItem();
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_reacList.getDomain()).getNames(Reaction.class).generateName();
    }

    private boolean nameInUse(String string) {
        return ((PyroMod)this.d_reacList.getDomain()).getNames(Reaction.class).isRegistered(string);
    }
}

