/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.particle;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.particle.PartDescCombo;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;

public class ParticleParamPanel
extends guiPanel
implements IEditor<Particle> {
    private static final long serialVersionUID = 3131792268053380236L;
    private final guiTextField d_fyi;
    private final ControlSelPnl d_ctrl;
    private final JTabbedPane d_tabs;
    private final guiDialog d_parent;
    private final ParticleList d_partList;
    private final PartDescCombo d_particleCombo;
    private DropletsPanel d_dropletsPanel;
    private InjectionPanel d_injectionPanel;
    private SizeDistributionPanel d_sizeDistPanel;
    private LiquidPropsPanel d_liquidPropsPanel;
    private SolidPropsPanel d_solidPropsPanel;
    private DragPropsPanel d_dragPropsPanel;
    private TracerPropsPanel d_tracerPropsPanel;
    private CustomFDSPanel d_advancedPnl;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private final String LIQUID = Intl.intl("Liquid");
    private final String SOLID = Intl.intl("Solid");
    private final String DRAG = Intl.intl("Drag");
    private final String COLORING = Intl.intl("Coloring");
    private final String SIZE_DISTRIBUTION = Intl.intl("Size Distribution");
    private final String PROPERTIES = Intl.intl("Tracer");
    private final String INJECTION = Intl.intl("Injection");
    private final String ADVANCED = Intl.intl("Advanced");

    public ParticleParamPanel(guiDialog guiDialog2) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_partList = pyroMod.getPartList();
        this.setLayout(new GridBagLayout());
        this.d_parent = guiDialog2;
        this.d_fyi = new guiTextField();
        this.d_ctrl = new ControlSelPnl(pyroMod.getControls());
        this.d_dropletsPanel = new DropletsPanel();
        this.d_injectionPanel = new InjectionPanel();
        this.d_sizeDistPanel = new SizeDistributionPanel();
        this.d_liquidPropsPanel = new LiquidPropsPanel();
        this.d_solidPropsPanel = new SolidPropsPanel();
        this.d_dragPropsPanel = new DragPropsPanel();
        this.d_tracerPropsPanel = new TracerPropsPanel();
        this.d_advancedPnl = new CustomFDSPanel(7);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(this.COLORING, this.d_dropletsPanel);
        this.d_tabs.addTab(this.LIQUID, this.d_liquidPropsPanel);
        this.d_tabs.addTab(this.SOLID, this.d_solidPropsPanel);
        this.d_tabs.addTab(this.SIZE_DISTRIBUTION, this.d_sizeDistPanel);
        this.d_tabs.addTab(this.INJECTION, this.d_injectionPanel);
        this.d_tabs.addTab(this.ADVANCED, this.d_advancedPnl);
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_dropletsPanel, this.d_injectionPanel, this.d_liquidPropsPanel, this.d_solidPropsPanel, this.d_tracerPropsPanel, this.d_advancedPnl));
        this.d_particleCombo = new PartDescCombo();
        this.d_particleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ParticleParamPanel.this.updateTabs();
            }
        });
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        gridBagHelper.addRow(Intl.intl("Description:"), this.d_fyi, 1.0, 0);
        this.d_ctrl.add(gridBagHelper);
        gridBagHelper.addRow(Intl.intl("Particle Type:"), this.d_particleCombo, 0);
        gridBagHelper.addRow(this.d_tabs, new double[]{1.0, 1.0}, new int[]{0, 0});
        gridBagHelper.finalizeRows();
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public Particle commit(final Particle particle) {
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                ParticleParamPanel.this.saveParticle(particle, false);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Particle"));
        this.setModified(false);
        return particle;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(Particle particle) {
        this.setEnabled(particle != null);
        this.clearPanels();
        if (particle != null) {
            this.loadParticle(particle);
        }
        this.setModified(false);
    }

    @Override
    public Particle preview(Particle particle) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveParticle(particle, true);
        return particle;
    }

    private void updateTabs() {
        String string = (String)this.d_particleCombo.getSelectedItem();
        this.d_tabs.removeAll();
        if (string == PartDescCombo.LIQUID) {
            this.d_tabs.addTab(this.LIQUID, this.d_liquidPropsPanel);
            this.d_tabs.addTab(this.SIZE_DISTRIBUTION, this.d_sizeDistPanel);
            this.d_tabs.addTab(this.COLORING, this.d_dropletsPanel);
            this.d_tabs.addTab(this.INJECTION, this.d_injectionPanel);
        } else if (string == PartDescCombo.MASSLESS_TRACER) {
            this.d_tabs.addTab(this.PROPERTIES, this.d_tracerPropsPanel);
        } else if (string == PartDescCombo.SOLID) {
            this.d_tabs.addTab(this.SOLID, this.d_solidPropsPanel);
            this.d_tabs.addTab(this.DRAG, this.d_dragPropsPanel);
            this.d_tabs.addTab(this.COLORING, this.d_dropletsPanel);
            this.d_tabs.addTab(this.INJECTION, this.d_injectionPanel);
        } else {
            this.d_tabs.addTab(this.PROPERTIES, new guiPanel());
        }
        this.d_tabs.addTab(this.ADVANCED, this.d_advancedPnl);
    }

    private void loadParticle(Particle particle) {
        this.d_fyi.setText(particle.getFYI());
        this.d_ctrl.setSourceObjs(Arrays.asList(particle));
        this.d_ctrl.load(Arrays.asList((OneLogicInPin)particle.getInputPin()));
        this.d_sizeDistPanel.loadData(particle);
        this.d_dragPropsPanel.loadData(particle);
        this.d_dropletsPanel.loadColorPanel(particle.getColoring());
        this.d_injectionPanel.loadOutput(particle.getOutput());
        this.d_liquidPropsPanel.loadData(particle.getSpecies(), particle.isStatic());
        this.d_solidPropsPanel.loadData(particle.getSurface(), particle.isStatic());
        this.d_tracerPropsPanel.loadData(particle.getOutput(), particle.getColoring());
        this.d_particleCombo.initDesc(particle.getType());
        this.d_advancedPnl.clear();
        this.d_advancedPnl.load(Collections.singleton(particle), new CustomFDSPanel.AdvPropWrapper<Boolean>(particle.isForceWrite(), 1));
    }

    private void clearPanels() {
        this.d_fyi.setText("");
        this.d_sizeDistPanel.loadData(null);
        this.d_dropletsPanel.loadColorPanel(null);
        this.d_injectionPanel.loadOutput(null);
        this.d_liquidPropsPanel.loadData(null, null);
        this.d_solidPropsPanel.loadData(null, null);
        this.d_tracerPropsPanel.loadData(null, null);
        this.d_advancedPnl.clear();
    }

    private void saveParticle(Particle particle, boolean bl) {
        particle.setFYI(this.d_fyi.getText());
        this.d_ctrl.save(Arrays.asList((OneLogicInPin)particle.getInputPin()));
        String string = (String)this.d_particleCombo.getSelectedItem();
        if (string == PartDescCombo.MASSLESS_TRACER) {
            particle.setType(Particle.Type.TRACER);
            particle.setColoring(this.d_tracerPropsPanel.getColoring());
            particle.setOutput(this.d_tracerPropsPanel.getOutput());
        } else if (string == PartDescCombo.LIQUID) {
            particle.setType(Particle.Type.LIQUID);
            this.d_sizeDistPanel.saveData(particle);
            this.d_liquidPropsPanel.saveData(particle, bl);
            particle.setColoring(this.d_dropletsPanel.saveIColoring());
            particle.setOutput(this.d_injectionPanel.saveOutput());
        } else if (string == PartDescCombo.SOLID) {
            particle.setType(Particle.Type.SOLID);
            this.d_dragPropsPanel.saveData(particle);
            particle.setSurface(this.d_solidPropsPanel.getSurf());
            particle.setStatic(this.d_solidPropsPanel.getStatic());
            particle.setColoring(this.d_dropletsPanel.saveIColoring());
            particle.setOutput(this.d_injectionPanel.saveOutput());
        }
        this.d_advancedPnl.save(Collections.singleton(particle));
    }

    private class ColorPanel
    extends guiPanel {
        private static final long serialVersionUID = -7265518323123983717L;
        private ColorButton d_colorButton;
        private guiRadioButton d_defaultRB;
        private guiRadioButton d_specifyRB;
        private guiRadioButton d_byDropletRB;
        private guiCheckBox d_ageCB;
        private guiCheckBox d_tempCB;
        private guiCheckBox d_diamCB;
        private guiCheckBox d_velCB;
        private guiCheckBox d_massCB;

        public ColorPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_colorButton = new ColorButton();
            this.d_colorButton.setMinimumSize(this.d_colorButton.getPreferredSize());
            this.d_defaultRB = new guiRadioButton(Intl.intl("Default"));
            this.d_defaultRB.setSelected(true);
            this.d_specifyRB = new guiRadioButton(Intl.intl("Specify") + ":");
            this.d_byDropletRB = new guiRadioButton(Intl.intl("By Droplet Property") + ":");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_defaultRB);
            buttonGroup.add(this.d_specifyRB);
            buttonGroup.add(this.d_byDropletRB);
            this.d_ageCB = new guiCheckBox(Intl.intl("Age"));
            this.d_tempCB = new guiCheckBox(Intl.intl("Temperature"));
            this.d_diamCB = new guiCheckBox(Intl.intl("Diameter"));
            this.d_velCB = new guiCheckBox(Intl.intl("Velocity"));
            this.d_massCB = new guiCheckBox(Intl.intl("Mass"));
            guiPanel guiPanel2 = new guiPanel();
            guiPanel2.setLayout(new GridLayout(2, 3));
            guiPanel2.add(this.d_ageCB);
            guiPanel2.add(this.d_velCB);
            guiPanel2.add(this.d_tempCB);
            guiPanel2.add(this.d_massCB);
            guiPanel2.add(this.d_diamCB);
            GridBagUtil.add(this, this.d_defaultRB, 0, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specifyRB, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_colorButton, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_byDropletRB, 0, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiPanel2, 0, n++, 2, 1, 0, 12, 6, 0, 0, 1.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_byDropletRB, guiPanel2);
            LinkStatus.link((AbstractButton)this.d_specifyRB, this.d_colorButton);
        }

        public void loadData(IColoring iColoring) {
            this.d_ageCB.setSelected(false);
            this.d_tempCB.setSelected(false);
            this.d_diamCB.setSelected(false);
            this.d_velCB.setSelected(false);
            this.d_massCB.setSelected(false);
            this.d_colorButton.setColor(this.getBackground());
            if (iColoring instanceof ConstColoring) {
                this.d_colorButton.setColor(((ConstColoring)iColoring).color);
                this.d_specifyRB.setSelected(true);
            } else if (iColoring instanceof DropletColoring) {
                DropletColoring dropletColoring = (DropletColoring)iColoring;
                this.d_byDropletRB.setSelected(true);
                this.d_ageCB.setSelected(dropletColoring.d_properties.contains(4));
                this.d_tempCB.setSelected(dropletColoring.d_properties.contains(0));
                this.d_diamCB.setSelected(dropletColoring.d_properties.contains(1));
                this.d_velCB.setSelected(dropletColoring.d_properties.contains(2));
                this.d_massCB.setSelected(dropletColoring.d_properties.contains(3));
            } else {
                this.d_defaultRB.setSelected(true);
            }
        }

        public IColoring saveData() {
            if (this.d_specifyRB.isSelected()) {
                return new ConstColoring(this.d_colorButton.getColor());
            }
            if (this.d_byDropletRB.isSelected()) {
                LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>(5);
                if (this.d_tempCB.isSelected()) {
                    linkedHashSet.add(0);
                }
                if (this.d_diamCB.isSelected()) {
                    linkedHashSet.add(1);
                }
                if (this.d_velCB.isSelected()) {
                    linkedHashSet.add(2);
                }
                if (this.d_massCB.isSelected()) {
                    linkedHashSet.add(3);
                }
                if (this.d_ageCB.isSelected()) {
                    linkedHashSet.add(4);
                }
                return new DropletColoring(linkedHashSet);
            }
            return null;
        }
    }

    private class SizeDistributionPanel
    extends guiPanel {
        private static final long serialVersionUID = 4627992393007325702L;
        private ValueField<UnitDouble> d_medDiameter;
        private ValueField<UnitDouble> d_minDiameter;
        private ValueField<UnitDouble> d_maxDiameter;
        private ValueField<Double> d_sigma;
        private ValueField<Double> d_gamma;
        private final guiLabel d_medDiameterLbl;
        private guiComboBox d_distributionCB;
        private final String CONST = Intl.intl("Constant");
        private final String ROSIN = Intl.intl("Rosin-Rammler ");
        private final String LOGNORMAL = Intl.intl("Lognormal");
        private final String ROSINLOGNORMAL = Intl.intl("Rosin-Rammler-Lognormal");

        public SizeDistributionPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_medDiameterLbl = new guiLabel(Intl.intl("Median Diameter:"));
            final guiLabel guiLabel2 = new guiLabel(Intl.intl("Minimum Diameter:"));
            final guiLabel guiLabel3 = new guiLabel(Intl.intl("Maximum Diameter:"));
            final guiLabel guiLabel4 = new guiLabel(Intl.intl("Sigma D:"));
            final guiLabel guiLabel5 = new guiLabel(Intl.intl("Gamma D:"));
            Unit unit = ParticleParamPanel.this.d_currentUS.getUnit(61);
            UnitDoubleVR unitDoubleVR = UnitDoubleVR.above(new UnitDouble(0.0, unit), false);
            this.d_medDiameter = ValueFields.udFld(UnitSystem.getSource(90), unitDoubleVR);
            this.d_medDiameter.setNullAllowed(true);
            this.d_minDiameter = ValueFields.udFld(UnitSystem.getSource(90), unitDoubleVR);
            this.d_maxDiameter = ValueFields.udFld(UnitSystem.getSource(90), unitDoubleVR);
            ValueFields.getFormat(this.d_maxDiameter).alias(new UnitDouble(Double.POSITIVE_INFINITY, unit), "Infinity");
            this.d_sigma = ValueFields.doubleFld();
            this.d_gamma = ValueFields.doubleFld();
            guiLabel guiLabel6 = new guiLabel(Intl.intl("Distribution:"));
            this.d_distributionCB = new guiComboBox<String>((T[])new String[]{this.CONST, this.ROSIN, this.LOGNORMAL, this.ROSINLOGNORMAL});
            this.d_distributionCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        return;
                    }
                    if (SizeDistributionPanel.this.d_distributionCB.getSelectedItem().equals(SizeDistributionPanel.this.CONST)) {
                        SizeDistributionPanel.this.d_sigma.setEnabled(false);
                        guiLabel4.setEnabled(false);
                        SizeDistributionPanel.this.d_gamma.setEnabled(false);
                        guiLabel5.setEnabled(false);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(false);
                        guiLabel2.setEnabled(false);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(false);
                        guiLabel3.setEnabled(false);
                    } else if (SizeDistributionPanel.this.d_distributionCB.getSelectedItem().equals(SizeDistributionPanel.this.ROSIN)) {
                        SizeDistributionPanel.this.d_sigma.setEnabled(false);
                        guiLabel4.setEnabled(false);
                        SizeDistributionPanel.this.d_gamma.setEnabled(true);
                        guiLabel5.setEnabled(true);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(true);
                        guiLabel2.setEnabled(true);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(true);
                        guiLabel3.setEnabled(true);
                    } else if (SizeDistributionPanel.this.d_distributionCB.getSelectedItem().equals(SizeDistributionPanel.this.LOGNORMAL)) {
                        SizeDistributionPanel.this.d_sigma.setEnabled(true);
                        guiLabel4.setEnabled(true);
                        SizeDistributionPanel.this.d_gamma.setEnabled(false);
                        guiLabel5.setEnabled(false);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(true);
                        guiLabel2.setEnabled(true);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(true);
                        guiLabel3.setEnabled(true);
                    } else {
                        SizeDistributionPanel.this.d_sigma.setEnabled(false);
                        guiLabel4.setEnabled(false);
                        SizeDistributionPanel.this.d_gamma.setEnabled(true);
                        guiLabel5.setEnabled(true);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(true);
                        guiLabel2.setEnabled(true);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(true);
                        guiLabel3.setEnabled(true);
                    }
                }
            });
            GridBagUtil.add(this, this.d_medDiameterLbl, 0, n, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_medDiameter, 1, n++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel6, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_distributionCB, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_minDiameter, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_maxDiameter, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel4, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_sigma, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel5, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_gamma, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            UnitDouble unitDouble;
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            UnitDouble unitDouble2 = (UnitDouble)this.d_maxDiameter.getValue();
            if (unitDouble2.compareTo(unitDouble = (UnitDouble)this.d_minDiameter.getValue()) < 0) {
                if (bl) {
                    JOptionPane.showMessageDialog(ParticleParamPanel.this, Intl.intl("The minimum diameter must be less than or equal to the maximum diameter."), Intl.intl("Diameter Range Error"), 0);
                }
                if (bl2) {
                    this.d_minDiameter.grabFocus();
                }
                return false;
            }
            return true;
        }

        public void loadData(Particle particle) {
            if (particle == null) {
                this.d_distributionCB.setSelectedItem(null);
                return;
            }
            if (particle.getType() != Particle.Type.SOLID) {
                this.d_medDiameter.setEnabled(true);
                this.d_medDiameterLbl.setEnabled(true);
                if (particle.getDiameter().getType() == Variant.Type.CONSTANT) {
                    this.d_medDiameter.setValue((UnitDouble)particle.getDiameter().val);
                }
            } else {
                this.d_medDiameter.setValue(null);
                this.d_medDiameter.setEnabled(false);
                this.d_medDiameterLbl.setEnabled(false);
            }
            this.d_minDiameter.setValue(particle.getMinDiameter());
            this.d_maxDiameter.setValue(particle.getMaxDiameter());
            this.d_sigma.setValue(0.0);
            if (particle.getSigmaD() != null) {
                this.d_sigma.setValue(particle.getSigmaD());
            }
            this.d_gamma.setValue(particle.getGammaD());
            if (particle.getDistribution() == Particle.Distribution.CONST) {
                this.d_distributionCB.setSelectedItem(this.CONST);
            } else if (particle.getDistribution() == Particle.Distribution.ROSIN) {
                this.d_distributionCB.setSelectedItem(this.ROSIN);
            } else if (particle.getDistribution() == Particle.Distribution.LOGNORMAL) {
                this.d_distributionCB.setSelectedItem(this.LOGNORMAL);
            } else {
                this.d_distributionCB.setSelectedItem(this.ROSINLOGNORMAL);
            }
        }

        public void saveData(Particle particle) {
            if (this.d_distributionCB.getSelectedItem().equals(this.CONST)) {
                particle.setConstDistribution((UnitDouble)this.d_medDiameter.getValue());
            } else if (this.d_distributionCB.getSelectedItem().equals(this.ROSIN)) {
                particle.setRosinRammler((UnitDouble)this.d_medDiameter.getValue(), (UnitDouble)this.d_minDiameter.getValue(), (UnitDouble)this.d_maxDiameter.getValue(), (Double)this.d_gamma.getValue());
            } else if (this.d_distributionCB.getSelectedItem().equals(this.LOGNORMAL)) {
                particle.setLognormal((UnitDouble)this.d_medDiameter.getValue(), (UnitDouble)this.d_minDiameter.getValue(), (UnitDouble)this.d_maxDiameter.getValue(), (Double)this.d_sigma.getValue());
            } else if (this.d_distributionCB.getSelectedItem().equals(this.ROSINLOGNORMAL)) {
                particle.setRosinRammlerLognormal((UnitDouble)this.d_medDiameter.getValue(), (UnitDouble)this.d_minDiameter.getValue(), (UnitDouble)this.d_maxDiameter.getValue(), (Double)this.d_gamma.getValue());
            }
        }
    }

    private class DropletsPanel
    extends guiPanel {
        private static final long serialVersionUID = -4557273216401335452L;
        private ColorPanel d_colorPanel;

        public DropletsPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_colorPanel = new ColorPanel();
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Color"));
            GridBagUtil.add(this, titleSeparator, 0, n++, 1, 1, 12, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_colorPanel, 0, n++, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadColorPanel(IColoring iColoring) {
            this.d_colorPanel.loadData(iColoring);
        }

        public IColoring saveIColoring() {
            return this.d_colorPanel.saveData();
        }
    }

    private class OutputPanel
    extends guiPanel {
        private static final long serialVersionUID = 1855642288511461510L;
        private ValueField<UnitDouble> d_duration;
        private ValueField<Integer> d_samplingFactor;

        public OutputPanel() {
            this.setLayout(new GridBagLayout());
            int n = 1;
            this.d_duration = ValueFields.udFld(UnitSystem.getSource(2));
            this.d_samplingFactor = ValueFields.intFld();
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Duration") + ":");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Sampling Factor") + ":");
            GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_duration, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_samplingFactor, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(Output output) {
            Output output2 = new Output(10);
            this.d_duration.setValue(output2.d_age);
            this.d_samplingFactor.setValue(output2.d_samplingFactor);
            if (output == null) {
                return;
            }
            this.d_duration.setValue(output.d_age);
            this.d_samplingFactor.setValue(output.d_samplingFactor);
        }

        public Output saveData() {
            return new Output((UnitDouble)this.d_duration.getValue(), (Integer)this.d_samplingFactor.getValue());
        }
    }

    private class TracerPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 390889945969660698L;
        private OutputPanel d_outputPanel;
        private ColorButton d_colorButton;
        private guiCheckBox d_colorCB;

        public TracerPropsPanel() {
            this.setLayout(new GridBagLayout());
            this.d_outputPanel = new OutputPanel();
            this.d_colorButton = new ColorButton();
            this.d_colorButton.setMinimumSize(this.d_colorButton.getPreferredSize());
            this.d_colorCB = new guiCheckBox(Intl.intl("Color") + ":");
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_colorCB, this.d_colorButton, 0);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Injection")));
            gridBagHelper.indent();
            gridBagHelper.addFilledRow(this.d_outputPanel);
            gridBagHelper.finalizeRows();
            LinkStatus.link((AbstractButton)this.d_colorCB, this.d_colorButton);
        }

        public void loadData(Output output, IColoring iColoring) {
            if (iColoring != null && iColoring instanceof ConstColoring) {
                this.d_colorButton.setColor(((ConstColoring)iColoring).color);
                this.d_colorCB.setSelected(true);
            } else {
                this.d_colorButton.setColor(this.getBackground());
                this.d_colorCB.setSelected(false);
            }
            this.d_outputPanel.loadData(output);
        }

        public IColoring getColoring() {
            if (this.d_colorCB.isSelected()) {
                return new ConstColoring(this.d_colorButton.getColor());
            }
            return null;
        }

        public Output getOutput() {
            return this.d_outputPanel.saveData();
        }
    }

    private class DragPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = -1513256999197008249L;
        private guiRadioButton d_cylinderDragRB;
        private guiRadioButton d_screenDragRB;
        private guiRadioButton d_sphereDragRB;
        private guiRadioButton d_coefDragRB;
        private ValueField<Double> d_dragCoef;
        private ValueField<UnitDouble> d_denseVolFrac;

        public DragPropsPanel() {
            this.setLayout(new GridBagLayout());
            this.d_cylinderDragRB = new guiRadioButton(Intl.intl("Cylinder"));
            this.d_screenDragRB = new guiRadioButton(Intl.intl("Screen"));
            this.d_sphereDragRB = new guiRadioButton(Intl.intl("Sphere"));
            this.d_coefDragRB = new guiRadioButton(Intl.intl("Specify Drag Coefficient"));
            this.d_dragCoef = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_denseVolFrac = ValueFields.udFld(DoubleVR.between(0.0, 1.0, true, true), SIUS.unit(87), UnitSystem.getSource(87));
            new guiButtonGroup(this.d_cylinderDragRB, this.d_screenDragRB, this.d_sphereDragRB, this.d_coefDragRB);
            LinkStatus.link((AbstractButton)this.d_coefDragRB, this.d_dragCoef);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Drag Options")));
            gridBagHelper.indent();
            gridBagHelper.addRow(this.d_sphereDragRB);
            gridBagHelper.addRow(this.d_cylinderDragRB);
            gridBagHelper.addRow(this.d_screenDragRB);
            gridBagHelper.addRow(this.d_coefDragRB, this.d_dragCoef);
            gridBagHelper.addRow(new guiLabel(Intl.intl("Dense Volume Fraction")), this.d_denseVolFrac);
            gridBagHelper.finalizeRows();
        }

        public void loadData(Particle particle) {
            this.d_dragCoef.setValue(0.0);
            if (particle.getDragType() == Particle.Drag.CYLINDER) {
                this.d_cylinderDragRB.setSelected(true);
            } else if (particle.getDragType() == Particle.Drag.SPHERE) {
                this.d_sphereDragRB.setSelected(true);
            } else if (particle.getDragType() == Particle.Drag.SCREEN) {
                this.d_screenDragRB.setSelected(true);
            } else if (particle.getDragType() == Particle.Drag.COEF) {
                this.d_coefDragRB.setSelected(true);
                this.d_dragCoef.setValue(particle.getDragCoef());
            }
            this.d_denseVolFrac.setValue(new UnitDouble(particle.getDenseVolumeFraction(), ParticleParamPanel.this.d_currentUS.getUnit(87)));
        }

        public void saveData(Particle particle) {
            particle.setDenseVolumeFraction(((UnitDouble)this.d_denseVolFrac.getValue()).getValueNoUnit());
            if (this.d_cylinderDragRB.isSelected()) {
                particle.setDrag(Particle.Drag.CYLINDER);
            } else if (this.d_sphereDragRB.isSelected()) {
                particle.setDrag(Particle.Drag.SPHERE);
            } else if (this.d_screenDragRB.isSelected()) {
                particle.setDrag(Particle.Drag.SCREEN);
            } else if (this.d_coefDragRB.isSelected()) {
                particle.setDrag(Particle.Drag.COEF);
                particle.setDragCoef((Double)this.d_dragCoef.getValue());
            } else assert (false);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2);
        }
    }

    private class SolidPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 8213330190161215232L;
        private final guiComboBox d_surfCombo;
        private final MovementPanel d_movementPnl;

        public SolidPropsPanel() {
            this.setLayout(new GridBagLayout());
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.d_surfCombo = new SurfaceComboBox(pyroMod.getSurfaceMgr(), null);
            JButton jButton = new JButton(Intl.intl("Edit Surfaces") + "...");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof JButton) {
                        Actions.editSurfaces((Surface)SolidPropsPanel.this.d_surfCombo.getSelectedItem());
                    }
                }
            };
            jButton.addActionListener(actionListener);
            this.d_movementPnl = new MovementPanel();
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(Intl.intl("Surface:"), this.d_surfCombo, jButton);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Movement")));
            gridBagHelper.indent();
            gridBagHelper.addFilledRow(this.d_movementPnl);
            gridBagHelper.finalizeRows();
        }

        public void loadData(Surface surface, Boolean bl) {
            this.d_surfCombo.setSelectedItem(surface);
            this.d_movementPnl.setStatic(bl);
        }

        public Surface getSurf() {
            return (Surface)this.d_surfCombo.getSelectedItem();
        }

        public Boolean getStatic() {
            return this.d_movementPnl.isStatic();
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (this.getSurf() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Must select a valid Surface."));
                }
                return false;
            }
            return super.validateData(bl, bl2);
        }
    }

    private class LiquidPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 7274442464895531032L;
        private final guiComboBox d_specCombo;
        private final MovementPanel d_movementPnl;

        public LiquidPropsPanel() {
            this.setLayout(new GridBagLayout());
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.d_specCombo = new ExSpecComboBox(pyroMod.getExSpecList());
            this.d_specCombo.setPreferredSize(new Dimension(100, this.d_specCombo.getPreferredSize().height));
            JButton jButton = new JButton(Intl.intl("Edit Species") + "...");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof JButton) {
                        Actions.editSpecies((ExSpec)LiquidPropsPanel.this.d_specCombo.getSelectedItem());
                    }
                }
            };
            jButton.addActionListener(actionListener);
            this.d_movementPnl = new MovementPanel();
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(Intl.intl("Species:"), this.d_specCombo, jButton);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Movement")));
            gridBagHelper.indent();
            gridBagHelper.addFilledRow(this.d_movementPnl);
            gridBagHelper.finalizeRows();
        }

        public void loadData(ExSpec exSpec, Boolean bl) {
            this.d_specCombo.setSelectedItem(exSpec);
            this.d_movementPnl.setStatic(bl);
        }

        public void saveData(Particle particle, boolean bl) {
            ExSpec exSpec = (ExSpec)this.d_specCombo.getSelectedItem();
            particle.setSpecies(exSpec);
            particle.setStatic(this.d_movementPnl.isStatic());
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            boolean bl3 = true;
            if (bl) {
                if (this.d_specCombo.getSelectedItem() != null) {
                    bl3 = Actions.isValidSpecies((ExSpec)this.d_specCombo.getSelectedItem());
                } else {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Must select a valid Species."));
                    bl3 = false;
                }
            }
            return bl3 && super.validateData(bl, bl2);
        }
    }

    private static class MovementPanel
    extends guiPanel {
        private static final long serialVersionUID = 7584064701758365701L;
        private final guiRadioButton d_cantMoveRB;
        private final guiRadioButton d_canMoveRB = new guiRadioButton(Intl.intl("Particles Can Move"));
        private ButtonGroup d_groupMovement;

        public MovementPanel() {
            this.d_cantMoveRB = new guiRadioButton(Intl.intl("Particles Are Stationary"));
            this.d_canMoveRB.setSelected(true);
            this.d_groupMovement = new ButtonGroup();
            this.d_groupMovement.add(this.d_canMoveRB);
            this.d_groupMovement.add(this.d_cantMoveRB);
            this.setLayout(new GridBagLayout());
            int n = 0;
            GridBagUtil.add(this, this.d_canMoveRB, 0, n++, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_cantMoveRB, 0, n++, 2, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void setStatic(Boolean bl) {
            if (bl == null) {
                this.unselect();
            } else {
                this.d_canMoveRB.setSelected(bl == false);
                this.d_cantMoveRB.setSelected(bl);
            }
        }

        public Boolean isStatic() {
            if (this.d_cantMoveRB.isSelected()) {
                return true;
            }
            return false;
        }

        public void unselect() {
            this.d_groupMovement.remove(this.d_canMoveRB);
            this.d_groupMovement.remove(this.d_cantMoveRB);
            this.d_canMoveRB.setSelected(false);
            this.d_cantMoveRB.setSelected(false);
            this.d_groupMovement.add(this.d_canMoveRB);
            this.d_groupMovement.add(this.d_cantMoveRB);
        }
    }

    private class InjectionPanel
    extends guiPanel {
        private static final long serialVersionUID = -831451803607726793L;
        private final OutputPanel d_outputPanel;

        public InjectionPanel() {
            this.setLayout(new GridBagLayout());
            this.d_outputPanel = new OutputPanel();
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addFilledRow(this.d_outputPanel);
            gridBagHelper.finalizeRows();
        }

        public void loadOutput(Output output) {
            this.d_outputPanel.loadData(output);
        }

        public Output saveOutput() {
            return this.d_outputPanel.saveData();
        }
    }
}

