/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.particle;

import java.awt.Window;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.particle.PartDescCombo;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;

public class NewParticleDlg
extends guiDialog {
    private static final long serialVersionUID = -8132843260894962985L;
    private final ParticleList d_partMgr;
    private final guiTextField d_name;
    private final guiRadioButton d_typeCB;
    private final PartDescCombo d_typeCombo;
    private final guiRadioButton d_templateCB;
    private final ParticleComboBox d_templateCombo;

    public NewParticleDlg(ParticleList particleList) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Particle"), 9);
        this.d_partMgr = particleList;
        this.d_name = new guiTextField(((PyroMod)this.d_partMgr.getDomain()).getNames(Particle.class).generateName());
        this.d_typeCB = new guiRadioButton(Intl.intl("Particle Type:"));
        this.d_typeCombo = new PartDescCombo();
        LinkStatus.link((AbstractButton)this.d_typeCB, this.d_typeCombo);
        this.d_templateCB = new guiRadioButton(Intl.intl("Particle Template:"));
        this.d_templateCombo = new ParticleComboBox(particleList);
        LinkStatus.link((AbstractButton)this.d_templateCB, this.d_templateCombo);
        guiUtil.group(new AbstractButton[]{this.d_typeCB, this.d_templateCB});
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addRow(Intl.intl("Particle Name:"), this.d_name, 0, 1.0);
        if (((APyroObject)this.d_partMgr).flatten(Particle.class).isEmpty()) {
            gridBagHelper.addRow(Intl.intl("Particle Type:"), this.d_typeCombo, 0);
        } else {
            gridBagHelper.addRow(this.d_typeCB, this.d_typeCombo, 1.0);
            gridBagHelper.addRow(this.d_templateCB, this.d_templateCombo, 1.0);
        }
        gridBagHelper.finalizeRows();
        this.d_typeCB.setSelected(true);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        String string = this.d_name.getText().trim();
        if (string.length() < 1) {
            String string2 = Intl.intl("You must name the particle.");
            this.showMessageBox(string2);
            this.requestFocusHack();
            return false;
        }
        if (((PyroMod)this.d_partMgr.getDomain()).getNames(Particle.class).isRegistered(string)) {
            String string3 = Intl.intl("Particle name is already in use.") + "\n" + Intl.intl("Each particle must have a unique name.");
            this.showMessageBox(string3);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    public Particle create() {
        if (this.d_typeCB.isSelected()) {
            PyroMod pyroMod = (PyroMod)this.d_partMgr.getDomain();
            String string = (String)this.d_typeCombo.getSelectedItem();
            if (string == PartDescCombo.MASSLESS_TRACER) {
                return new Particle(this.d_name.getValue(), Particle.Type.TRACER, new Output(1), null);
            }
            if (string == PartDescCombo.LIQUID) {
                Particle particle = new Particle(this.d_name.getValue(), Particle.Type.LIQUID, new Output(10), null);
                ExSpec exSpec = pyroMod != null ? pyroMod.getExSpecList().find(ExSpecList.Predefined.WATER_VAPOR.getName(), ExSpec.class, true) : null;
                particle.setSpecies(exSpec);
                return particle;
            }
            Particle particle = new Particle(this.d_name.getValue(), Particle.Type.SOLID, new Output(10), null);
            Surface surface = pyroMod != null ? pyroMod.getSurfaceMgr().get(PredefSurf.INERT) : null;
            particle.setSurface(surface);
            return particle;
        }
        assert (this.d_templateCB.isSelected());
        Particle particle = (Particle)this.d_templateCombo.getSelectedItem();
        Particle particle2 = (Particle)particle.clone();
        particle2.setName(this.d_name.getValue());
        return particle2;
    }
}

