/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.geom.Geometry;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.comboboxes.GridComboBox;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.Point3DPanel;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.IntVR;

public class StatisticsPanel
extends guiPanel
implements IEditor<IMeasurementStat>,
ItemListener {
    private static final long serialVersionUID = 5078624111651396306L;
    private final GridList d_gridManager;
    private final guiTextField d_msrField;
    private final guiRadioButton d_volumeStatsRB;
    private final guiRadioButton d_areaStatsRB;
    private final guiRadioButton d_pointStatsRB;
    private final guiRadioButton d_devcArrayRB;
    private final LinkedHashMap<UIStatistic, StatBtn> d_stats;
    private final guiRadioButton d_boxRB;
    private final guiRadioButton d_gridRB;
    private final GridComboBox d_gridCombo;
    private final AABoxGeomEditor d_boxPanel;
    private final AARectangleEditor d_rectPanel;
    private final Point3DPanel d_pointPanel;
    private final LinearArrayGeomEditor d_lineSegPanel;
    private final guiPanel d_geomPanel;
    private final CardLayout d_geomLayout;
    private String d_currentCard;
    private final CustomFDSPanel d_customProps;
    private LinkedHashMap<IQuantity, ArrayList<Integer>> d_quantities;
    private IQuantity d_currMsr;
    private static final String CARD_VOL = "CV";
    private static final String CARD_AREA = "CA";
    private static final String CARD_POINT = "CP";
    private static final String CARD_LINE = "CL";
    private static final int STAT_TYPE_POINT = 0;
    private static final int STAT_TYPE_AREA = 1;
    private static final int STAT_TYPE_VOLUME = 2;
    private static final int STAT_TYPE_LINE = 3;
    private static final int STAT_TYPE_NONE = 4;
    private static final Map<Integer, UIStatistic> UIStatTable = new HashMap<Integer, UIStatistic>();

    public StatisticsPanel(PyroMod pyroMod) {
        Map.Entry<UIStatistic, StatBtn> entry2;
        this.d_gridManager = pyroMod.getGridManager();
        this.d_quantities = new LinkedHashMap();
        this.d_currMsr = null;
        this.d_volumeStatsRB = new guiRadioButton(Intl.intl("Volume Statistics"));
        this.d_areaStatsRB = new guiRadioButton(Intl.intl("Area Statistics"));
        this.d_pointStatsRB = new guiRadioButton(Intl.intl("Point Statistics"));
        this.d_devcArrayRB = new guiRadioButton(Intl.intl("Line Statistics"));
        guiUtil.group(new AbstractButton[]{this.d_volumeStatsRB, this.d_areaStatsRB, this.d_pointStatsRB, this.d_devcArrayRB});
        this.d_volumeStatsRB.setSelected(true);
        this.d_volumeStatsRB.addItemListener(this);
        this.d_areaStatsRB.addItemListener(this);
        this.d_pointStatsRB.addItemListener(this);
        this.d_devcArrayRB.addItemListener(this);
        this.d_msrField = new guiTextField();
        this.d_msrField.setEnabled(false);
        this.d_msrField.setColumns(30);
        this.d_gridRB = new guiRadioButton(Intl.intl("Record in an entire mesh:"));
        this.d_boxRB = new guiRadioButton(Intl.intl("Record in a volume:"));
        this.d_gridCombo = new GridComboBox(pyroMod.getGridManager());
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Recording Area"));
        this.d_boxPanel = new AABoxGeomEditor(false, true);
        this.d_rectPanel = new AARectangleEditor(false);
        this.d_pointPanel = new Point3DPanel(Intl.intl("Recording Location"));
        this.d_lineSegPanel = new LinearArrayGeomEditor();
        new guiButtonGroup(this.d_gridRB, this.d_boxRB);
        LinkStatus.link((AbstractButton)this.d_gridRB, this.d_gridCombo);
        LinkStatus.link((AbstractButton)this.d_boxRB, this.d_boxPanel);
        this.d_stats = new LinkedHashMap();
        Stream.of(UIStatistic.values()).filter(uIStatistic -> uIStatistic.getStatType() != 4).forEach(uIStatistic -> this.addStatBtn(new guiCheckBox(uIStatistic.getDisplayName()), (UIStatistic)((Object)uIStatistic)));
        guiPanel guiPanel2 = new guiPanel((LayoutManager)new MigLayout("wrap 3", "[][]15[]"));
        guiPanel2.add((Component)new guiLabel(Intl.intl("Quantity:")), "gapbottom 11, gaptop 11");
        guiPanel2.add((Component)this.d_msrField, "span");
        Consumer<List> consumer = list -> {
            for (int i = 0; i < list.size(); ++i) {
                MigStringBuilder migStringBuilder = MigStringBuilder.newInstance();
                if (i % 2 == 0) {
                    migStringBuilder = migStringBuilder.gapleft(18).span(2);
                }
                if (i + 1 == list.size()) {
                    migStringBuilder = migStringBuilder.wrap();
                }
                guiPanel2.add((Component)((StatBtn)list.get((int)i)).button, migStringBuilder.buildString());
            }
        };
        ArrayList<StatBtn> arrayList = new ArrayList<StatBtn>();
        ArrayList<StatBtn> arrayList2 = new ArrayList<StatBtn>();
        ArrayList<StatBtn> arrayList3 = new ArrayList<StatBtn>();
        ArrayList<StatBtn> arrayList4 = new ArrayList<StatBtn>();
        for (Map.Entry<UIStatistic, StatBtn> entry2 : this.d_stats.entrySet()) {
            int n = entry2.getKey().getStatType();
            if (n == 4) continue;
            if (n == 2) {
                arrayList.add(entry2.getValue());
                continue;
            }
            if (n == 1) {
                arrayList2.add(entry2.getValue());
                continue;
            }
            if (n == 0) {
                arrayList3.add(entry2.getValue());
                continue;
            }
            if (n != 3) continue;
            arrayList4.add(entry2.getValue());
        }
        guiPanel2.add((Component)this.d_volumeStatsRB, "span, wrap");
        consumer.accept(arrayList);
        guiPanel2.add((Component)this.d_areaStatsRB, "span, wrap");
        consumer.accept(arrayList2);
        guiPanel2.add((Component)this.d_pointStatsRB, "span, wrap");
        consumer.accept(arrayList3);
        guiPanel2.add((Component)this.d_devcArrayRB, "span, wrap");
        consumer.accept(arrayList4);
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel3, this.d_boxRB, 0, 0, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_boxPanel, 0, 1, 10, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_gridRB, 0, 2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_gridCombo, 1, 2, 10, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(guiPanel3);
        entry2 = new guiPanel(new GridBagLayout());
        GridBagUtil.add((Container)((Object)entry2), titleSeparator, 0, 0, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add((Container)((Object)entry2), this.d_rectPanel, 0, 1, 10, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue((Container)((Object)entry2));
        if (this.d_pointPanel.getLayout() instanceof GridBagLayout) {
            GridBagUtil.addGlue(this.d_pointPanel);
        }
        if (this.d_lineSegPanel.getLayout() instanceof GridBagLayout) {
            GridBagUtil.addGlue(this.d_lineSegPanel);
        }
        this.d_geomLayout = new CardLayout(0, 0);
        this.d_geomPanel = new guiPanel(this.d_geomLayout);
        this.d_geomPanel.add((Component)guiPanel3, CARD_VOL);
        this.d_geomLayout.addLayoutComponent(guiPanel3, CARD_VOL);
        this.d_geomPanel.add((Component)((Object)entry2), CARD_AREA);
        this.d_geomLayout.addLayoutComponent((Component)((Object)entry2), CARD_AREA);
        this.d_geomPanel.add((Component)this.d_pointPanel, CARD_POINT);
        this.d_geomLayout.addLayoutComponent(this.d_pointPanel, CARD_POINT);
        this.d_geomPanel.add((Component)this.d_lineSegPanel, CARD_LINE);
        this.d_geomLayout.addLayoutComponent(this.d_lineSegPanel, CARD_LINE);
        this.d_currentCard = CARD_VOL;
        this.d_boxRB.setSelected(true);
        guiPanel2.add(new guiLabel(Intl.intl("Options")));
        guiPanel2.add((Component)new JSeparator(), "span, growx, wrap");
        guiPanel2.add((Component)this.d_geomPanel, "gapleft 18, span, wrap");
        this.d_customProps = new CustomFDSPanel(6);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
        jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customProps);
        this.setLayout(new BorderLayout());
        this.add((Component)jTabbedPane, "Center");
        this.init(null);
    }

    @Override
    public IMeasurementStat preview(IMeasurementStat iMeasurementStat) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.save(iMeasurementStat);
        return iMeasurementStat;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateEnabledStats();
        this.updateGeomParametersNew();
    }

    private void addStatBtn(JToggleButton jToggleButton, UIStatistic uIStatistic) {
        StatBtn statBtn = new StatBtn(jToggleButton, uIStatistic.getQuantType());
        this.d_stats.put(uIStatistic, statBtn);
    }

    private void updateEnabledStats() {
        List list = this.d_quantities.get(this.d_currMsr);
        if (list == null) {
            return;
        }
        if (this.d_devcArrayRB.isSelected()) {
            this.setSelectedForType(3, list);
        } else if (this.d_pointStatsRB.isSelected()) {
            this.setSelectedForType(0, list);
        } else if (this.d_areaStatsRB.isSelected()) {
            this.setSelectedForType(1, list);
        } else if (this.d_volumeStatsRB.isSelected()) {
            this.setSelectedForType(2, list);
        }
    }

    private void setSelectedForType(int n, List<Integer> list) {
        for (Map.Entry<UIStatistic, StatBtn> entry : this.d_stats.entrySet()) {
            if (entry.getKey().statType == 4) continue;
            if (entry.getKey().statType == n) {
                entry.getValue().button.setEnabled(list.contains(entry.getKey().getQuantType()));
                continue;
            }
            entry.getValue().button.setEnabled(false);
            entry.getValue().button.setSelected(false);
        }
    }

    private void updateGeomParametersNew() {
        if (this.d_volumeStatsRB.isSelected()) {
            this.d_geomLayout.show(this.d_geomPanel, CARD_VOL);
            this.d_currentCard = CARD_VOL;
        } else if (this.d_areaStatsRB.isSelected()) {
            this.d_geomLayout.show(this.d_geomPanel, CARD_AREA);
            this.d_currentCard = CARD_AREA;
        } else if (this.d_pointStatsRB.isSelected()) {
            this.d_geomLayout.show(this.d_geomPanel, CARD_POINT);
            this.d_currentCard = CARD_POINT;
        } else if (this.d_devcArrayRB.isSelected()) {
            this.d_geomLayout.show(this.d_geomPanel, CARD_LINE);
            this.d_currentCard = CARD_LINE;
        }
        this.d_gridRB.setEnabled(!this.d_gridManager.flatten().isEmpty());
        if (!this.d_gridRB.isEnabled()) {
            this.d_gridRB.setToolTipText(Intl.intl("There are no meshes currently in the model."));
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(IMeasurementStat iMeasurementStat) {
        Object object;
        IQuantity iQuantity;
        this.setEnabled(iMeasurementStat != null);
        this.d_currMsr = iQuantity = iMeasurementStat != null ? iMeasurementStat.getQuantity() : null;
        boolean bl = !this.d_quantities.containsKey(this.d_currMsr);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.d_msrField.setEnabled(false);
        this.d_msrField.setValue("");
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (StatBtn object2 : this.d_stats.values()) {
            boolean bl5 = this.d_currMsr != null ? QuantityUtil.canOutputAll(this.d_currMsr.get(), object2.outputID) : false;
            object2.button.setEnabled(bl5);
            object2.button.setSelected(false);
            if (bl && bl5) {
                arrayList.add(object2.outputID);
            }
            if ((object = UIStatTable.get(object2.outputID)) == null) continue;
            if (object.getStatType() == 2 && !bl2) {
                bl2 = bl5;
                continue;
            }
            if (object.getStatType() == 1 && !bl3) {
                bl3 = bl5;
                continue;
            }
            if (object.getStatType() != 0 || bl4) continue;
            bl4 = bl5;
        }
        if (bl) {
            this.d_quantities.put(this.d_currMsr, arrayList);
        }
        if (iMeasurementStat != null) {
            this.d_msrField.setValue(iMeasurementStat.getQuantity().getDescription());
            this.d_volumeStatsRB.setEnabled(bl2);
            this.d_areaStatsRB.setEnabled(bl3);
            this.d_pointStatsRB.setEnabled(bl4);
            for (Integer n : iMeasurementStat.getStats()) {
                UIStatistic uIStatistic = UIStatTable.get(n);
                if (uIStatistic == null) continue;
                object = this.d_stats.get((Object)uIStatistic);
                ((StatBtn)object).button.setSelected(true);
                if (uIStatistic.getStatType() == 3) {
                    this.d_devcArrayRB.setSelected(true);
                    continue;
                }
                if (uIStatistic.getStatType() == 0) {
                    this.d_pointStatsRB.setSelected(true);
                    continue;
                }
                if (uIStatistic.getStatType() == 1) {
                    this.d_areaStatsRB.setSelected(true);
                    continue;
                }
                this.d_volumeStatsRB.setSelected(true);
            }
            this.validateRBSelection();
            this.updateEnabledStats();
            this.updateGeomParametersNew();
            IGeom iGeom = iMeasurementStat.getGeom().flatten().getLocalGeom();
            if (iGeom instanceof AARectangle) {
                assert (this.d_rectPanel.isVisible());
                this.d_rectPanel.load((AARectangle)iGeom);
            } else if (iGeom instanceof AABoxGeom) {
                assert (this.d_boxPanel.isVisible());
                this.d_boxPanel.load((AABoxGeom)iGeom);
                this.d_boxRB.setSelected(true);
            } else if (iGeom instanceof StatGeom.GridGeom) {
                assert (this.d_boxPanel.isVisible());
                this.d_gridCombo.setSelectedItem(((StatGeom.GridGeom)iGeom).grid);
                this.d_gridRB.setSelected(true);
            } else if (iGeom instanceof Point) {
                assert (this.d_pointPanel.isVisible());
                Point point = (Point)iGeom;
                this.d_pointPanel.load(new UnitPoint3D(point.loc, Geometry.LU));
            } else if (iGeom instanceof StatGeom.LinearArrayGeom) {
                assert (this.d_lineSegPanel.isVisible());
                this.d_lineSegPanel.load((StatGeom.LinearArrayGeom)iGeom);
            }
            this.d_customProps.load(iMeasurementStat);
        }
        this.setModified(false);
    }

    private void validateRBSelection() {
        int n = -1;
        if (this.d_volumeStatsRB.isSelected()) {
            n = 2;
        }
        if (this.d_areaStatsRB.isSelected()) {
            n = 1;
        }
        if (this.d_pointStatsRB.isSelected()) {
            n = 0;
        }
        if (this.d_devcArrayRB.isSelected()) {
            n = 3;
        }
        boolean bl = this.d_volumeStatsRB.isEnabled();
        boolean bl2 = this.d_areaStatsRB.isEnabled();
        boolean bl3 = this.d_pointStatsRB.isEnabled();
        boolean bl4 = this.d_devcArrayRB.isEnabled();
        boolean bl5 = true;
        switch (n) {
            case 2: {
                if (bl) break;
                bl5 = false;
                break;
            }
            case 1: {
                if (bl2) break;
                bl5 = false;
                break;
            }
            case 0: {
                if (bl3) break;
                bl5 = false;
                break;
            }
            case 3: {
                if (bl4) break;
                bl5 = false;
            }
        }
        if (!bl5) {
            if (bl) {
                this.d_volumeStatsRB.setSelected(true);
            } else if (bl2) {
                this.d_areaStatsRB.setSelected(true);
            } else if (bl3) {
                this.d_pointStatsRB.setSelected(true);
            } else if (bl4) {
                this.d_devcArrayRB.setSelected(true);
            }
        }
    }

    @Override
    public IMeasurementStat commit(final IMeasurementStat iMeasurementStat) {
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                StatisticsPanel.this.save(iMeasurementStat);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Statistic"));
        this.setModified(false);
        return iMeasurementStat;
    }

    private void save(IMeasurementStat iMeasurementStat) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.d_stats.size());
        for (StatBtn object2 : this.d_stats.values()) {
            JToggleButton jToggleButton = object2.button;
            if (!jToggleButton.isEnabled() || !jToggleButton.isSelected()) continue;
            arrayList.add(object2.outputID);
        }
        iMeasurementStat.setStats(arrayList);
        Object object3 = null;
        if (this.d_currentCard == CARD_POINT) {
            UnitPoint3D unitPoint3D = this.d_pointPanel.save();
            object3 = new Point(unitPoint3D.getPoint3dValue(Geometry.LU));
        } else if (this.d_currentCard == CARD_AREA) {
            object3 = this.d_rectPanel.saveData();
        } else if (this.d_currentCard == CARD_LINE) {
            object3 = this.d_lineSegPanel.saveData();
        } else if (this.d_currentCard == CARD_VOL) {
            if (this.d_boxRB.isSelected()) {
                object3 = this.d_boxPanel.save();
            } else {
                Grid grid = (Grid)this.d_gridCombo.getSelectedItem();
                object3 = new StatGeom.GridGeom(grid);
            }
        }
        iMeasurementStat.setGeom(GeomNodeUtil.newNode((IGeom)object3));
        this.d_customProps.save(iMeasurementStat);
    }

    static {
        Stream.of(UIStatistic.values()).forEach(uIStatistic -> UIStatTable.put(uIStatistic.getQuantType(), (UIStatistic)((Object)uIStatistic)));
    }

    private static class MigStringBuilder {
        List<String> modifiers = new ArrayList<String>();

        public static MigStringBuilder newInstance() {
            return new MigStringBuilder();
        }

        private MigStringBuilder() {
        }

        public String buildString() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = this.modifiers.iterator();
            while (iterator.hasNext()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(iterator.next());
            }
            return stringBuilder.toString();
        }

        public MigStringBuilder addString(String string) {
            this.modifiers.add(string);
            return this;
        }

        private MigStringBuilder addVarLengthInput(String string, int n) {
            if (n == 0) {
                return this.addString(string);
            }
            return this.addString(string + " " + n);
        }

        public MigStringBuilder span() {
            return this.span(0);
        }

        public MigStringBuilder span(int n) {
            return this.addVarLengthInput("span", n);
        }

        public MigStringBuilder wrap() {
            return this.wrap(0);
        }

        public MigStringBuilder wrap(int n) {
            return this.addVarLengthInput("wrap", n);
        }

        public MigStringBuilder gaptop() {
            return this.gaptop(0);
        }

        public MigStringBuilder gaptop(int n) {
            return this.addVarLengthInput("gaptop", n);
        }

        public MigStringBuilder gapleft() {
            return this.gapleft(0);
        }

        public MigStringBuilder gapleft(int n) {
            return this.addVarLengthInput("gapleft", n);
        }

        public MigStringBuilder gapbottom() {
            return this.gapbottom(0);
        }

        public MigStringBuilder gapbottom(int n) {
            return this.addVarLengthInput("gapbottom", n);
        }

        public MigStringBuilder gapright() {
            return this.gapright(0);
        }

        public MigStringBuilder gapright(int n) {
            return this.addVarLengthInput("gapright", n);
        }
    }

    private static class LinearArrayGeomEditor
    extends guiPanel {
        static final long serialVersionUID = 1L;
        private final ValueField<Integer> d_numPoints;
        private final Point3DPanel d_p1;
        private final Point3DPanel d_p2;

        public LinearArrayGeomEditor() {
            this.setLayout(new GridBagLayout());
            this.d_numPoints = ValueFields.intFld(IntVR.above(2, true));
            this.d_p1 = new Point3DPanel(Intl.intl("Point 1:"));
            this.d_p2 = new Point3DPanel(Intl.intl("Point 2:"));
            int n = 0;
            GridBagUtil.add(this, new guiLabel(Intl.intl("Num Points:")), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_numPoints, 1, n++, 2, 1, 0, 0, 6, 12, 0, 0.0, 1.0, 17);
            this.d_p1.addToPanel(this, 0, n++);
            this.d_p2.addToPanel(this, 0, n++);
            GridBagUtil.addGlue(this);
        }

        public StatGeom.LinearArrayGeom saveData() {
            int n = (Integer)this.d_numPoints.getValue();
            UnitPoint3D unitPoint3D = this.d_p1.save();
            UnitPoint3D unitPoint3D2 = this.d_p2.save();
            return new StatGeom.LinearArrayGeom(unitPoint3D.getPoint3dValue(Geometry.LU), unitPoint3D2.getPoint3dValue(Geometry.LU), n);
        }

        public void load(StatGeom.LinearArrayGeom linearArrayGeom) {
            this.d_numPoints.setValue(linearArrayGeom.d_numPoints);
            this.d_p1.load(new UnitPoint3D(linearArrayGeom.p1, Geometry.LU));
            this.d_p2.load(new UnitPoint3D(linearArrayGeom.p2, Geometry.LU));
        }
    }

    private static class StatBtn {
        public final int outputID;
        public final JToggleButton button;

        public StatBtn(JToggleButton jToggleButton, int n) {
            this.button = jToggleButton;
            this.outputID = n;
        }
    }

    private static enum UIStatistic {
        MINIMUM(Intl.intl("Minimum"), 65536, 2),
        MAXIMUM(Intl.intl("Maximum"), 131072, 2),
        MEAN(Intl.intl("Mean"), 262144, 2),
        VOLMEAN(Intl.intl("Volume Mean"), 524288, 2),
        MASSMEAN(Intl.intl("Mass Mean"), 0x100000, 2),
        VOLINTEGRAL(Intl.intl("Volume Integral"), 0x200000, 2),
        MASSINTEGRAL(Intl.intl("Mass Integral"), 0x4000000, 2),
        AREAINTEGRAL(Intl.intl("Area Integral"), 0x400000, 1),
        SURFINTEGRAL(Intl.intl("Surface Integral"), 0x800000, 1),
        RMS(Intl.intl("RMS"), 0x8000000, 0),
        TIMEINTEGRAL(Intl.intl("Time Integral"), 0x1000000, 0),
        RMS_ARRAY(Intl.intl("RMS"), 0x40000000, 3),
        STEADYSTATE(Intl.intl("Steady State Profile"), 0x2000000, 3);

        private final String displayName;
        private final int quantType;
        private final int statType;

        private UIStatistic(String string2, int n2, int n3) {
            this.displayName = string2;
            this.quantType = n2;
            this.statType = n3;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getQuantType() {
            return this.quantType;
        }

        public int getStatType() {
            return this.statType;
        }
    }
}

