/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.output.NewStatDlg;
import pyrosim.gui.output.StatisticsPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class StatisticsDlg
extends ManagerDlg<IMeasurementStat, StatisticMgr> {
    private static final long serialVersionUID = 3696969351649941166L;
    private final PyroMod d_model = PyroSim.getApp().getMediator();
    private final Action[] d_actions = new Action[]{new NewAction(), new RenameAction<IMeasurementStat, StatisticMgr>(this, Intl.intl("statistic")), new ManagerDlg.DeleteAction()};
    private final IEditor<IMeasurementStat> d_editor = new StatisticsPanel(this.d_model);
    private StatisticMgr d_mgr;

    public StatisticsDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Edit Statistics"), true);
    }

    public void init(StatisticMgr statisticMgr, IMeasurementStat iMeasurementStat) {
        this.d_mgr = statisticMgr;
        ((RenameAction)this.d_actions[1]).init(statisticMgr);
        super.init(this.d_mgr, this.d_editor, this.d_actions, iMeasurementStat);
        this.updateActions();
    }

    private void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 2732237473459878619L;

        public NewAction() {
            super(Intl.intl("New..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!StatisticsDlg.this.preSave()) {
                return;
            }
            NewStatDlg newStatDlg = new NewStatDlg(StatisticsDlg.this, StatisticsDlg.this.d_model);
            if (newStatDlg.doModal() == 1) {
                IMeasurementStat iMeasurementStat = newStatDlg.createStat();
                AddTask addTask = new AddTask((IPyroObject)StatisticsDlg.this.d_mgr, new IPyroObject[]{iMeasurementStat});
                StatisticsDlg.this.d_model.getTaskManager().exec(addTask, Intl.intl("New Statistic"));
                StatisticsDlg.this.getList().updateModelView(StatisticsDlg.this.d_mgr);
                StatisticsDlg.this.getList().select(iMeasurementStat);
                StatisticsDlg.this.updateActions();
            }
        }
    }
}

