/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.output.QuantityClipboard;
import pyrosim.gui.output.guiOutputUtil;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ComboBoxTableCell;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;

public class SlcfDialog
extends guiDialog {
    private static final long serialVersionUID = -281526882433842190L;
    private PyroMod d_pyroMod = ((PyroSim)Application.getApp()).getMediator();
    private guiTableEditor d_editor;
    private guiTable table;
    private Unit d_lengthUnit;
    private static final String OPT_YES = Intl.intl("YES");
    private static final String OPT_NO = Intl.intl("NO");

    public SlcfDialog(JFrame jFrame) {
        super((Window)jFrame, Intl.intl("Animated Planar Slices"), 9);
        UnitSystem unitSystem = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lengthUnit = unitSystem.getLengthUnit();
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        String[] stringArray = new String[]{Intl.intl("XYZ Plane"), Intl.intl("Plane Value"), Intl.intl("Gas Phase Quantity"), Intl.intl("Use Vector?"), Intl.intl("Cell Centered?")};
        this.d_editor = new guiTableEditor(guiTableUtil.fixedColumnTable(stringArray, new Class[]{String.class, UnitDouble.class, IQuantity.class, String.class, String.class}), 30);
        this.table = this.d_editor.getTable();
        this.table.setNullValuesAllowed(false);
        this.table.setColumnOptions(0, "X", "Y", "Z");
        this.table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(this.d_lengthUnit));
        this.table.getColumnModel().getColumn(1).setCellRenderer(new guiTable.UnitDoubleRenderer());
        QuantityComboBox quantityComboBox = new QuantityComboBox(128, QuantityType.GAS);
        ComboBoxTableCell<IQuantity> comboBoxTableCell = new ComboBoxTableCell<IQuantity>(quantityComboBox);
        QuantityUtil.TypeFilter typeFilter = new QuantityUtil.TypeFilter(128, QuantityType.GAS);
        this.table.setClipboard(2, (guiTableClipboard)new QuantityClipboard(typeFilter));
        this.table.getColumnModel().getColumn(2).setCellRenderer(comboBoxTableCell);
        this.table.getColumnModel().getColumn(2).setCellEditor(comboBoxTableCell);
        this.table.setColumnOptions(3, OPT_YES, OPT_NO);
        this.table.setColumnOptions(4, OPT_YES, OPT_NO);
        this.loadData();
        this.table.autoSizeColumns(200);
        GridBagUtil.add(guiPanel2, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        int n = this.table.getRowHeight();
        this.table.setRowHeight(n + 1);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (!this.noTwoPointsSame()) {
            String string = Intl.intl("Error: Duplicate values of the same quantity are not permitted.");
            this.showMessageBox(string);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private Collection<PlanarSlice> getAllSlices() {
        return ((APyroObject)this.d_pyroMod.getSlcfList()).flatten(PlanarSlice.class);
    }

    public void setInitialSel(Collection<? extends PlanarSlice> collection) {
        this.table.clearSelection();
        this.table.setColumnSelectionInterval(0, 4);
        for (Slice slice : collection) {
            int n = Util.indexOf(this.getAllSlices(), slice);
            if (n < 0) continue;
            this.table.addRowSelectionInterval(n, n);
        }
    }

    public void loadData() {
        Collection<PlanarSlice> collection = this.getAllSlices();
        int n = collection.size();
        if (n > 0) {
            guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.table.getModel();
            int n2 = 0;
            for (PlanarSlice planarSlice : collection) {
                String string;
                boolean bl = planarSlice.includeFlowVector();
                String string2 = bl ? OPT_YES : OPT_NO;
                boolean bl2 = planarSlice.isCellCentered();
                String string3 = bl2 ? OPT_YES : OPT_NO;
                int n3 = planarSlice.getPlane();
                switch (n3) {
                    case 0: {
                        string = "X";
                        break;
                    }
                    case 1: {
                        string = "Y";
                        break;
                    }
                    case 2: {
                        string = "Z";
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                guiDefaultTableModel2.setValueAt(string, n2, 0);
                guiDefaultTableModel2.setValueAt(planarSlice.getLocation().convert(this.d_lengthUnit), n2, 1);
                guiDefaultTableModel2.setValueAt(planarSlice.getQuantity(), n2, 2);
                guiDefaultTableModel2.setValueAt(string2, n2, 3);
                guiDefaultTableModel2.setValueAt(string3, n2, 4);
                ++n2;
            }
        }
    }

    public void saveData() {
        List<PlanarSlice> list = Arrays.asList(this.getSlices());
        Task task = guiOutputUtil.taskReplaceObjs(this.d_pyroMod.getSlcfList(), list);
        this.d_pyroMod.getTaskManager().exec(task, Intl.intl("Save Slices"));
    }

    private PlanarSlice[] getSlices() {
        TableModel tableModel = this.d_editor.getTable().getModel();
        int n = tableModel.getRowCount();
        PlanarSlice[] planarSliceArray = new PlanarSlice[n];
        for (int i = 0; i < n; ++i) {
            Object object = tableModel.getValueAt(i, 3);
            boolean bl = object.equals(OPT_YES);
            Object object2 = tableModel.getValueAt(i, 4);
            boolean bl2 = object2.equals(OPT_YES);
            String string = (String)tableModel.getValueAt(i, 0);
            int n2 = string.equals("X") ? 0 : (string.equals("Y") ? 1 : 2);
            planarSliceArray[i] = new PlanarSlice(n2, (UnitDouble)tableModel.getValueAt(i, 1), (IQuantity)tableModel.getValueAt(i, 2), bl, bl2);
        }
        return planarSliceArray;
    }

    private boolean noTwoPointsSame() {
        HashSet<PlanarSlice.PlanarSliceHash> hashSet = new HashSet<PlanarSlice.PlanarSliceHash>();
        TableModel tableModel = this.d_editor.getTable().getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string = (String)tableModel.getValueAt(i, 0);
            int n = string.equals("X") ? 0 : (string.equals("Y") ? 1 : 2);
            PlanarSlice.PlanarSliceHash planarSliceHash = new PlanarSlice.PlanarSliceHash(n, (UnitDouble)tableModel.getValueAt(i, 1), (IQuantity)tableModel.getValueAt(i, 2));
            if (hashSet.add(planarSliceHash)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        this.savePreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
        if (n == 1) {
            this.saveData();
        }
        return n;
    }
}

