/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.output.QuantityClipboard;
import pyrosim.gui.output.guiOutputUtil;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ComboBoxTableCell;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;

public class Slcf3dDialog
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private PyroMod d_pyroMod = ((PyroSim)Application.getApp()).getMediator();
    private guiTableEditor d_editor;
    private guiTable table;
    private Unit d_lengthUnit;
    private static final String OPT_YES = Intl.intl("YES");
    private static final String OPT_NO = Intl.intl("NO");

    public Slcf3dDialog(JFrame jFrame) {
        super((Window)jFrame, Intl.intl("Animated 3D Slices"), 9);
        UnitSystem unitSystem = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lengthUnit = unitSystem.getLengthUnit();
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        String[] stringArray = (String[])Stream.of(COLUMN_IDS.values()).map(cOLUMN_IDS -> cOLUMN_IDS.name).toArray(String[]::new);
        Class[] classArray = (Class[])Stream.of(COLUMN_IDS.values()).map(cOLUMN_IDS -> cOLUMN_IDS.clazz).toArray(Class[]::new);
        this.d_editor = new guiTableEditor(guiTableUtil.fixedColumnTable(stringArray, classArray), 30);
        this.table = this.d_editor.getTable();
        this.table.setNullValuesAllowed(false);
        Stream.of(COLUMN_IDS.values()).filter(cOLUMN_IDS -> cOLUMN_IDS.clazz.isAssignableFrom(UnitDouble.class)).forEach(cOLUMN_IDS -> {
            this.table.getColumnModel().getColumn(cOLUMN_IDS.ordinal()).setCellEditor(new guiTable.UnitDoubleEditor(this.d_lengthUnit));
            this.table.getColumnModel().getColumn(cOLUMN_IDS.ordinal()).setCellRenderer(new guiTable.UnitDoubleRenderer());
        });
        QuantityComboBox quantityComboBox = new QuantityComboBox(128, QuantityType.GAS);
        ComboBoxTableCell<IQuantity> comboBoxTableCell = new ComboBoxTableCell<IQuantity>(quantityComboBox);
        QuantityUtil.TypeFilter typeFilter = new QuantityUtil.TypeFilter(128, QuantityType.GAS);
        this.table.setClipboard(COLUMN_IDS.GASPHASE.ordinal(), (guiTableClipboard)new QuantityClipboard(typeFilter));
        this.table.getColumnModel().getColumn(COLUMN_IDS.GASPHASE.ordinal()).setCellRenderer(comboBoxTableCell);
        this.table.getColumnModel().getColumn(COLUMN_IDS.GASPHASE.ordinal()).setCellEditor(comboBoxTableCell);
        this.table.setColumnOptions(COLUMN_IDS.USEVEC.ordinal(), OPT_YES, OPT_NO);
        this.table.setColumnOptions(COLUMN_IDS.CELLCENTER.ordinal(), OPT_YES, OPT_NO);
        this.loadData();
        this.table.autoSizeColumns(200);
        GridBagUtil.add(guiPanel2, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        int n = this.table.getRowHeight();
        this.table.setRowHeight(n + 1);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        VolumeSlice[] volumeSliceArray = this.getSlices();
        if (!Slcf3dDialog.noTwo3DSlicesSame(volumeSliceArray)) {
            this.doWarn(Intl.intl("Error: Duplicate values of the same quantity are not permitted."));
            return false;
        }
        Set set = Stream.of(volumeSliceArray).map(volumeSlice -> volumeSlice.getName()).collect(Collectors.toSet());
        if (set.size() != volumeSliceArray.length) {
            this.doWarn(Intl.intl("Error: All slice IDs must be unique."));
            return false;
        }
        return true;
    }

    private void doWarn(String string) {
        this.showMessageBox(string);
        this.requestFocusHack();
    }

    private Collection<VolumeSlice> getAll3DSlices() {
        return ((APyroObject)this.d_pyroMod.getSlcf3dList()).flatten(VolumeSlice.class);
    }

    public void setInitialSel(Collection<? extends VolumeSlice> collection) {
        this.table.clearSelection();
        this.table.setColumnSelectionInterval(0, COLUMN_IDS.values().length - 1);
        for (Slice slice : collection) {
            int n = Util.indexOf(this.getAll3DSlices(), slice);
            if (n < 0) continue;
            this.table.addRowSelectionInterval(n, n);
        }
    }

    public void loadData() {
        Collection<VolumeSlice> collection = this.getAll3DSlices();
        int n = collection.size();
        if (n > 0) {
            guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.table.getModel();
            int n2 = 0;
            for (VolumeSlice volumeSlice : collection) {
                String string = volumeSlice.getName();
                UnitAABox unitAABox = GeomUtil.getUnitBounds(volumeSlice);
                boolean bl = volumeSlice.includeFlowVector();
                String string2 = bl ? OPT_YES : OPT_NO;
                boolean bl2 = volumeSlice.isCellCentered();
                String string3 = bl2 ? OPT_YES : OPT_NO;
                guiDefaultTableModel2.setValueAt(string, n2, COLUMN_IDS.ID.ordinal());
                guiDefaultTableModel2.setValueAt(unitAABox.getMin().xu().convert(this.d_lengthUnit), n2, COLUMN_IDS.MINX.ordinal());
                guiDefaultTableModel2.setValueAt(unitAABox.getMax().xu().convert(this.d_lengthUnit), n2, COLUMN_IDS.MAXX.ordinal());
                guiDefaultTableModel2.setValueAt(unitAABox.getMin().yu().convert(this.d_lengthUnit), n2, COLUMN_IDS.MINY.ordinal());
                guiDefaultTableModel2.setValueAt(unitAABox.getMax().yu().convert(this.d_lengthUnit), n2, COLUMN_IDS.MAXY.ordinal());
                guiDefaultTableModel2.setValueAt(unitAABox.getMin().zu().convert(this.d_lengthUnit), n2, COLUMN_IDS.MINZ.ordinal());
                guiDefaultTableModel2.setValueAt(unitAABox.getMax().zu().convert(this.d_lengthUnit), n2, COLUMN_IDS.MAXZ.ordinal());
                guiDefaultTableModel2.setValueAt(volumeSlice.getQuantity(), n2, COLUMN_IDS.GASPHASE.ordinal());
                guiDefaultTableModel2.setValueAt(string2, n2, COLUMN_IDS.USEVEC.ordinal());
                guiDefaultTableModel2.setValueAt(string3, n2, COLUMN_IDS.CELLCENTER.ordinal());
                ++n2;
            }
        }
    }

    public void saveData() {
        List<VolumeSlice> list = Arrays.asList(this.getSlices());
        Task task = guiOutputUtil.taskReplaceObjs(this.d_pyroMod.getSlcf3dList(), list);
        this.d_pyroMod.getTaskManager().exec(task, Intl.intl("Save 3D Slices"));
    }

    private VolumeSlice[] getSlices() {
        TableModel tableModel = this.d_editor.getTable().getModel();
        int n = tableModel.getRowCount();
        VolumeSlice[] volumeSliceArray = new VolumeSlice[n];
        for (int i = 0; i < n; ++i) {
            Object object = tableModel.getValueAt(i, COLUMN_IDS.ID.ordinal());
            Object object2 = tableModel.getValueAt(i, COLUMN_IDS.MINX.ordinal());
            Object object3 = tableModel.getValueAt(i, COLUMN_IDS.MAXX.ordinal());
            Object object4 = tableModel.getValueAt(i, COLUMN_IDS.MINY.ordinal());
            Object object5 = tableModel.getValueAt(i, COLUMN_IDS.MAXY.ordinal());
            Object object6 = tableModel.getValueAt(i, COLUMN_IDS.MINZ.ordinal());
            Object object7 = tableModel.getValueAt(i, COLUMN_IDS.MAXZ.ordinal());
            Object object8 = tableModel.getValueAt(i, COLUMN_IDS.GASPHASE.ordinal());
            Object object9 = tableModel.getValueAt(i, COLUMN_IDS.USEVEC.ordinal());
            Object object10 = tableModel.getValueAt(i, COLUMN_IDS.CELLCENTER.ordinal());
            boolean bl = object9.equals(OPT_YES);
            boolean bl2 = object10.equals(OPT_YES);
            volumeSliceArray[i] = new VolumeSlice((String)object, (UnitDouble)object2, (UnitDouble)object3, (UnitDouble)object4, (UnitDouble)object5, (UnitDouble)object6, (UnitDouble)object7, (IQuantity)object8, bl, bl2);
        }
        return volumeSliceArray;
    }

    private boolean noTwo3DSlicesSame() {
        return Slcf3dDialog.noTwo3DSlicesSame(this.getSlices());
    }

    private static boolean noTwo3DSlicesSame(VolumeSlice[] volumeSliceArray) {
        HashSet<VolumeSlice> hashSet = new HashSet<VolumeSlice>();
        for (VolumeSlice volumeSlice : volumeSliceArray) {
            if (hashSet.add(volumeSlice)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        this.savePreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
        if (n == 1) {
            this.saveData();
        }
        return n;
    }

    private static enum COLUMN_IDS {
        ID(Intl.intl("Name"), String.class),
        MINX(Intl.intl("Min X"), UnitDouble.class),
        MAXX(Intl.intl("Max X"), UnitDouble.class),
        MINY(Intl.intl("Min Y"), UnitDouble.class),
        MAXY(Intl.intl("Max Y"), UnitDouble.class),
        MINZ(Intl.intl("Min Z"), UnitDouble.class),
        MAXZ(Intl.intl("Max Z"), UnitDouble.class),
        GASPHASE(Intl.intl("Gas Phase Quantity"), IQuantity.class),
        USEVEC(Intl.intl("Use Vector?"), String.class),
        CELLCENTER(Intl.intl("Cell Centered?"), String.class);

        public final String name;
        public final Class<?> clazz;

        private COLUMN_IDS(String string2, Class<?> clazz) {
            this.name = string2;
            this.clazz = clazz;
        }
    }
}

