/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.domain.quantity.VelocitySign;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.SplitButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypedProp;

public class QuantitySetDlg
extends guiDialog {
    private static final long serialVersionUID = 6869169854791368907L;
    private final PyroMod d_pyromod = ((PyroSim)Application.getApp()).getMediator();
    private final AMeasurementSet d_measurementSet;
    private MeasurementTableModel d_model;
    private final guiTable d_tEnabledQuantities;
    private final JScrollPane d_spEnabledQuantities;
    private final guiLabel d_lNumberQuansChosen;
    private final guiLabel d_velSignLbl;
    private final guiComboBox<VelocitySign> d_velSignCB;
    private final int d_maxQuantities;
    private final JButton d_resetButton;
    private final TypedProp<Integer> d_prefSizeX;
    private final TypedProp<Integer> d_prefSizeY;
    public static final String DLG = "QuantityDlg";

    public QuantitySetDlg(JFrame jFrame, String string, AMeasurementSet aMeasurementSet, int n, TypedProp<Integer> typedProp, TypedProp<Integer> typedProp2, Action ... actionArray) {
        super((Window)jFrame, string, 9);
        this.d_measurementSet = aMeasurementSet;
        this.d_maxQuantities = n;
        this.d_prefSizeX = typedProp;
        this.d_prefSizeY = typedProp2;
        this.d_model = new MeasurementTableModel(aMeasurementSet.getOutputType());
        this.d_tEnabledQuantities = new guiTable((TableModel)this.d_model, 0);
        this.d_tEnabledQuantities.setCellSelectionEnabled(false);
        this.d_tEnabledQuantities.setShowVerticalLines(false);
        this.d_spEnabledQuantities = new JScrollPane(this.d_tEnabledQuantities);
        this.d_lNumberQuansChosen = new guiLabel(Intl.intl("0 Quantities Chosen"));
        this.getNumberQuansChosen().setForeground(Color.BLUE);
        this.d_tEnabledQuantities.autoSizeColumns(true, 200);
        TableColumn tableColumn = this.d_tEnabledQuantities.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getPreferredWidth());
        this.d_velSignLbl = new guiLabel(Intl.intl("Velocity Sign:"));
        this.d_velSignCB = new guiComboBox<VelocitySign>(VelocitySign.values());
        this.getVelSignLbl().setToolTipText("PLOT3D_VELO_INDEX");
        if (actionArray.length > 0) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new ClearAction(Intl.intl("Clear Selection")));
            for (Action action : actionArray) {
                action.putValue(DLG, this);
                jPopupMenu.add(action);
            }
            this.d_resetButton = new JButton(Intl.intl("Reset..."));
            this.d_resetButton.addActionListener(actionEvent -> {
                int n = 1;
                int n2 = this.d_resetButton.getSize().height;
                jPopupMenu.show(this.d_resetButton, n, n2);
            });
        } else {
            this.d_resetButton = new JButton(Intl.intl("Clear Selection"));
            this.d_resetButton.addActionListener(actionEvent -> this.clearSelection());
        }
        this.loadValues();
        this.d_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                QuantitySetDlg.this.updateNumQuansSelected();
                QuantitySetDlg.this.updateVelSign();
            }
        });
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(this.d_prefSizeX.key.toString(), this.d_prefSizeY.key.toString());
    }

    protected String getTaskDesc() {
        return Intl.intl("Save Quantities");
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        this.savePreferredSize(this.d_prefSizeX.key.toString(), this.d_prefSizeY.key.toString());
        return n;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        int n = this.countSelQuantities();
        if (n > this.d_maxQuantities) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("Please choose no more than %d quantities."), this.d_maxQuantities), Intl.intl("Error"), 0);
            return false;
        }
        return super.validateData(bl, bl2);
    }

    public void loadValues() {
        this.d_model.loadValues(this.d_measurementSet.getQuantities());
        if (this.d_measurementSet.getQuantities().contains(Quantity.VELOCITY.create())) {
            this.getVelSignCB().setSelectedItem((Object)this.d_measurementSet.getVelocitySign());
        }
        this.updateNumQuansSelected();
        this.updateVelSign();
    }

    public void selectQuantities(Set<IQuantity> set) {
        for (IQuantity iQuantity : set) {
            Integer n = (Integer)this.d_model.d_ixMap.get(iQuantity);
            this.d_tEnabledQuantities.setValueAt(Boolean.TRUE, n, 0);
        }
    }

    public void updateUI() {
        this.d_tEnabledQuantities.updateUI();
    }

    protected Collection<IQuantity> getSelectedQuantities() {
        return this.d_model.saveValues();
    }

    protected Task getSaveTask() {
        final Collection<IQuantity> collection = this.getSelectedQuantities();
        return new AUndoableTask(){
            private List<IQuantity> d_oldMeasurements;
            private VelocitySign d_oldVelocitySign;

            @Override
            public void undo() {
                QuantitySetDlg.this.d_measurementSet.setQuantities(this.d_oldMeasurements);
                QuantitySetDlg.this.d_measurementSet.setVelocitySign(this.d_oldVelocitySign);
            }

            @Override
            public void run() {
                this.d_oldMeasurements = new ArrayList<IQuantity>(QuantitySetDlg.this.d_measurementSet.getQuantities());
                QuantitySetDlg.this.d_measurementSet.setQuantities(collection);
                this.d_oldVelocitySign = QuantitySetDlg.this.d_measurementSet.getVelocitySign();
                if (QuantitySetDlg.this.d_measurementSet.getQuantities().contains(Quantity.VELOCITY.create())) {
                    QuantitySetDlg.this.d_measurementSet.setVelocitySign(QuantitySetDlg.this.getVelSignCB().getSelectedItem());
                }
            }
        };
    }

    private int countSelQuantities() {
        int n = 0;
        for (int i = 0; i < this.d_tEnabledQuantities.getRowCount(); ++i) {
            Boolean bl = (Boolean)this.d_tEnabledQuantities.getValueAt(i, 0);
            boolean bl2 = bl;
            if (!bl2) continue;
            ++n;
        }
        return n;
    }

    protected void updateNumQuansSelected() {
        int n = this.countSelQuantities();
        Color color = n > this.d_maxQuantities ? Color.RED : Color.BLUE;
        this.getNumberQuansChosen().setForeground(color);
        String string = this.d_maxQuantities < Integer.MAX_VALUE ? String.format(Intl.intl("%d/%d Quantities Chosen"), n, this.d_maxQuantities) : String.format(Intl.intl("%d Quantities Chosen"), n);
        this.getNumberQuansChosen().setText(string);
    }

    protected void updateVelSign() {
        Integer n = (Integer)this.d_model.d_ixMap.get(Quantity.VELOCITY.create());
        if (n != null) {
            boolean bl = this.d_model.d_enableStatus[n];
            this.getVelSignCB().setEnabled(bl);
            this.getVelSignLbl().setEnabled(bl);
        }
    }

    protected boolean isMsrSelected(IQuantity iQuantity) {
        return this.d_model.isMsrSelected(iQuantity);
    }

    public boolean containsQauntity(IQuantity iQuantity) {
        return this.d_model.d_ixMap.containsKey(iQuantity);
    }

    protected void updateMeasurementTableModel() {
        Collection<IQuantity> collection = this.d_model.saveValues();
        this.d_model = new MeasurementTableModel(this.d_measurementSet.getOutputType());
        this.d_tEnabledQuantities.setModel(this.d_model);
        this.d_tEnabledQuantities.autoSizeColumns(true, 200);
        TableColumn tableColumn = this.d_tEnabledQuantities.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getPreferredWidth());
        this.d_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                QuantitySetDlg.this.updateNumQuansSelected();
                QuantitySetDlg.this.updateVelSign();
            }
        });
        this.d_model.loadValues(new HashSet<IQuantity>(collection));
    }

    public PyroMod getPyroMod() {
        return this.d_pyromod;
    }

    public SimParams.FileOutput getFileOutput() {
        return this.d_pyromod.getSimParams().getFileOutput();
    }

    public JScrollPane getspEnabledQuantities() {
        return this.d_spEnabledQuantities;
    }

    public guiLabel getNumberQuansChosen() {
        return this.d_lNumberQuansChosen;
    }

    public guiLabel getVelSignLbl() {
        return this.d_velSignLbl;
    }

    public guiComboBox<VelocitySign> getVelSignCB() {
        return this.d_velSignCB;
    }

    public guiTable getQuantitiesTable() {
        return this.d_tEnabledQuantities;
    }

    public JButton getResetButton() {
        return this.d_resetButton;
    }

    protected void clearSelection() {
        for (int i = 0; i < this.d_tEnabledQuantities.getRowCount(); ++i) {
            this.d_tEnabledQuantities.setValueAt(Boolean.FALSE, i, 0);
        }
        this.d_tEnabledQuantities.updateUI();
        this.updateNumQuansSelected();
    }

    protected class ClearAction
    extends guiAction {
        private static final long serialVersionUID = -2553535237002728307L;

        public ClearAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QuantitySetDlg.this.clearSelection();
        }
    }

    protected class ResetAction
    extends guiAction {
        private static final long serialVersionUID = -5099678688259771817L;

        public ResetAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof SplitButton) {
                SplitButton splitButton = (SplitButton)actionEvent.getSource();
                int n = 0;
                int n2 = splitButton.getPreferredSize().height;
                splitButton.getMenu().show(splitButton, n, n2);
            }
        }
    }

    protected class MeasurementTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 7028159279044149212L;
        private final Map<IQuantity, Integer> d_ixMap;
        private final IQuantity[] d_availMsr;
        private final boolean[] d_enableStatus;

        public MeasurementTableModel(int n) {
            ArrayList<StaticQuantity> arrayList = new ArrayList<StaticQuantity>();
            QuantityUtil.TypeFilter typeFilter = new QuantityUtil.TypeFilter(n, new QuantityType[0]);
            arrayList.addAll(QuantityUtil.generateAllObjectQuanties(PyroSim.getApp().getMediator(), typeFilter, true));
            arrayList.addAll(QuantityUtil.generateStaticQuantities(typeFilter, true));
            this.d_availMsr = arrayList.toArray(new IQuantity[arrayList.size()]);
            this.d_ixMap = new HashMap<IQuantity, Integer>();
            int n2 = 0;
            for (IQuantity iQuantity : this.d_availMsr) {
                this.d_ixMap.put(iQuantity, n2++);
            }
            this.d_enableStatus = new boolean[this.d_availMsr.length];
            Arrays.fill(this.d_enableStatus, false);
        }

        protected boolean isMsrSelected(IQuantity iQuantity) {
            int n = this.d_ixMap.get(iQuantity);
            return this.d_enableStatus[n];
        }

        public void loadValues(Set<IQuantity> set) {
            for (IQuantity iQuantity : set) {
                int n = this.d_ixMap.get(iQuantity);
                this.d_enableStatus[n] = true;
            }
        }

        public Collection<IQuantity> saveValues() {
            ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>(5);
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                arrayList.add(this.d_availMsr[i]);
            }
            return arrayList;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.d_availMsr.length;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Intl.intl("Output");
                }
                case 1: {
                    return Intl.intl("Quantity");
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return n == 0 ? Boolean.class : String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.d_enableStatus[n];
                }
                case 1: {
                    return this.d_availMsr[n].getDescription();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            boolean bl;
            boolean bl2;
            if (n2 == 0 && object != null && (bl2 = this.d_enableStatus[n]) != (bl = ((Boolean)object).booleanValue())) {
                this.d_enableStatus[n] = bl;
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

