/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.output.guiOutputUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Task;

public class ProfListDlg
extends guiDialog {
    private static final long serialVersionUID = 9119082078203525066L;
    private guiTableEditor d_tableEd;
    private Unit d_uLen;

    public ProfListDlg(JFrame jFrame, Unit unit) {
        super((Window)jFrame, "Edit Solid Profiles", 9);
        this.d_uLen = unit;
        String string = " (" + unit.toString() + ")";
        String[] stringArray = new String[]{Intl.intl("ID"), Intl.intl("X") + string, Intl.intl("Y") + string, Intl.intl("Z") + string, Intl.intl("ORIENT"), Intl.intl("QUANTITY")};
        Class[] classArray = new Class[]{String.class, Double.class, Double.class, Double.class, String.class, IQuantity.class};
        this.d_tableEd = new guiTableEditor(guiTableUtil.fixedColumnTable(stringArray, classArray), 30);
        this.d_tableEd.getTable().setNullValuesAllowed(false);
        guiTable guiTable2 = this.d_tableEd.getTable();
        guiTable2.setColumnOptions(4, this.ior2str(1), this.ior2str(-1), this.ior2str(2), this.ior2str(-2), this.ior2str(3), this.ior2str(-3));
        QuantityUtil.TypeFilter typeFilter = new QuantityUtil.TypeFilter(256, new QuantityType[0]);
        List<IQuantity> list = QuantityUtil.generateAllQuantities(PyroSim.getApp().getMediator(), typeFilter, true);
        guiTable2.setColumnOptions(5, list);
        Dimension dimension = ((DefaultTableCellRenderer)guiTable2.getDefaultRenderer(Double.class)).getPreferredSize();
        dimension.width = 50;
        ((DefaultTableCellRenderer)guiTable2.getDefaultRenderer(Double.class)).setPreferredSize(dimension);
        ((DefaultTableCellRenderer)guiTable2.getDefaultRenderer(String.class)).setPreferredSize(dimension);
        guiTable2.autoSizeColumns(50);
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new BorderLayout());
        guiPanel2.add((Component)this.d_tableEd, "Center");
    }

    public void init(ProfList profList) {
        int n = 0;
        for (ProfRec profRec : profList.flatten()) {
            this.setRow(n, profRec);
            ++n;
        }
    }

    private void setRow(int n, ProfRec profRec) {
        TableModel tableModel = this.d_tableEd.getTable().getModel();
        IQuantity iQuantity = profRec.getQuantity();
        UnitPoint3D unitPoint3D = profRec.getPoint();
        Point3d point3d = unitPoint3D.getPoint3dValue(this.d_uLen);
        tableModel.setValueAt(profRec.getName(), n, 0);
        tableModel.setValueAt(point3d.x, n, 1);
        tableModel.setValueAt(point3d.y, n, 2);
        tableModel.setValueAt(point3d.z, n, 3);
        tableModel.setValueAt(this.ior2str(profRec.getIOR()), n, 4);
        tableModel.setValueAt(iQuantity, n, 5);
    }

    public Task taskSaveTo(PyroMod pyroMod, ProfList profList) {
        ArrayList<ProfRec> arrayList = new ArrayList<ProfRec>();
        guiTable guiTable2 = this.d_tableEd.getTable();
        int n = guiTable2.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            String string = (String)guiTable2.getValueAt(i, 0);
            double d = (Double)guiTable2.getValueAt(i, 1);
            double d2 = (Double)guiTable2.getValueAt(i, 2);
            double d3 = (Double)guiTable2.getValueAt(i, 3);
            int n2 = this.str2ior((String)guiTable2.getValueAt(i, 4));
            IQuantity iQuantity = (IQuantity)guiTable2.getValueAt(i, 5);
            UnitPoint3D unitPoint3D = new UnitPoint3D(d, d2, d3, this.d_uLen);
            ProfRec profRec = new ProfRec(string, n2, iQuantity, unitPoint3D);
            arrayList.add(profRec);
        }
        return guiOutputUtil.taskReplaceObjs(profList, arrayList);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        guiTable guiTable2 = this.d_tableEd.getTable();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = guiTable2.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            String string = (String)guiTable2.getValueAt(i, 0);
            String string2 = string.toUpperCase();
            if (arrayList.contains(string2)) {
                String string3 = Intl.intl("Error: Duplicate ID ") + "\"" + string + "\"" + "\n" + Intl.intl("Please enter a unique ID for each profile.");
                this.showMessageBox(string3);
                this.requestFocusHack();
                return false;
            }
            arrayList.add(string2);
        }
        return true;
    }

    private int str2ior(String string) {
        if (string.equals("X+")) {
            return 1;
        }
        if (string.equals("X-")) {
            return -1;
        }
        if (string.equals("Y+")) {
            return 2;
        }
        if (string.equals("Y-")) {
            return -2;
        }
        if (string.equals("Z+")) {
            return 3;
        }
        if (string.equals("Z-")) {
            return -3;
        }
        return 0;
    }

    private String ior2str(int n) {
        switch (n) {
            case 1: {
                return "X+";
            }
            case -1: {
                return "X-";
            }
            case 2: {
                return "Y+";
            }
            case -2: {
                return "Y-";
            }
            case 3: {
                return "Z+";
            }
            case -3: {
                return "Z-";
            }
        }
        return "?";
    }
}

