/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.output.QuantitySetDlg;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypedProp;

public class Plot3dDlg
extends QuantitySetDlg {
    private static final long serialVersionUID = -5531515506280662998L;
    private final guiCheckBox d_enable = new guiCheckBox(Intl.intl("Enable Plot 3D Output"));
    private final guiLabel d_intervalLbl = new guiLabel(Intl.intl("Output Interval:"));
    private final ValueField<UnitDouble> d_intervalFd = ValueFields.udFld(UnitSystem.getSource(2), PLOT3d_INTERVAL_RANGE);
    public static final UnitDoubleVR PLOT3d_INTERVAL_RANGE = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), false);

    public Plot3dDlg(JFrame jFrame, String string, AMeasurementSet aMeasurementSet, int n, TypedProp<Integer> typedProp, TypedProp<Integer> typedProp2) {
        super(jFrame, string, aMeasurementSet, n, typedProp, typedProp2, new FDSDefaultAction(Intl.intl("FDS Default")), new PFQuantitiesAction(Intl.intl("Pathfinder Quantities")));
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        LinkStatus.link((AbstractButton)this.d_enable, this.getQuantitiesTable());
        LinkStatus.link((AbstractButton)this.d_enable, this.getNumberQuansChosen());
        LinkStatus.link((AbstractButton)this.d_enable, this.d_intervalLbl);
        LinkStatus.link((AbstractButton)this.d_enable, this.d_intervalFd);
        LinkStatus.link((AbstractButton)this.d_enable, this.getResetButton());
        int n2 = 0;
        GridBagUtil.add(guiPanel2, this.d_enable, 0, n2, 2, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getResetButton(), 2, n2++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
        GridBagUtil.add(guiPanel2, this.getspEnabledQuantities(), 0, n2++, 3, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(guiPanel2, this.d_intervalLbl, 0, n2, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_intervalFd, 1, n2, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getNumberQuansChosen(), 2, n2++, 1, 1, 0, 12, 6, 12, 0, 1.0, 0.0, 13);
        if (this.containsQauntity(Quantity.VELOCITY.create())) {
            GridBagUtil.add(guiPanel2, this.getVelSignLbl(), 0, n2, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.getVelSignCB(), 1, n2++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        }
        this.d_intervalFd.setPreferredSize(new Dimension(this.getVelSignCB().getPreferredSize().width, this.d_intervalFd.getPreferredSize().height));
        this.loadPlot3dSettings();
        this.d_enable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Plot3dDlg.this.setComponentStatus(itemEvent.getStateChange());
            }
        });
    }

    private void setComponentStatus(int n) {
        if (n == 1) {
            this.updateVelSign();
        } else if (n == 2) {
            this.getVelSignLbl().setEnabled(false);
            this.getVelSignCB().setEnabled(false);
        }
    }

    private void loadPlot3dSettings() {
        SimParams.FileOutput fileOutput = this.getFileOutput();
        if (fileOutput.getDtPlot3dFile() != null) {
            this.d_intervalFd.setValue(fileOutput.getDtPlot3dFile());
        } else {
            this.d_intervalFd.setValue(new UnitDouble(10.0, PyroSim.getApp().getUnitSystem().getTimeUnit()));
        }
        boolean bl = fileOutput.getDtPlot3dFile() != null;
        this.d_enable.setSelected(bl);
        if (bl) {
            this.setComponentStatus(1);
        } else {
            this.setComponentStatus(2);
        }
    }

    private void savePlot3dSettings() {
        if (this.d_enable.isSelected()) {
            SimParams.FileOutput fileOutput = this.getFileOutput();
            fileOutput.setDtPlot3dFile((UnitDouble)this.d_intervalFd.getValue());
        } else {
            SimParams.FileOutput fileOutput = this.getFileOutput();
            fileOutput.setDtPlot3dFile(null);
        }
    }

    public Task taskSaveValues() {
        final PyroMod pyroMod = this.getPyroMod();
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.getPyroMod());
        compositeTask.addTask(super.getSaveTask());
        UnitDouble unitDouble = this.d_enable.isSelected() ? (UnitDouble)this.d_intervalFd.getValue() : null;
        compositeTask.addTask(new AReplaceRefTask<UnitDouble>((Object)this.getFileOutput().getDtPlot3dFile(), (Object)unitDouble){

            @Override
            protected void set(UnitDouble unitDouble) {
                pyroMod.getSimParams().getFileOutput().setDtPlot3dFile(unitDouble);
            }
        });
        return compositeTask;
    }

    private static Quantity getQuantityForSpecies(Map<ExSpecList.Predefined, Quantity> map, ExSpec exSpec) {
        for (Map.Entry<ExSpecList.Predefined, Quantity> entry : map.entrySet()) {
            ExSpecList.Predefined predefined = entry.getKey();
            if (!predefined.spec.equals(exSpec)) continue;
            return entry.getValue();
        }
        assert (false);
        return null;
    }

    private void setPFQuantitiesSelection() {
        HashSet<IQuantity> hashSet;
        Object object322;
        HashMap<ExSpecList.Predefined, Quantity> hashMap = new HashMap<ExSpecList.Predefined, Quantity>();
        hashMap.put(ExSpecList.Predefined.CARBON_DIOXIDE, Quantity.SPEC_VOLUME_FRACTION);
        hashMap.put(ExSpecList.Predefined.CARBON_MONOXIDE, Quantity.SPEC_VOLUME_FRACTION);
        hashMap.put(ExSpecList.Predefined.SOOT, Quantity.SPEC_VISIBILITY);
        hashMap.put(ExSpecList.Predefined.OXYGEN, Quantity.SPEC_VOLUME_FRACTION);
        ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>();
        ArrayList<ExSpec> arrayList2 = new ArrayList<ExSpec>();
        ArrayList<ExSpec> arrayList3 = new ArrayList<ExSpec>();
        for (Object object322 : hashMap.keySet()) {
            ExSpec object22 = this.getPyroMod().getExSpecList().find(((ExSpecList.Predefined)((Object)object322)).spec.getName(), ExSpec.class, true);
            if (object22 != null && ((ExSpecList.Predefined)((Object)object322)).spec.equals(object22)) {
                arrayList.add(object22);
                continue;
            }
            if (object22 != null) {
                arrayList3.add(((ExSpecList.Predefined)((Object)object322)).spec);
                continue;
            }
            arrayList2.add(((ExSpecList.Predefined)((Object)object322)).spec);
        }
        if (!arrayList3.isEmpty()) {
            hashSet = new ArrayList();
            for (ExSpec exSpec : arrayList3) {
                Quantity quantity = Plot3dDlg.getQuantityForSpecies(hashMap, exSpec);
                hashSet.add((IQuantity)((Object)String.format("[%s] %s", exSpec.getName(), quantity.name)));
            }
            object322 = String.format(Intl.intl("Non-default Pathfinder species must be selected manually:%n%s%n"), String.join((CharSequence)"\n", hashSet));
            JOptionPane.showMessageDialog(this, object322);
        }
        hashSet = new HashSet<IQuantity>();
        for (ExSpec exSpec : arrayList) {
            if (exSpec == null) continue;
            Quantity quantity = Plot3dDlg.getQuantityForSpecies(hashMap, exSpec);
            hashSet.add(quantity.create(exSpec));
        }
        if (!arrayList2.isEmpty()) {
            String string;
            object322 = new LinkedList();
            for (ExSpec exSpec : arrayList2) {
                object322.add(exSpec.getName());
            }
            String string2 = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)object322);
            String string3 = arrayList2.size() == 1 ? Intl.intl("The following Pathfinder species is missing:%n%s%nDo you want to add this species?") : Intl.intl("The following Pathfinder species are missing:%n%s%nDo you want to add these species?");
            String string4 = String.format(string3, string2);
            int n = JOptionPane.showConfirmDialog(this, string4, string = String.format(Intl.intl("Add missing species"), new Object[0]), 1);
            if (n == 0) {
                ArrayList<ExSpec> arrayList4 = new ArrayList<ExSpec>(arrayList2.size());
                for (ExSpec exSpec : arrayList2) {
                    arrayList4.add((ExSpec)exSpec.clone());
                }
                AddTask addTask = new AddTask((IPyroObject)this.getPyroMod().getExSpecList(), arrayList4);
                this.getPyroMod().getTaskManager().exec(addTask, Intl.intl("New Extra Species"));
                this.updateMeasurementTableModel();
                for (ExSpec exSpec : arrayList4) {
                    Quantity quantity = Plot3dDlg.getQuantityForSpecies(hashMap, exSpec);
                    hashSet.add(quantity.create(exSpec));
                }
            } else if (n == 2) {
                return;
            }
        }
        this.clearSelection();
        this.selectQuantities(hashSet);
        this.updateUI();
        this.updateNumQuansSelected();
    }

    private void setFDSDefaultSelection() {
        this.selectQuantities(new Plot3d().getQuantities());
    }

    private static class PFQuantitiesAction
    extends guiAction {
        private static final long serialVersionUID = 8281328019102077230L;

        public PFQuantitiesAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.getValue("QuantityDlg") instanceof Plot3dDlg) {
                Plot3dDlg plot3dDlg = (Plot3dDlg)this.getValue("QuantityDlg");
                plot3dDlg.setPFQuantitiesSelection();
            }
        }
    }

    private static class FDSDefaultAction
    extends guiAction {
        private static final long serialVersionUID = -4066927347979838926L;

        public FDSDefaultAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.getValue("QuantityDlg") instanceof Plot3dDlg) {
                Plot3dDlg plot3dDlg = (Plot3dDlg)this.getValue("QuantityDlg");
                plot3dDlg.clearSelection();
                plot3dDlg.setFDSDefaultSelection();
            }
        }
    }
}

