/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import javax.swing.JDialog;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.SolidMsrStat;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.NewTypeDlg;
import pyrosim.gui.comboboxes.QuantityComboBox;

public class NewStatDlg
extends NewTypeDlg<IMeasurementStat, IQuantity> {
    private static final long serialVersionUID = -461338032515125141L;

    public NewStatDlg(JDialog jDialog, PyroMod pyroMod) {
        super(jDialog, Intl.intl("New Statistic"), pyroMod.getMsrStatMgr(), Intl.intl("Quantity:"), NewStatDlg.getQuantityCB());
    }

    private static QuantityComboBox getQuantityCB() {
        return new QuantityComboBox(new QuantityUtil.TypeFilter(1, new QuantityType[]{QuantityType.GAS, QuantityType.SOLID}){

            @Override
            public boolean test(Quantity quantity) {
                return super.test(quantity) && QuantityUtil.canOutputAny(quantity, -65536);
            }
        });
    }

    public IMeasurementStat createStat() {
        String string = this.getSelectedName();
        IQuantity iQuantity = (IQuantity)this.getSelectedType();
        if (iQuantity.get().quantityType == QuantityType.GAS) {
            return new GasMsrStat(string, iQuantity);
        }
        return new SolidMsrStat(string, iQuantity);
    }

    @Override
    protected void validateName(PyroMod pyroMod, IQuantity iQuantity, String string) throws Exception {
        if (pyroMod.getNames(IMeasurementStat.class).isRegistered(string)) {
            throw new NewTypeDlg.NameInUseException();
        }
    }

    @Override
    protected String getNameSuggestion(PyroMod pyroMod, IQuantity iQuantity) {
        String string = iQuantity.getDescription();
        return pyroMod.getNames(IMeasurementStat.class).generateValidName(string);
    }
}

