/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.gui.output.guiOutputUtil;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Task;

public class IsofDialog
extends guiDialog {
    private static final long serialVersionUID = -2175863594477471684L;
    private final PyroMod d_pyroMod = PyroSim.getApp().getMediator();
    private final UnitSystem d_unitSystem = PyroSim.getApp().getUnitSystem();
    private final IsosurfaceMgr d_isofList = this.d_pyroMod.getIsofList();
    private final guiTable d_table;
    private final IsofTableModel d_model = new IsofTableModel();
    private final guiComboBox<VelocitySign> d_velSignCB;

    public IsofDialog(JFrame jFrame) {
        super((Window)jFrame, Intl.intl("Animated Isosurfaces"), 9);
        this.d_table = new guiTable((TableModel)this.d_model, 0);
        TableColumn tableColumn = this.d_table.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new UnitDoubleListRenderer());
        tableColumn.setCellEditor(new UnitDoubleListEditor());
        JScrollPane jScrollPane = new JScrollPane(this.d_table);
        TableColumn tableColumn2 = this.d_table.getColumnModel().getColumn(0);
        tableColumn2.setMaxWidth(tableColumn2.getPreferredWidth());
        tableColumn.setPreferredWidth(200);
        this.d_table.autoSizeColumns(true, 200);
        final guiLabel guiLabel2 = new guiLabel(Intl.intl("Velocity Sign:"));
        guiLabel2.setToolTipText("VELO_INDEX");
        this.d_velSignCB = new guiComboBox<VelocitySign>(VelocitySign.values());
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Multiple contour values must be separated by a semi-colon (;)."));
        int n = 0;
        GridBagUtil.add(guiPanel2, jScrollPane, 0, n++, 2, 1, 0, 18, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, 0, n++, 2, 1, 0, 18, 12, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel2, 0, n, 1, 1, 0, 18, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_velSignCB, 1, n++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        this.d_model.loadValues();
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastIsofDlgSizeX.key.toString(), PyroPrefs.LastIsofDlgSizeY.key.toString());
        this.d_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                if (n2 == 0) {
                    if (((Boolean)IsofDialog.this.d_model.getValueAt(n, n2)).booleanValue()) {
                        IsofDialog.this.d_table.changeSelection(n, 2, false, false);
                    }
                    IsofDialog.this.updateVelIndexComps(new Component[]{guiLabel2, IsofDialog.this.d_velSignCB});
                } else if (n2 == 2) {
                    List list = (List)IsofDialog.this.d_model.getValueAt(n, n2);
                    boolean bl = list != null && !list.isEmpty();
                    IsofDialog.this.d_model.setValueAt(bl, n, 0);
                }
            }
        });
        this.updateVelIndexComps(guiLabel2, this.d_velSignCB);
    }

    private void updateVelIndexComps(Component ... componentArray) {
        int n = (Integer)this.d_model.d_ixMap.get(Quantity.VELOCITY.create());
        boolean bl = this.d_model.d_enableStatus[n];
        for (Component component : componentArray) {
            component.setEnabled(bl);
        }
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        this.savePreferredSize(PyroPrefs.LastIsofDlgSizeX.key.toString(), PyroPrefs.LastIsofDlgSizeY.key.toString());
        if (n == 1) {
            this.d_model.saveValues();
        }
        return n;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        return this.d_model.validateData();
    }

    private String renderUDList(JTable jTable, int n, int n2, List<UnitDouble> list) {
        IQuantity iQuantity = this.d_model.d_availQuant[n];
        Unit unit = this.d_unitSystem.getUnit(iQuantity.get().unitType);
        StringBuffer stringBuffer = new StringBuffer();
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(Global.format(list.get(i).getValue(unit)));
            }
        }
        return stringBuffer.toString();
    }

    private List<UnitDouble> parseUDList(IQuantity iQuantity, String string) {
        Unit unit = this.d_unitSystem.getUnit(iQuantity.get().unitType);
        ArrayList<UnitDouble> arrayList = new ArrayList<UnitDouble>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                double d = Global.parseDouble(string2);
                arrayList.add(new UnitDouble(d, unit));
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return arrayList;
    }

    private class UnitDoubleListEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -1074854858125563035L;
        private IQuantity d_editingQuant;
        private List<UnitDouble> d_list;

        public UnitDoubleListEditor() {
            super(new JTextField());
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JTextField jTextField = (JTextField)this.getComponent();
            this.d_editingQuant = IsofDialog.this.d_model.d_availQuant[n];
            this.d_list = (List)object;
            jTextField.setText(IsofDialog.this.renderUDList(jTable, n, n2, this.d_list));
            return jTextField;
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            List list = IsofDialog.this.parseUDList(this.d_editingQuant, jTextField.getText());
            if (list == null) {
                return false;
            }
            this.d_list = list;
            super.stopCellEditing();
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.d_list;
        }
    }

    private class UnitDoubleListRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7427803260924126284L;

        public UnitDoubleListRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            List list = (List)object;
            this.setText(IsofDialog.this.renderUDList(jTable, n, n2, list));
            return component;
        }
    }

    private class IsofTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4722072538908121092L;
        private final Map<IQuantity, Integer> d_ixMap;
        private final IQuantity[] d_availQuant;
        private final boolean[] d_enableStatus;
        private final List<UnitDouble>[] d_contours;

        public IsofTableModel() {
            QuantityUtil.TypeFilter typeFilter = new QuantityUtil.TypeFilter(32, new QuantityType[0]);
            ArrayList<StaticQuantity> arrayList = new ArrayList<StaticQuantity>();
            arrayList.addAll(QuantityUtil.generateAllObjectQuanties(IsofDialog.this.d_pyroMod, typeFilter, true));
            arrayList.addAll(QuantityUtil.generateStaticQuantities(typeFilter, true));
            this.d_availQuant = arrayList.toArray(new IQuantity[arrayList.size()]);
            this.d_ixMap = new HashMap<IQuantity, Integer>();
            int n = 0;
            for (IQuantity iQuantity : this.d_availQuant) {
                this.d_ixMap.put(iQuantity, n++);
            }
            this.d_enableStatus = new boolean[this.d_availQuant.length];
            Arrays.fill(this.d_enableStatus, false);
            this.d_contours = new List[this.d_availQuant.length];
            for (int i = 0; i < this.d_availQuant.length; ++i) {
                this.d_contours[i] = new ArrayList<UnitDouble>();
            }
        }

        public boolean validateData() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                List list;
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue() || !(list = (List)this.getValueAt(i, 2)).isEmpty()) continue;
                IsofDialog.this.showMessageBox(Intl.intl("Each enabled quantity must have a list of contour values."));
                return false;
            }
            return true;
        }

        public void loadValues() {
            for (Isosurface isosurface : IsofDialog.this.d_isofList.flatten()) {
                int n = this.d_ixMap.get(isosurface.getQuantity());
                this.setValueAt(true, n, 0);
                this.setValueAt(isosurface.getContours(), n, 2);
                if (!isosurface.getQuantity().get().equals((Object)Quantity.VELOCITY)) continue;
                IsofDialog.this.d_velSignCB.setSelectedItem((Object)isosurface.getVelocitySign());
            }
        }

        public void saveValues() {
            ArrayList<Isosurface> arrayList = new ArrayList<Isosurface>();
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.d_enableStatus[i]) continue;
                IQuantity iQuantity = this.d_availQuant[i];
                List list = (List)this.getValueAt(i, 2);
                Isosurface isosurface = new Isosurface(iQuantity, list);
                if (iQuantity.get().equals((Object)Quantity.VELOCITY)) {
                    isosurface.setVelocitySign((VelocitySign)((Object)IsofDialog.this.d_velSignCB.getSelectedItem()));
                }
                arrayList.add(isosurface);
            }
            Task task = guiOutputUtil.taskReplaceObjs(IsofDialog.this.d_isofList, arrayList);
            IsofDialog.this.d_pyroMod.getTaskManager().exec(task, Intl.intl("Save Isosurfaces"));
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.d_availQuant.length;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Intl.intl("Output");
                }
                case 1: {
                    return Intl.intl("Quantity");
                }
                case 2: {
                    return Intl.intl("Contour Values");
                }
                case 3: {
                    return Intl.intl("Unit");
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return List.class;
                }
                case 3: {
                    return Unit.class;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.d_enableStatus[n];
                }
                case 1: {
                    return this.d_availQuant[n].getDescription();
                }
                case 2: {
                    return this.d_contours[n];
                }
                case 3: {
                    return IsofDialog.this.d_unitSystem.getUnit(this.d_availQuant[n].get().unitType);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || n2 == 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            boolean bl = true;
            switch (n2) {
                case 0: {
                    if (object == null) break;
                    this.d_enableStatus[n] = (Boolean)object;
                    break;
                }
                case 2: {
                    ArrayList<UnitDouble> arrayList = object == null ? new ArrayList<UnitDouble>(0) : new ArrayList((List)object);
                    IQuantity iQuantity = this.d_availQuant[n];
                    Unit unit = IsofDialog.this.d_unitSystem.getUnit(iQuantity.get().unitType);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        UnitDouble unitDouble = (UnitDouble)arrayList.get(i);
                        if (UnitDouble.areCompatible(unitDouble.getUnit(), unit)) continue;
                        arrayList.set(i, new UnitDouble(unitDouble.getValueNoUnit(), unit));
                    }
                    this.d_contours[n] = arrayList;
                    break;
                }
                default: {
                    assert (false);
                    bl = false;
                }
            }
            if (bl) {
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

