/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point3d;
import junit.framework.TestCase;
import org.jscience.physics.units.Unit;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.gui.grid.Validator;
import thunderheadeng.units.UnitPoint3D;

public class ValidatorTest
extends TestCase {
    public void testCompleteIsect() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(10.0, 10.0, 10.0);
        int n = Validator.getOverlap(point3d, point3d2, point3d, point3d2, 1.0E-6);
        ValidatorTest.assertSame((Object)7, (Object)n);
    }

    public void testInnerIsect() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(10.0, 10.0, 10.0);
        Point3d point3d3 = new Point3d(1.0, 1.0, 1.0);
        Point3d point3d4 = new Point3d(9.0, 9.0, 9.0);
        int n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)7, (Object)n);
    }

    public void testOuterIsect() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(10.0, 10.0, 10.0);
        Point3d point3d3 = new Point3d(1.0, 1.0, 1.0);
        Point3d point3d4 = new Point3d(11.0, 11.0, 9.0);
        int n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)7, (Object)n);
    }

    public void testNoOverlapPosX() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(10.0, 10.0, 10.0);
        Point3d point3d3 = new Point3d(20.0, 0.0, 0.0);
        Point3d point3d4 = new Point3d(30.0, 10.0, 10.0);
        int n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)0, (Object)n);
    }

    public void testNoOverlapNegX() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(10.0, 10.0, 10.0);
        Point3d point3d3 = new Point3d(-20.0, 0.0, 0.0);
        Point3d point3d4 = new Point3d(-10.0, 10.0, 10.0);
        int n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)0, (Object)n);
    }

    public void testTouchPosX() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(10.0, 10.0, 10.0);
        Point3d point3d3 = new Point3d(10.0, 0.0, 0.0);
        Point3d point3d4 = new Point3d(20.0, 10.0, 10.0);
        int n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)1, (Object)n);
        point3d3 = new Point3d(10.0, 5.0, -5.0);
        point3d4 = new Point3d(20.0, 15.0, 5.0);
        n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)1, (Object)n);
    }

    public void testTouchNegX() {
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(10.0, 10.0, 10.0);
        Point3d point3d3 = new Point3d(-10.0, 0.0, 0.0);
        Point3d point3d4 = new Point3d(0.0, 10.0, 10.0);
        int n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)1, (Object)n);
        point3d3 = new Point3d(-10.0, 5.0, -5.0);
        point3d4 = new Point3d(0.0, 15.0, 5.0);
        n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
        ValidatorTest.assertSame((Object)1, (Object)n);
    }

    public void testGrid1() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 4, 4, 4);
        Grid grid2 = new Grid("", new UnitPoint3D(1.0, 0.0, 0.0, unit), new UnitPoint3D(2.0, 1.0, 1.0, unit), 4, 4, 4);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get(0).isValid());
        ValidatorTest.assertTrue((boolean)list.get(1).isValid());
    }

    public void testGrid2() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 4, 4, 4);
        Grid grid2 = new Grid("", new UnitPoint3D(1.0, 0.0, 0.0, unit), new UnitPoint3D(2.0, 1.0, 1.0, unit), 8, 8, 8);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get(0).isValid());
        ValidatorTest.assertTrue((boolean)list.get(1).isValid());
    }

    public void testGrid2a() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 4, 4, 4);
        Grid grid2 = new Grid("", new UnitPoint3D(1.0, 0.0, 0.0, unit), new UnitPoint3D(2.0, 0.875, 1.0, unit), 8, 7, 8);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)0).unalignedTouch.contains(grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)1).unalignedTouch.contains(grid));
    }

    public void testGrid2b() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 4, 4, 4);
        Grid grid2 = new Grid("", new UnitPoint3D(1.0, 0.0, 0.0, unit), new UnitPoint3D(2.0, 0.75, 1.0, unit), 8, 6, 8);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get(0).isValid());
        ValidatorTest.assertTrue((boolean)list.get(1).isValid());
    }

    public void testGrid3() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 4, 4, 4);
        Grid grid2 = new Grid("", new UnitPoint3D(0.75, 0.25, 0.0, unit), new UnitPoint3D(1.75, 1.25, 1.0, unit), 8, 8, 8);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)0).alignedOverlap.contains(grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)1).alignedOverlap.contains(grid));
    }

    public void testGrid3a() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 4, 4, 4);
        Grid grid2 = new Grid("", new UnitPoint3D(0.75, 0.25, 0.0, unit), new UnitPoint3D(1.75, 1.25, 1.0, unit), 10, 8, 8);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)0).unalignedOverlap.contains(grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)1).unalignedOverlap.contains(grid));
    }

    public void testGrid4() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 4, 4, 4);
        Grid grid2 = new Grid("", new UnitPoint3D(1.0, 0.0, 0.0, unit), new UnitPoint3D(2.0, 1.0, 1.0, unit), 10, 10, 10);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)0).unalignedTouch.contains(grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)1).unalignedTouch.contains(grid));
    }

    public void testGrid5() {
        Unit unit = Geometry.LU;
        Grid grid = new Grid("", new UnitPoint3D(0.0, 0.0, 0.0, unit), new UnitPoint3D(1.0, 1.0, 1.0, unit), 20, 20, 6);
        Grid grid2 = new Grid("", new UnitPoint3D(1.0, 0.0, 0.0, unit), new UnitPoint3D(2.0, 1.0, 1.0, unit), 20, 10, 12);
        List<Validator.Alignment> list = Validator.getValidity(Arrays.asList(grid, grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)0).unalignedTouch.contains(grid2));
        ValidatorTest.assertTrue((boolean)list.get((int)1).unalignedTouch.contains(grid));
    }
}

