/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderProps;
import thunderheadeng.units.UnitDouble;

public class Validator {
    public static final int OVERLAP_NONE = 0;
    public static final int OVERLAP_INTERSECT = 7;
    public static final int OVERLAP_TOUCH_X_FACE = 1;
    public static final int OVERLAP_TOUCH_Y_FACE = 2;
    public static final int OVERLAP_TOUCH_Z_FACE = 3;

    public static List<Alignment> getValidity(List<? extends Grid> list) {
        Unit unit = Geometry.LU;
        Alignment[] alignmentArray = new Alignment[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            alignmentArray[i] = new Alignment();
        }
        Grid[] gridArray = list.toArray(new Grid[list.size()]);
        for (int i = 0; i < gridArray.length; ++i) {
            Grid grid = gridArray[i];
            if (!grid.isEnabled()) continue;
            Point3d point3d = grid.getMinPoint().getPoint3dValue(unit);
            Point3d point3d2 = grid.getMaxPoint().getPoint3dValue(unit);
            Alignment alignment = alignmentArray[i];
            for (int j = i + 1; j < gridArray.length; ++j) {
                Grid grid2 = gridArray[j];
                if (!grid2.isEnabled()) continue;
                Point3d point3d3 = grid2.getMinPoint().getPoint3dValue(unit);
                Point3d point3d4 = grid2.getMaxPoint().getPoint3dValue(unit);
                Alignment alignment2 = alignmentArray[j];
                int n = Validator.getOverlap(point3d, point3d2, point3d3, point3d4, 1.0E-6);
                Validator.getAlignment(grid, grid2, alignment, alignment2, n);
            }
        }
        return Arrays.asList(alignmentArray);
    }

    public static Alignment getValidity(List<? extends Grid> list, Grid grid) {
        Unit unit = Geometry.LU;
        Alignment alignment = new Alignment();
        if (!grid.isEnabled()) {
            return alignment;
        }
        Grid[] gridArray = list.toArray(new Grid[list.size()]);
        Grid grid2 = grid;
        Point3d point3d = grid2.getMinPoint().getPoint3dValue(unit);
        Point3d point3d2 = grid2.getMaxPoint().getPoint3dValue(unit);
        for (int i = 0; i < gridArray.length; ++i) {
            Grid grid3 = gridArray[i];
            if (grid3 == grid2 || grid2.getEvacuation() != grid3.getEvacuation() || !grid3.isEnabled()) continue;
            Point3d point3d3 = grid3.getMinPoint().getPoint3dValue(unit);
            Point3d point3d4 = grid3.getMaxPoint().getPoint3dValue(unit);
            PyroSim pyroSim = PyroSim.getApp();
            FDSRenderProps fDSRenderProps = pyroSim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter iDecimalFormatter = fDSRenderProps.getDecimalFormatter();
            int n = Validator.getOverlap(Validator.getRoundedP3d(point3d, iDecimalFormatter), Validator.getRoundedP3d(point3d2, iDecimalFormatter), Validator.getRoundedP3d(point3d3, iDecimalFormatter), Validator.getRoundedP3d(point3d4, iDecimalFormatter), 1.0E-6);
            Validator.getAlignment(grid2, grid3, alignment, null, n);
        }
        return alignment;
    }

    private static Point3d getRoundedP3d(Point3d point3d, FDSRenderProps.IDecimalFormatter iDecimalFormatter) {
        try {
            return new Point3d(Double.parseDouble(iDecimalFormatter.format(point3d.x)), Double.parseDouble(iDecimalFormatter.format(point3d.y)), Double.parseDouble(iDecimalFormatter.format(point3d.z)));
        }
        catch (Exception exception) {
            return point3d;
        }
    }

    private static void getAlignment(Grid grid, Grid grid2, Alignment alignment, Alignment alignment2, int n) {
        if (n == 0) {
            return;
        }
        if (n == 7) {
            boolean bl = true;
            for (int i = 1; i <= 3 && (bl &= Validator.isTouchValid(grid, grid2, i, 1.0E-6)); ++i) {
            }
            if (bl) {
                alignment.alignedOverlap.add(grid2);
                if (alignment2 != null) {
                    alignment2.alignedOverlap.add(grid);
                }
            } else {
                alignment.unalignedOverlap.add(grid2);
                if (alignment2 != null) {
                    alignment2.unalignedOverlap.add(grid);
                }
            }
        } else {
            boolean bl = Validator.isTouchValid(grid, grid2, n, 1.0E-6);
            if (!bl) {
                alignment.unalignedTouch.add(grid2);
                if (alignment2 != null) {
                    alignment2.unalignedTouch.add(grid);
                }
            }
        }
    }

    private static int compare(double d, double d2, double d3) {
        if (d == d2 || Math.abs(d - d2) < d3) {
            return 0;
        }
        return Double.compare(d, d2);
    }

    protected static int getOverlap(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        boolean bl;
        int n = Validator.compare(point3d2.x, point3d3.x, d);
        int n2 = Validator.compare(point3d.x, point3d4.x, d);
        int n3 = Validator.compare(point3d2.y, point3d3.y, d);
        int n4 = Validator.compare(point3d.y, point3d4.y, d);
        int n5 = Validator.compare(point3d2.z, point3d3.z, d);
        int n6 = Validator.compare(point3d.z, point3d4.z, d);
        boolean bl2 = n2 < 0 && n > 0;
        boolean bl3 = n4 < 0 && n3 > 0;
        boolean bl4 = bl = n6 < 0 && n5 > 0;
        if (bl2 && bl3 && bl) {
            return 7;
        }
        if (n2 == 0 || n == 0) {
            return bl3 && bl ? 1 : 0;
        }
        if (n4 == 0 || n3 == 0) {
            return bl2 && bl ? 2 : 0;
        }
        if (n6 == 0 || n5 == 0) {
            return bl2 && bl3 ? 3 : 0;
        }
        return 0;
    }

    private static Double[] toDoubles(UnitDouble[] unitDoubleArray, Unit unit) {
        Double[] doubleArray = new Double[unitDoubleArray.length];
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            doubleArray[i] = unitDoubleArray[i].getValue(unit);
        }
        return doubleArray;
    }

    protected static boolean isTouchValid(Grid grid, Grid grid2, int n, double d) {
        UnitDouble[] unitDoubleArray = null;
        UnitDouble[] unitDoubleArray2 = null;
        UnitDouble[] unitDoubleArray3 = null;
        UnitDouble[] unitDoubleArray4 = null;
        switch (n) {
            case 1: {
                unitDoubleArray = grid.getYLinePositions();
                unitDoubleArray3 = grid.getZLinePositions();
                unitDoubleArray2 = grid2.getYLinePositions();
                unitDoubleArray4 = grid2.getZLinePositions();
                break;
            }
            case 2: {
                unitDoubleArray = grid.getXLinePositions();
                unitDoubleArray3 = grid.getZLinePositions();
                unitDoubleArray2 = grid2.getXLinePositions();
                unitDoubleArray4 = grid2.getZLinePositions();
                break;
            }
            case 3: {
                unitDoubleArray = grid.getXLinePositions();
                unitDoubleArray3 = grid.getYLinePositions();
                unitDoubleArray2 = grid2.getXLinePositions();
                unitDoubleArray4 = grid2.getYLinePositions();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Unit unit = Geometry.LU;
        return Validator.isTouchValid(Validator.toDoubles(unitDoubleArray, unit), Validator.toDoubles(unitDoubleArray3, unit), Validator.toDoubles(unitDoubleArray2, unit), Validator.toDoubles(unitDoubleArray4, unit), d);
    }

    protected static boolean isTouchValid(Double[] doubleArray, Double[] doubleArray2, Double[] doubleArray3, Double[] doubleArray4, double d) {
        TolComparator tolComparator = new TolComparator(d);
        return Validator.areCellsFilled(doubleArray, doubleArray2, doubleArray3, doubleArray4, tolComparator) && Validator.areCellsFilled(doubleArray3, doubleArray4, doubleArray, doubleArray2, tolComparator);
    }

    protected static boolean areCellsFilled(Double[] doubleArray, Double[] doubleArray2, Double[] doubleArray3, Double[] doubleArray4, Comparator<Double> comparator) {
        for (int i = 0; i < doubleArray.length - 1; ++i) {
            for (int j = 0; j < doubleArray2.length - 1; ++j) {
                double d;
                double d2 = doubleArray[i];
                double d3 = doubleArray[i + 1];
                double d4 = doubleArray2[j];
                if (Validator.isCellFilled(d2, d4, d3, d = doubleArray2[j + 1].doubleValue(), doubleArray3, doubleArray4, comparator)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean isCellFilled(double d, double d2, double d3, double d4, Double[] doubleArray, Double[] doubleArray2, Comparator<Double> comparator) {
        double d5 = doubleArray.length - 1;
        double d6 = doubleArray2.length - 1;
        int n = Validator.findCellBoundary(d, doubleArray, -1, comparator);
        int n2 = Validator.findCellBoundary(d3, doubleArray, 1, comparator);
        int n3 = Validator.findCellBoundary(d2, doubleArray2, -1, comparator);
        int n4 = Validator.findCellBoundary(d4, doubleArray2, 1, comparator);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        if (n5 == 1 && n6 == 1) {
            return true;
        }
        if (n < 0 && n2 <= 0 || (double)n >= d5 && (double)n2 > d5 || n3 < 0 && n4 <= 0 || (double)n3 >= d6 && (double)n4 > d6) {
            return true;
        }
        if (n < 0 && n2 > 0 || (double)n < d5 && (double)n2 > d5 || n3 < 0 && n4 > 0 || (double)n3 < d6 && (double)n4 > d6) {
            return false;
        }
        double d7 = (d4 - d2) * (d3 - d);
        double d8 = 0.0;
        double d9 = 0.0;
        for (int i = n; i < n2; ++i) {
            double d10 = doubleArray[i];
            double d11 = doubleArray[i + 1];
            for (int j = n3; j < n4; ++j) {
                double d12 = doubleArray2[j];
                double d13 = doubleArray2[j + 1];
                d8 += (d11 - d10) * (d13 - d12);
                d9 += Validator.getOverlapArea(d, d2, d3, d4, d10, d12, d11, d13);
            }
        }
        return comparator.compare(d7, d8) == 0 && comparator.compare(d7, d9) == 0;
    }

    private static double getOverlapArea(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = Math.max(d, d5);
        double d10 = Math.min(d3, d7);
        double d11 = Math.max(d2, d6);
        double d12 = Math.min(d4, d8);
        return (d10 - d9) * (d12 - d11);
    }

    private static int findCellBoundary(double d, Double[] doubleArray, int n, Comparator<Double> comparator) {
        int n2 = Arrays.binarySearch(doubleArray, d, comparator);
        if (n2 >= 0) {
            return n2;
        }
        return n < 0 ? -n2 - 2 : -n2 - 1;
    }

    private static boolean isIntegral(double d) {
        return d - Math.floor(d) == 0.0;
    }

    private static class TolComparator
    implements Comparator<Double> {
        private final double tol;

        public TolComparator(double d) {
            this.tol = d;
        }

        @Override
        public int compare(Double d, Double d2) {
            return Validator.compare(d, d2, this.tol);
        }
    }

    public static class Alignment {
        public final List<Grid> alignedOverlap = new ArrayList<Grid>();
        public final List<Grid> unalignedOverlap = new ArrayList<Grid>();
        public final List<Grid> unalignedTouch = new ArrayList<Grid>();

        public boolean isValid() {
            return this.alignedOverlap.isEmpty() && this.unalignedOverlap.isEmpty() && this.unalignedTouch.isEmpty();
        }

        public boolean isQuestionable() {
            return this.unalignedTouch.isEmpty() && !this.alignedOverlap.isEmpty() && this.unalignedOverlap.isEmpty();
        }
    }
}

