/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Window;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;

public class SplitMeshDlg
extends guiDialog {
    private static final long serialVersionUID = 2921449540230054081L;
    private guiComboBox<Geometry.Axis> d_cbAxis = new guiComboBox<Geometry.Axis>(Geometry.Axis.values());
    private ValueField<UnitDouble> d_value = ValueFields.udFld(UnitSystem.getSource(0));

    public SplitMeshDlg(Window window, UnitSystem unitSystem, AABox aABox) {
        super(window, Intl.intl("Split Mesh"), 9);
        AABoxGeomEditor aABoxGeomEditor = new AABoxGeomEditor(false, true);
        aABoxGeomEditor.setEnabled(false);
        aABoxGeomEditor.load(new AABoxGeom(aABox));
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addRow(Intl.intl("Split Near:"), this.d_cbAxis, "=", this.d_value);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Bounding Box")));
        gridBagHelper.addFilledRow(aABoxGeomEditor);
    }

    public Geometry.Axis getAxis() {
        return this.d_cbAxis.getSelectedItem();
    }

    public UnitDouble getValue() {
        return (UnitDouble)this.d_value.getValue();
    }

    public static double roundToSignificantFigures(double d, int n) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Math.ceil(Math.log10(d < 0.0 ? -d : d));
        int n2 = n - (int)d2;
        double d3 = Math.pow(10.0, n2);
        long l = Math.round(d * d3);
        return (double)l / d3;
    }
}

