/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.grid.GridCreator;
import pyrosim.gui.grid.GridPanel;
import pyrosim.gui.grid.MeshmakerGridCreator;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;

public class RegularGridCreator
implements GridCreator {
    private static final DecimalFormat FMT1 = new DecimalFormat("0.0");
    private static final DecimalFormat FMT2 = new DecimalFormat("0.00");
    private static final DecimalFormat FMT3 = new DecimalFormat("0.000");
    private static final DecimalFormat FMT4 = new DecimalFormat("0.0000");
    private static final Icon ICON_GOOD = PyroGuiUtil.loadPyroSimIcon("good.png");
    private static final Icon ICON_MAYBE = PyroGuiUtil.loadPyroSimIcon("maybe.png");
    private static final Icon ICON_BAD = PyroGuiUtil.loadPyroSimIcon("bad.png");
    private static final Icon ICON_NONE = PyroGuiUtil.loadPyroSimIcon("none.png");
    private PyroMod d_pyMod;
    private guiLabel d_labX;
    private guiLabel d_labY;
    private guiLabel d_labZ;
    private ValueField<Integer> d_fldX;
    private ValueField<Integer> d_fldY;
    private ValueField<Integer> d_fldZ;
    private guiLabel d_labWarnRatioX;
    private guiLabel d_labWarnRatioY;
    private guiLabel d_labWarnRatioZ;
    private MultiLineLabel d_warningLabel;
    private guiLabel d_labCellsForGrid;
    private guiLabel d_labTotalCells;
    private guiLabel d_labCellSz;
    private Grid d_currentGrid;
    private guiPanel d_panel;
    private GridPanel d_gp;
    private static final Color ORANGE_TEXT = Color.ORANGE.darker().darker().darker().darker();

    public RegularGridCreator(GridPanel gridPanel) {
        PyroMod pyroMod;
        this.d_pyMod = pyroMod = PyroSim.getApp().getMediator();
        this.d_gp = gridPanel;
        this.d_panel = this.createPanel();
        this.setValues(null);
        this.updateWarnings();
    }

    @Override
    public guiPanel getPanel() {
        return this.d_panel;
    }

    private guiPanel createPanel() {
        guiPanel guiPanel2 = new guiPanel();
        guiPanel2.setLayout(new GridBagLayout());
        this.d_fldX = ValueFields.intFld(IntVR.above(3, true));
        this.d_fldY = ValueFields.intFld(IntVR.above(1, true));
        this.d_fldZ = ValueFields.intFld(IntVR.above(1, true));
        int n = 0;
        this.d_labX = new guiLabel(Intl.intl("X Cells") + ":");
        this.d_labWarnRatioX = this.mkRatioWarningLabel();
        GridBagUtil.add(guiPanel2, this.d_labX, 0, n, 1, 1, 0, 0, 5, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_fldX, 1, n, 1, 1, 0, 0, 5, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_labWarnRatioX, 2, n, 1, 1, 0, 0, 5, 12, 0, 0.0, 0.0, 17);
        this.d_labY = new guiLabel(Intl.intl("Y Cells") + ":");
        this.d_labWarnRatioY = this.mkRatioWarningLabel();
        GridBagUtil.add(guiPanel2, this.d_labY, 0, ++n, 1, 1, 0, 0, 5, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_fldY, 1, n, 1, 1, 0, 0, 5, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_labWarnRatioY, 2, n, 1, 1, 0, 0, 5, 12, 0, 0.0, 0.0, 17);
        this.d_labZ = new guiLabel(Intl.intl("Z Cells") + ":");
        this.d_labWarnRatioZ = this.mkRatioWarningLabel();
        GridBagUtil.add(guiPanel2, this.d_labZ, 0, ++n, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_fldZ, 1, n, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_labWarnRatioZ, 2, n, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        this.d_labCellSz = new guiLabel();
        this.d_labCellSz.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CellSizeEditorDlg cellSizeEditorDlg = new CellSizeEditorDlg(SwingUtilities.getWindowAncestor(RegularGridCreator.this.d_labCellSz));
                if (cellSizeEditorDlg.doModal() == 1) {
                    try {
                        Unit unit = UnitSystem.getSource(0).getUnit();
                        double d = cellSizeEditorDlg.getSizeValue().get(unit);
                        if (d <= 0.0) {
                            return;
                        }
                        double d2 = RegularGridCreator.this.d_gp.tryGetMaxX().sub(RegularGridCreator.this.d_gp.tryGetMinX()).get(unit);
                        double d3 = RegularGridCreator.this.d_gp.tryGetMaxY().sub(RegularGridCreator.this.d_gp.tryGetMinY()).get(unit);
                        double d4 = RegularGridCreator.this.d_gp.tryGetMaxZ().sub(RegularGridCreator.this.d_gp.tryGetMinZ()).get(unit);
                        int n = (int)Math.round(d2 / d);
                        int n2 = (int)Math.round(d3 / d);
                        int n3 = (int)Math.round(d4 / d);
                        RegularGridCreator.this.d_fldX.setValue(n);
                        RegularGridCreator.this.d_fldY.setValue(n2);
                        RegularGridCreator.this.d_fldZ.setValue(n3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.d_labCellsForGrid = new guiLabel(Intl.intl("Number of cells for %s: %d"));
        this.d_labTotalCells = new guiLabel(Intl.intl("Total number of cells: %d"));
        GridBagUtil.add(guiPanel2, this.d_labCellSz, 0, ++n, 6, 1, 0, 0, 12, 5, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_labCellsForGrid, 0, ++n, 6, 1, 0, 0, 12, 5, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_labTotalCells, 0, ++n, 6, 1, 0, 0, 12, 5, 0, 0.0, 0.0, 17);
        this.d_warningLabel = new MultiLineLabel(Intl.intl("The number of cells is potentially inefficient. For maximum efficiency, the number should be factorable by 2, 3 and 5."));
        this.d_warningLabel.setColumns(40);
        this.d_warningLabel.setForeground(Color.blue);
        this.d_warningLabel.setVisible(false);
        GridBagUtil.add(guiPanel2, this.d_warningLabel, 0, ++n, 6, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(guiPanel2);
        UpdateComponentsListener updateComponentsListener = new UpdateComponentsListener();
        this.d_fldX.addValueChangeListener(updateComponentsListener);
        this.d_fldY.addValueChangeListener(updateComponentsListener);
        this.d_fldZ.addValueChangeListener(updateComponentsListener);
        this.d_gp.addBoundsValueChangeListener(updateComponentsListener);
        Dimension dimension = RegularGridCreator.calcMinWarningLblSize(this.d_labWarnRatioX);
        this.d_labWarnRatioX.setPreferredSize(dimension);
        this.d_labWarnRatioY.setPreferredSize(dimension);
        this.d_labWarnRatioZ.setPreferredSize(dimension);
        return guiPanel2;
    }

    public void updateWarnings() {
        this.updateRatioWarnings();
        this.updateCellSz();
        this.updateTotalCells();
    }

    private guiLabel mkRatioWarningLabel() {
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Cell Size Ratio: %r"));
        guiLabel2.setIcon(ICON_NONE);
        String string = Intl.intl("<html>Ratio of this cell dimention to the shortest.<br>For best results, use cubic cells (ratio of 1.0).");
        guiLabel2.setToolTipText(string);
        return guiLabel2;
    }

    private static long countCells(Grid grid) {
        return (long)grid.getXDivisions().length * (long)grid.getYDivisions().length * (long)grid.getZDivisions().length;
    }

    public void updateTotalCells() {
        long l;
        long l2;
        long l3;
        long l4 = 0L;
        for (Grid grid : this.d_pyMod.getGridManager().flatten()) {
            if (this.d_currentGrid == grid) continue;
            l4 += RegularGridCreator.countCells(grid);
        }
        try {
            l3 = Math.max(1, Integer.parseInt(this.d_fldX.getText()));
        }
        catch (Throwable throwable) {
            l3 = 1L;
        }
        try {
            l2 = Math.max(1, Integer.parseInt(this.d_fldY.getText()));
        }
        catch (Throwable throwable) {
            l2 = 1L;
        }
        try {
            l = Math.max(1, Integer.parseInt(this.d_fldZ.getText()));
        }
        catch (Throwable throwable) {
            l = 1L;
        }
        long l5 = l3 * l2 * l;
        l4 += l5;
        String string = String.format(Intl.intl("Number of cells for mesh: %s"), NumberFormat.getNumberInstance(Locale.getDefault()).format(l5));
        this.d_labCellsForGrid.setText(string);
        if (this.d_pyMod.getGridManager().flatten().size() > 1) {
            String string2 = String.format(Intl.intl("Total number of cells in model: %s"), NumberFormat.getNumberInstance(Locale.getDefault()).format(l4));
            this.d_labTotalCells.setText(string2);
        } else {
            this.d_labTotalCells.setText("");
        }
    }

    private boolean isSensitiveToNDigits(int n, double d, double ... dArray) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 *= 10;
        }
        for (double d2 : dArray) {
            double d3 = d2 * (double)n2;
            int n3 = (int)Math.round(d2 * (double)n2);
            if (!(d < Math.abs(d3 - (double)n3))) continue;
            return true;
        }
        return false;
    }

    public void updateCellSz() {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        int n3;
        try {
            Unit unit = UnitSystem.getSource(0).getUnit();
            n3 = Integer.parseInt(this.d_fldX.getText());
            n2 = Integer.parseInt(this.d_fldY.getText());
            n = Integer.parseInt(this.d_fldZ.getText());
            if (n3 < 1 || n2 < 1 || n < 1) {
                return;
            }
            d3 = this.d_gp.tryGetMaxX().get(unit) - this.d_gp.tryGetMinX().get(unit);
            d2 = this.d_gp.tryGetMaxY().get(unit) - this.d_gp.tryGetMinY().get(unit);
            d = this.d_gp.tryGetMaxZ().get(unit) - this.d_gp.tryGetMinZ().get(unit);
            if (d3 <= 0.0 || d2 <= 0.0 || d <= 0.0) {
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
        double d4 = d3 / (double)n3;
        double d5 = d2 / (double)n2;
        double d6 = d / (double)n;
        DecimalFormat decimalFormat = this.isSensitiveToNDigits(3, 1.0E-6, d4, d5, d6) ? FMT4 : (this.isSensitiveToNDigits(2, 1.0E-6, d4, d5, d6) ? FMT3 : (this.isSensitiveToNDigits(1, 1.0E-6, d4, d5, d6) ? FMT2 : FMT1));
        String string = decimalFormat.format(d3 / (double)n3) + " x " + decimalFormat.format(d2 / (double)n2) + " x " + decimalFormat.format(d / (double)n);
        String string2 = "<html>" + String.format(Intl.intl("Cell Size (%1$s): "), this.d_gp.getUnit().toString()) + "<a href=\"BLAH\">" + string + "</a></html>";
        this.d_labCellSz.setText(string2);
    }

    public void updateRatioWarnings() {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        int n3;
        this.d_labWarnRatioX.setText("");
        this.d_labWarnRatioY.setText("");
        this.d_labWarnRatioZ.setText("");
        this.d_labWarnRatioX.setIcon(ICON_NONE);
        this.d_labWarnRatioY.setIcon(ICON_NONE);
        this.d_labWarnRatioZ.setIcon(ICON_NONE);
        this.d_labWarnRatioX.setForeground(this.d_labTotalCells.getForeground());
        this.d_labWarnRatioY.setForeground(this.d_labTotalCells.getForeground());
        this.d_labWarnRatioZ.setForeground(this.d_labTotalCells.getForeground());
        try {
            Unit unit = UnitSystem.getSource(0).getUnit();
            n3 = Integer.parseInt(this.d_fldX.getText());
            n2 = Integer.parseInt(this.d_fldY.getText());
            n = Integer.parseInt(this.d_fldZ.getText());
            if (n3 < 1 || n2 < 1 || n < 1) {
                return;
            }
            d3 = this.d_gp.tryGetMaxX().get(unit) - this.d_gp.tryGetMinX().get(unit);
            d2 = this.d_gp.tryGetMaxY().get(unit) - this.d_gp.tryGetMinY().get(unit);
            d = this.d_gp.tryGetMaxZ().get(unit) - this.d_gp.tryGetMinZ().get(unit);
            if (d3 <= 0.0 || d2 <= 0.0 || d <= 0.0) {
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
        if (d3 <= 0.0 || d2 <= 0.0 || d <= 0.0) {
            return;
        }
        double d4 = d3 / (double)n3;
        double d5 = d2 / (double)n2;
        double d6 = d / (double)n;
        double d7 = this.min(d4, d5, d6);
        RegularGridCreator.updateRatioWarning(this.d_labWarnRatioX, n3, d4, d7);
        RegularGridCreator.updateRatioWarning(this.d_labWarnRatioY, n2, d5, d7);
        RegularGridCreator.updateRatioWarning(this.d_labWarnRatioZ, n, d6, d7);
    }

    private static Dimension calcMinWarningLblSize(guiLabel guiLabel2) {
        String string = guiLabel2.getText();
        String string2 = RegularGridCreator.getWarning(10000, 10000.0);
        guiLabel2.setText(string2);
        Dimension dimension = guiLabel2.getPreferredSize();
        guiLabel2.setText(string);
        return dimension;
    }

    private static String getWarning(int n, double d) {
        String string = Intl.intl("Cell Size Ratio: %r");
        String string2 = FMT2.format(d);
        string = string.replaceFirst("%r", string2);
        if (d > 1.25) {
            String string3 = " " + Intl.intl("(suggested cells: %s)");
            string3 = string3.replaceFirst("%s", Integer.toString(n));
            string = string + string3;
        }
        return string;
    }

    private static void updateRatioWarning(guiLabel guiLabel2, int n, double d, double d2) {
        double d3 = d / d2;
        int n2 = (int)(d3 * (double)n);
        String string = RegularGridCreator.getWarning(n2, d3);
        guiLabel2.setText(string);
        if (d3 >= 2.0) {
            guiLabel2.setIcon(ICON_BAD);
            guiLabel2.setForeground(ORANGE_TEXT);
        } else if (d3 > 1.25) {
            guiLabel2.setIcon(ICON_MAYBE);
        } else {
            guiLabel2.setIcon(ICON_GOOD);
        }
    }

    private double min(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    public int getDefaultDivsX() {
        return 20;
    }

    public int getDefaultDivsY() {
        return 20;
    }

    public int getDefaultDivsZ() {
        return 6;
    }

    @Override
    public String getPanelName() {
        return Intl.intl("Uniform");
    }

    @Override
    public void setValues(Grid grid) {
        this.d_currentGrid = grid;
        if (grid != null) {
            this.d_fldX.setValue(grid.getXDivisions().length);
            this.d_fldY.setValue(grid.getYDivisions().length);
            this.d_fldZ.setValue(grid.getZDivisions().length);
        } else {
            this.d_fldX.setValue(this.getDefaultDivsX());
            this.d_fldY.setValue(this.getDefaultDivsY());
            this.d_fldZ.setValue(this.getDefaultDivsZ());
        }
        this.updateWarnings();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if ((Integer)this.d_fldY.getValue() == 2) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(this.d_panel, Intl.intl("Invalid Y cells, must use at least 3 cells for 3-D simulations."));
            }
            return false;
        }
        return true;
    }

    public int getNumX() {
        return (Integer)this.d_fldX.getValue();
    }

    public int getNumY() {
        return (Integer)this.d_fldY.getValue();
    }

    public int getNumZ() {
        return (Integer)this.d_fldZ.getValue();
    }

    @Override
    public Grid createGrid(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        return new Grid("Mesh", unitPoint3D, unitPoint3D2, this.getNumX(), this.getNumY(), this.getNumZ());
    }

    public static boolean isGridRegular(Grid grid) {
        return RegularGridCreator.isUniform(grid.getXDivisions()) && RegularGridCreator.isUniform(grid.getYDivisions()) && RegularGridCreator.isUniform(grid.getZDivisions());
    }

    public static boolean isUniform(UnitDouble[] unitDoubleArray) {
        if (unitDoubleArray.length == 0) {
            return true;
        }
        double d = unitDoubleArray[0].getValue(Geometry.LU);
        for (int i = 1; i < unitDoubleArray.length; ++i) {
            double d2 = unitDoubleArray[i].getValue(Geometry.LU);
            if (theUtil.eq(d, d2, MeshmakerGridCreator.TOL)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void calcCellSizes() {
    }

    private class CellSizeEditorDlg
    extends guiDialog {
        private static final long serialVersionUID = 4953734602941220191L;
        private ValueField<UnitDouble> d_sizeFld;

        public CellSizeEditorDlg(Window window) {
            super(window, "Set cell size", 9);
            this.d_sizeFld = ValueFields.udFld(new UnitDouble(0.25, SI.METER), UnitSystem.getSource(0));
            GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
            gridBagHelper.add(new guiLabel(Intl.intl("Cell Size:")), this.d_sizeFld);
            gridBagHelper.finalizeRows();
        }

        public UnitDouble getSizeValue() {
            return (UnitDouble)this.d_sizeFld.getValue();
        }
    }

    private class UpdateComponentsListener
    implements PropertyChangeListener,
    ItemListener {
        private UpdateComponentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RegularGridCreator.this.updateWarnings();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            RegularGridCreator.this.updateWarnings();
        }
    }
}

