/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.IntVR;

public class RefineMeshDlg
extends guiDialog
implements ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = -3219072534524758124L;
    private guiRadioButton d_rbFine = new guiRadioButton(Intl.intl("Refine Factor:"));
    private guiRadioButton d_rbCoarse;
    private ValueField<Integer> d_fldFine = ValueFields.intFld(1, IntVR.between(1, 4, true, true));
    private ValueField<Integer> d_fldCoarse;
    private Runnable d_updateCellCount;

    public RefineMeshDlg(Window window, final Collection<Grid> collection, final Collection<Grid> collection2) {
        super(window, Intl.intl("Refine Mesh"), 9);
        this.d_fldFine.setCommitOnValidEdit(true);
        this.d_rbCoarse = new guiRadioButton(Intl.intl("Coarsen Factor:"));
        this.d_fldCoarse = ValueFields.intFld(1, IntVR.between(1, 4, true, true));
        this.d_fldCoarse.setCommitOnValidEdit(true);
        new guiButtonGroup(this.d_rbFine, this.d_rbCoarse);
        this.d_rbFine.setSelected(true);
        this.d_rbCoarse.addItemListener(this);
        this.d_fldCoarse.addValueChangeListener(this);
        this.d_rbFine.addItemListener(this);
        this.d_fldFine.addValueChangeListener(this);
        final guiTextField guiTextField2 = new guiTextField();
        guiTextField2.setHorizontalAlignment(4);
        guiTextField2.setEditable(false);
        final guiTextField guiTextField3 = new guiTextField();
        guiTextField3.setHorizontalAlignment(4);
        guiTextField3.setEditable(false);
        LinkStatus.link((AbstractButton)this.d_rbFine, this.d_fldFine);
        LinkStatus.link((AbstractButton)this.d_rbCoarse, this.d_fldCoarse);
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addFilledRow(new guiLabel(Intl.intl("Please enter a value from 1 to 4:")));
        gridBagHelper.addIdentRow(this.d_rbFine, this.d_fldFine);
        gridBagHelper.addIdentRow(this.d_rbCoarse, this.d_fldCoarse);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Resulting Cells")));
        gridBagHelper.addIdentRow(new guiLabel(Intl.intl("Selected Meshes:")), guiTextField2);
        gridBagHelper.addIdentRow(new guiLabel(Intl.intl("All Meshes:")), guiTextField3);
        this.d_updateCellCount = new Runnable(){

            @Override
            public void run() {
                double d = 1.0;
                if (RefineMeshDlg.this.isRefine()) {
                    if (!RefineMeshDlg.this.d_fldFine.validateData(false, false)) {
                        return;
                    }
                    d = ((Integer)RefineMeshDlg.this.d_fldFine.getValue()).intValue();
                } else if (RefineMeshDlg.this.isCoarsen()) {
                    if (!RefineMeshDlg.this.d_fldCoarse.validateData(false, false)) {
                        return;
                    }
                    d = 1.0 / (double)((Integer)RefineMeshDlg.this.d_fldCoarse.getValue()).intValue();
                }
                long l = RefineMeshDlg.countCells(collection, d);
                long l2 = RefineMeshDlg.countCells(collection2, 1.0);
                guiTextField2.setValue(Long.toString(l));
                guiTextField3.setValue(Long.toString(l + l2));
            }
        };
        this.updateCellCount();
    }

    public static long countCells(Collection<Grid> collection, double d) {
        long l = 0L;
        for (Grid grid : collection) {
            l = (long)((double)l + Math.max(1.0, (double)grid.getXDivisions().length * d) * Math.max(1.0, (double)grid.getYDivisions().length * d) * Math.max(1.0, (double)grid.getZDivisions().length * d));
        }
        return l;
    }

    public boolean isCoarsen() {
        return this.d_rbCoarse.isSelected();
    }

    public boolean isRefine() {
        return this.d_rbFine.isSelected();
    }

    public double getValue() {
        if (this.isRefine()) {
            return ((Integer)this.d_fldFine.getValue()).intValue();
        }
        return 1.0 / (double)((Integer)this.d_fldCoarse.getValue()).intValue();
    }

    private void updateCellCount() {
        EventQueue.invokeLater(this.d_updateCellCount);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateCellCount();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateCellCount();
    }
}

