/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.gui.grid.GridPanel;
import pyrosim.gui.grid.MeshmakerGridCreator;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class MeshmakerGridCreatorFDS
extends MeshmakerGridCreator {
    private GridPanel d_gridDlg;
    private Grid d_currentGrid;

    public MeshmakerGridCreatorFDS(GridPanel gridPanel) {
        this.d_gridDlg = gridPanel;
        this.setValues(null);
    }

    @Override
    public String getPanelName() {
        return Intl.intl("Non-uniform");
    }

    @Override
    public void setValues(Grid grid) {
        this.d_currentGrid = grid;
        this.clearTable();
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        if (grid != null) {
            MeshmakerGridCreator.MeshmakerEntry meshmakerEntry = MeshmakerGridCreatorFDS.buildEntryList(grid.getXDivisions(), unit);
            MeshmakerGridCreator.MeshmakerEntry meshmakerEntry2 = MeshmakerGridCreatorFDS.buildEntryList(grid.getYDivisions(), unit);
            MeshmakerGridCreator.MeshmakerEntry meshmakerEntry3 = MeshmakerGridCreatorFDS.buildEntryList(grid.getZDivisions(), unit);
            int n = 0;
            MeshmakerGridCreator.MeshmakerEntry meshmakerEntry4 = meshmakerEntry;
            while (meshmakerEntry4 != null) {
                this.d_table.getModel().setValueAt(new String("X"), n, 0);
                this.d_table.getModel().setValueAt(new Integer(meshmakerEntry4.numCells), n, 1);
                this.d_table.getModel().setValueAt(new Double(meshmakerEntry4.value), n, 2);
                ++n;
                meshmakerEntry4 = meshmakerEntry4.next;
            }
            meshmakerEntry4 = meshmakerEntry2;
            while (meshmakerEntry4 != null) {
                this.d_table.getModel().setValueAt(new String("Y"), n, 0);
                this.d_table.getModel().setValueAt(new Integer(meshmakerEntry4.numCells), n, 1);
                this.d_table.getModel().setValueAt(new Double(meshmakerEntry4.value), n, 2);
                ++n;
                meshmakerEntry4 = meshmakerEntry4.next;
            }
            meshmakerEntry4 = meshmakerEntry3;
            while (meshmakerEntry4 != null) {
                this.d_table.getModel().setValueAt(new String("Z"), n, 0);
                this.d_table.getModel().setValueAt(new Integer(meshmakerEntry4.numCells), n, 1);
                this.d_table.getModel().setValueAt(new Double(meshmakerEntry4.value), n, 2);
                ++n;
                meshmakerEntry4 = meshmakerEntry4.next;
            }
        }
    }

    @Override
    public Grid createGrid(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        int n;
        this.calcCellSizes();
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        UnitDouble[] unitDoubleArray = new UnitDouble[this.d_XCells.length];
        UnitDouble[] unitDoubleArray2 = new UnitDouble[this.d_YCells.length];
        UnitDouble[] unitDoubleArray3 = new UnitDouble[this.d_ZCells.length];
        for (n = 0; n < unitDoubleArray.length; ++n) {
            unitDoubleArray[n] = new UnitDouble(this.d_XCells[n], unit);
        }
        for (n = 0; n < unitDoubleArray2.length; ++n) {
            unitDoubleArray2[n] = new UnitDouble(this.d_YCells[n], unit);
        }
        for (n = 0; n < unitDoubleArray3.length; ++n) {
            unitDoubleArray3[n] = new UnitDouble(this.d_ZCells[n], unit);
        }
        return new Grid("Mesh", unitPoint3D, unitPoint3D2, unitDoubleArray, unitDoubleArray2, unitDoubleArray3);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        int n;
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        this.calcCellSizes();
        Unit unit = UnitSystem.getSource(0).getUnit();
        double d = 0.0;
        double d2 = this.d_gridDlg.getMax(0).get(unit) - this.d_gridDlg.getMin(0).get(unit);
        double d3 = this.d_gridDlg.getMax(1).get(unit) - this.d_gridDlg.getMin(1).get(unit);
        double d4 = this.d_gridDlg.getMax(2).get(unit) - this.d_gridDlg.getMin(2).get(unit);
        for (int i = 0; i < this.d_XCells.length; ++i) {
            d += this.d_XCells[i];
        }
        double d5 = UnitDouble.convert(TOL, Geometry.LU, unit);
        if (Math.abs(d - d2) > d5) {
            if (bl) {
                this.showDimensionError("X", d, d2, d5);
            }
            return false;
        }
        d = 0.0;
        for (n = 0; n < this.d_YCells.length; ++n) {
            d += this.d_YCells[n];
        }
        if (Math.abs(d - d3) > d5) {
            if (bl) {
                this.showDimensionError("Y", d, d3, d5);
            }
            return false;
        }
        d = 0.0;
        for (n = 0; n < this.d_ZCells.length; ++n) {
            d += this.d_ZCells[n];
        }
        if (Math.abs(d - d4) > d5) {
            if (bl) {
                this.showDimensionError("Z", d, d4, d5);
            }
            return false;
        }
        return true;
    }
}

