/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.gui.grid.GridCreator;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public abstract class MeshmakerGridCreator
implements GridCreator {
    public static double TOL = 1.0E-4;
    protected guiTable d_table;
    private guiTableEditor d_editor;
    private guiDefaultTableModel d_mod = new guiDefaultTableModel(0, 3, true, 1000, false, 5);
    protected double[] d_XCells;
    protected double[] d_YCells;
    protected double[] d_ZCells;

    public MeshmakerGridCreator() {
        this.d_mod.setColumnClass(0, String.class);
        this.d_mod.setColumnClass(1, Integer.class);
        this.d_mod.setColumnClass(2, Double.class);
        this.d_table = new guiTable((TableModel)this.d_mod, 24);
        this.d_table.setNullValuesAllowed(false);
        TableColumnModel tableColumnModel = this.d_table.getColumnModel();
        tableColumnModel.getColumn(0).setHeaderValue(Intl.intl("Dir") + " (X, Y, Z)");
        tableColumnModel.getColumn(1).setHeaderValue(Intl.intl("Num Cells"));
        tableColumnModel.getColumn(2).setHeaderValue(Intl.intl("Size"));
        this.d_table.setColumnOptions(0, "X", "Y", "Z");
        int n = 30;
        this.d_editor = new guiTableEditor(this.d_table, n);
        this.d_editor.setPreferredSize(new Dimension(400, 250));
    }

    @Override
    public guiPanel getPanel() {
        return this.d_editor;
    }

    @Override
    public String getPanelName() {
        return "Meshmaker";
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        int n = this.d_mod.getRowCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            String string;
            int n5 = (Integer)this.d_mod.getValueAt(i, 1);
            double d = guiTableUtil.getDouble(this.d_mod, i, 2);
            if (n5 <= 0) {
                if (bl) {
                    string = Intl.intl("All cell counts must be greater than 0.");
                    this.showMessageBox(string);
                }
                return false;
            }
            if (d <= 0.0) {
                if (bl) {
                    string = Intl.intl("All cell sizes must be greater than 0.");
                    this.showMessageBox(string);
                }
                return false;
            }
            string = (String)this.d_mod.getValueAt(i, 0);
            if (string.equalsIgnoreCase("x") || string.equalsIgnoreCase("nx")) {
                n2 += n5;
                continue;
            }
            if (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("ny")) {
                n3 += n5;
                continue;
            }
            if (string.equalsIgnoreCase("z") || string.equalsIgnoreCase("nz")) {
                n4 += n5;
                continue;
            }
            if (bl) {
                String string2 = String.format(Intl.intl("In valid entry in direction column (row: %d)."), i + 1);
                this.showMessageBox(string2);
            }
            return false;
        }
        return this.validateCellCount(n2, "X", bl, bl2) && this.validateCellCount(n3, "Y", bl, bl2) && this.validateCellCount(n4, "Z", bl, bl2);
    }

    private boolean validateCellCount(int n, String string, boolean bl, boolean bl2) {
        if (n < 3 && !string.equals("Y")) {
            if (bl) {
                String string2 = String.format(Intl.intl("The total cell count in the %s direction must be greater than 2."), string);
                this.showMessageBox(string2);
            }
            return false;
        }
        if (n < 3 && string.equals("Y") && n != 1) {
            if (bl) {
                String string3 = String.format(Intl.intl("The total cell count in the Y direction must be greater than 2 for 3-D simulations."), new Object[0]);
                this.showMessageBox(string3);
            }
            return false;
        }
        return true;
    }

    @Override
    public void calcCellSizes() {
        int n = this.d_mod.getRowCount();
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        Vector<Double> vector4 = new Vector<Double>();
        Vector<Double> vector5 = new Vector<Double>();
        Vector<Double> vector6 = new Vector<Double>();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.d_mod.getValueAt(i, 0);
            if (string.compareToIgnoreCase("X") == 0 || string.compareToIgnoreCase("NX") == 0) {
                vector.add((Integer)this.d_mod.getValueAt(i, 1));
                vector4.add((Double)this.d_mod.getValueAt(i, 2));
                continue;
            }
            if (string.compareToIgnoreCase("Y") == 0 || string.compareToIgnoreCase("NY") == 0) {
                vector2.add((Integer)this.d_mod.getValueAt(i, 1));
                vector5.add((Double)this.d_mod.getValueAt(i, 2));
                continue;
            }
            if (string.compareToIgnoreCase("Z") != 0 && string.compareToIgnoreCase("NZ") != 0) continue;
            vector3.add((Integer)this.d_mod.getValueAt(i, 1));
            vector6.add((Double)this.d_mod.getValueAt(i, 2));
        }
        this.d_XCells = this.calcSizes(vector, vector4);
        this.d_YCells = this.calcSizes(vector2, vector5);
        this.d_ZCells = this.calcSizes(vector3, vector6);
    }

    private double[] calcSizes(Vector vector, Vector vector2) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            n += ((Integer)vector.elementAt(i)).intValue();
        }
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j < (Integer)vector.elementAt(i); ++j) {
                dArray[n2] = (Double)vector2.elementAt(i);
                ++n2;
            }
        }
        return dArray;
    }

    protected void showMessageBox(String string) {
        JOptionPane.showMessageDialog(this.d_table, string, Intl.intl("Invalid Entry"), 2);
    }

    protected void showDimensionError(String string, double d, double d2, double d3) {
        String string2 = "";
        string2 = string2 + String.format(Intl.intl("Mesh dimensions do not match model dimensions along the %s axis."), string) + "\n";
        string2 = string2 + Intl.intl("Mesh axis length") + ": " + d + "\n";
        string2 = string2 + Intl.intl("Model axis length") + ": " + d2 + "\n";
        string2 = string2 + Intl.intl("Tolerance") + ": " + d3;
        this.showMessageBox(string2);
    }

    public static MeshmakerEntry buildEntryList(UnitDouble[] unitDoubleArray, Unit unit) {
        double d = UnitDouble.convert(TOL, Geometry.LU, unit);
        MeshmakerEntry meshmakerEntry = null;
        MeshmakerEntry meshmakerEntry2 = null;
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            MeshmakerEntry meshmakerEntry3;
            double d2 = unitDoubleArray[i].getValue(unit);
            if (i == 0) {
                meshmakerEntry = meshmakerEntry2 = new MeshmakerEntry(d2);
                continue;
            }
            if (theUtil.eq(meshmakerEntry.value, d2, d)) {
                ++meshmakerEntry.numCells;
                continue;
            }
            meshmakerEntry.next = meshmakerEntry3 = new MeshmakerEntry(d2);
            meshmakerEntry = meshmakerEntry3;
        }
        return meshmakerEntry2;
    }

    public void clearTable() {
        ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_table.getModel();
        for (int i = resizableTableModel.getRowCount() - 1; i >= 0; --i) {
            resizableTableModel.removeRow(i);
        }
    }

    public static class MeshmakerEntry {
        public final double value;
        public int numCells;
        public MeshmakerEntry next;

        public MeshmakerEntry(double d) {
            this.value = d;
            this.numCells = 1;
            this.next = null;
        }
    }
}

