/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.grid.CreateGridPanel;
import pyrosim.gui.grid.GridCreator;
import pyrosim.gui.grid.MeshmakerGridCreatorFDS;
import pyrosim.gui.grid.RegularGridCreator;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class GridPanel
extends CreateGridPanel {
    private static final long serialVersionUID = -8187637114237843941L;
    private GridCreator[] d_creators;
    ValueField<UnitDouble> d_minX;
    ValueField<UnitDouble> d_minY;
    ValueField<UnitDouble> d_minZ;
    ValueField<UnitDouble> d_maxX;
    ValueField<UnitDouble> d_maxY;
    ValueField<UnitDouble> d_maxZ;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;

    public GridPanel(Integer ... integerArray) {
        assert (integerArray != null && integerArray.length > 0);
        this.d_minX = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_minY = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_minZ = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_maxX = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_maxY = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_maxZ = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_creators = new GridCreator[integerArray.length];
        block4: for (int i = 0; i < integerArray.length; ++i) {
            switch (integerArray[i]) {
                case 0: {
                    this.d_creators[i] = new RegularGridCreator(this);
                    continue block4;
                }
                case 1: {
                    this.d_creators[i] = new MeshmakerGridCreatorFDS(this);
                    continue block4;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        guiPanel[] guiPanelArray = new guiPanel[integerArray.length];
        String[] stringArray = new String[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            guiPanelArray[i] = this.d_creators[i].getPanel();
            stringArray[i] = this.d_creators[i].getPanelName();
        }
        this.setPanels(guiPanelArray, this.getHeaderPanel(), stringArray);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (((UnitDouble)this.d_minX.getValue()).ge((UnitDouble)this.d_maxX.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, bl, bl2, this.d_minX, Intl.intl("Min X must be less than Max X."));
        }
        if (((UnitDouble)this.d_minY.getValue()).ge((UnitDouble)this.d_maxY.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, bl, bl2, this.d_minY, Intl.intl("Min Y must be less than Max Y."));
        }
        if (((UnitDouble)this.d_minZ.getValue()).ge((UnitDouble)this.d_maxZ.getValue(), 1.0E-6)) {
            return PyroGuiUtil.invalidateFld((Component)this, bl, bl2, this.d_minZ, Intl.intl("Min Z must be less than Max Z."));
        }
        return this.d_creators[super.getSelection()].validateData(bl, bl2);
    }

    public Grid getGrid() {
        UnitPoint3D unitPoint3D = new UnitPoint3D((UnitDouble)this.d_minX.getValue(), (UnitDouble)this.d_minY.getValue(), (UnitDouble)this.d_minZ.getValue());
        UnitPoint3D unitPoint3D2 = new UnitPoint3D((UnitDouble)this.d_maxX.getValue(), (UnitDouble)this.d_maxY.getValue(), (UnitDouble)this.d_maxZ.getValue());
        return this.d_creators[super.getSelection()].createGrid(unitPoint3D, unitPoint3D2);
    }

    public void setValues(Grid grid) {
        if (grid != null) {
            if (RegularGridCreator.isGridRegular(grid)) {
                super.setSelection(0);
            } else {
                super.setSelection(1);
            }
            this.d_minX.setValue(grid.getMinPoint().xu());
            this.d_minY.setValue(grid.getMinPoint().yu());
            this.d_minZ.setValue(grid.getMinPoint().zu());
            this.d_maxX.setValue(grid.getMaxPoint().xu());
            this.d_maxY.setValue(grid.getMaxPoint().yu());
            this.d_maxZ.setValue(grid.getMaxPoint().zu());
        } else {
            Unit unit = UnitSystem.getSource(0).getUnit();
            super.setSelection(0);
            this.d_minX.setValue(new UnitDouble(0.0, unit));
            this.d_minY.setValue(new UnitDouble(0.0, unit));
            this.d_minZ.setValue(new UnitDouble(0.0, unit));
            this.d_maxX.setValue(new UnitDouble(1.0, unit));
            this.d_maxY.setValue(new UnitDouble(1.0, unit));
            this.d_maxZ.setValue(new UnitDouble(1.0, unit));
        }
        this.d_creators[super.getSelection()].setValues(grid);
        for (int i = 0; i < this.d_creators.length; ++i) {
            if (i == super.getSelection()) continue;
            this.d_creators[i].setValues(null);
        }
    }

    public void addBoundsValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d_minX.addValueChangeListener(propertyChangeListener);
        this.d_minY.addValueChangeListener(propertyChangeListener);
        this.d_minZ.addValueChangeListener(propertyChangeListener);
        this.d_maxX.addValueChangeListener(propertyChangeListener);
        this.d_maxY.addValueChangeListener(propertyChangeListener);
        this.d_maxZ.addValueChangeListener(propertyChangeListener);
    }

    private guiPanel getHeaderPanel() {
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        guiPanel2.setFocusTraversalPolicy(new CoordsFocusTP());
        guiPanel2.setFocusTraversalPolicyProvider(true);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Mesh Boundary:")), 0, 0, 2, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Min X") + ":"), 0, 1, 1, 1, 0, 18, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_minX, 1, 1, 1, 1, 0, 0, 6, 12);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Min Y") + ":"), 2, 1, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_minY, 3, 1, 1, 1, 0, 0, 6, 12);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Min Z") + ":"), 4, 1, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_minZ, 5, 1, 1, 1, 0, 0, 6, 0);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Max X") + ":"), 0, 2, 1, 1, 0, 18, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_maxX, 1, 2, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Max Y") + ":"), 2, 2, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_maxY, 3, 2, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Max Z") + ":"), 4, 2, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_maxZ, 5, 2, 1, 1, 0, 0, 12, 0);
        return guiPanel2;
    }

    public Unit getUnit() {
        return PyroSim.getApp().getUnitSystem().getLengthUnit();
    }

    private UnitDouble tryGetVal(ValueField<UnitDouble> valueField) {
        if (!valueField.validateData(false, false)) {
            return null;
        }
        return (UnitDouble)valueField.getValue();
    }

    public UnitDouble tryGetMinX() {
        return this.tryGetVal(this.d_minX);
    }

    public UnitDouble tryGetMinY() {
        return this.tryGetVal(this.d_minY);
    }

    public UnitDouble tryGetMinZ() {
        return this.tryGetVal(this.d_minZ);
    }

    public UnitDouble tryGetMaxX() {
        return this.tryGetVal(this.d_maxX);
    }

    public UnitDouble tryGetMaxY() {
        return this.tryGetVal(this.d_maxY);
    }

    public UnitDouble tryGetMaxZ() {
        return this.tryGetVal(this.d_maxZ);
    }

    public UnitDouble getMin(int n) {
        switch (n) {
            case 0: {
                return (UnitDouble)this.d_minX.getValue();
            }
            case 1: {
                return (UnitDouble)this.d_minY.getValue();
            }
            case 2: {
                return (UnitDouble)this.d_minZ.getValue();
            }
        }
        return new UnitDouble(Double.POSITIVE_INFINITY, UnitSystem.getSource(0).getUnit());
    }

    public UnitDouble getMax(int n) {
        switch (n) {
            case 0: {
                return (UnitDouble)this.d_maxX.getValue();
            }
            case 1: {
                return (UnitDouble)this.d_maxY.getValue();
            }
            case 2: {
                return (UnitDouble)this.d_maxZ.getValue();
            }
        }
        return new UnitDouble(Double.NEGATIVE_INFINITY, UnitSystem.getSource(0).getUnit());
    }

    public void giveFocus() {
        this.d_minX.requestFocusInWindow();
    }

    private class CoordsFocusTP
    extends FocusTraversalPolicy {
        private CoordsFocusTP() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(GridPanel.this.d_minX)) {
                return GridPanel.this.d_maxX;
            }
            if (component.equals(GridPanel.this.d_maxX)) {
                return GridPanel.this.d_minY;
            }
            if (component.equals(GridPanel.this.d_minY)) {
                return GridPanel.this.d_maxY;
            }
            if (component.equals(GridPanel.this.d_maxY)) {
                return GridPanel.this.d_minZ;
            }
            if (component.equals(GridPanel.this.d_minZ)) {
                return GridPanel.this.d_maxZ;
            }
            if (component.equals(GridPanel.this.d_maxZ)) {
                return null;
            }
            return GridPanel.this.d_minX;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(GridPanel.this.d_minX)) {
                return null;
            }
            if (component.equals(GridPanel.this.d_maxX)) {
                return GridPanel.this.d_minX;
            }
            if (component.equals(GridPanel.this.d_minY)) {
                return GridPanel.this.d_maxX;
            }
            if (component.equals(GridPanel.this.d_maxY)) {
                return GridPanel.this.d_minY;
            }
            if (component.equals(GridPanel.this.d_minZ)) {
                return GridPanel.this.d_maxY;
            }
            if (component.equals(GridPanel.this.d_maxZ)) {
                return GridPanel.this.d_minZ;
            }
            return GridPanel.this.d_minX;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return GridPanel.this.d_minX;
        }

        @Override
        public Component getLastComponent(Container container) {
            return GridPanel.this.d_maxZ;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return GridPanel.this.d_minX;
        }
    }
}

