/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroTaskManager;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.NewDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.grid.GridPanel;
import pyrosim.gui.grid.Validator;
import pyrosim.util.GeomUtil;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.TaskManager;

public class GridManagerDlg
extends ManagerDlg<Grid, GridList> {
    private static final long serialVersionUID = 3083871787606522107L;
    private final Action[] d_actions;
    private final IEditor d_editor = new GridEditor();
    private GridList d_mgr = null;

    public GridManagerDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Edit Meshes"), true);
        this.d_actions = new Action[]{new NewAction(), new RenameAction<Grid, GridList>(this, Intl.intl("mesh")), new ManagerDlg.DeleteAction()};
        this.updateActions();
    }

    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    protected Collection<? extends Grid> getModelColl(GridList gridList) {
        return gridList.flatten();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, object);
    }

    public void init(GridList gridList, Grid grid) {
        this.d_mgr = gridList;
        ((RenameAction)this.d_actions[1]).init(gridList);
        super.init(this.d_mgr, this.d_editor, this.d_actions, grid);
        this.updateActions();
    }

    private double getSmallCellLen(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, int n, int n2, int n3) {
        Unit unit = unitPoint3D2.getUnit();
        double d = unitPoint3D2.x(unit) - unitPoint3D.x(unit);
        double d2 = unitPoint3D2.y(unit) - unitPoint3D.y(unit);
        double d3 = unitPoint3D2.z(unit) - unitPoint3D.z(unit);
        return Math.min(d / (double)n, Math.min(d2 / (double)n2, d3 / (double)n3));
    }

    public class GridEditor
    implements IEditor<Grid>,
    ChangeListener {
        private final JTabbedPane d_tabs;
        private final guiPanel d_editorPanel;
        private final guiTextField d_fyi;
        private final JSpinner d_spinner;
        private final guiCheckBox d_colorCB;
        private final ColorButton d_colorBtn;
        private final GridPanel d_panel = new GridPanel(0, 1);
        private final guiLabel d_alignQ;
        private final CustomFDSPanel d_advancedPanel = new CustomFDSPanel(6);

        public GridEditor() {
            this.d_tabs = new JTabbedPane();
            this.d_tabs.addTab(Intl.intl("Properties"), this.d_panel);
            this.d_tabs.addTab(Intl.intl("Advanced"), this.d_advancedPanel);
            this.d_editorPanel = new guiPanel(new GridBagLayout());
            this.d_fyi = new guiTextField();
            this.d_spinner = new JSpinner();
            this.d_spinner.addChangeListener(this);
            this.d_spinner.setPreferredSize(new JButton("M").getPreferredSize());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Order / Priority") + ":");
            this.d_colorCB = new guiCheckBox(Intl.intl("Specify Color:"));
            this.d_colorBtn = new ColorButton(1);
            this.d_colorBtn.addObserver(this.d_editorPanel.getComm());
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Mesh Alignment Test:"));
            this.d_alignQ = new guiLabel();
            this.d_alignQ.setFont(this.d_alignQ.getFont().deriveFont(1));
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Description:"));
            int n = 0;
            GridBagUtil.add(this.d_editorPanel, guiLabel4, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_editorPanel, this.d_fyi, 1, n, 5, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this.d_editorPanel, guiLabel2, 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_editorPanel, this.d_spinner, 1, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_editorPanel, this.d_colorCB, 0, ++n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_editorPanel, this.d_colorBtn, 1, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_editorPanel, guiLabel3, 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_editorPanel, this.d_alignQ, 1, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            int n2 = ++n;
            ++n;
            GridBagUtil.add(this.d_editorPanel, this.d_tabs, 0, n2, 3, 1, 0, 0, 6, 12, 1, 1.0, 1.0, 17);
            LinkStatus.link((AbstractButton)this.d_colorCB, this.d_colorBtn);
            this.init(null);
        }

        @Override
        public void init(Grid grid) {
            this.d_editorPanel.setEnabled(grid != null);
            this.d_panel.setValues(grid);
            this.d_fyi.setText("");
            if (grid != null) {
                this.d_fyi.setText(grid.getFYI());
                this.updateSpinner(grid);
                Color color = grid.getColor();
                this.d_colorCB.setSelected(color != null);
                if (color != null) {
                    this.d_colorBtn.setColor(color);
                }
                this.updateAlignmentQuality(grid);
                this.d_advancedPanel.load(Collections.singleton(grid));
            }
            this.d_editorPanel.setModified(false);
            this.getGridPanel().giveFocus();
        }

        @Override
        public Grid preview(Grid grid) {
            if (!GridManagerDlg.this.validateData(false, false)) {
                return null;
            }
            this.saveGrid(grid);
            return grid;
        }

        private void updateAlignmentQuality(Grid grid) {
            if (!grid.isEnabled()) {
                this.d_alignQ.setForeground(new Color(100, 100, 100));
                this.d_alignQ.setText(Intl.intl("Mesh Disabled, Test Skipped"));
                this.d_alignQ.setToolTipText("");
                return;
            }
            ArrayList arrayList = new ArrayList(GridManagerDlg.this.d_mgr.flatten());
            Validator.Alignment alignment = Validator.getValidity(arrayList, grid);
            if (alignment.isValid()) {
                this.d_alignQ.setForeground(new Color(0, 124, 36));
                this.d_alignQ.setText(Intl.intl("Passed"));
                this.d_alignQ.setToolTipText("");
            } else {
                String string;
                int n;
                String string2;
                String string3;
                ArrayList<Grid> arrayList2 = new ArrayList<Grid>(alignment.unalignedTouch);
                arrayList2.addAll(alignment.unalignedOverlap);
                String string4 = Intl.intl("Failed: ");
                String string5 = "";
                int n2 = 2;
                if (!alignment.alignedOverlap.isEmpty()) {
                    string3 = "";
                    string2 = "";
                    for (n = 0; n < alignment.alignedOverlap.size(); ++n) {
                        string = "";
                        if (n != 0) {
                            string = string + ",";
                        }
                        string = string + alignment.alignedOverlap.get(n).getName();
                        string2 = string2 + string;
                        if (n < n2) {
                            string3 = string3 + string;
                            continue;
                        }
                        if (n != n2) continue;
                        string3 = string3 + ",...";
                    }
                    string4 = string4 + String.format(Intl.intl("Overlaps with %s"), string3);
                    string5 = string5 + String.format(Intl.intl("Overlaps with %s"), string2);
                }
                if (!arrayList2.isEmpty()) {
                    string3 = "";
                    string2 = "";
                    for (n = 0; n < arrayList2.size(); ++n) {
                        string = "";
                        if (n != 0) {
                            string = string + ",";
                        }
                        string = string + ((Grid)arrayList2.get(n)).getName();
                        string2 = string2 + string;
                        if (n < n2) {
                            string3 = string3 + string;
                            continue;
                        }
                        if (n != n2) continue;
                        string3 = string3 + ",...";
                    }
                    if (!alignment.alignedOverlap.isEmpty()) {
                        string4 = string4 + "    ";
                        string5 = string5 + "    ";
                    }
                    string4 = string4 + String.format(Intl.intl("Unaligned with %s"), string3);
                    string5 = string5 + String.format(Intl.intl("Unaligned with %s"), string2);
                }
                this.d_alignQ.setForeground(new Color(217, 128, 13));
                this.d_alignQ.setText(string4);
                this.d_alignQ.setToolTipText(string5);
            }
        }

        private void updateSpinner(Grid grid) {
            int n = Util.indexOf(GridManagerDlg.this.d_mgr.flatten(), grid) + 1;
            int n2 = Math.max(1, n - 1);
            int n3 = Math.min(GridManagerDlg.this.d_mgr.flatten().size(), n + 1);
            this.d_spinner.setModel(new SpinnerNumberModel(n, n2, n3, -1));
        }

        @Override
        public boolean isModified() {
            return this.d_editorPanel.isModified();
        }

        public void saveGrid(Grid grid) {
            Grid grid2 = this.d_panel.getGrid();
            grid2.setName(grid.getName());
            grid2.setFYI(this.d_fyi.getText());
            Color color = this.d_colorCB.isSelected() ? this.d_colorBtn.getColor() : null;
            grid2.setColor(color);
            this.d_advancedPanel.save(Collections.singleton(grid2));
            grid.taskImprint(grid2).run();
        }

        @Override
        public Grid commit(Grid grid) {
            assert (grid != null);
            Grid grid2 = grid;
            Grid grid3 = new Grid(grid2.getName());
            this.saveGrid(grid3);
            PyroMod pyroMod = (PyroMod)GridManagerDlg.this.d_mgr.getDomain();
            pyroMod.getTaskManager().exec(grid2.taskImprint(grid3), Intl.intl("Apply Mesh Changes"));
            this.d_editorPanel.setModified(false);
            this.updateAlignmentQuality(grid2);
            return grid2;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this.d_editorPanel;
        }

        @Override
        public void addObserver(Observer observer) {
            this.d_editorPanel.addObserver(observer);
        }

        @Override
        public void removeObserver(Observer observer) {
            this.d_editorPanel.removeObserver(observer);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            NamedPyroObject namedPyroObject;
            int n = (Integer)this.d_spinner.getValue() - 1;
            Grid grid = (Grid)GridManagerDlg.this.getList().getItem(GridManagerDlg.this.getList().getSelectedIx());
            PyroMod pyroMod = (PyroMod)GridManagerDlg.this.d_mgr.getDomain();
            PyroTaskManager pyroTaskManager = pyroMod.getTaskManager();
            APyroObject aPyroObject = null;
            int n2 = 0;
            Iterator iterator = GridManagerDlg.this.d_mgr.flatten().iterator();
            while (iterator.hasNext() && n2 < n) {
                namedPyroObject = (Grid)iterator.next();
                if (namedPyroObject == grid) continue;
                aPyroObject = namedPyroObject;
                ++n2;
            }
            namedPyroObject = aPyroObject == null ? GridManagerDlg.this.d_mgr : (Composite)aPyroObject.getParent();
            int n3 = aPyroObject == null ? 0 : ((Composite)namedPyroObject).indexOf(aPyroObject) + 1;
            ReorderObjectsTask reorderObjectsTask = new ReorderObjectsTask((IPyroObject)namedPyroObject, n3, grid);
            ((TaskManager)pyroTaskManager).exec(reorderObjectsTask, Intl.intl("Reorder Meshes"));
            GridManagerDlg.this.d_edix = n;
            GridManagerDlg.this.getList().updateModelView(GridManagerDlg.this.d_mgr);
            this.updateSpinner(grid);
            this.updateAlignmentQuality(grid);
        }

        public GridPanel getGridPanel() {
            return this.d_panel;
        }
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -8901054711690594357L;

        public NewAction() {
            super(Intl.intl("New..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!GridManagerDlg.this.preSave()) {
                return;
            }
            PyroMod pyroMod = (PyroMod)GridManagerDlg.this.d_mgr.getDomain();
            boolean bl = false;
            double d = 0.25;
            while (!bl) {
                bl = true;
                NewDlg<Grid> newDlg = new NewDlg<Grid>(GridManagerDlg.this.d_mgr, Grid.class, Intl.intl("mesh"));
                try {
                    Object object;
                    if (newDlg.doModal() != 1) continue;
                    Grid grid = null;
                    if (GridManagerDlg.this.d_mgr.flatten().isEmpty() && ((AABox)(object = GeomUtil.getBounds(pyroMod.getAllGeom()))).isValid()) {
                        double d2 = ((AABox)object).getWidth();
                        double d3 = ((AABox)object).getDepth();
                        double d4 = ((AABox)object).getHeight();
                        double d5 = 0.01;
                        if (d2 > d5 && d3 > d5 && d4 > d5) {
                            AABox aABox = new AABox(new Point3d(Math.floor(((AABox)object).getMinX()), Math.floor(((AABox)object).getMinY()), Math.floor(((AABox)object).getMinZ())), new Point3d(Math.ceil(((AABox)object).getMaxX()), Math.ceil(((AABox)object).getMaxY()), Math.ceil(((AABox)object).getMaxZ())));
                            int n = Math.max((int)Math.round(aABox.getWidth() / d), 1);
                            int n2 = Math.max((int)Math.round(aABox.getDepth() / d), 1);
                            int n3 = Math.max((int)Math.round(aABox.getHeight() / d), 1);
                            grid = new Grid(newDlg.getName(), new UnitPoint3D(aABox.getMin(), (Unit)SI.METER), new UnitPoint3D(aABox.getMax(), (Unit)SI.METER), n, n2, n3);
                        }
                    }
                    if (grid == null) {
                        grid = new Grid(newDlg.getName(), new UnitPoint3D(new Point3d(0.0, 0.0, 0.0), (Unit)SI.METER), new UnitPoint3D(new Point3d(10.0, 10.0, 3.0), (Unit)SI.METER), 40, 40, 12);
                    }
                    try {
                        object = pyroMod.getTaskManager();
                        ((TaskManager)object).exec(new AddTask((IPyroObject)GridManagerDlg.this.d_mgr, new IPyroObject[]{grid}), Intl.intl("New Mesh"));
                        GridManagerDlg.this.getList().updateModelView(GridManagerDlg.this.d_mgr);
                        GridManagerDlg.this.getList().select(grid);
                        GridManagerDlg.this.updateActions();
                    }
                    catch (Throwable throwable) {
                        PyroTaskManager pyroTaskManager = pyroMod.getTaskManager();
                        ((TaskManager)pyroTaskManager).undo();
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    bl = false;
                    d *= 1.5;
                }
            }
        }
    }
}

