/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Floor;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.PointListEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.ACurve;
import thunderheadeng.geometry.objs.ClosedLinearCurve;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class WallGeomEditor
extends guiPanel
implements IGeomEditor<WallGeom> {
    private static final long serialVersionUID = -4397271184479586500L;
    private final PointListEditor d_pointEditor;
    private final guiComboBox<WallGeom.Alignment> d_alignmentCB = new guiComboBox<WallGeom.Alignment>(WallGeom.Alignment.values());
    private final ValueField<UnitDouble> d_heightFld;
    private final ValueField<UnitDouble> d_thicknessFld;
    private boolean d_loadedClosed = false;

    public WallGeomEditor() {
        super(new GridBagLayout());
        this.d_alignmentCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -7671962728127094643L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                String string = "";
                String string2 = null;
                if (object != null) {
                    switch ((WallGeom.Alignment)((Object)object)) {
                        case LEFT: {
                            string = Intl.intl("Left");
                            string2 = Intl.intl("Align the wall to the left of the reference line");
                            break;
                        }
                        case RIGHT: {
                            string = Intl.intl("Right");
                            string2 = Intl.intl("Align the wall to the right of the reference line");
                            break;
                        }
                        default: {
                            string = Intl.intl("Center");
                            string2 = Intl.intl("Align the center of the wall with the reference line");
                        }
                    }
                }
                WallGeomEditor.this.d_alignmentCB.setToolTipText(string2);
                this.setText(string);
                return this;
            }
        });
        Floor floor = new Floor("");
        this.d_pointEditor = new PointListEditor(false);
        this.d_heightFld = WallGeomEditor.newField(floor.getWallHeight());
        this.d_thicknessFld = WallGeomEditor.newField(new UnitDouble(0.2, SI.METER));
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        gridBagHelper.addRow(Intl.intl("Thickness:"), this.d_thicknessFld, 0);
        gridBagHelper.addRow(Intl.intl("Height:"), this.d_heightFld, 0);
        gridBagHelper.addRow(Intl.intl("Alignment:"), this.d_alignmentCB, 0);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Reference Line")));
        gridBagHelper.addIdentRow(this.d_pointEditor, new double[]{1.0, 1.0}, new int[]{0, 0});
        gridBagHelper.finalizeRows();
    }

    private static ValueField newField(UnitDouble unitDouble) {
        ValueField<UnitDouble> valueField = ValueFields.udFld(unitDouble, UnitDoubleVR.above(0.0, PyroSim.getApp().getUnitSystem().getLengthUnit(), true), UnitSystem.getSource(0));
        valueField.setColumns(8);
        valueField.setNullAllowed(true);
        return valueField;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Wall");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getFaceNames() {
        Object object;
        void pair;
        WallGeom wallGeom = this.getTempGeom();
        if (wallGeom == null) {
            return new String[0];
        }
        ArrayList<Pair<WallGeom.Face, int[]>> arrayList = new ArrayList<Pair<WallGeom.Face, int[]>>();
        Object arrayList2 = WallGeom.Face.values();
        int n = ((WallGeom.Face[])arrayList2).length;
        boolean bl = false;
        while (pair < n) {
            object = arrayList2[pair];
            int[] i = wallGeom.getFaceRange((WallGeom.Face)((Object)object));
            if (i[1] > 0) {
                arrayList.add(new Pair<WallGeom.Face, int[]>((WallGeom.Face)((Object)object), i));
            }
            ++pair;
        }
        Collections.sort(arrayList, new Comparator<Pair<WallGeom.Face, int[]>>(){

            @Override
            public int compare(Pair<WallGeom.Face, int[]> pair, Pair<WallGeom.Face, int[]> pair2) {
                return ((int[])pair.v2)[0] - ((int[])pair2.v2)[0];
            }
        });
        arrayList2 = new ArrayList();
        for (Pair pair2 : arrayList) {
            object = WallGeomEditor.getNameForFaceType((WallGeom.Face)((Object)pair2.v1));
            for (int i = 0; i < ((int[])pair2.v2)[1]; ++i) {
                Object object2 = ((int[])pair2.v2)[1] > 1 ? String.format("%s [%d]", object, i + 1) : object;
                arrayList2.add(object2);
            }
        }
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private static String getNameForFaceType(WallGeom.Face face) {
        switch (face) {
            case BOTTOM: {
                return Intl.intl("Bottom");
            }
            case TOP: {
                return Intl.intl("Top");
            }
            case ENDCAP_START: {
                return Intl.intl("Endcap 1");
            }
            case ENDCAP_END: {
                return Intl.intl("Endcap 2");
            }
            case SIDE1: {
                return Intl.intl("Side 1");
            }
            case SIDE2: {
                return Intl.intl("Side 2");
            }
        }
        return "";
    }

    @Override
    public int getNumFaces() {
        WallGeom wallGeom = this.getTempGeom();
        if (wallGeom == null) {
            return -1;
        }
        return wallGeom.getNumPrims(1);
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    private ICurve toCurve(List<Point3d> list) {
        if (list.size() < 2) {
            return null;
        }
        ACurve aCurve = list.size() == 2 ? new LineSeg(list.get(0), list.get(1)) : new PolyLine(theUtil.toArray(list, Point3d.class));
        if (this.d_loadedClosed && list.get(0).epsilonEquals(list.get(list.size() - 1), 1.0E-9)) {
            aCurve = new ClosedLinearCurve((ILinearCurve)((Object)aCurve));
        }
        return aCurve;
    }

    private WallGeom getTempGeom() {
        List<Point3d> list = this.d_pointEditor.save();
        if (list == null || list.size() < 2) {
            return null;
        }
        WallGeom.Alignment alignment = this.d_alignmentCB.getSelectedItem();
        if (alignment == null) {
            alignment = WallGeom.Alignment.LEFT;
        }
        WallGeom wallGeom = new WallGeom(this.toCurve(list), alignment, 0.2, 3.0);
        return wallGeom;
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        List<Point3d> list = this.d_pointEditor.save();
        if (list != null && list.size() == 1) {
            this.error(bl, Intl.intl("At least 2 points must be specified."));
            return false;
        }
        return true;
    }

    private void error(boolean bl, String string) {
        JOptionPane.showMessageDialog(this, string, Intl.intl("Invalid Wall"), 0);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = GeomGuiUtil.getDataVals(collection, new DataProp(), 2, Geometry.LU);
        this.d_thicknessFld.setValue(unitDoubleArray[0]);
        this.d_heightFld.setValue(unitDoubleArray[1]);
        Object object = PropertyUtil.getProperty(new CurveProp(), collection);
        if (object instanceof ILinearCurve) {
            this.d_pointEditor.load(this.getPoints((ILinearCurve)object));
        } else {
            this.d_pointEditor.load(Collections.EMPTY_LIST);
        }
        this.d_loadedClosed = object instanceof ICurve && ((ICurve)object).isClosed();
        Object object2 = PropertyUtil.getProperty(new AlignmentProp(), collection);
        if (object2 instanceof WallGeom.Alignment) {
            this.d_alignmentCB.setSelectedItem(object2);
        } else {
            this.d_alignmentCB.setSelectedItem(null);
        }
    }

    private List<Point3d> getPoints(ILinearCurve iLinearCurve) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(iLinearCurve.getNumVerts());
        for (int i = 0; i < iLinearCurve.getNumVerts(); ++i) {
            arrayList.add(iLinearCurve.getVert(i));
        }
        return arrayList;
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        Object object;
        GeomGuiUtil.setDataVals(collection, new DataProp(), Geometry.LU, (UnitDouble)this.d_thicknessFld.getValue(), (UnitDouble)this.d_heightFld.getValue());
        List<Point3d> list = this.d_pointEditor.save();
        if (list != null && (object = this.toCurve(list)) != null) {
            PropertyUtil.setProperty(new CurveProp(), object, collection);
        }
        if ((object = this.d_alignmentCB.getSelectedItem()) != null) {
            PropertyUtil.setProperty(new AlignmentProp(), object, collection);
        }
    }

    private static abstract class WallProp<T>
    extends PropertyUtil.AProp<IPyroGeomSrc, T> {
        public WallProp() {
            super(IPyroGeomSrc.class);
        }

        @Override
        protected abstract Object get(WallGeom var1);

        protected abstract WallGeom apply(IPyroGeomSrc var1, WallGeom var2, T var3);

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            WallGeom wallGeom = (WallGeom)iPyroGeomSrc.getGeom().getLocalGeom();
            return this.get(wallGeom);
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, T t) {
            IGeomNode iGeomNode = iPyroGeomSrc.getGeom();
            WallGeom wallGeom = this.apply(iPyroGeomSrc, (WallGeom)iGeomNode.getLocalGeom(), t);
            iPyroGeomSrc.setGeom(iGeomNode.applyLocalGeom(wallGeom));
        }
    }

    private static class AlignmentProp
    extends WallProp<WallGeom.Alignment> {
        private AlignmentProp() {
        }

        @Override
        protected WallGeom apply(IPyroGeomSrc iPyroGeomSrc, WallGeom wallGeom, WallGeom.Alignment alignment) {
            return new WallGeom(wallGeom.refCurve, alignment, wallGeom.thickness, wallGeom.height);
        }

        @Override
        protected Object get(WallGeom wallGeom) {
            return wallGeom.alignment;
        }
    }

    private static class CurveProp
    extends WallProp<ICurve> {
        private CurveProp() {
        }

        @Override
        protected Object get(WallGeom wallGeom) {
            return wallGeom.refCurve;
        }

        @Override
        protected WallGeom apply(IPyroGeomSrc iPyroGeomSrc, WallGeom wallGeom, ICurve iCurve) {
            return new WallGeom(iCurve, wallGeom.alignment, wallGeom.thickness, wallGeom.height);
        }

        @Override
        public boolean equal(ICurve iCurve, ICurve iCurve2) {
            if (iCurve instanceof ILinearCurve && iCurve2 instanceof ILinearCurve) {
                if (iCurve.isClosed() != iCurve2.isClosed()) {
                    return false;
                }
                ILinearCurve iLinearCurve = (ILinearCurve)iCurve;
                ILinearCurve iLinearCurve2 = (ILinearCurve)iCurve2;
                int n = iLinearCurve.getNumVerts();
                if (n != iLinearCurve2.getNumVerts()) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (iLinearCurve.getVert(i).equals(iLinearCurve2.getVert(i))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class DataProp
    extends GeomGuiUtil.AGeomProp<WallGeom> {
        @Override
        protected WallGeom constructGeom(WallGeom wallGeom, double[] dArray) {
            return new WallGeom(wallGeom.refCurve, wallGeom.alignment, dArray[0], dArray[1]);
        }

        @Override
        protected double[] saveData(WallGeom wallGeom) {
            return new double[]{wallGeom.thickness, wallGeom.height};
        }
    }
}

