/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.geom.plane.AAPlane;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.View;
import pyrosim.gui.geom.PlaneDialog;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Task;

public class ViewClipDlg
extends guiDialog {
    private static final long serialVersionUID = -5392202711233254665L;
    private final List<ClipPlaneEditor> d_editors = new ArrayList<ClipPlaneEditor>(4);

    public ViewClipDlg(Window window) {
        super(window, Intl.intl("Edit Clipping Planes"), 9);
        for (int i = 0; i < 4; ++i) {
            this.d_editors.add(new ClipPlaneEditor(i));
        }
        guiLabel guiLabel2 = new guiLabel("<html><b>" + Intl.intl("NOTE: Geometry on the positive side of the planes is clipped from view."));
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        for (ClipPlaneEditor clipPlaneEditor : this.d_editors) {
            clipPlaneEditor.add(gridBagHelper);
        }
        gridBagHelper.addFilledRow(guiLabel2);
        gridBagHelper.finalizeRows();
    }

    public void load(View view) {
        Set<ClipPlane> set = view.getClipPlanes();
        assert (set.size() <= 4);
        int n = 0;
        for (ClipPlane clipPlane : set) {
            this.d_editors.get(n).load(view, clipPlane);
            ++n;
        }
        for (int i = n; i < 4; ++i) {
            this.d_editors.get(i).load(view, null);
        }
    }

    public Task taskSave(final View view) {
        return new AOneTimeTask(){

            @Override
            public void run() {
                ViewClipDlg.this.save(view);
            }
        };
    }

    private void save(View view) {
        for (ClipPlaneEditor clipPlaneEditor : this.d_editors) {
            clipPlaneEditor.save(view);
        }
    }

    private static class PlaneEditor
    extends guiPanel {
        private static final long serialVersionUID = -1943465494986451072L;
        private final HTMLBtn d_label = new HTMLBtn("");
        private IPlane d_plane;

        public PlaneEditor() {
            this.d_label.addActionListener(actionEvent -> {
                PlaneDialog planeDialog = new PlaneDialog(SwingUtilities.getWindowAncestor(this));
                IPlane iPlane = this.d_plane != null ? this.d_plane : new AAPlane(AAPlane.Axis.X, 0.0, true);
                planeDialog.load(iPlane);
                if (planeDialog.doModal() != 1) {
                    return;
                }
                this.setPlane(planeDialog.save());
                this.setModified(true);
            });
            this.updateLbl();
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addFilledRow(this.d_label);
            gridBagHelper.finalizeRows();
        }

        public IPlane getPlane() {
            return this.d_plane;
        }

        public void setPlane(IPlane iPlane) {
            this.d_plane = iPlane;
            this.setModified(false);
            this.updateLbl();
        }

        private void updateLbl() {
            String string = this.d_plane == null ? String.format("&lt;%s&gt;", Intl.intl("edit")) : this.d_plane.toString(PyroSim.getApp().getUnitSystem().getLengthUnit());
            this.d_label.setText(string);
        }
    }

    private static class ClipPlaneEditor {
        private final PlaneEditor d_editor = new PlaneEditor();
        private final guiCheckBox d_enabledCB;
        private ClipPlane d_plane;

        public ClipPlaneEditor(int n) {
            this.d_enabledCB = new guiCheckBox(String.format(Intl.intl("Plane %d:"), n + 1));
            LinkStatus.link((AbstractButton)this.d_enabledCB, this.d_editor);
        }

        public void add(GridBagHelper gridBagHelper) {
            gridBagHelper.addRow(this.d_enabledCB, this.d_editor, 1.0, 0);
        }

        public void load(View view, ClipPlane clipPlane) {
            this.d_plane = clipPlane;
            this.d_enabledCB.setSelected(clipPlane != null);
            if (clipPlane != null) {
                this.d_editor.setPlane(clipPlane.getPlane());
            } else {
                this.d_editor.setPlane(null);
            }
        }

        public void save(View view) {
            IPlane iPlane;
            IPlane iPlane2 = iPlane = this.d_enabledCB.isSelected() ? this.d_editor.getPlane() : null;
            if (this.d_plane != null && iPlane != null) {
                this.d_plane.setPlane(iPlane);
            } else if (this.d_plane != null) {
                view.removeClipPlane(this.d_plane);
            } else if (iPlane != null) {
                ClipPlane clipPlane = new ClipPlane(iPlane);
                view.addClipPlane(clipPlane);
            }
        }
    }
}

