/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.geom.Vent;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.PropertyUtil;

public class VentGeomEditor
extends guiPanel
implements IGeomEditor<Vent.VentGeom> {
    private static final long serialVersionUID = 2939186383674263719L;
    public static final String FACE_NAME = Intl.intl("Face");
    private static final int NORMALIX = 0;
    private static final int NEGIX = 1;
    private static final int POSIX = 2;
    private final Integer[] d_aiXNormals = new Integer[]{new Integer(0), new Integer(-1), new Integer(1)};
    private final Integer[] d_aiYNormals = new Integer[]{new Integer(0), new Integer(-2), new Integer(2)};
    private final Integer[] d_aiZNormals = new Integer[]{new Integer(0), new Integer(-3), new Integer(3)};
    private final guiComboBox<Integer> d_cbNormal;
    private final AARectangleEditor d_rectEditor;
    private final ValueField<UnitDouble> d_radiusEditor;
    private final guiCheckBox d_enableCircular;
    private guiComboBox<CenterPointType> d_cpType;
    private Point3DPanel d_cpPoint;
    private final UpdateCpStatusListener d_updateCpStatus;
    private final PropertyUtil.IProp normalProp = new PropertyUtil.AProp<IPyroGeomSrc, Vector3d>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            Vent.VentGeom ventGeom = (Vent.VentGeom)iPyroGeomSrc.getGeom().getLocalGeom();
            return ventGeom.normal == null ? GeomConstants.VEC3D_ZERO : ventGeom.normal;
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, Vector3d vector3d) {
            Vent.VentGeom ventGeom = (Vent.VentGeom)iPyroGeomSrc.getGeom().getLocalGeom();
            iPyroGeomSrc.setGeom(GeomNodeUtil.newNode(new Vent.VentGeom(ventGeom, vector3d, ventGeom.centerPoint, ventGeom.louver, ventGeom.radius)));
        }
    };
    private final PropertyUtil.IProp originProp = new PropertyUtil.AProp<IPyroGeomSrc, UnitPoint3D>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            Vent vent = (Vent)iPyroGeomSrc;
            return vent.getCenterPoint();
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, UnitPoint3D unitPoint3D) {
            Vent vent = (Vent)iPyroGeomSrc;
            vent.setCenterPoint(unitPoint3D);
        }
    };
    private final PropertyUtil.IProp defOriginProp = new PropertyUtil.AProp<IPyroGeomSrc, UnitPoint3D>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            Vent vent = (Vent)iPyroGeomSrc;
            return vent.getDefaultCenterPoint();
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, UnitPoint3D unitPoint3D) {
        }
    };
    private final PropertyUtil.IProp radiusProp = new PropertyUtil.AProp<IPyroGeomSrc, UnitDouble>(IPyroGeomSrc.class){

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, UnitDouble unitDouble) {
            Vent.VentGeom ventGeom = (Vent.VentGeom)iPyroGeomSrc.getGeom().getLocalGeom();
            Vent.VentGeom ventGeom2 = new Vent.VentGeom(ventGeom, ventGeom.normal, ventGeom.centerPoint, ventGeom.louver, VentGeomEditor.this.d_enableCircular.isSelected() ? (UnitDouble)VentGeomEditor.this.d_radiusEditor.getValue() : null);
            iPyroGeomSrc.setGeom(GeomNodeUtil.newNode(ventGeom2));
        }

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            Vent.VentGeom ventGeom = (Vent.VentGeom)iPyroGeomSrc.getGeom().getLocalGeom();
            return ventGeom.radius;
        }
    };

    public VentGeomEditor() {
        super(new GridBagLayout());
        this.d_cbNormal = new guiComboBox<Integer>((T[])this.d_aiXNormals);
        this.d_cbNormal.setRenderer(new NormalListCellRenderer());
        this.d_rectEditor = new AARectangleEditor(true);
        this.d_rectEditor.getPlaneCB().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = VentGeomEditor.this.d_cbNormal.getSelectedIndex();
                int n2 = VentGeomEditor.this.d_rectEditor.getPlaneCB().getSelectedIndex();
                if (n2 == 0) {
                    VentGeomEditor.this.d_cbNormal.setItems(VentGeomEditor.this.d_aiXNormals);
                } else if (n2 == 1) {
                    VentGeomEditor.this.d_cbNormal.setItems(VentGeomEditor.this.d_aiYNormals);
                } else {
                    VentGeomEditor.this.d_cbNormal.setItems(VentGeomEditor.this.d_aiZNormals);
                }
                VentGeomEditor.this.d_cbNormal.setSelectedIndex(n);
            }
        });
        this.d_cpPoint = new Point3DPanel("", true);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Center Point:"));
        guiLabel2.setToolTipText(Intl.intl("XYZ"));
        this.d_cpType = new guiComboBox<Object>((T[])new Object[]{CenterPointType.AUTO, CenterPointType.CUSTOM});
        this.d_cpType.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 3917711678910135993L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object == CenterPointType.AUTO) {
                    this.setText(Intl.intl("Auto"));
                }
                if (object == CenterPointType.CUSTOM) {
                    this.setText(Intl.intl("Custom"));
                }
                return this;
            }
        });
        this.d_updateCpStatus = new UpdateCpStatusListener();
        this.d_radiusEditor = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(0), UnitSystem.getSource(0));
        this.d_enableCircular = new guiCheckBox(Intl.intl("Circular Vent"));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Normal Direction:"));
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Radius:"));
        LinkStatus.link((AbstractButton)this.d_enableCircular, guiLabel4, this.d_radiusEditor);
        GridBagUtil.add(this, guiLabel3, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cbNormal, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rectEditor, 0, 1, 2, 1, 0, 0, 6, 0, 0, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel2, 0, 3, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cpType, 1, 3, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cpPoint, 0, 4, 2, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_enableCircular, 0, 5, 2, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel4, 0, 6, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_radiusEditor, 1, 6, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(this);
    }

    @Override
    public String[] getFaceNames() {
        return new String[]{FACE_NAME};
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Vent Geometry");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        return this.d_rectEditor.validateData(collection, bl, bl2);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        Object object;
        this.d_rectEditor.load(collection);
        Object object2 = PropertyUtil.getProperty(this.normalProp, collection);
        if (!(object2 instanceof Vector3d)) {
            object2 = null;
        }
        if (object2 == null) {
            this.d_cbNormal.setSelectedItem(null);
        } else if (object2.equals(GeomConstants.VEC3D_ZERO)) {
            this.d_cbNormal.setSelectedIndex(0);
        } else {
            object = (Vector3d)object2;
            this.d_cbNormal.setSelectedIndex(this.getNormalIx((Vector3d)object));
        }
        object = PropertyUtil.getProperty(this.originProp, collection);
        if (collection.size() == 1) {
            if (object == null) {
                this.d_cpType.setSelectedItem((Object)CenterPointType.AUTO);
                this.d_cpPoint.load(null);
            } else if (object instanceof UnitPoint3D) {
                this.d_cpType.setSelectedItem((Object)CenterPointType.CUSTOM);
                this.d_cpPoint.load((UnitPoint3D)object);
            } else assert (false);
        } else if (object == null) {
            this.d_cpType.setSelectedItem((Object)CenterPointType.AUTO);
            this.d_cpPoint.load(null);
        } else if (object instanceof UnitPoint3D) {
            this.d_cpType.setSelectedItem((Object)CenterPointType.CUSTOM);
            this.d_cpPoint.load((UnitPoint3D)object);
        } else {
            this.d_cpType.setSelectedItem(null);
            this.d_cpPoint.load(null);
        }
        this.updateCpStatus();
        this.d_cpType.removeItemListener(this.d_updateCpStatus);
        this.d_cpType.addItemListener(this.d_updateCpStatus);
        this.d_rectEditor.getComm().addObserver(this.d_updateCpStatus);
        Object object3 = PropertyUtil.getProperty(this.radiusProp, collection);
        if (!(object3 instanceof UnitDouble)) {
            object3 = null;
        }
        if (object3 == null) {
            this.d_enableCircular.setSelected(false);
            this.d_radiusEditor.setValue(new UnitDouble(0.0, PyroSim.getApp().getUnitSystem().getLengthUnit()));
        } else {
            this.d_enableCircular.setSelected(true);
            this.d_radiusEditor.setValue((UnitDouble)object3);
        }
    }

    private void updateCpStatus() {
        UnitAABox unitAABox;
        this.d_cpPoint.setEditable(this.d_cpType.getSelectedItem() == CenterPointType.CUSTOM);
        if (this.d_cpType.getSelectedItem() == CenterPointType.AUTO && this.d_rectEditor.validateData(false, false) && (unitAABox = this.d_rectEditor.getBoundingBox()) != null) {
            this.d_cpPoint.load(unitAABox.getCenter());
        }
    }

    private int getNormalIx(Vector3d vector3d) {
        switch (this.d_rectEditor.getPlaneCB().getSelectedIndex()) {
            case -1: {
                return -1;
            }
            case 0: {
                return vector3d.x > 0.0 ? 2 : 1;
            }
            case 1: {
                return vector3d.y > 0.0 ? 2 : 1;
            }
            case 2: {
                return vector3d.z > 0.0 ? 2 : 1;
            }
        }
        return -1;
    }

    private Vector3d getNormal(int n) {
        if (n == 0) {
            return GeomConstants.VEC3D_ZERO;
        }
        switch (this.d_rectEditor.getPlaneCB().getSelectedIndex()) {
            case -1: {
                return null;
            }
            case 0: {
                return n == 2 ? GeomConstants.VEC3D_XPOS : GeomConstants.VEC3D_XNEG;
            }
            case 1: {
                return n == 2 ? GeomConstants.VEC3D_YPOS : GeomConstants.VEC3D_YNEG;
            }
            case 2: {
                return n == 2 ? GeomConstants.VEC3D_ZPOS : GeomConstants.VEC3D_ZNEG;
            }
        }
        return null;
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        Serializable serializable;
        this.d_rectEditor.save(collection);
        int n = this.d_cbNormal.getSelectedIndex();
        if (n >= 0 && (serializable = this.getNormal(n)) != null) {
            if (serializable.equals(GeomConstants.VEC3D_ZERO)) {
                serializable = null;
            }
            PropertyUtil.setProperty(this.normalProp, serializable, collection);
        }
        if (this.d_cpType.getSelectedItem() != null) {
            if (this.d_cpType.getSelectedItem() == CenterPointType.AUTO) {
                PropertyUtil.setProperty(this.originProp, null, collection);
            } else if (this.d_cpType.getSelectedItem() == CenterPointType.CUSTOM && (serializable = this.d_cpPoint.save()) != null) {
                PropertyUtil.setProperty(this.originProp, serializable, collection);
            }
        }
        serializable = (UnitDouble)this.d_radiusEditor.getValue();
        PropertyUtil.setProperty(this.radiusProp, serializable, collection);
    }

    private class NormalListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 7676892310073633448L;

        private NormalListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                jLabel.setText("");
                return jLabel;
            }
            switch ((Integer)object) {
                case 0: {
                    jLabel.setText(Intl.intl("Automatic (Recommended)"));
                    break;
                }
                case -1: {
                    jLabel.setText("-X");
                    break;
                }
                case 1: {
                    jLabel.setText("+X");
                    break;
                }
                case -2: {
                    jLabel.setText("-Y");
                    break;
                }
                case 2: {
                    jLabel.setText("+Y");
                    break;
                }
                case -3: {
                    jLabel.setText("-Z");
                    break;
                }
                case 3: {
                    jLabel.setText("+Z");
                }
            }
            return jLabel;
        }
    }

    private class UpdateCpStatusListener
    implements ItemListener,
    Observer {
        private UpdateCpStatusListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            VentGeomEditor.this.updateCpStatus();
        }

        @Override
        public void update(Observable observable, Object object) {
            VentGeomEditor.this.updateCpStatus();
        }
    }

    private static enum CenterPointType {
        AUTO,
        CUSTOM;

    }
}

