/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Vent;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.geom.EvacPanel;
import pyrosim.gui.geom.ModelDialogsUtil;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.gui.geom.TexMapperPnl;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class VentEditor
implements ModelObjectDialog.IEditor<Vent> {
    private static final String OPEN_PROPS_TAB = Intl.intl("Open Properties");
    private static final String HVAC_PROPS_TAB = Intl.intl("HVAC Properties");
    private static final String BURNER_PROPS_TAB = Intl.intl("Fire Spread Properties");
    private final ModelObjectDialog d_parent;
    private final guiMultiStateCheckBox d_outlineCB;
    private final SurfaceComboBox d_surfCB;
    private final TexMapperPnl d_texOriginPanel;
    private final FireSpreadPnl d_fireSpreadPnl;
    private final OpenPropsPnl d_openPropsPnl;
    private ControlSelPnl d_controlPnl;
    private final EvacPanel d_evacPanel;
    private final HvacPnl d_hvacPanel;
    private Collection<? extends Vent> d_loadedVents;
    private boolean d_burnerSurfLoaded = false;
    private boolean d_openSurfLoaded = false;
    private boolean d_hvacSurfLoaded = false;
    private boolean d_ctrlSurfLoaded = false;
    private static final PropertyUtil.IProp<Vent, UnitDouble> s_extTempProp = new PropertyUtil.AProp<Vent, UnitDouble>(Vent.class){

        @Override
        public Object get(Vent vent) {
            return vent.getOpenProps() != null ? vent.getOpenProps().temp : Vent.OpenProps.DEFAULT.temp;
        }

        @Override
        public void set(Vent vent, UnitDouble unitDouble) {
            Vent.OpenProps openProps = vent.getOpenProps();
            Vent.OpenProps openProps2 = new Vent.OpenProps(unitDouble, openProps.pressure);
            vent.setOpenProps(openProps2);
        }
    };
    private static final PropertyUtil.IProp<Vent, TimeBasedValue<UnitDouble>> s_pressureProp = new PropertyUtil.AProp<Vent, TimeBasedValue<UnitDouble>>(Vent.class){

        @Override
        public Object get(Vent vent) {
            return vent.getOpenProps() != null ? vent.getOpenProps().pressure : Vent.OpenProps.DEFAULT.pressure;
        }

        @Override
        public void set(Vent vent, TimeBasedValue<UnitDouble> timeBasedValue) {
            Vent.OpenProps openProps = vent.getOpenProps();
            Vent.OpenProps openProps2 = new Vent.OpenProps(openProps.temp, timeBasedValue);
            vent.setOpenProps(openProps2);
        }
    };

    public VentEditor(ModelObjectDialog modelObjectDialog, PyroMod pyroMod) {
        this.d_parent = modelObjectDialog;
        this.d_loadedVents = Collections.EMPTY_LIST;
        this.d_outlineCB = new guiMultiStateCheckBox(Intl.intl("Display as Outline"));
        this.d_surfCB = new SurfaceComboBox(pyroMod.getSurfaceMgr(), pyroMod.getDefaultSurface());
        this.d_texOriginPanel = new TexMapperPnl();
        this.d_fireSpreadPnl = new FireSpreadPnl(this.d_surfCB);
        this.d_openPropsPnl = new OpenPropsPnl();
        this.d_evacPanel = pyroMod.getFdsEvacEnabled() ? new EvacPanel() : null;
        this.d_surfCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                VentEditor.this.updateSelSurf();
            }
        });
        this.d_hvacPanel = new HvacPnl();
    }

    @Override
    public Class<Vent> getType() {
        return Vent.class;
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Vent Properties");
    }

    @Override
    public boolean validateData(Component component, boolean bl, boolean bl2) {
        String string;
        int n;
        return !bl || !this.d_surfCB.isModified() || this.d_surfCB.getSelectedItem() == null || !((Surface)this.d_surfCB.getSelectedItem()).isPredefined(PredefSurf.HVAC) || (n = JOptionPane.showConfirmDialog(component, string = Intl.intl("WARNING: Once a vent is assigned to an HVAC surface, it\ncannot be changed to another surface type."), Intl.intl("HVAC Surface"), 2, 2)) == 0;
    }

    @Override
    public void add(ModelObjectDialog modelObjectDialog, GridBagHelper gridBagHelper) {
        this.d_controlPnl = modelObjectDialog.getControlPanel();
        modelObjectDialog.addControlInput(gridBagHelper);
        gridBagHelper.addRow(Intl.intl("Surface:"), this.d_surfCB);
        modelObjectDialog.addColor(gridBagHelper);
        gridBagHelper.addRow(this.d_outlineCB, 0);
        gridBagHelper.addRow(this.d_texOriginPanel, 1.0, 0);
    }

    @Override
    public boolean isControllable(Vent vent) {
        Surface surface = (Surface)this.d_surfCB.getSelectedItem();
        if (surface == null) {
            return vent.isControllable();
        }
        return Vent.isControllableSurf(surface);
    }

    private void updateSelSurf() {
        Surface surface = (Surface)this.d_surfCB.getSelectedItem();
        if (this.d_controlPnl != null) {
            boolean bl = false;
            for (Vent vent : this.d_loadedVents) {
                if (!this.isControllable(vent)) continue;
                bl = true;
                break;
            }
            this.d_controlPnl.setEnabled(bl);
            if (!bl) {
                this.d_controlPnl.selectAlwaysOn();
            }
        }
        if (surface == null && this.d_burnerSurfLoaded || surface != null && Vent.isValidFireSpreadSurf(surface)) {
            this.d_parent.addExtraTab(BURNER_PROPS_TAB, this.d_fireSpreadPnl);
        } else {
            this.d_parent.removeExtraTab(BURNER_PROPS_TAB);
        }
        if (surface == null && this.d_openSurfLoaded || surface != null && surface.isPredefined(PredefSurf.OPEN)) {
            this.d_parent.addExtraTab(OPEN_PROPS_TAB, this.d_openPropsPnl);
        } else {
            this.d_parent.removeExtraTab(OPEN_PROPS_TAB);
        }
        if (surface == null && this.d_hvacSurfLoaded || surface != null && surface.isPredefined(PredefSurf.HVAC)) {
            this.d_parent.addExtraTab(HVAC_PROPS_TAB, this.d_hvacPanel);
        } else {
            this.d_parent.removeExtraTab(HVAC_PROPS_TAB);
        }
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        ArrayList<Pair<String, guiPanel>> arrayList = new ArrayList<Pair<String, guiPanel>>();
        arrayList.add(new Pair<String, OpenPropsPnl>(OPEN_PROPS_TAB, this.d_openPropsPnl));
        arrayList.add(new Pair<String, HvacPnl>(HVAC_PROPS_TAB, this.d_hvacPanel));
        arrayList.add(new Pair<String, FireSpreadPnl>(BURNER_PROPS_TAB, this.d_fireSpreadPnl));
        if (this.d_evacPanel != null) {
            arrayList.add(new Pair<String, EvacPanel>(Intl.intl("Evac"), this.d_evacPanel));
        }
        return arrayList;
    }

    @Override
    public void load(PyroMod pyroMod, Collection<? extends Vent> collection) {
        this.d_loadedVents = new ArrayList<Vent>(collection);
        HashSet<Predicate<Surface>> hashSet = new HashSet<Predicate<Surface>>();
        for (Vent object2 : collection) {
            hashSet.add(object2.getSurfFilter());
        }
        Predicate<Surface> predicate = hashSet.isEmpty() ? Vent.getSurfaceFilter() : Predicates.and(theUtil.toArray(hashSet, Predicate.class));
        this.d_surfCB.setFilter(predicate);
        Object object = Composite.getProperty(Vent.surfProp, collection);
        if (!(object instanceof Surface)) {
            this.d_surfCB.setSelectedItem(null);
        } else {
            this.d_surfCB.setSelectedItem((Surface)object);
        }
        this.d_texOriginPanel.load(collection);
        this.d_fireSpreadPnl.load(collection);
        ModelDialogsUtil.loadBoolean(collection, this.d_outlineCB, new Vent.OptionProp(1));
        this.d_burnerSurfLoaded = false;
        this.d_openSurfLoaded = false;
        this.d_ctrlSurfLoaded = false;
        this.d_hvacSurfLoaded = false;
        if (this.d_surfCB.getSelectedItem() == null) {
            for (Vent vent : collection) {
                Surface surface = vent.getSurface();
                if (Vent.isValidFireSpreadSurf(surface)) {
                    this.d_burnerSurfLoaded = true;
                } else if (surface.isPredefined(PredefSurf.OPEN)) {
                    this.d_openSurfLoaded = true;
                } else if (surface.isPredefined(PredefSurf.HVAC)) {
                    this.d_hvacSurfLoaded = true;
                }
                this.d_ctrlSurfLoaded |= this.isControllable(vent);
                if (!this.d_openSurfLoaded || !this.d_ctrlSurfLoaded || !this.d_hvacSurfLoaded || !this.d_burnerSurfLoaded) continue;
                break;
            }
        }
        this.updateSelSurf();
        this.d_openPropsPnl.load(pyroMod, collection);
        this.d_hvacPanel.load(collection);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.load(pyroMod, collection);
        }
    }

    @Override
    public void save(PyroMod pyroMod, Collection<? extends Vent> collection) {
        Surface surface = (Surface)this.d_surfCB.getSelectedItem();
        if (surface != null) {
            Composite.setProperty(Vent.surfProp, surface, collection);
        }
        this.d_texOriginPanel.save(pyroMod, collection);
        this.d_fireSpreadPnl.save(pyroMod, collection);
        ModelDialogsUtil.saveBoolean(pyroMod, collection, this.d_outlineCB, new Vent.OptionProp(1));
        this.d_openPropsPnl.save(pyroMod, collection);
        this.d_hvacPanel.save(collection);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.save(pyroMod, collection);
        }
    }

    private static class OpenPropsPnl
    extends guiPanel {
        private static final long serialVersionUID = 7403210301008526754L;
        private final ValueField<UnitDouble> d_tempFld = ValueFields.udFld(UnitSystem.getSource(1));
        private final ValueField<UnitDouble> d_pressureFld;
        private final TimeFunctionEditor d_pressureFuncEditor;
        private static final UnitDouble TMPA = new UnitDouble(Double.POSITIVE_INFINITY, SI.CELSIUS);

        public OpenPropsPnl() {
            super(new GridBagLayout());
            ValueFields.getFormat(this.d_tempFld).alias(TMPA, "TMPA");
            this.d_tempFld.setNullAllowed(true);
            this.d_pressureFld = ValueFields.udFld(UnitSystem.getSource(39));
            this.d_pressureFuncEditor = new TimeFunctionEditor(Intl.intl("Pressure Ramp"), 17);
            this.d_pressureFld.setNullAllowed(true);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Exterior Temperature") + ":");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Dynamic Pressure") + ":");
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(guiLabel2, this.d_tempFld);
            gridBagHelper.addRow(guiLabel3, this.d_pressureFld);
            gridBagHelper.addRow(this.d_pressureFuncEditor.getLabel(), this.d_pressureFuncEditor.getCombo(), this.d_pressureFuncEditor.getEditor());
            gridBagHelper.finalizeRows();
        }

        public void load(PyroMod pyroMod, Collection<? extends Vent> collection) {
            if ((collection = theUtil.filter(collection, new PredefSurfFilter(PredefSurf.OPEN))).isEmpty()) {
                Vent.OpenProps openProps = Vent.OpenProps.DEFAULT;
                this.d_tempFld.setValue(TMPA);
                this.d_pressureFld.setValue(openProps.pressure.val);
                this.d_pressureFuncEditor.loadFunction(openProps.pressure.func);
                return;
            }
            Object object = PropertyUtil.getProperty(s_extTempProp, collection);
            if (object == PropertyUtil.NON_UNIFORM || object == PropertyUtil.NOT_SUPPORTED) {
                object = null;
            } else if (object == null) {
                object = TMPA;
            }
            this.d_tempFld.setValue((UnitDouble)object);
            Object object2 = PropertyUtil.getProperty(s_pressureProp, collection);
            if (!(object2 instanceof TimeBasedValue)) {
                object2 = null;
            }
            UnitDouble unitDouble = object2 == null ? null : (UnitDouble)((TimeBasedValue)object2).val;
            TimeFunction timeFunction = object2 == null ? null : ((TimeBasedValue)object2).func;
            this.d_pressureFld.setValue(unitDouble);
            this.d_pressureFuncEditor.loadFunction(timeFunction);
        }

        public void save(PyroMod pyroMod, Collection<? extends Vent> collection) {
            for (Vent serializable2 : collection) {
                if (!serializable2.getSurface().isPredefined(PredefSurf.OPEN)) {
                    serializable2.setOpenProps(null);
                    continue;
                }
                if (serializable2.getOpenProps() != null) continue;
                serializable2.setOpenProps(Vent.OpenProps.DEFAULT);
            }
            collection = theUtil.filter(collection, new PredefSurfFilter(PredefSurf.OPEN));
            Object object = (UnitDouble)this.d_tempFld.getValue();
            if (object != null) {
                if (object == TMPA) {
                    object = null;
                }
                PropertyUtil.setProperty(s_extTempProp, object, collection);
            }
            UnitDouble unitDouble = (UnitDouble)this.d_pressureFld.getValue();
            TimeFunction<?> timeFunction = this.d_pressureFuncEditor.saveFunction();
            if (unitDouble != null && timeFunction != null) {
                TimeBasedValue<UnitDouble> timeBasedValue = new TimeBasedValue<UnitDouble>(unitDouble, timeFunction);
                PropertyUtil.setProperty(s_pressureProp, timeBasedValue, collection);
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2) && this.d_pressureFuncEditor.validateData(bl, bl2);
        }
    }

    private static class FireSpreadPnl
    extends guiPanel {
        private static final long serialVersionUID = 5522134974656300231L;
        private final guiMultiStateCheckBox d_enableFireSpread;
        private final ValueField<UnitDouble> d_spreadRateFld;
        private final guiLabel d_spreadRateLbl;
        private final Composite.IObjectProp rateProp = new Composite.AObjectProp<Vent, UnitDouble>(Vent.class){

            @Override
            public void set(Vent vent, UnitDouble unitDouble) {
                vent.setFireSpreadRate(unitDouble);
            }

            @Override
            public Object get(Vent vent) {
                return vent.getFireSpreadRate();
            }
        };

        public FireSpreadPnl(SurfaceComboBox surfaceComboBox) {
            super(new GridBagLayout());
            this.d_enableFireSpread = new guiMultiStateCheckBox(Intl.intl("Enable Fire Spread"));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Fire spreads from the Center Point defined on the Geometry tab."));
            guiLabel2.setFont(guiLabel2.getFont().deriveFont(2));
            this.d_spreadRateFld = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(8), UnitSystem.getSource(8));
            this.d_spreadRateFld.setNullAllowed(true);
            this.d_enableFireSpread.addActionListener(actionEvent -> {
                if (this.d_spreadRateFld.isEmpty()) {
                    this.d_spreadRateFld.setValue(SIUS.newud(0.0, 8));
                    this.d_spreadRateFld.requestFocusInWindow();
                }
            });
            this.d_spreadRateLbl = new guiLabel(Intl.intl("Spread Rate:"));
            LinkStatus.link((AbstractButton)this.d_enableFireSpread, this.d_spreadRateLbl, this.d_spreadRateFld);
            GridBagUtil.add(this, this.d_enableFireSpread, 0, 0, 4, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, 1, 3, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_spreadRateLbl, 0, 2, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_spreadRateFld, 1, 2, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void load(Collection<? extends Vent> collection) {
            Object object = Composite.getProperty(this.rateProp, collection);
            if (object == null) {
                this.d_enableFireSpread.setState(0);
                this.d_spreadRateFld.setValue(object);
            } else if (object instanceof UnitDouble) {
                this.d_enableFireSpread.setState(1);
                this.d_spreadRateFld.setValue(object);
            } else {
                this.d_enableFireSpread.setState(2);
                this.d_spreadRateFld.setValue(null);
            }
            boolean bl = this.d_enableFireSpread.getState() == 1;
            this.d_spreadRateLbl.setEnabled(bl);
            this.d_spreadRateFld.setEnabled(bl);
        }

        public void save(PyroMod pyroMod, Collection<? extends Vent> collection) {
            UnitDouble unitDouble = (UnitDouble)this.d_spreadRateFld.getValue();
            int n = this.d_enableFireSpread.getState();
            if (unitDouble != null && n == 1) {
                Composite.setProperty(this.rateProp, unitDouble, collection);
            } else if (n == 0) {
                Composite.setProperty(this.rateProp, null, collection);
            }
        }
    }

    private static class FireSpreadFilter
    implements Predicate<Vent> {
        private FireSpreadFilter() {
        }

        @Override
        public boolean test(Vent vent) {
            return Vent.isValidFireSpreadSurf(vent.getSurface());
        }
    }

    private static class PredefSurfFilter
    implements Predicate<Vent> {
        private final PredefSurf d_surf;

        public PredefSurfFilter(PredefSurf predefSurf) {
            this.d_surf = predefSurf;
        }

        @Override
        public boolean test(Vent vent) {
            return vent.getSurface().isPredefined(this.d_surf);
        }
    }

    private static class HvacPnl
    extends guiPanel {
        private static final long serialVersionUID = 4252489330431369486L;
        private final guiMultiStateCheckBox d_louverCB;
        private final Point3DPanel d_louverPnl;
        private final Composite.IObjectProp louverProp = new Composite.AObjectProp<Vent, Vector3d>(Vent.class){

            @Override
            public void set(Vent vent, Vector3d vector3d) {
                vent.setLouver(vector3d);
            }

            @Override
            public Object get(Vent vent) {
                Vector3d vector3d = vent.getLouver();
                return vector3d == null ? GeomConstants.VEC3D_ZERO : vector3d;
            }
        };
        private final Composite.IObjectProp louverSpecProp = new Composite.AObjectProp<Vent, Boolean>(Vent.class){

            @Override
            public void set(Vent vent, Boolean bl) {
            }

            @Override
            public Object get(Vent vent) {
                return vent.getLouver() != null;
            }
        };

        public HvacPnl() {
            this.d_louverCB = new guiMultiStateCheckBox(Intl.intl("Louver:"));
            this.d_louverPnl = new Point3DPanel(null, true, 28);
            LinkStatus.link((AbstractButton)this.d_louverCB, this.d_louverPnl);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(this.d_louverCB, this.d_louverPnl, 1.0, 0);
            gridBagHelper.finalizeRows();
        }

        public void load(Collection<? extends Vent> collection) {
            if ((collection = theUtil.filter(collection, new PredefSurfFilter(PredefSurf.HVAC))).isEmpty()) {
                this.d_louverCB.setSelected(false);
                this.d_louverPnl.load(new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE));
                return;
            }
            Object object = Composite.getProperty(this.louverSpecProp, collection);
            if (object instanceof Boolean) {
                this.d_louverCB.setSelected((Boolean)object);
            } else {
                this.d_louverCB.setState(2);
            }
            Object object2 = Composite.getProperty(this.louverProp, collection);
            if (object2 instanceof Vector3d) {
                Vector3d vector3d = (Vector3d)object2;
                this.d_louverPnl.load(new UnitPoint3D(vector3d.x, vector3d.y, vector3d.z, Unit.ONE));
            } else {
                this.d_louverPnl.load(null);
            }
        }

        public void save(Collection<? extends Vent> collection) {
            PredefSurfFilter predefSurfFilter = new PredefSurfFilter(PredefSurf.HVAC);
            for (Vent vent : collection) {
                if (predefSurfFilter.test(vent)) continue;
                vent.setLouver(null);
            }
            collection = theUtil.filter(collection, predefSurfFilter);
            if (this.d_louverCB.getState() != 2) {
                if (this.d_louverCB.isSelected()) {
                    UnitPoint3D unitPoint3D = this.d_louverPnl.save();
                    if (unitPoint3D != null) {
                        Composite.setProperty(this.louverProp, unitPoint3D.getVector3dValue(Unit.ONE), collection);
                    }
                } else {
                    Composite.setProperty(this.louverProp, null, collection);
                }
            }
        }
    }
}

