/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.domain.tasks.TranslateTask;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.GeomUtil;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class TranslateDialog
extends TransformDialog {
    private static final long serialVersionUID = 8529781172286773747L;
    private ValueField<UnitDouble> d_x = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_y = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_z = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_minXField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_minYField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_minZField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_maxXField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_maxYField = ValueFields.udFld(UnitSystem.getSource(0));
    private ValueField<UnitDouble> d_maxZField = ValueFields.udFld(UnitSystem.getSource(0));

    public TranslateDialog(PyroMod pyroMod, Collection<? extends IPyroObject> collection) {
        super(Intl.intl("Translate"), pyroMod, collection, true, true);
        this.d_minXField.setEditable(false);
        this.d_minYField.setEditable(false);
        this.d_minZField.setEditable(false);
        this.d_maxXField.setEditable(false);
        this.d_maxYField.setEditable(false);
        this.d_maxZField.setEditable(false);
        this.d_minXField.setFocusable(false);
        this.d_minYField.setFocusable(false);
        this.d_minZField.setFocusable(false);
        this.d_maxXField.setFocusable(false);
        this.d_maxYField.setFocusable(false);
        this.d_maxZField.setFocusable(false);
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(guiPanel2, this.getModePanel(), 0, n, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getPanel(), 0, ++n, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        this.updateSelection(collection);
        super.init();
    }

    @Override
    protected String getTaskDesc() {
        return this.getNumCopies() > 0 ? Intl.intl("Copy/Move Objects") : Intl.intl("Move Objects");
    }

    private guiPanel getPanel() {
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        int n = 0;
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Translate"));
        GridBagUtil.add(guiPanel2, titleSeparator, 0, n, 99, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, new guiLabel("X"), 1, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 10);
        GridBagUtil.add(guiPanel2, new guiLabel("Y"), 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 10);
        GridBagUtil.add(guiPanel2, new guiLabel("Z"), 3, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 10);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Offset") + ": "), 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_x, 1, n, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_y, 2, n, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_z, 3, n, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, new TitleSeparator(Intl.intl("Selected Border")), 0, ++n, 40, 1, 6, 0, 6, 12, 2, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Min") + ": "), 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_minXField, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_minYField, 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_minZField, 3, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Max") + ": "), 0, ++n, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_maxXField, 1, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_maxYField, 2, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_maxZField, 3, n, 1, 1, 0, 0, 6, 0, 0, 1.0, 1.0, 17);
        return guiPanel2;
    }

    private UnitPoint3D getOffset() {
        return new UnitPoint3D((UnitDouble)this.d_x.getValue(), (UnitDouble)this.d_y.getValue(), (UnitDouble)this.d_z.getValue());
    }

    private void updateSelection(Collection<? extends IPyroObject> collection) {
        UnitAABox unitAABox = GeomUtil.getUnitBounds(Hierarchy.flatten(collection, IPyroGeomSrc.class));
        UnitPoint3D unitPoint3D = unitAABox.getMin();
        UnitPoint3D unitPoint3D2 = unitAABox.getMax();
        this.d_minXField.setValue(unitPoint3D.xu());
        this.d_minYField.setValue(unitPoint3D.yu());
        this.d_minZField.setValue(unitPoint3D.zu());
        this.d_maxXField.setValue(unitPoint3D2.xu());
        this.d_maxYField.setValue(unitPoint3D2.yu());
        this.d_maxZField.setValue(unitPoint3D2.zu());
    }

    @Override
    protected boolean isIdentityTransform() {
        return this.getOffset().equals(new UnitPoint3D(0.0, 0.0, 0.0, UnitSystem.getSource(0).getUnit()));
    }

    @Override
    protected TransformTask taskTransform(Collection<? extends IPyroObject> collection) {
        return new TranslateTask(this.getMediator(), collection, this.getNumCopies(), this.getOffset());
    }
}

